/* menu.c - Menu handling part of NFSmenu
 *
 * version 0.24 30-5-1995
 * (c) Bastiaan Bakker        Bastiaan.Bakker@twi.TUDelft.NL
 *
 */
 
#include <stdio.h>
#include <sys/time.h>
#include "nfspart.h"
 
int help_oper();

typedef struct {
   char *name;
#ifdef ultrix
   int (*operation) ();
#else
   int (*operation) (int, char **, nfs_env *);
#endif
   int minargs;
   char *argdesc;   
} nfs_oper;

#define MENU_ITEMS 20

nfs_oper nfs_menu[MENU_ITEMS] =
{ {"getattr",	getattr_oper,	0,	"[filename]"},
  {"setattr",	setattr_oper,	1,	"filename"},
  {"cd",	cd_oper,	1,	"dirname"},
  {"read",	read_oper,	1,	"inputfilename [outputfilename]"},
  {"write",	write_oper,	2,	"inputfilename outputfilename"},
  {"create",	create_oper,	1,	"filename"},
  {"remove",	remove_oper,	1,	"filename"},
  {"rename",	rename_oper,	2,	"old_filename new_filename"},
  {"link",	NULL,		2,	""},
  {"symlink",	NULL,		2,	""},
  {"readlink",	rlink_oper,	1,	"linkname"},
  {"rmdir",	remove_oper,	1,	"dirname"},
  {"mkdir",	create_oper,	1,	"dirname"},
  {"dir",	dir_oper,	0,	""},
  {"stat",	stat_oper,	0,	""}, 
  {"id",	id_oper,	0,	"[new_UID [new_GID]]"},
  {"handle",	handle_oper,	0,	"[filehandle_file]"},
  {"help",	help_oper,	0,	""},
  {"exit",	quit_oper,	0,	""},
  {"quit",	quit_oper,	0,	""} };

#define INPUT_LEN 1024
#define ARG_LEN 128 

char *program;
struct timeval TIMEOUT = {30, 0};
int verbose = 0;

int do_oper();
void usage();
bool init_env();

void main(int argc, char *argv[])
{
   nfs_env nfsenv; 
   char input[INPUT_LEN];
   int res;
 
   if (init_env(&nfsenv, argc, argv) != OK) 
   {
      printf("Initialization failed\nQuiting...\n");
      do_oper("quit", &nfsenv);
   }

   while(1)
   {
      printf("%s:%s> ", nfsenv.host, nfsenv.path);
      fgets(input, INPUT_LEN - 1, stdin);
      if ((res = do_oper(input, &nfsenv)) != NFS_OK)
         fprintf(stderr, "Error! %s\n", print_error(res));
   }
}

int do_oper(char *input, nfs_env *env)
{
   static char arg0[ARG_LEN], arg1[ARG_LEN], arg2[ARG_LEN], arg3[ARG_LEN];
   static char *argv[4] = { arg0, arg1, arg2, arg3 }; 
   int argc, i, res;

   res = NFS_OK;

   if ((argc = sscanf(input, "%s %s %s %s", arg0, arg1, arg2, arg3)) > 0) {
      for(i = 0; i < MENU_ITEMS; i++)
      {
         if (!strcmp(nfs_menu[i].name, arg0))
         {
            if (argc - 1 < nfs_menu[i].minargs)
               printf("Not enough argmuments\n");
            else
            {
               if (nfs_menu[i].operation)
                  res = nfs_menu[i].operation(argc, argv, env);
               else
                  printf("%s: command not implemented yet\n", arg0);
            }
            break;
         }
      }
      if (i >= MENU_ITEMS) 
      {
         printf("Unrecognized command: %s\n", arg0);
      }
   }
   return(res);
}

int help_oper(int argc, char *argv[], nfs_env *env)
{
   int i;

   printf("Available commands:\n");
   for(i=0; i<MENU_ITEMS; i++)
   {
      if (nfs_menu[i].operation) 
         printf("   %s %s\n",nfs_menu[i].name, nfs_menu[i].argdesc);
   }
   return(NFS_OK);
}

void usage()
{
   printf("Usage: %s [-p port] [-t timeout] [-v [-v]] handlefile host dir\n", program);
   exit(1);
}

extern int optind;
extern char *optarg;

bool init_env(nfs_env *env, int argc, char *argv[]) 
{
   int opt;
   char *fname, *host, *path;
   FILE *handlefile;
   unsigned char *r, *c;
   unsigned int i, k;
   int port = 0;

   memset((char *)env, 0, sizeof(nfs_env));

   program = argv[0];
   while ((opt = getopt(argc, argv, "vp:t:")) != EOF)
   {
      switch(opt) {
      case 'v':
         verbose++;
         break;
      case 'p':
         port = atoi(optarg);
         break;
      case 't':
         TIMEOUT.tv_sec = atoi(optarg);
         break;
      default:
         usage();
      }
   }
   if (argc < optind + 3) 
      usage();

   fname = argv[optind];
   host = argv[optind + 1];
   path = argv[optind + 2];
   if (!(handlefile = fopen(fname, "r")))
   {
      fprintf(stderr, "Could not open handle file %s\n", fname);
      return(ERR);
   }
   
   r = (unsigned char *)(env->roothandle); 
   c = (unsigned char *)(env->curhandle); 
   do
   {
      fscanf(handlefile, "%s", env->host);
      fscanf(handlefile, "%s", env->path); 
      for(i = 0; i < FHSIZE; i++)
      {
         fscanf(handlefile, "%x", &k); 
         r[i] = c[i] = (unsigned char)(k & 0xff);
      } 
      if (ferror(handlefile)) 
      {
          fprintf(stderr, "Error reading handle file %s\n", fname);
          fclose(handlefile);
          return(ERR);
      } 
      if (feof(handlefile)) 
      {
          fprintf(stderr, "Unexpected end of handle file %s\n", fname);
          fclose(handlefile);
          return(ERR);
      }    
   } while (!(!strcmp(env->host, host) && !strcmp(env->path, path)));
   
   fclose(handlefile);
   if (init_client(env, port) != OK) 
   {
      fprintf(stderr, "Could not create RPC client\n");
      return(ERR);
   }
   else
   {
      do_oper("id -2 -2", env); 
      return(OK); 
   }
} 
