#include <rpc/rpc.h>
#include "nfs_prot.h"

char *nfs_error(int status)
{
   switch (status) {
   case NFS_OK:
      return "No error"; 
   case NFSERR_PERM: 
      return "Not owner"; 
   case NFSERR_NOENT: 
      return "No such file or directory"; 
   case NFSERR_IO: 
      return "I/O error"; 
   case NFSERR_NXIO:
      return "No such device or address"; 
   case NFSERR_ACCES: 
      return "Permission denied"; 
   case NFSERR_EXIST: 
      return "File exists"; 
   case NFSERR_NODEV: 
      return "No such device"; 
   case NFSERR_NOTDIR: 
      return "Not a directory"; 
   case NFSERR_ISDIR: 
      return "Is a directory"; 
   case NFSERR_FBIG: 
      return "File too large"; 
   case NFSERR_NOSPC: 
      return "No space left on device"; 
   case NFSERR_ROFS: 
      return "Read-only file system"; 
   case NFSERR_NAMETOOLONG: 
      return "File name too long"; 
   case NFSERR_NOTEMPTY: 
      return "Directory not empty"; 
   case NFSERR_DQUOT: 
      return "Disc quota exceeded"; 
   case NFSERR_STALE: 
      return "Stale NFS file handle"; 
   case NFSERR_WFLUSH: 
      return "Write cache flushed"; 
   default: 
      return "UKNOWN NFS ERROR"; 
   }    
}
