/* nfspart.c - Main routines of NFSmenu
 *
 * version 0.24 30-5-1995
 * (c) Bastiaan Bakker        Bastiaan.Bakker@twi.TUDelft.NL
 *
 */

#include "nfspart.h"
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h> 
#include <time.h>
#include <sys/time.h>

extern struct timeval TIMEOUT;
extern int verbose;
#define Vprint	if (verbose > 0) printf
#define VVprint if (verbose > 1) printf

int lookupfile(char *fname, nfs_env *env, diropokres *result)
{ 
   diropargs args;
   diropres reply;

   Vprint("Looking up <%s> ...", fname); 
   memcpy((char *)&(args.dir), (char *)env->curhandle, NFS_FHSIZE);
   args.name = fname;
   memset((char *)&reply, 0, sizeof(reply));
   if (clnt_call(env->client, NFSPROC_LOOKUP, xdr_diropargs, &args,
      xdr_diropres, &reply, TIMEOUT) != RPC_SUCCESS) 
   {
      Vprint("\n");
      return(OWNERR_RPCFAIL);
   }
   else
   {
      if (reply.status == NFS_OK) 
      {
         memcpy(result, &(reply.diropres_u.diropres), sizeof(diropokres));
         Vprint(" found.");
      }
      Vprint("\n");
      return(reply.status);
   }
}

int getattr_oper(int argc, char *argv[], nfs_env *env)
{  
   diropokres lreply;
   attrstat reply;
   fattr *attr;
   int result;
   
   if (argc > 1) 
   {
      if ((result = lookupfile(argv[1], env, &lreply)) != NFS_OK)
         return(result);
      else
      { 
         attr = &(lreply.attributes);
      }
   }
   else 
   {
      memset((char *)&reply, 0, sizeof(reply));
      Vprint("Calling getattr\n");
      if (clnt_call(env->client, NFSPROC_GETATTR, xdr_nfs_fh, 
         env->curhandle, xdr_attrstat, &reply, TIMEOUT) != RPC_SUCCESS)
         return(OWNERR_RPCFAIL);
      else
      {
         if (reply.status != NFS_OK) 
            return(reply.status);
         else
            attr = &(reply.attrstat_u.attributes);
      }
   }

   printf("type: %d\nmode: %o\n", attr->type, attr->mode);
   printf("nlink: %d\nuid: %d\n", attr->nlink, attr->uid);
   printf("gid: %d\nsize: %d\n", attr->gid, attr->size);
   printf("atime: %s", ctime((time_t *)&(attr->atime.seconds)));
   printf("mtime: %s", ctime((time_t *)&(attr->mtime.seconds)));
   printf("ctime: %s", ctime((time_t *)&(attr->ctime.seconds))); 
   return(NFS_OK);
}

int asktime()
{
   struct tm time;
   char input[32];

   printf("(dd mm yyyy hh mm ss): ");
   fgets(input, 31, stdin);
   if (sscanf(input, "%d %d %d %d %d %d", &(time.tm_mday), &(time.tm_mon),
      &(time.tm_year), &(time.tm_hour), &(time.tm_min), &(time.tm_sec)) > 0)
   {
      return(mktime(&time));
   }
   else
   {
      return(0);
   }
}   

void askattributes(sattr *attributes)
{
   char input[16];
   char *timestr, *nl;
   unsigned int value;

   printf("mode (%o)? ", attributes->mode);
   fgets(input, 15, stdin);
   if (sscanf(input, "%o", &value) > 0)
      attributes->mode = value;      
   printf("uid (%d)? ", attributes->uid);
   fgets(input, 15, stdin);
   if (sscanf(input, "%d", &value) > 0)
      attributes->uid = value;      
   printf("gid (%d)? ", attributes->gid);
   fgets(input, 15, stdin);
   if (sscanf(input, "%d", &value) > 0)
      attributes->gid = value;      
   printf("size (%d)? ", attributes->size);
   fgets(input, 15, stdin);
   if (sscanf(input, "%d", &value) > 0)
      attributes->size = value;  
   timestr = ctime((time_t *)&(attributes->atime.seconds));
   nl = strchr(timestr, '\n');
   *nl = 0x00;         
   printf("atime (%s)? ", timestr);
   if ((value = asktime()) != 0) 
      attributes->atime.seconds = value;
   timestr = ctime((time_t *)&(attributes->mtime.seconds));
   nl = strchr(timestr, '\n');
   *nl = 0x00;         
   printf("mtime (%s)? ", timestr);
   if ((value = asktime()) != 0) 
      attributes->mtime.seconds = value;
}
 
int setattr_oper(int argc, char *argv[], nfs_env *env)
{
   diropokres lreply;
   attrstat reply;
   sattrargs sargs;
   int result;

   if ((result = lookupfile(argv[1], env, &lreply)) == NFS_OK)
   { 
      memcpy((char *)&(sargs.file), (char *)&(lreply.file), NFS_FHSIZE);
      sargs.attributes.mode = lreply.attributes.mode;
      sargs.attributes.uid = lreply.attributes.uid;
      sargs.attributes.gid = lreply.attributes.gid;
      sargs.attributes.size = lreply.attributes.size;
      sargs.attributes.atime = lreply.attributes.atime;
      sargs.attributes.mtime = lreply.attributes.mtime;
      askattributes(&(sargs.attributes));

      memset((char *)&reply, 0, sizeof(reply)); 
      Vprint("Calling setattr\n");     
      if (clnt_call(env->client, NFSPROC_SETATTR, xdr_sattrargs, &sargs, 
         xdr_attrstat, &reply, TIMEOUT) != RPC_SUCCESS)
         result = OWNERR_RPCFAIL;
      else
         result = reply.status;
   }
   return(result);
} 

int cd_oper(int argc, char *argv[], nfs_env *env)
{
   diropokres reply;
   int result;
   char *slash;

   if ((result = lookupfile(argv[1], env, &reply)) != NFS_OK)
      return(result);
   if (reply.attributes.type != NFDIR) 
      return(NFSERR_NOTDIR);
   else 
   {
      memcpy((char *)env->curhandle, (char *)&(reply.file), NFS_FHSIZE);
      if (strcmp(argv[1], ".") != 0) 
      {
         if (strcmp(argv[1], "..") != 0) 
         {
            if (strlen(env->path) < NFS_MAXPATHLEN) 
            {
               strcat(env->path, "/");
               strncat(env->path, argv[1], 
                  NFS_MAXPATHLEN - strlen(env->path));
            }
         }
         else 
         {
            if (slash = (char *)strrchr(env->path, '/')) 
               *slash = (char)0x00;
         }
      }
   } 
   return(NFS_OK);
}

int read_oper(int argc, char *argv[], nfs_env *env)
{
   diropokres lreply;
   readargs rargs;
   readres reply;
   char *data;
   int fsize, offset, length, i;
   int result = NFS_OK;
   FILE *outfile;

   outfile = stdout;
   if (argc > 2) 
   {
      if (!(outfile = fopen(argv[2], "w")))
         return(OWNERR_LOCALFILE);
   } 
   if ((result = lookupfile(argv[1], env, &lreply)) == NFS_OK)
   {
      fsize = lreply.attributes.size;
      memcpy((char *)&(rargs.file), (char *)&(lreply.file), NFS_FHSIZE);
      rargs.offset = 0;
      rargs.count = RWBATCHSIZE;
      rargs.totalcount = 0;
      for(offset = 0; offset < fsize; offset += RWBATCHSIZE) 
      {
         rargs.offset = offset;
         memset((char *)&reply, 0, sizeof(reply));
         VVprint("\nCalling read, offset = %d\n", offset);
         if (clnt_call(env->client, NFSPROC_READ, xdr_readargs, &rargs,
            xdr_readres, &reply, TIMEOUT) != RPC_SUCCESS)
         {
            result = OWNERR_RPCFAIL;
            break;
         }
         else
         {
            if (reply.status != NFS_OK)
            {
               result = reply.status;
               break;
            }
            else
            {
               length = reply.readres_u.reply.data.data_len;
               data = reply.readres_u.reply.data.data_val;
               VVprint("Received %d bytes\n", length);
               for(i = 0; i < length; i++)
                  fputc(data[i], outfile);
            }
         }
      } 
   }
   if (argc > 2) 
      fclose(outfile);
   return(result);
}

int write_oper(int argc, char *argv[], nfs_env *env)
{
   diropokres lreply;
   writeargs wargs;
   attrstat reply;
   sattrargs sargs;
   char data[RWBATCHSIZE];
   int offset, length, fsize;
   int result = NFS_OK;
   FILE *infile = NULL;

   if (!(infile = fopen(argv[1], "r")))
      return(OWNERR_LOCALFILE);
 
   if ((result = lookupfile(argv[2], env, &lreply)) == NFS_OK)
   {
      memcpy((char *)&(wargs.file), (char *)&(lreply.file), NFS_FHSIZE);
      wargs.beginoffset = 0;
      wargs.totalcount = 0;
      wargs.data.data_val = data;
      offset = length = fsize = 0; 
      data[length] = fgetc(infile);
      while (!feof(infile) && !ferror(infile))
      {
         length++; fsize++;   
         if (length >= RWBATCHSIZE)
         {
            wargs.offset = offset;
            wargs.data.data_len = length;
            memset((char *)&reply, 0, sizeof(reply));
            VVprint("Calling write, offset = %d, length = %d\n", offset, length);
            if (clnt_call(env->client, NFSPROC_WRITE, xdr_writeargs, &wargs,
               xdr_attrstat, &reply, TIMEOUT) != RPC_SUCCESS)
            {
               result = OWNERR_RPCFAIL;
               break;
            }
            else
            {
               if ((result = reply.status) != NFS_OK)
                  break;
            }
            offset += length;
            length = 0;
         }
         data[length] = fgetc(infile);
      }
      if (ferror(infile))
         result = OWNERR_LOCALFILE;
      if ((length > 0) && (result == NFS_OK)) 
      {
         wargs.offset = offset;
         wargs.data.data_len = length;
         memset((char *)&reply, 0, sizeof(reply));
         VVprint("Calling write, offset = %d, length = %d\n", offset, length);
         if (clnt_call(env->client, NFSPROC_WRITE, xdr_writeargs, &wargs,
            xdr_attrstat, &reply, TIMEOUT) != RPC_SUCCESS)
            result = OWNERR_RPCFAIL;
         else
            result = reply.status;
      }
      if (result == NFS_OK) 
      {
         memcpy((char *)&(sargs.file), (char *)&(lreply.file), NFS_FHSIZE);
         sargs.attributes.mode = lreply.attributes.mode;
         sargs.attributes.uid = lreply.attributes.uid;
         sargs.attributes.gid = lreply.attributes.gid;
         sargs.attributes.size = fsize;
         sargs.attributes.atime = lreply.attributes.atime;
         sargs.attributes.mtime = lreply.attributes.mtime;
         memset((char *)&reply, 0, sizeof(reply));
         Vprint("Calling setattr, size = %d\n", fsize);
         if (clnt_call(env->client, NFSPROC_SETATTR, xdr_sattrargs, &sargs,
            xdr_attrstat, &reply, TIMEOUT) != RPC_SUCCESS)
            result = OWNERR_RPCFAIL;
         else
            result = reply.status;
      }
   }
   fclose(infile);
   return(result);
}

int create_oper(int argc, char *argv[], nfs_env *env)
{
   createargs args;
   diropres reply;
   int proc;
 
   memcpy((char *)&(args.where.dir), (char *)env->curhandle, NFS_FHSIZE);
   args.where.name = argv[1];
   args.attributes.mode = 0644;
   args.attributes.uid = env->uid;
   args.attributes.gid = env->gid;
   args.attributes.size = 0;
   args.attributes.atime.seconds = args.attributes.mtime.seconds = time(NULL);
   args.attributes.atime.useconds = args.attributes.mtime.useconds = 0;
   askattributes(&(args.attributes));

   proc = (!strcmp(argv[0], "mkdir")) ? NFSPROC_MKDIR : NFSPROC_CREATE;
   memset((char *)&reply, 0, sizeof(reply));
   Vprint("Calling create\n");
   if (clnt_call(env->client, proc, xdr_createargs, &args,
      xdr_diropres, &reply, TIMEOUT) != RPC_SUCCESS)
      return(OWNERR_RPCFAIL);
   else
      return(reply.status);
}

int remove_oper(int argc, char *argv[], nfs_env *env)
{
   diropargs args;
   int status = 0;
   int proc;

   memcpy((char *)&(args.dir), (char *)env->curhandle, NFS_FHSIZE);
   args.name = argv[1];
   proc = (!strcmp("rmdir", argv[0])) ? NFSPROC_RMDIR : NFSPROC_REMOVE;
   Vprint("Calling %s\n", argv[0]);
   if (clnt_call(env->client, proc, xdr_diropargs, &args, xdr_nfsstat,
      &status, TIMEOUT) != RPC_SUCCESS)
      return(OWNERR_RPCFAIL);
   else
      return(status);
}

int rename_oper(int argc, char *argv[], nfs_env *env)
{
   renameargs args;
   int status = 0;

   memcpy((char *)&(args.from.dir), (char *)env->curhandle, NFS_FHSIZE);
   memcpy((char *)&(args.to.dir), (char *)env->curhandle, NFS_FHSIZE);

   args.from.name = argv[1];
   args.to.name = argv[2];

   Vprint("Calling rename\n");
   if (clnt_call(env->client, NFSPROC_RENAME, xdr_renameargs, &args, 
      xdr_nfsstat, &status, TIMEOUT) != RPC_SUCCESS)
      return(OWNERR_RPCFAIL);
   else
      return(status);
}

int dir_oper(int argc, char *argv[], nfs_env *env)
{
   struct readdirargs dirargs;
   struct readdirres dirres;
   dirlist *list;
   entry *ent;

   memcpy((char *)&(dirargs.dir), (char *)env->curhandle, NFS_FHSIZE);
   memset(dirargs.cookie, 0, NFS_COOKIESIZE);
   dirargs.count = DIRBATCHSIZE;

   do {
     memset((char *)&dirres, 0, sizeof(dirres));
     VVprint("Calling readdir, cookie = %d\n", (int)*(dirargs.cookie));
     if (clnt_call(env->client, NFSPROC_READDIR, xdr_readdirargs, &dirargs,
         xdr_readdirres, &dirres, TIMEOUT) != RPC_SUCCESS)
         return(OWNERR_RPCFAIL);
      else
      {
         if (dirres.status != NFS_OK) 
            return(dirres.status);
         else
         {
            list = &(dirres.readdirres_u.reply);
            if (list->entries)
            {
               for(ent = list->entries; ent->nextentry;
                   ent = ent->nextentry) printf("%s\n", ent->name);
               printf("%s\n", ent->name);
               memcpy(dirargs.cookie, ent->cookie, NFS_COOKIESIZE);
            }
         }
      }
   } while (!list->eof);

   return(NFS_OK);
}

int rlink_oper(int argc, char *argv[], nfs_env *env)
{
   diropokres lreply;
   readlinkres reply;
   int result;
   
   if ((result = lookupfile(argv[1], env, &lreply)) != NFS_OK)
      return(result);
   else
   { 
     memset((char *)&reply, 0, sizeof(reply));
     Vprint("Calling readlink\n");
     if (clnt_call(env->client, NFSPROC_READLINK, xdr_nfs_fh, &(lreply.file),
         xdr_readlinkres, &reply, TIMEOUT) != RPC_SUCCESS)
         return(OWNERR_RPCFAIL);
      else
      {
         if (reply.status != NFS_OK) 
            return(reply.status);
         else
         {
            printf("%s\n", reply.readlinkres_u.data);
            return(NFS_OK);
         }
      }
   }
}



int stat_oper(int argc, char *argv[], nfs_env *env)
{
   statfsres res;
   statfsokres *reply;

   memset((char *)&res, 0, sizeof(res));
   Vprint("Calling stat\n");
   if (clnt_call(env->client, NFSPROC_STATFS, xdr_nfs_fh, env->roothandle,
      xdr_statfsres, &res, TIMEOUT) != RPC_SUCCESS)
      return(OWNERR_RPCFAIL);
   else
   {
      if (res.status != NFS_OK)
         return(res.status);
      else
      {
         reply = &(res.statfsres_u.reply);
         printf("File system attributes:\n");
         printf("optimal transfer size: %d\n", reply->tsize);
         printf("block size: %d\n", reply->bsize);
         printf("blocks present: %d\n", reply->blocks);
         printf("blocks free: %d\n", reply->bfree);
         printf("blocks available: %d\n", reply->bavail);
         return(NFS_OK);
      }
   }
}

int id_oper(int argc, char *argv[], nfs_env *env)
{
   char hostname[MAX_MACHINE_NAME + 1];
#ifdef sun4
   int gidlist[1];
#else
   gid_t gidlist[1];
#endif

   if (argc > 1) env->uid = atoi(argv[1]);
   if (argc > 2) env->gid = atoi(argv[2]);

   printf("uid = %d, gid = %d\n", env->uid, env->gid);

   if (argc > 1) 
   {
      if (env->client->cl_auth) auth_destroy(env->client->cl_auth);
      memset((char *)hostname, 0, MAX_MACHINE_NAME + 1);
      gethostname(hostname, MAX_MACHINE_NAME); 
      gidlist[0] = env->gid;
      if (!(env->client->cl_auth = 
         authunix_create(hostname, env->uid, env->gid, 1, gidlist)))
      {
         printf("Failed to create unix authentication\nQuiting...\n");
         quit_oper(0, NULL, env);
      }
   }       
   return(NFS_OK);
}

int handle_oper(int argc, char *argv[], nfs_env *env)
{ 
   int i;
   unsigned char *p;
   FILE *outfile = NULL;

   outfile = stdout;
   if (argc > 1) 
   {
      if (!(outfile = fopen(argv[1], "a")))
         return(OWNERR_LOCALFILE);
   }
   fprintf(outfile, "%s %s", env->host, env->path); 
   p = (unsigned char *)env->curhandle; 
   for(i = 0; i < FHSIZE; i++) 
      fprintf(outfile, " %02x", (unsigned int)p[i]);
   fprintf(outfile, "\n");
   if (argc > 1)
      fclose(outfile);
   return(NFS_OK);
}

int quit_oper(int argc, char *argv[], nfs_env *env)
{
   if (env->client) 
      clnt_destroy(env->client);
   exit(0);
}

bool init_client(nfs_env *env, int port)
{
   struct sockaddr_in host_addr;
   struct hostent *host;
   int socket = RPC_ANYSOCK;

   memset(&host_addr, 0, sizeof(host_addr));
   if (isdigit(*(env->host)))
   {
      if ((long int)(host_addr.sin_addr.s_addr = inet_addr(env->host)) == -1)
         return(ERR);
   }
   else
   {
      if (!(host = (struct hostent *)gethostbyname(env->host)))
         return(ERR);
      memcpy(&host_addr.sin_addr, host->h_addr, host->h_length);
   }
   host_addr.sin_family = AF_INET;
   host_addr.sin_port = port;

   if (!(env->client = clntudp_create(&host_addr, NFS_PROGRAM, NFS_VERSION,
      TIMEOUT, &socket))) 
      return(ERR);
   else
      return(OK);
}

char *print_error(int status)
{
   switch (status) {
   case NFS_OK:
      return "No error";
   case NFSERR_PERM:
      return "Not owner";
   case NFSERR_NOENT:
      return "No such file or directory";
   case NFSERR_IO:
      return "I/O error";
   case NFSERR_NXIO:
      return "No such device or address";
   case NFSERR_ACCES:
      return "Permission denied";
   case NFSERR_EXIST:
      return "File exists";
   case NFSERR_NODEV:
      return "No such device";
   case NFSERR_NOTDIR:
      return "Not a directory";
   case NFSERR_ISDIR:
      return "Is a directory";
   case NFSERR_FBIG:
      return "File too large";
   case NFSERR_NOSPC:
      return "No space left on device";
   case NFSERR_ROFS:
      return "Read-only file system";
   case NFSERR_NAMETOOLONG:
      return "File name too long";
   case NFSERR_NOTEMPTY:
      return "Directory not empty";
   case NFSERR_DQUOT:
      return "Disc quota exceeded";
   case NFSERR_STALE:
      return "Stale NFS file handle";
   case NFSERR_WFLUSH:
      return "Write cache flushed";
   case OWNERR_RPCFAIL:
      return "RPC call returned empty reply";
   case OWNERR_LOCALFILE:
      return "Could not open local file";
   default:
      return "UKNOWN ERROR";
   }
}
 
