#include <rpc/rpc.h>
#include <stdio.h>
#include "mount.h"
#include "nfs_prot.h"
#include "time.h"

typedef struct {
   char host[MAX_MACHINE_NAME];
   char path[NFS_MAXPATHLEN];
   fhandle roothandle;
   fhandle curhandle;
   CLIENT *client;
   int uid;
   int gid;
} nfs_env;

#define bool	char 
#ifndef TRUE
  #define TRUE	(1)
  #define FALSE	(0)
#endif

#define ERR	(0)
#define OK	(1)

#define DIRBATCHSIZE (0x0400)
#define RWBATCHSIZE  (0x0400)
 
#define OWNERR_RPCFAIL		(-1)
#define OWNERR_LOCALFILE	(-2) 

extern int lookupfile();
extern void askattributes();

extern int getattr_oper();
extern int setattr_oper();
extern int cd_oper();
extern int read_oper();
extern int write_oper();
extern int rlink_oper();
extern int create_oper();
extern int remove_oper();
extern int rename_oper();
extern int dir_oper();
extern int stat_oper();
extern int id_oper();
extern int handle_oper();
extern int quit_oper();

extern bool init_client();
extern char *print_error();

