/* pmapmount.c - a small utility to get file handles via the portmapper
 *
 * v1.1 4-5-1995
 * (c) Bastiaan Bakker          Bastiaan.Bakker@twi.TUDelft.NL
 *
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <string.h>
#include "mount.h"

struct timeval TIMEOUT = { 30, 0};
char *program;

void usage()
{
   fprintf(stderr, "Usage: %s [-t timeout] host dir\n", program);
   exit(1);
}
 
void main(int argc, char *argv[])
{
   char *host, *dir;   
   struct hostent *hostent;
   struct sockaddr_in address;
   fhstatus res;
   int status, i, opt;
   unsigned long int port = RPC_ANYSOCK;
   extern int optind;
   extern char *optarg;

   program = argv[0];
   while ((opt = getopt(argc, argv, "t:")) != EOF)
   {
      switch(opt) {
      case 't':
         TIMEOUT.tv_sec = atoi(optarg);
         break;
      default:
         usage();
      }
   }   
   if (argc < optind + 2) 
      usage();

   host = argv[optind];
   dir = argv[optind + 1];

   if (isdigit(*host))
   {
      if ((long int)(address.sin_addr.s_addr = inet_addr(host)) == -1)
      {
         fprintf(stderr, "%s: %s: invalid address\n", program, host);
         exit(1);
      }
   }
   else 
   {
      if (!(hostent = gethostbyname(host)))
      {
         fprintf(stderr, "%s: %s: unknown host\n", program, host);
         exit(1);
      }
      memcpy((char *)&address.sin_addr.s_addr, hostent->h_addr,   
         hostent->h_length);
   }
   address.sin_family = AF_INET;
   address.sin_port = 0;

   memset((char *)&res, 0, sizeof(res));
   if ((status = pmap_rmtcall(&address, MOUNTPROG, MOUNTVERS, MOUNTPROC_MNT,
      xdr_dirpath, &dir, xdr_fhstatus, &res, TIMEOUT, &port)) != RPC_SUCCESS)
   {
      clnt_perrno(status);
      fprintf(stderr, "\n");
      exit(1);
   }
   if (res.fhs_status != 0) {
      fprintf(stderr, "%s: mount failed: %s\n", program, nfs_error(res.fhs_status));
      exit(1);
   }
   
   printf("%s %s", host, dir);

   for(i=0; i < FHSIZE; i++) {
      printf(" %02x", (unsigned char)res.fhstatus_u.fhs_fhandle[i]);
   }
   printf("\n");
   exit(0);
}

   
