unit sharedump;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Registry, about;

type
  TPassrecovery = class(TForm)
    about: TButton;
    Sharednames: TListBox;
    Label4: TLabel;
    Memo1: TMemo;
    SaveDialog1: TSaveDialog;
    save: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure viewitClick(Sender: TObject);
    procedure aboutClick(Sender: TObject);
    procedure saveClick(Sender: TObject);

  private
    { Private declarations }
    procedure decode(var doorgeef:array of char;length:integer);
    function screensavedecode:string;

  public
    { Public declarations }
    FIniFile: TRegIniFile;

  end;

var
  Passrecovery: TPassrecovery;

implementation

{$R *.DFM}

const
  SECTION = 'SOFTWARE\Microsoft\Windows\CurrentVersion\Network\LanMan';


procedure TPassrecovery.FormCreate(Sender: TObject);
begin
  FIniFile := TRegIniFile.Create('Sample Registry');
  ViewitClick(Sender);
end;

procedure TPassrecovery.FormDestroy(Sender: TObject);
var
  Cleanup: TRegistry;
  key: string;
begin
  key := FIniFile.FileName;
  FIniFile.Free;

  // make sure we don't leave junk in the registry behind.
  Cleanup := TRegistry.Create;
  try
    Cleanup.DeleteKey(key);
  finally
    Cleanup.Free;
  end;

end;

procedure TPassrecovery.decode(var doorgeef:array of char;length:integer);
const table1: array[32..126] of integer =
              ($15,$14,$17,$16,$11,$10,$13,$12,$1D,$1C,$1F,$1E,$19,
               $18,$1B,$1A,$05,$04,$07,$06,$01,$00,$03,$02,$0D,$0C,
               $0F,$0E,$09,$08,$0B,$0A,$75,$74,$77,$76,$71,$70,$73,
               $72,$7D,$7C,$7F,$7E,$79,$78,$7B,$7A,$65,$64,$67,$66,
               $61,$60,$63,$62,$6D,$6C,$6F,$6E,$69,$68,$6B,$6A,$55,
               $74,$77,$76,$71,$70,$73,$72,$7D,$7C,$7F,$7E,$79,$78,
               $7B,$7A,$65,$64,$67,$66,$61,$60,$63,$62,$6D,$6C,$6F,
               $4E,$49,$48,$4B);
const table2: array[32..126] of integer =
              ($BA,$BB,$B8,$B9,$BE,$BF,$BC,$BD,$B2,$B3,$B0,$B1,$B6,
               $B7,$B4,$B5,$AA,$AB,$A8,$A9,$AE,$AF,$AC,$AD,$A2,$A3,
               $A0,$A1,$A6,$A7,$A4,$A5,$DA,$DB,$D8,$D9,$DE,$DF,$DC,
               $DD,$D2,$D3,$D0,$D1,$D6,$D7,$D4,$D5,$CA,$CB,$C8,$C9,
               $CE,$CF,$CC,$CD,$C2,$C3,$C0,$C1,$C6,$C7,$C4,$C5,$FA,
               $DB,$D8,$D9,$DE,$DF,$DC,$DD,$D2,$D3,$D0,$D1,$D6,$D7,
               $D4,$D5,$CA,$CB,$C8,$C9,$CE,$CF,$CC,$CD,$C2,$C3,$C0,
               $E1,$E6,$E7,$E4);
const table3: array[32..126] of integer =
              ($6D,$6C,$6F,$6E,$69,$68,$6B,$6A,$65,$64,$67,$66,$61,
               $60,$63,$62,$7D,$7C,$7F,$7E,$79,$78,$7B,$7A,$75,$74,
               $77,$76,$71,$70,$73,$72,$0D,$0C,$0F,$0E,$09,$08,$0B,
               $0A,$05,$04,$07,$06,$01,$00,$03,$02,$1D,$1C,$1F,$1E,
               $19,$18,$1B,$1A,$15,$14,$17,$16,$11,$10,$13,$12,$2D,
               $0C,$0F,$0E,$09,$08,$0B,$0A,$05,$04,$07,$06,$01,$00,
               $03,$02,$1D,$1C,$1F,$1E,$19,$18,$1B,$1A,$15,$14,$17,
               $36,$31,$30,$33);
const table4: array[32..126] of integer =
              ($86,$87,$84,$85,$82,$83,$80,$81,$8E,$8F,$8C,$8D,$8A,
               $8B,$88,$89,$96,$97,$94,$95,$92,$93,$90,$91,$9E,$9F,
               $9C,$9D,$9A,$9B,$98,$99,$E6,$E7,$E4,$E5,$E2,$E3,$E0,
               $E1,$EE,$EF,$EC,$ED,$EA,$EB,$E8,$E9,$F6,$F7,$F4,$F5,
               $F2,$F3,$F0,$F1,$FE,$FF,$FC,$FD,$FA,$FB,$F8,$F9,$C6,
               $E7,$E4,$E5,$E2,$E3,$E0,$E1,$EE,$EF,$EC,$ED,$EA,$EB,
               $E8,$E9,$F6,$F7,$F4,$F5,$F2,$F3,$F0,$1A,$FE,$FF,$FC,
               $DD,$DA,$DB,$D8);
const table5: array[32..126] of integer =
               ($73,$72,$71,$70,$77,$76,$75,$74,$7B,$7A,$79,$78,$7F,
                $7E,$7D,$7C,$63,$62,$61,$60,$67,$66,$65,$64,$6B,$6A,
                $69,$68,$6F,$6E,$6D,$6C,$13,$12,$11,$10,$17,$16,$15,
                $14,$1B,$1A,$19,$18,$1F,$1E,$1D,$1C,$03,$02,$01,$00,
                $07,$06,$05,$04,$0B,$0A,$09,$08,$0F,$0E,$0D,$0C,$33,
                $12,$11,$10,$17,$16,$15,$14,$1B,$1A,$19,$18,$1F,$1E,
                $1D,$1C,$03,$02,$01,$00,$07,$06,$05,$1A,$0B,$0A,$09,
                $28,$2F,$2E,$2D);
const table6: array[32..126] of integer =
                ($89,$88,$8B,$8A,$8D,$8C,$8F,$8E,$81,$80,$83,$82,$85,
                 $84,$87,$86,$99,$98,$9B,$9A,$9D,$9C,$9F,$9E,$91,$90,
                 $93,$92,$95,$94,$97,$96,$E9,$E8,$EB,$EA,$ED,$EC,$EF,
                 $EE,$E1,$E0,$E3,$E2,$E5,$E4,$E7,$E6,$F9,$F8,$FB,$FA,
                 $FD,$FC,$FF,$FE,$F1,$F0,$F3,$F2,$F5,$F4,$F7,$F6,$C9,
                 $E8,$EB,$EA,$ED,$EC,$EF,$EE,$E1,$1A,$E3,$E2,$E5,$E4,
                 $E7,$E6,$F9,$F8,$FB,$FA,$FD,$FC,$FF,$1A,$F1,$F0,$F3,
                 $D2,$D5,$D4,$D7);
const table7: array[32..126] of integer=
                 ($F4,$F5,$F6,$F7,$F0,$F1,$F2,$F3,$FC,$FD,$FE,$FF,$F8,
                  $F9,$FA,$FB,$E4,$E5,$E6,$E7,$E0,$E1,$E2,$E3,$EC,$ED,
                  $EE,$EF,$E8,$E9,$EA,$EB,$94,$95,$96,$97,$90,$91,$92,
                  $93,$9C,$9D,$9E,$9F,$98,$99,$9A,$9B,$84,$85,$86,$87,
                  $80,$81,$82,$83,$8C,$8D,$8E,$8F,$88,$89,$8A,$8B,$B4,
                  $95,$96,$97,$90,$91,$92,$93,$9C,$1A,$9E,$9F,$98,$99,
                  $9A,$9B,$84,$85,$86,$87,$80,$81,$82,$1A,$8C,$8D,$8E,
                  $AF,$A8,$A9,$AA);
const table8: array[32..126] of integer=
                  ($4A,$4B,$48,$49,$4E,$4F,$4C,$4D,$42,$43,$40,$41,$46,
                   $47,$44,$45,$5A,$5B,$58,$59,$5E,$5F,$5C,$5D,$52,$53,
                   $50,$51,$56,$57,$54,$55,$2A,$2B,$28,$29,$2E,$2F,$2C,
                   $2D,$22,$23,$20,$21,$26,$27,$24,$25,$3A,$3B,$38,$39,
                   $3E,$3F,$3C,$3D,$32,$33,$30,$31,$36,$37,$34,$35,$0A,
                   $2B,$28,$29,$2E,$2F,$2C,$2D,$22,$1A,$20,$21,$26,$27,
                   $24,$25,$3A,$3B,$38,$39,$3E,$3F,$3C,$1A,$32,$33,$30,
                   $11,$16,$17,$14);

var counter,found,charnum:integer;
begin
  if length>0 then
  begin
    for charnum:= 0 to (length-1) do
    begin
      counter:=32;
      if charnum=0 then
      begin // Ja,een 2d array was een betere oplossing geweest.
        while (doorgeef[charnum]<> char(table1[counter])) AND (counter<127)do
           counter:=counter+1;
        if counter<127 then //found
          doorgeef[charnum]:=char(counter)
        else doorgeef[charnum]:='?'; //zit niet in de set
      end;
      if charnum=1 then
      begin
        while (doorgeef[charnum]<> char(table2[counter])) AND (counter<127)do
          counter:=counter+1;
        if counter<127 then //found
          doorgeef[charnum]:=char(counter)
        else doorgeef[charnum]:='?';
      end;
      if charnum=2 then
      begin
        while (doorgeef[charnum]<> char(table3[counter])) AND (counter<127)do
          counter:=counter+1;
        if counter<127 then //found
          doorgeef[charnum]:=char(counter)
        else doorgeef[charnum]:='?';
      end;
      if charnum=3 then
      begin
        while (doorgeef[charnum]<> char(table4[counter])) AND (counter<127)do
          counter:=counter+1;
        if counter<127 then //found
          doorgeef[charnum]:=char(counter)
        else doorgeef[charnum]:='?';
      end;
      if charnum=4 then
      begin
        while (doorgeef[charnum]<> char(table5[counter])) AND (counter<127)do
          counter:=counter+1;
        if counter<127 then //found
          doorgeef[charnum]:=char(counter)
        else doorgeef[charnum]:='?';
      end;
      if charnum=5 then
      begin
        while (doorgeef[charnum]<> char(table6[counter])) AND (counter<127)do
          counter:=counter+1;
        if counter<127 then //found
          doorgeef[charnum]:=char(counter)
        else doorgeef[charnum]:='?';
      end;
      if charnum=6 then
      begin
        while (doorgeef[charnum]<> char(table7[counter])) AND (counter<127)do
          counter:=counter+1;
        if counter<127 then //found
          doorgeef[charnum]:=char(counter)
        else doorgeef[charnum]:='?';
      end;
      if charnum=7 then
      begin
        while (doorgeef[charnum]<> char(table8[counter])) AND (counter<127)do
          counter:=counter+1;
        if counter<127 then //found
          doorgeef[charnum]:=char(counter)
        else doorgeef[charnum]:='?';
      end;
    end;
  end;
end;


function TPassrecovery.screensavedecode:string;
const    SECTION = '\CONTROL PANEL\Desktop';
  var flags:integer;
  tussen:array [0 .. 37] of byte;
  newpw:array[0..18] of char;
  meeloop,count:integer;



//eigenlijke decodeerroutine
function decode(in1,in2 : integer; lijn:integer): char;
const  lijst1: array [0..189] of integer= ($36,$38,$36,$39,$36,$41,$36,$42,$36,$43,$36,$44,$36,
		$45,$36,$46,$36,$30,$36,$31,$36,$32,$36,$33,$36,$34,
		$36,$35,$36,$36,$36,$37,$37,$38,$37,$39,$37,$41,$37,
		$42,$37,$43,$37,$44,$37,$45,$37,$46,$37,$30,$37,$31,
		$37,$32,$37,$33,$37,$34,$37,$35,$37,$36,$37,$37,$30,
		$38,$30,$39,$30,$41,$30,$42,$30,$43,$30,$44,$30,$45,
		$30,$46,$30,$30,$30,$31,$30,$32,$30,$33,$30,$34,$30,
		$35,$30,$36,$30,$37,$31,$38,$31,$39,$31,$41,$31,$42,
                $31,$43,$31,$44,$31,$45,$31,$46,$31,$30,$31,$31,$31,
		$32,$31,$33,$31,$34,$31,$35,$31,$36,$31,$37,$32,$38,
                $30,$39,$30,$41,$30,$42,$30,$43,$30,$44,$30,$45,$30,
                $46,$30,$30,$30,$31,$30,$32,$30,$33,$30,$34,$30,$35,
                $30,$36,$30,$37,$31,$38,$31,$39,$31,$41,$31,$42,$31,
                $43,$31,$44,$31,$45,$31,$46,$31,$30,$31,$31,$31,$32,
                $33,$33,$33,$34,$33,$35,$33,$36);
const lijst2: array[0..189] of integer= ($43,$45,$43,$46,$43,$43,$43,$44,$43,$41,$43,$42,$43,
                $38,$43,$39,$43,$36,$43,$37,$43,$34,$43,$35,$43,$32,
                $43,$33,$43,$30,$43,$31,$44,$45,$44,$46,$44,$43,$44,
                $44,$44,$41,$44,$42,$44,$38,$44,$39,$44,$36,$44,$37,
                $44,$34,$44,$35,$44,$32,$44,$33,$44,$30,$44,$31,$41,
                $45,$41,$46,$41,$43,$41,$44,$41,$41,$41,$42,$41,$38,
                $41,$39,$41,$36,$41,$37,$41,$34,$41,$35,$41,$32,$41,
		$33,$41,$30,$41,$31,$42,$45,$42,$46,$42,$43,$42,$44,
                $42,$41,$42,$42,$42,$38,$42,$39,$42,$36,$42,$37,$42,
                $34,$42,$35,$42,$32,$42,$33,$42,$30,$42,$31,$38,$45,
		$41,$46,$41,$43,$41,$44,$41,$41,$41,$42,$41,$38,$41,
		$39,$41,$36,$41,$37,$41,$34,$41,$35,$41,$32,$41,$33,
                $41,$30,$41,$31,$42,$45,$42,$46,$42,$43,$42,$44,$42,
                $41,$42,$42,$42,$38,$42,$39,$42,$36,$42,$37,$42,$34,
                $39,$35,$39,$32,$39,$33,$39,$30);
const lijst3:array [0..189] of integer= ($35,$36,$35,$37,$35,$34,$35,$35,$35,$32,$35,$33,$35,
                $30,$35,$31,$35,$45,$35,$46,$35,$43,$35,$44,$35,$41,
                $35,$42,$35,$38,$35,$39,$34,$36,$34,$37,$34,$34,$34,
                $35,$34,$32,$34,$33,$34,$30,$34,$31,$34,$45,$34,$46,
		$34,$43,$34,$44,$34,$41,$34,$42,$34,$38,$34,$39,$33,
                $36,$33,$37,$33,$34,$33,$35,$33,$32,$33,$33,$33,$30,
                $33,$31,$33,$45,$33,$46,$33,$43,$33,$44,$33,$41,$33,
                $42,$33,$38,$33,$39,$32,$36,$32,$37,$32,$34,$32,$35,
		$32,$32,$32,$33,$32,$30,$32,$31,$32,$45,$32,$46,$32,
                $43,$32,$44,$32,$41,$32,$42,$32,$38,$32,$39,$31,$36,
		$33,$37,$33,$34,$33,$35,$33,$32,$33,$33,$33,$30,$33,
                $31,$33,$45,$33,$46,$33,$43,$33,$44,$33,$41,$33,$42,
		$33,$38,$33,$39,$32,$36,$32,$37,$32,$34,$32,$35,$32,
                $32,$32,$33,$32,$30,$32,$31,$32,$45,$32,$46,$32,$43,
                $30,$44,$30,$41,$30,$42,$30,$38);
const lijst4: array[0..189] of integer = ($33,$44,$33,$43,$33,$46,$33,$45,$33,$39,$33,$38,$33,
                $42,$33,$41,$33,$35,$33,$34,$33,$37,$33,$36,$33,$31,
                $33,$30,$33,$33,$33,$32,$32,$44,$32,$43,$32,$46,$32,
                $45,$32,$39,$32,$38,$32,$42,$32,$41,$32,$35,$32,$34,
                $32,$37,$32,$36,$32,$31,$32,$30,$32,$33,$32,$32,$35,
                $44,$35,$43,$35,$46,$35,$45,$35,$39,$35,$38,$35,$42,
                $35,$41,$35,$35,$35,$34,$35,$37,$35,$36,$35,$31,$35,
                $30,$35,$33,$35,$32,$34,$44,$34,$43,$34,$46,$34,$45,
                $34,$39,$34,$38,$34,$42,$34,$41,$34,$35,$34,$34,$34,
                $37,$34,$36,$34,$31,$34,$30,$34,$33,$34,$32,$37,$44,
                $35,$43,$35,$46,$35,$45,$35,$39,$35,$38,$35,$42,$35,
                $41,$35,$35,$35,$34,$35,$37,$35,$36,$35,$31,$35,$30,
		$35,$33,$35,$32,$34,$44,$34,$43,$34,$46,$34,$45,$34,
                $39,$34,$38,$34,$42,$34,$41,$34,$35,$34,$34,$34,$37,
                $36,$36,$36,$31,$36,$30,$36,$33);
const lijst5: array[0..189] of integer= ($34,$37,$34,$36,$34,$35,$34,$34,$34,$33,$34,$32,$34,
		$31,$34,$30,$34,$46,$34,$45,$34,$44,$34,$43,$34,$42,
                $34,$41,$34,$39,$34,$38,$35,$37,$35,$36,$35,$35,$35,
                $34,$35,$33,$35,$32,$35,$31,$35,$30,$35,$46,$35,$45,
                $35,$44,$35,$43,$35,$42,$35,$41,$35,$39,$35,$38,$32,
                $37,$32,$36,$32,$35,$32,$34,$32,$33,$32,$32,$32,$31,
                $32,$30,$32,$46,$32,$45,$32,$44,$32,$43,$32,$42,$32,
                $41,$32,$39,$32,$38,$33,$37,$33,$36,$33,$35,$33,$34,
                $33,$33,$33,$32,$33,$31,$33,$30,$33,$46,$33,$45,$33,
		$44,$33,$43,$33,$42,$33,$41,$33,$39,$33,$38,$30,$37,
                $32,$36,$32,$35,$32,$34,$32,$33,$32,$32,$32,$31,$32,
		$30,$32,$46,$32,$45,$32,$44,$32,$43,$32,$42,$32,$41,
                $32,$39,$32,$38,$33,$37,$33,$36,$33,$35,$33,$34,$33,
		$33,$33,$32,$33,$31,$33,$30,$33,$46,$33,$45,$33,$44,
                $31,$43,$31,$42,$31,$41,$31,$39);
const lijst6:array[0..189]of integer= ($34,$39,$34,$38,$34,$42,$34,$41,$34,$44,$34,$43,$34,
                $46,$34,$45,$34,$31,$34,$30,$34,$33,$34,$32,$34,$35,
		$34,$34,$34,$37,$34,$36,$35,$39,$35,$38,$35,$42,$35,
                $41,$35,$44,$35,$43,$35,$46,$35,$45,$35,$31,$35,$30,
                $35,$33,$35,$32,$35,$35,$35,$34,$35,$37,$35,$36,$32,
                $39,$32,$38,$32,$42,$32,$41,$32,$44,$32,$43,$32,$46,
                $32,$45,$32,$31,$32,$30,$32,$33,$32,$32,$32,$35,$32,
                $34,$32,$37,$32,$36,$33,$39,$33,$38,$33,$42,$33,$41,
                $33,$44,$33,$43,$33,$46,$33,$45,$33,$31,$33,$30,$33,
                $33,$33,$32,$33,$35,$33,$34,$33,$37,$33,$36,$30,$39,
		$32,$38,$32,$42,$32,$41,$32,$44,$32,$43,$32,$46,$32,
                $45,$32,$31,$32,$30,$32,$33,$32,$32,$32,$35,$32,$34,
                $32,$37,$32,$36,$33,$39,$33,$38,$33,$42,$33,$41,$33,
                $44,$33,$43,$33,$46,$33,$45,$33,$31,$33,$30,$33,$33,
                $31,$32,$31,$35,$31,$34,$31,$37);
const lijst7:array[0..189] of integer= ($38,$31,$38,$30,$38,$33,$38,$32,$38,$35,$38,$34,$38,
                $37,$38,$36,$38,$39,$38,$38,$38,$42,$38,$41,$38,$44,
		$38,$43,$38,$46,$38,$45,$39,$31,$39,$30,$39,$33,$39,
                $32,$39,$35,$39,$34,$39,$37,$39,$36,$39,$39,$39,$38,
                $39,$42,$39,$41,$39,$44,$39,$43,$39,$46,$39,$45,$45,
		$31,$45,$30,$45,$33,$45,$32,$45,$35,$45,$34,$45,$37,
		$45,$36,$45,$39,$45,$38,$45,$42,$45,$41,$45,$44,$45,
                $43,$45,$46,$45,$45,$46,$31,$46,$30,$46,$33,$46,$32,
                $46,$35,$46,$34,$46,$37,$46,$36,$46,$39,$46,$38,$46,
                $42,$46,$41,$46,$44,$46,$43,$46,$46,$46,$45,$43,$31,
                $45,$30,$45,$33,$45,$32,$45,$35,$45,$34,$45,$37,$45,
                $36,$45,$39,$45,$38,$45,$42,$45,$41,$45,$44,$45,$43,
                $45,$46,$45,$45,$46,$31,$46,$30,$46,$33,$46,$32,$46,
                $35,$46,$34,$46,$37,$46,$36,$46,$39,$46,$38,$46,$42,
		$44,$41,$44,$44,$44,$43,$44,$46);
const lijst8:array[0..189]of integer= ($33,$42,$33,$41,$33,$39,$33,$38,$33,$46,$33,$45,$33,
                $44,$33,$43,$33,$33,$33,$32,$33,$31,$33,$30,$33,$37,
                $33,$36,$33,$35,$33,$34,$32,$42,$32,$41,$32,$39,$32,
		$38,$32,$46,$32,$45,$32,$44,$32,$43,$32,$33,$32,$32,
                $32,$31,$32,$30,$32,$37,$32,$36,$32,$35,$32,$34,$35,
                $42,$35,$41,$35,$39,$35,$38,$35,$46,$35,$45,$35,$44,
                $35,$43,$35,$33,$35,$32,$35,$31,$35,$30,$35,$37,$35,
		$36,$35,$35,$35,$34,$34,$42,$34,$41,$34,$39,$34,$38,
                $34,$46,$34,$45,$34,$44,$34,$43,$34,$33,$34,$32,$34,
                $31,$34,$30,$34,$37,$34,$36,$34,$35,$34,$34,$37,$42,
                $35,$41,$35,$39,$35,$38,$35,$46,$35,$45,$35,$44,$35,
		$43,$35,$33,$35,$32,$35,$31,$35,$30,$35,$37,$35,$36,
                $35,$35,$35,$34,$34,$42,$34,$41,$34,$39,$34,$38,$34,
                $46,$34,$45,$34,$44,$34,$43,$34,$33,$34,$32,$34,$31,
                $36,$30,$36,$37,$36,$36,$36,$35);
const lijst9:array[0..189] of integer= ($35,$41,$35,$42,$35,$38,$35,$39,$35,$45,$35,$46,$35,
                $43,$35,$44,$35,$32,$35,$33,$35,$30,$35,$31,$35,$36,
                $35,$37,$35,$34,$35,$35,$34,$41,$34,$42,$34,$38,$34,
                $39,$34,$45,$34,$46,$34,$43,$34,$44,$34,$32,$34,$33,
                $34,$30,$34,$31,$34,$36,$34,$37,$34,$34,$34,$35,$33,
                $41,$33,$42,$33,$38,$33,$39,$33,$45,$33,$46,$33,$43,
                $33,$44,$33,$32,$33,$33,$33,$30,$33,$31,$33,$36,$33,
		$37,$33,$34,$33,$35,$32,$41,$32,$42,$32,$38,$32,$39,
                $32,$45,$32,$46,$32,$43,$32,$44,$32,$32,$32,$33,$32,
                $30,$32,$31,$32,$36,$32,$37,$32,$34,$32,$35,$31,$41,
		$33,$42,$33,$38,$33,$39,$33,$45,$33,$46,$33,$43,$33,
		$44,$33,$32,$33,$33,$33,$30,$33,$31,$33,$36,$33,$37,
                $33,$34,$33,$35,$32,$41,$32,$42,$32,$38,$32,$39,$32,
                $45,$32,$46,$32,$43,$32,$44,$32,$32,$32,$33,$32,$30,
                $30,$31,$30,$36,$30,$37,$30,$34);
const lijst10:array[0..189] of integer=($41,$43,$41,$44,$41,$45,$41,$46,$41,$38,$41,$39,$41,
                $41,$41,$42,$41,$34,$41,$35,$41,$36,$41,$37,$41,$30,
                $41,$31,$41,$32,$41,$33,$42,$43,$42,$44,$42,$45,$42,
                $46,$42,$38,$42,$39,$42,$41,$42,$42,$42,$34,$42,$35,
		$42,$36,$42,$37,$42,$30,$42,$31,$42,$32,$42,$33,$43,
                $43,$43,$44,$43,$45,$43,$46,$43,$38,$43,$39,$43,$41,
                $43,$42,$43,$34,$43,$35,$43,$36,$43,$37,$43,$30,$43,
                $31,$43,$32,$43,$33,$44,$43,$44,$44,$44,$45,$44,$46,
		$44,$38,$44,$39,$44,$41,$44,$42,$44,$34,$44,$35,$44,
                $36,$44,$37,$44,$30,$44,$31,$44,$32,$44,$33,$45,$43,
                $43,$44,$43,$45,$43,$46,$43,$38,$43,$39,$43,$41,$43,
                $42,$43,$34,$43,$35,$43,$36,$43,$37,$43,$30,$43,$31,
		$43,$32,$43,$33,$44,$43,$44,$44,$44,$45,$44,$46,$44,
                $38,$44,$39,$44,$41,$44,$42,$44,$34,$44,$35,$44,$36,
                $46,$37,$46,$30,$46,$31,$46,$32);
const lijst11:array[0..189] of integer=($36,$37,$36,$36,$36,$35,$36,$34,$36,$33,$36,$32,$36,
                $31,$36,$30,$36,$46,$36,$45,$36,$44,$36,$43,$36,$42,
                $36,$41,$36,$39,$36,$38,$37,$37,$37,$36,$37,$35,$37,
                $34,$37,$33,$37,$32,$37,$31,$37,$30,$37,$46,$37,$45,
                $37,$44,$37,$43,$37,$42,$37,$41,$37,$39,$37,$38,$30,
                $37,$30,$36,$30,$35,$30,$34,$30,$33,$30,$32,$30,$31,
                $30,$30,$30,$46,$30,$45,$30,$44,$30,$43,$30,$42,$30,
                $41,$30,$39,$30,$38,$31,$37,$31,$36,$31,$35,$31,$34,
                $31,$33,$31,$32,$31,$31,$31,$30,$31,$46,$31,$45,$31,
                $44,$31,$43,$31,$42,$31,$41,$31,$39,$31,$38,$32,$37,
                $30,$36,$30,$35,$30,$34,$30,$33,$30,$32,$30,$31,$30,
		$30,$30,$46,$30,$45,$30,$44,$30,$43,$30,$42,$30,$41,
		$30,$39,$30,$38,$31,$37,$31,$36,$31,$35,$31,$34,$31,
                $33,$31,$32,$31,$31,$31,$30,$31,$46,$31,$45,$31,$44,
                $33,$43,$33,$42,$33,$41,$33,$39);
const lijst12:array[0..189] of integer=($44,$38,$44,$39,$44,$41,$44,$42,$44,$43,$44,$44,$44,
		$45,$44,$46,$44,$30,$44,$31,$44,$32,$44,$33,$44,$34,
                $44,$35,$44,$36,$44,$37,$43,$38,$43,$39,$43,$41,$43,
                $42,$43,$43,$43,$44,$43,$45,$43,$46,$43,$30,$43,$31,
                $43,$32,$43,$33,$43,$34,$43,$35,$43,$36,$43,$37,$42,
                $38,$42,$39,$42,$41,$42,$42,$42,$43,$42,$44,$42,$45,
                $42,$46,$42,$30,$42,$31,$42,$32,$42,$33,$42,$34,$42,
                $35,$42,$36,$42,$37,$41,$38,$41,$39,$41,$41,$41,$42,
                $41,$43,$41,$44,$41,$45,$41,$46,$41,$30,$41,$31,$41,
		$32,$41,$33,$41,$34,$41,$35,$41,$36,$41,$37,$39,$38,
		$42,$39,$42,$41,$42,$42,$42,$43,$42,$44,$42,$45,$42,
                $46,$42,$30,$42,$31,$42,$32,$42,$33,$42,$34,$42,$35,
                $42,$36,$42,$37,$41,$38,$41,$39,$41,$41,$41,$42,$41,
		$43,$41,$44,$41,$45,$41,$46,$41,$30,$41,$31,$41,$32,
                $38,$33,$38,$34,$38,$35,$38,$36);
const lijst13:array[0..189] of integer=($37,$34,$37,$35,$37,$36,$37,$37,$37,$30,$37,$31,$37,
                $32,$37,$33,$37,$43,$37,$44,$37,$45,$37,$46,$37,$38,
		$37,$39,$37,$41,$37,$42,$36,$34,$36,$35,$36,$36,$36,
                $37,$36,$30,$36,$31,$36,$32,$36,$33,$36,$43,$36,$44,
                $36,$45,$36,$46,$36,$38,$36,$39,$36,$41,$36,$42,$31,
                $34,$31,$35,$31,$36,$31,$37,$31,$30,$31,$31,$31,$32,
                $31,$33,$31,$43,$31,$44,$31,$45,$31,$46,$31,$38,$31,
                $39,$31,$41,$31,$42,$30,$34,$30,$35,$30,$36,$30,$37,
                $30,$30,$30,$31,$30,$32,$30,$33,$30,$43,$30,$44,$30,
                $45,$30,$46,$30,$38,$30,$39,$30,$41,$30,$42,$33,$34,
                $31,$35,$31,$36,$31,$37,$31,$30,$31,$31,$31,$32,$31,
                $33,$31,$43,$31,$44,$31,$45,$31,$46,$31,$38,$31,$39,
                $31,$41,$31,$42,$30,$34,$30,$35,$30,$36,$30,$37,$30,
                $30,$30,$31,$30,$32,$30,$33,$30,$43,$30,$44,$30,$45,
                $32,$46,$32,$38,$32,$39,$32,$41);
const lijst14:array[0..189] of integer=($42,$35,$42,$34,$42,$37,$42,$36,$42,$31,$42,$30,$42,
                $33,$42,$32,$42,$44,$42,$43,$42,$46,$42,$45,$42,$39,
		$42,$38,$42,$42,$42,$41,$41,$35,$41,$34,$41,$37,$41,
                $36,$41,$31,$41,$30,$41,$33,$41,$32,$41,$44,$41,$43,
		$41,$46,$41,$45,$41,$39,$41,$38,$41,$42,$41,$41,$44,
		$35,$44,$34,$44,$37,$44,$36,$44,$31,$44,$30,$44,$33,
		$44,$32,$44,$44,$44,$43,$44,$46,$44,$45,$44,$39,$44,
                $38,$44,$42,$44,$41,$43,$35,$43,$34,$43,$37,$43,$36,
                $43,$31,$43,$30,$43,$33,$43,$32,$43,$44,$43,$43,$43,
                $46,$43,$45,$43,$39,$43,$38,$43,$42,$43,$41,$46,$35,
                $44,$34,$44,$37,$44,$36,$44,$31,$44,$30,$44,$33,$44,
		$32,$44,$44,$44,$43,$44,$46,$44,$45,$44,$39,$44,$38,
                $44,$42,$44,$41,$43,$35,$43,$34,$43,$37,$43,$36,$43,
                $31,$43,$30,$43,$33,$43,$32,$43,$44,$43,$43,$43,$46,
		$45,$45,$45,$39,$45,$38,$45,$42);
const lijst15:array[0..189] of integer=($42,$37,$42,$36,$42,$35,$42,$34,$42,$33,$42,$32,$42,
                $31,$42,$30,$42,$46,$42,$45,$42,$44,$42,$43,$42,$42,
                $42,$41,$42,$39,$42,$38,$41,$37,$41,$36,$41,$35,$41,
		$34,$41,$33,$41,$32,$41,$31,$41,$30,$41,$46,$41,$45,
                $41,$44,$41,$43,$41,$42,$41,$41,$41,$39,$41,$38,$44,
                $37,$44,$36,$44,$35,$44,$34,$44,$33,$44,$32,$44,$31,
                $44,$30,$44,$46,$44,$45,$44,$44,$44,$43,$44,$42,$44,
		$41,$44,$39,$44,$38,$43,$37,$43,$36,$43,$35,$43,$34,
                $43,$33,$43,$32,$43,$31,$43,$30,$43,$46,$43,$45,$43,
                $44,$43,$43,$43,$42,$43,$41,$43,$39,$43,$38,$46,$37,
		$44,$36,$44,$35,$44,$34,$44,$33,$44,$32,$44,$31,$44,
                $30,$44,$46,$44,$45,$44,$44,$44,$43,$44,$42,$44,$41,
                $44,$39,$44,$38,$43,$37,$43,$36,$43,$35,$43,$34,$43,
		$33,$43,$32,$43,$31,$43,$30,$43,$46,$43,$45,$43,$44,
                $45,$43,$45,$42,$45,$41,$45,$39);
const lijst16:array[0..189] of integer=($37,$46,$37,$45,$37,$44,$37,$43,$37,$42,$37,$41,$37,
                $39,$37,$38,$37,$37,$37,$36,$37,$35,$37,$34,$37,$33,
                $37,$32,$37,$31,$37,$30,$36,$46,$36,$45,$36,$44,$36,
                $43,$36,$42,$36,$41,$36,$39,$36,$38,$36,$37,$36,$36,
                $36,$35,$36,$34,$36,$33,$36,$32,$36,$31,$36,$30,$31,
                $46,$31,$45,$31,$44,$31,$43,$31,$42,$31,$41,$31,$39,
                $31,$38,$31,$37,$31,$36,$31,$35,$31,$34,$31,$33,$31,
		$32,$31,$31,$31,$30,$30,$46,$30,$45,$30,$44,$30,$43,
                $30,$42,$30,$41,$30,$39,$30,$38,$30,$37,$30,$36,$30,
                $35,$30,$34,$30,$33,$30,$32,$30,$31,$30,$30,$33,$46,
		$31,$45,$31,$44,$31,$43,$31,$42,$31,$41,$31,$39,$31,
		$38,$31,$37,$31,$36,$31,$35,$31,$34,$31,$33,$31,$32,
                $31,$31,$31,$30,$30,$46,$30,$45,$30,$44,$30,$43,$30,
                $42,$30,$41,$30,$39,$30,$38,$30,$37,$30,$36,$30,$35,
                $32,$34,$32,$33,$32,$32,$32,$31);
const lijst17:array[0..189] of integer=($7d,$d6,$7d,$d7,$7d,$af,$7d,$ac,$7d,$ad,$7d,$aa,$7d,
                $ab,$7d,$a8,$7d,$de,$7d,$df,$7d,$dc,$7d,$dd,$7d,$da,
                $7d,$db,$7d,$d8,$7d,$d9,$7c,$d6,$7c,$d7,$7c,$af,$7c,
                $ac,$7c,$ad,$7c,$aa,$7c,$ab,$7c,$a8,$7c,$de,$7c,$df,
		$7c,$dc,$7c,$dd,$7c,$da,$7c,$db,$7c,$d8,$7c,$d9,$7b,
                $d6,$7b,$d7,$7b,$af,$7b,$ac,$7b,$ad,$7b,$aa,$7b,$ab,
                $7b,$a8,$7b,$de,$7b,$df,$7b,$dc,$7b,$dd,$7b,$da,$7b,
                $db,$7b,$d8,$7b,$d9,$7a,$d6,$7a,$d7,$7a,$af,$7a,$ac,
		$7a,$ad,$7a,$aa,$7a,$ab,$7a,$a8,$7a,$de,$7a,$df,$7a,
                $dc,$7a,$dd,$7a,$da,$7a,$db,$7a,$d8,$7a,$d9,$79,$d6,
                $7b,$d7,$7b,$af,$7b,$ac,$7b,$ad,$7b,$aa,$7b,$ab,$7b,
		$a8,$7b,$de,$7b,$df,$7b,$dc,$7b,$dd,$7b,$da,$7b,$db,
		$7b,$d8,$7b,$d9,$7a,$d6,$7a,$d7,$7a,$af,$7a,$ac,$7a,
                $ad,$7a,$aa,$7a,$ab,$7a,$a8,$7a,$de,$7a,$df,$7a,$dc,
                $78,$dd,$78,$da,$78,$db,$78,$d8);
const lijst18:array[0..189] of integer=($30,$24,$30,$25,$30,$5f,$30,$5c,$30,$59,$30,$5e,$30,
                $5b,$30,$58,$30,$2c,$30,$2d,$30,$2e,$30,$2f,$30,$28,
                $30,$29,$30,$2a,$30,$2b,$33,$24,$33,$25,$33,$5f,$33,
		$5c,$33,$59,$33,$5e,$33,$5b,$33,$58,$33,$2c,$33,$2d,
                $33,$2e,$33,$2f,$33,$28,$33,$29,$33,$2a,$33,$2b,$4f,
                $24,$4f,$25,$4f,$5f,$4f,$5c,$4f,$59,$4f,$5e,$4f,$5b,
                $4f,$58,$4f,$2c,$4f,$2d,$4f,$2e,$4f,$2f,$4f,$28,$4f,
                $29,$4f,$2a,$4f,$2b,$4e,$24,$4e,$25,$4e,$5f,$4e,$5c,
                $4e,$59,$4e,$5e,$4e,$5b,$4e,$58,$4e,$2c,$4e,$2d,$4e,
                $2e,$4e,$2f,$4e,$28,$4e,$29,$4e,$2a,$4e,$2b,$34,$24,
		$4f,$25,$4f,$5f,$4f,$5c,$4f,$59,$4f,$5e,$4f,$5b,$4f,
                $58,$4f,$2c,$4f,$2d,$4f,$2e,$4f,$2f,$4f,$28,$4f,$29,
		$4f,$2a,$4f,$2b,$4e,$24,$4e,$25,$4e,$5f,$4e,$5c,$4e,
		$59,$4e,$5e,$4e,$5b,$4e,$58,$4e,$2c,$4e,$2d,$4e,$2e,
		$37,$2f,$37,$28,$37,$29,$37,$2a);

var lijst: array [0..189] of integer;
    terug : char;
    counter,found:integer;
begin
 found:=0;

   case lijn of
       1: for counter:=0 to 189 do lijst[counter]:=lijst1[counter];
       2: for counter:=0 to 189 do lijst[counter]:=lijst2[counter];
       3: for counter:=0 to 189 do lijst[counter]:=lijst3[counter];
       4: for counter:=0 to 189 do lijst[counter]:=lijst4[counter];
       5: for counter:=0 to 189 do lijst[counter]:=lijst5[counter];
       6: for counter:=0 to 189 do lijst[counter]:=lijst6[counter];
       7: for counter:=0 to 189 do lijst[counter]:=lijst7[counter];
       8: for counter:=0 to 189 do lijst[counter]:=lijst8[counter];
       9: for counter:=0 to 189 do lijst[counter]:=lijst9[counter];
      10: for counter:=0 to 189 do lijst[counter]:=lijst10[counter];
      11: for counter:=0 to 189 do lijst[counter]:=lijst11[counter];
      12: for counter:=0 to 189 do lijst[counter]:=lijst12[counter];
      13: for counter:=0 to 189 do lijst[counter]:=lijst13[counter];
      14: for counter:=0 to 189 do lijst[counter]:=lijst14[counter];
      15: for counter:=0 to 189 do lijst[counter]:=lijst15[counter];
      16: for counter:=0 to 189 do lijst[counter]:=lijst16[counter];
      17: for counter:=0 to 189 do lijst[counter]:=lijst17[counter];
      18: for counter:=0 to 189 do lijst[counter]:=lijst18[counter];
   end;
   counter:=31;
   repeat
      counter:=counter+1;
      if (in1=lijst[((counter-32)*2)])then
	 if (in2=lijst[((counter-32)*2 +1)]) then
	    found:=1;

   until((counter>127) or(found=1));
   decode:=char(counter);
end;
begin
   Finifile.RootKey:= HKEY_CURRENT_USER;
  if (Finifile.openkey(SECTION, FALSE)=FALSE) then memo1.lines.add('openkey_error');

{ case Finifile.GetDataType('ScreenSaveUsePassword') of
   rdUnknown: errormsg.text:='unknown';
   rdString: errormsg.text:='string';
   rdExpandString:errormsg.text:='expstring';
   rdInteger:errormsg.text:='integer';
   rdBinary:errormsg.text:='binary';
 end;}
 FIniFile.ReadBinaryData('ScreenSave_Data',tussen,37);
 count:=FiniFile.Getdatasize('ScreenSave_Data');
 count:=count-1;
 if (count>1) then
 begin
   for meeloop:= 0 to round(((count-2)/2)) do
     newpw[meeloop]:=decode(tussen[2*meeloop],tussen[2*meeloop+1],meeloop+1);
   newpw[round((count-2)/2)+1]:=char(0);
   screensavedecode:=newpw;
 end else screensavedecode:='';
 FiniFile.closekey;
end;



procedure TPassrecovery.viewitClick(Sender: TObject);
var counter: integer;
    naam,comment,path,rop,fup:string;
    found: integer;
    tussen:array [0 .. 10 ] of char;
    scrspwd:string;

begin
  memo1.lines.clear;
  memo1.lines.add('Shares as reported by the system :');
  Finifile.RootKey:= HKEY_LOCAL_MACHINE;
  if (Finifile.openkey(SECTION, FALSE)=FALSE) then memo1.lines.add('openkey_error');
  Finifile.getkeynames(sharednames.items);
  Finifile.closekey;
  if sharednames.items.count<=0 then
  begin
    memo1.lines.add('No shares reported.');
  end else
  begin
    for found:= 0 to sharednames.items.count-1 do
    begin
      Finifile.RootKey:= HKEY_LOCAL_MACHINE;
      if (Finifile.openkey(SECTION+'\'+sharednames.items.strings[found], FALSE)=FALSE)
      then begin
      memo1.lines.add('openkey_error');
      halt;
      end;
      path := FIniFile.ReadString('', 'Path', '');
      comment:= FIniFile.ReadString('', 'Remark', '');
      for counter:=0 to 10 do tussen[counter]:=char(0);
      FIniFile.ReadBinaryData('Parm1enc',tussen,10);
      decode(tussen,FiniFile.Getdatasize('Parm1enc'));
      if FiniFile.Getdatasize('Parm1enc')>0 then fup:=tussen
      else fup:='';
      for counter:=0 to 10 do tussen[counter]:=char(0);
      FIniFile.ReadBinaryData('Parm2enc',tussen,10);
      decode(tussen,FiniFile.Getdatasize('Parm2enc'));
      if FiniFile.Getdatasize('Parm2enc')>0 then rop:=tussen
      else rop:='';
      Finifile.closekey;
      memo1.lines.add(''''+sharednames.items.strings[found]+'''-'+path+' '''+
                      comment+''' RO:'''+rop+''' RW:'''+fup+'''');
    end;
  end;
  memo1.lines.add('');
  scrspwd:=screensavedecode;
  if scrspwd<>'' then
    memo1.lines.add('Screensaver password : '''+scrspwd+'''')
  else memo1.lines.add('No screensaver password reported.');
end;

procedure TPassrecovery.aboutClick(Sender: TObject);
begin
  aboutbox.enabled:=true;
  aboutbox.visible:=true;
end;

procedure TPassrecovery.saveClick(Sender: TObject);
begin
      if savedialog1.execute= true then
      begin
        memo1.lines.SaveToFile(savedialog1.filename);
      end;
end;

end.
