#!/usr/bin/perl -w

# Definitions. Feel free to change them.

$device = "/dev/cuecat"; #Device to read from
$config = "~/.cueactrc"; #Config file to read from
$scan_max = 0;           #Maximum number to scan; 0 = infinity.
$verbosity = 1;          #0 = silent, 2 = extra verbosity.

############################################################################
#       DON'T CHANGE ANYTHING BELOW UNLESS YOU KNOW WHAT YOU ARE DOING.    #
############################################################################

parse_cmdline();
open(CUECAT_DEV, $device) || die "Couldn't open device: $!";

$scan_max --;
do {
    read_cue();
    $scan_max -- if ($scan_max > 0);
} while ($scan_max != 0);

sub parse_cmdline () {
    use Getopt::Std;
    my %options;
    getopt('frvn', \%options);
    foreach (keys %options) {
	if ($_ eq 'f' && ($options{$_} =~ /\D/ || $options{$_} != 1)) {
	    $device = $options{$_};
	} elsif ($_ eq 'r' && ($options{$_} =~ /\D/ || $options{$_} != 1)) {
	    $config = $options{$_};
	} elsif ($_ eq 'v' && $options{$_} =~ /^\d*$/) {
	    $verbosity = $options{$_};
	} elsif ($_ eq 'n' && $options{$_} =~ /^\d*$/) {
	    $scan_max = $options{$_};
	} else {
	    usage();
	}
    }
}

sub usage () {
    die <<EOF
USAGE:
    $0 [-f -r -v -n]
	-f: Specify device to read from
        -r: Specify config file to use
	-v: Specify verbosity level (0 = silent, 2 = extra verbosity)
	-n: Specify number of barcodes to read (0 = infinity)
EOF
    
}

sub read_cue () {
    $_ = <CUECAT_DEV>;
    return 0 if !defined($_);
    chomp;
    print "Got code $_.\n" if $verbosity >= 2;
    do $config;
}

