#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <unistd.h>
#include <errno.h>
#include "libfoocat.h"

#define DECODE_VERSION 0.0.7
#define	TIMEOUT 6

void output(char * scan);


int main(int argc, char **argv)
{
	char						sample[2048];
	struct chunks 	*c;
	int							bs;

	if (argc > 1)
	{
		output(argv[1]);
	}
	else
	{
		while(1)
		{
			bs=read(0, sample, 2047);
			sample[bs]=0;
			output(sample);
			fflush(stdout);
		};	
	};
	return 0;
}



void output(char * scan)
{
		struct chunks 	*c;
		char						sample[2048];
		struct bookinfo	*ama;
		char						*s, *upac;
		struct cueinfo 	*ci=NULL;
		int							bl;
		
		c=convert(scan);
		if (c != NULL)
		{
			if (c->data != NULL)
			{
				decode_type(c);
				sprintf(sample,"DATA\t%s\t%s\t%s\t", c->serial, c->ctype, c->data);
				if(c->formatted!=NULL)
				{
						strcat(sample,c->formatted);
				};
				strcat(sample,"\n");
				printf("%s",sample);

				ci=docue(c, NULL, 6);
				sprintf(sample,"");
				if(c->formatted!=NULL)
				{
						strcat(sample,c->formatted);
				};
				strcat(sample,"\t");
				if (ci != NULL)
				if(ci->cuereq != NULL)
				{
						strcat(sample,ci->cuereq);
				};
				strcat(sample,"\t");
				if (ci != NULL)
				if(ci->cueurl!=NULL)
				{
						strcat(sample,ci->cueurl);
				};
				strcat(sample,"\t");
				if (ci != NULL)
				if(ci->cuedesc!=NULL)
				{
						strcat(sample,ci->cuedesc);
				};
				strcat(sample,"\n");
				printf("CUE\t%s", sample);
				free_cueinfo(ci);

				if ( (strcmp(c->ctype,"IB5")==0) || (strcmp(c->ctype,"IBN")==0) )
				{
					ama=doamazon(c, TIMEOUT);
					memset(sample,0,2048);
					if (ama != NULL)
					{
						if(c->formatted != NULL)
						{
								strcat(sample,c->formatted);
						};
						strcat(sample,"\t");
						if(ama->url != NULL)
						{
								strcat(sample,ama->url);
						};
						strcat(sample,"\t");
						if(ama->title != NULL)
						{
								strcat(sample,ama->title);
						};
						strcat(sample,"\t");
						if(ama->author != NULL)
						{
								strcat(sample,ama->author);
						};
						strcat(sample,"\t");
						if(ama->image != NULL)
						{
								strcat(sample,ama->image);
						}
						strcat(sample,"\n");
						free_bookinfo(ama);
					}
					else
					{
						sprintf(sample,"");
						if(c->formatted != NULL)
						{
								sprintf(sample,c->formatted);
						};
						strcat(sample,"\t\t\t\t\n");
					};
					printf("AMAZON\t%s",sample);
				}; // amazon

				if ( (strcmp(c->ctype,"UPA")==0)  )
				{
					ama=dobn(c, TIMEOUT);
					memset(sample,0,2048);
					if (ama != NULL)
					{
						if(c->data != NULL)
						{
								strcat(sample,c->data);
						};
						strcat(sample,"\t");
						if(ama->url != NULL)
						{
								strcat(sample,ama->url);
						};
						strcat(sample,"\t");
						if(ama->title != NULL)
						{
								strcat(sample,ama->title);
						};
						strcat(sample,"\t");
						if(ama->author != NULL)
						{
								strcat(sample,ama->author);
						};
						strcat(sample,"\t");
						if(ama->image != NULL)
						{
								strcat(sample,ama->image);
						}
						strcat(sample,"\n");
						free_bookinfo(ama);
					}
					else
					{
						sprintf(sample,"");
						if(c->data != NULL)
						{
								sprintf(sample,c->data);
						};
						strcat(sample,"\t\t\t\t\n");
					};
					printf("BN\t%s",sample);
				}; // amazon


				// grocery image test
				if(c->formatted != NULL)
				{
					if (strcmp(c->ctype,"UPA")==0)
					{
						sprintf(sample,"http://www.egrocery.com/products/large/%s.jpg",c->formatted);
						bl=http_head(sample,6);
						if (bl == 200)
						{
							// name, maker, desc, url, imageurl
							sprintf(sample,"GROC\t\t\t\t\thttp://www.egrocery.com/products/large/%s.jpg\n",c->formatted);
							printf("%s",sample);
						};
					};
				};

			}; // c->data != NULL

		// finish up
		deallocmem(c->formatted);
		deallocmem(c->serial);
		deallocmem(c->data);
		deallocmem(c);
	}; // c != null
}; // void output();
