/*
 * Thanks to : 
 *        Ian Eure <ieure@sickfuck.org>
 *	for gnome-moz-remote fix        
 *
 *
 *
 */

#include <gnome.h>
#include <gdk/gdk.h>
#include <applet-widget.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "libfoocat.h"

void	gotmouse();
void	do_cuecat();
void	lostmouse();
void	keypress();

GtkWidget 	*applet;
GtkWidget 	*label;
GtkWidget 	*event_box;
GtkWidget 	*entry;
GtkWidget 	*frame;
GtkWidget 	*borderframe;
GtkWidget	*listwindow;
GtkWidget	*listbox;
GtkWidget	*listitem;
GtkWidget	*scrolly;
int			panelsize;
int			appletwidth;
int			borderpad=4;
int			appletclick=1;
char		mb[2048];

// 


int main(int argc, char **argv)
{
	
	applet_widget_init("foocat_applet",NULL,argc,argv,NULL,0,NULL);
	
	applet=applet_widget_new("foocat_applet");
	if (!applet)
		g_error("cannot create applet\n\n");

	panelsize=applet_widget_get_panel_pixel_size(APPLET_WIDGET(applet));
	appletwidth=135;

	//g_print("%dx%d\n",appletwidth,panelsize);

//	g_print("frame\n");
	borderframe=gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(borderframe),GTK_SHADOW_NONE);
	gtk_widget_set_uposition(GTK_WIDGET(borderframe), 0, 0);
	gtk_widget_set_usize(GTK_WIDGET(borderframe), appletwidth, panelsize);
//	g_print("frame->applet\n");
	gtk_container_add(GTK_CONTAINER (applet), borderframe);
	gtk_widget_show(borderframe);

	frame=gtk_event_box_new();
	gtk_container_add(GTK_CONTAINER (borderframe), frame);
	gtk_widget_show(frame);
			

	label=gtk_label_new("FooCat BarCode");
	gtk_container_add(GTK_CONTAINER (frame), label);
	gtk_widget_show(label);

//	g_print("signals:1\n");
	gtk_widget_set_events (frame, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(frame), "button_press_event", GTK_SIGNAL_FUNC(gotmouse), NULL);
//	gtk_signal_connect(GTK_OBJECT(frame), "key_press_event", GTK_SIGNAL_FUNC(keypress), NULL);
//	gtk_signal_connect(GTK_OBJECT(frame), "leave_notify_event", GTK_SIGNAL_FUNC(lostmouse), NULL);
//	g_print("signals:2\n");

	gtk_widget_show(applet);
	
	applet_widget_gtk_main();

//	g_print("exiting applet\n");
	
	return 0;
	
}; // main


/* -=-=-=-=-= -=-=-=-=-= -=-=-=-=-= -=-=-=-=-= -=-=-=-=-= -=-=-=-=-= -=-=-=-=-= -=-=-=-=-= -=-=-=-=-= */

void gotmouse()
{
	gtk_frame_set_shadow_type(GTK_FRAME(borderframe),GTK_SHADOW_ETCHED_IN);
	gtk_container_remove(GTK_CONTAINER (frame), label);
	entry=gtk_entry_new();
	gtk_container_add(GTK_CONTAINER (frame), entry);
	gtk_signal_connect(GTK_OBJECT(entry), "activate", GTK_SIGNAL_FUNC(do_cuecat),NULL);
	gtk_widget_show(entry);
	gtk_widget_grab_focus(entry);
	appletclick=1; // entry shown, not activated
};

void keypress()
{
//	printf("keypress\n");
};

void lostmouse()
{
/*
	if (appletclick==1)
	{

	}
	else
	{

	};
*/
};

void do_cuecat()
{
	gchar 			*buf;
	char			txt[1024];
	char			scan[1024];
	struct chunks 	*c;
	struct bookinfo	*bi;
	struct cueinfo 	*ci;
	static	int		first_popup=1;
	char			*cue;
	char			*url;
	int 			i;
	
	gtk_frame_set_shadow_type(GTK_FRAME(borderframe),GTK_SHADOW_NONE);
	buf=gtk_editable_get_chars(GTK_EDITABLE(entry),0,-1);
	gtk_container_remove(GTK_CONTAINER (frame), entry);
	appletclick=0; // no entry

	label=gtk_label_new("searching...");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap(GTK_LABEL(label),TRUE);
	gtk_container_add(GTK_CONTAINER (frame), label);
	gtk_widget_show(GTK_WIDGET (label));


	strcpy(scan,buf);
	c=convert(buf);
	if (c!=NULL)
	{
		decode_type(c);

		if (c->formatted != NULL)
		{
			sprintf(txt,"%s:%s\n",c->ctype,c->formatted);
		} 
		else
		{
			sprintf(txt,"%s:%s\n",c->ctype,c->data);
		};

		gtk_label_set_text(GTK_LABEL(label),txt);

    while (gtk_events_pending()) {
      gtk_main_iteration();
    }
		ci=docue(c,NULL,10);

		if (ci!=NULL)
		{
			if (ci->cuedesc!=NULL)
			{
				if (c->formatted != NULL)
				{
					sprintf(txt,"%s:%s\n%s\n",c->ctype,c->formatted,ci->cuedesc);
				} 
				else
				{
					sprintf(txt,"%s:%s\n%s\n",c->ctype,c->data,ci->cuedesc);
				};

				gtk_label_set_text(GTK_LABEL(label),txt);
			};

			if (ci->cueurl != NULL)
			{
				sprintf(txt,"gnome-moz-remote --newwin %s",ci->cueurl);
				system(txt);
			};
		};


		free_cueinfo(ci);
		free(c->serial);
		free(c->data);
		if (c->formatted != NULL)
		{
			free(c->formatted);
		};
		free(c);
	}
	else
	{
		sprintf(txt,"error\nnot a barcode\n");
		gtk_label_set_text(GTK_LABEL(label),txt);
	};

};









