/*
 *
 * FooCat Barcode Utilities Library
 *  version 0.1.3
 *
 *  (c) 2000 Michael Rothwell
 *  rothwell@holly-springs.nc.us
 *
 *  Released under the GPL
 *
 *
 *  DO NOT PASS IN STATIC STRINGS!
 *  This will crash:
 *	c=convert(".C3nZC3nZc3nYDhv7D3DWCxnX.fGjX.C3r3D3rZe3nYc3bZCni.");
 *
 *  This will not crash:
 *  char buf[2048];
 *  strcpy(buf,".C3nZC3nZc3nYDhv7D3DWCxnX.fGjX.C3r3D3rZe3nYc3bZCni.");
 *  c=convert(buf);
 *  
 *  libfoocat currently replaces all occurances of '.' is its input with '\0'.
 *  It also returns pointers to segments of its input. Yes, perhaps this is
 *  ugly. I'll fix it. But it's how things are for now.
 *  
 */


#ifndef __LIBFOOCAT_H__
#define __LIBFOOCAT_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <unistd.h>

#define LIBFOOCAT_VERSION "0.1.3"
#define BASE64_PAD_CHAR 	61
#define BASE64_LINE_LENGTH 	76
#define	FETCH_CHUNK	4096

struct		chunks  { char *scandata; char *serial; char *ctype; char *data; char *formatted;};
struct		bookinfo{ char *url; char *title; char *author; char *image;};
struct		cueinfo	{ char *cuereq; char *cueurl; char *cuedesc;}; // fuck the fucking fuckers!
struct		httpreq { char *host; char *path; char *op; int port; int proxy; char *status; int length; char *data; int fd;};

extern char codetable[256];
extern int	__base64_codetable_initialized;

void 										free_httpreq(struct httpreq *h);
struct									httpreq *new_httpreq();
struct 		httpreq 			*parse_url(char *url);
struct 		chunks 				*chunk(char *sample);
char 										*chunkdecode(char *buf, char *type);
struct 		chunks 				*convert(char *sample);
char 										*decode(char *buf, int length);
void 										init_codetable();
int 										decode_type(struct chunks *c);
char 										*fetch(char* url, int * buflen, int timeout);
int 										http_head(char* url, int timeout);
struct 		cueinfo 			*new_cueinfo();
struct 		cueinfo 			*docue(struct chunks *c, char * actcode, int timeout);
struct 		cueinfo				*dcnv_request(char *actcode, struct chunks *c);
void 										free_cueinfo(struct cueinfo *c);
struct 		bookinfo 			*new_bookinfo();
struct		bookinfo 			*doamazon(struct chunks *c, int timeout);
struct 		bookinfo 			*doamazon_isbn(char *isbn, int timeout);
void										free_bookinfo(struct bookinfo *c);
void 										deallocmem(void *ptr);

#endif


