#!/usr/bin/perl

# test file for encoding routine

use Barcode;
use strict;

# scan using the kernel driver
print "Scan barcode now...\n";
my $scan = CueCat->kdecode;
print "CueCat serial number: $scan->{'cuecat_ser_no'}\n";
print "Barcode type: $scan->{'barcode_type'}\n";
print "Barcode: $scan->{'barcode_data'}\n\n";
$scan->destroy($scan->{'pid'});

# now encode it back to a raw CueCat scan
my $encoded_ser = CueCat->encode($scan->{'cuecat_ser_no'});
my $encoded_type = CueCat->encode($scan->{'barcode_type'});
my $encoded_data = CueCat->encode($scan->{'barcode_data'});

# assemble the parts
my $scan_string = "." . $encoded_ser->{'encoded'} . "." . $encoded_type->{'encoded'} . "." . $encoded_data->{'encoded'} . "." . "\n";
print "$scan_string\n";

# now get the url
my $cue = CueCat->get_dc_cue($scan_string);
print "\n";
print "url = $cue->{'url'}\n\n";


