/*

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/* 
	2002-06-25 Written by Andy Green (andy@warmcat.com)
	
	This is my first nontrivial piece of code for Linux, (although I have written plenty of C++ under MFC) if you have advice or
	complaints I will be happy to hear them
*/

#ifndef __WXGTK__
#define wxSIZE_T_IS_UINT
//#include "windows.h"
#include "winsock.h"
#endif

// #include <conio.h>
 #include <wx/file.h>
// #include <wx/string.h>
#ifdef __WXGTK__
 #include <getopt.h>
 #include <sys/time.h>
 extern int errno;
 #endif 
 #include <wx/textfile.h>
 

 #define VERSION "0.2"

#include "milk.h"

void IssueCommandlineHelp()
{
	printf(
		"MILK app: controls Milksop flash programmer\n"
		"\n"
		"milk [options]\n"
		"  default action with no options shows this help display\n"
		"\n"
		"Options:\n"
		"  -i, --internal   Target internal flash (default is external) used with other options\n"
		"  -z, --justcheck   Just test that the flash can be communicated with, then exit\n"
		"  -r, --readback <file>   Read back flash into the binary file given\n"
		"  -p, --program <file>   Erase/Program flash with the binary file given\n"
		"  -e, --erase   Just perform erase\n"
		"  -o, --ioport hhh   Use parallel port at given hex IO address (default 0x378)\n"
		"  -a, --address hhhhh    Perform action starting from this hex address in flash (default 0)\n"
		"  -x, --xcode <file>   x-code disassembly on given file\n"
		"  -q, --cyclepower   quick power cycle\n"
		"  -t, --patch <file>   insert patchfile into binary file\n"
		"  -b, --binarypatch <file>   insert binary into binary file, needs --address hhhhh\n"
		"  -h, --help   print this help\n"
		"  -v, --version   show version\n"
		"\n"
		"Examples:\n"
		"  milk -i -p myfile.bin\n"
		"  milk -p myfile.bin -o 278 -a 80000\n"
		"  milk -r newfile.bin\n"
		"  milk -t patchfile\n"
		"  milk -a 1000 -b binfile\n"
		"\n"
	);
}

#ifndef __WXGTK__

	struct option {
		const char * szcName;
		int nTakesArg;
		void * pvoid;
		char cShortForm;
	};

	const char * optarg;
	int nArg=1;
	int getopt_long(int argc, char ** argv, const char * szcSwitchMap, option * poptionaLongOptions, int * pn)
	{
		if(nArg<argc) {
			char cSwitchChar=-1;

			if(argv[nArg][0]=='-') { // some kind of switch, look for long
				if(poptionaLongOptions!=NULL) {
					int n=0; while(poptionaLongOptions[n].szcName!=NULL) {
						if(stricmp(&argv[nArg][1], poptionaLongOptions[n].szcName)==0) {
							cSwitchChar=poptionaLongOptions[n].cShortForm;
						}
						n++;
					}
				}

				if(strlen(argv[nArg])==2) { // -x
					int n=0;
					while(szcSwitchMap[n]!='\0') {
						if(szcSwitchMap[n]==argv[nArg][1]) {
							cSwitchChar=argv[nArg][1];
							if(szcSwitchMap[n+1]==':') {
								optarg=argv[nArg+1];
								nArg++;
								while(szcSwitchMap[n]) n++;
								n--;
							}
						}
						n++;
					}
				}
			}

			nArg++;

			return cSwitchChar;
		}
		return -1;
	}

#else
   DWORD GetTickCount(void)
    {
     struct timeval _tstart;
     struct timezone tz;

     gettimeofday(&_tstart, &tz);
	  return (_tstart.tv_sec*1000) +(_tstart.tv_usec /1000);
    }

#endif
	 int main(int argc, char * argv[])

{


	CParallelMilksop milksop;

	bool 
		fReadback=false, 
		fProgram=false, 
		fErase=false, 
		fX=false, 
		fPower=false, 
		fTestFlashCommsOnly=false,
		fConfirm=false
	;
	DWORD dwAddressOffset=0;
	DWORD dwKnownDeviceSizeInBytes=0;
	wxString csFilepathBinary;
	wxString csPatchfile, csBinaryPatchFile;

	printf("Milksop GPL Reflasher - " VERSION " - (c)2002 andy@warmcat.com\n\n");

	if(argc==1) {
		IssueCommandlineHelp();
		return 1;
	}

	csFilepathBinary=argv[1];

   static struct option optionaLongOptions[] = {
    {"internal",   0, 0, 'i'},
    {"justcheck",  0, 0, 'z'},
    {"readback",   1, 0, 'r'},
    {"program",    1, 0, 'p'},
    {"erase",      0, 0, 'e'},
    {"ioport",     1, 0, 'o'},
    {"address",    1, 0, 'a'},
    {"xcode",      0, 0, 'x'},
    {"cyclepower", 0, 0, 'q'},
    {"patch",      1, 0, 't'},
    {"binarypatch",1, 0, 'b'},
    {"version",    0, 0, 'v'},
    {"help",       0, 0, 'h'},
    {0, 0, 0, 0}
    };

	int opt, option_index;

	while((opt = getopt_long(argc, argv, "izr:p:eo:a:xqt:b:vh", &optionaLongOptions[0], &option_index )) !=-1) {
	
		switch(opt) {
			
			case 'o':
				{ 
					int n;
					sscanf(optarg, "%x", &n);
					milksop.m_wAddress=(WORD)n;
					break;
				}
				
			case 'a':
				int n;
				sscanf(optarg, "%x", &n);
				dwAddressOffset=(WORD)n;
				break;

			case 't':
				csPatchfile = optarg;
				fX=true;
				break;

			case 'b':
				csBinaryPatchFile=optarg;
				break;

			case 'i':
				milksop.m_bModeMask|=0x10; // b4 of mode selects internal
				break;

			case 'r':
				fReadback=true;
				csFilepathBinary = optarg;
				fConfirm=true;
				break;

			case 'e':
				fErase=true;
				fConfirm=true;
				break;

			case 'x':
				fX=true;
				csFilepathBinary = optarg;
				break;

			case 'p':
				fErase=true; fProgram=true;
				csFilepathBinary = optarg;
				fConfirm=true;
				break;

			case 'q':
				 fPower=true;
				break;

			case 'z':
				fTestFlashCommsOnly = true;
				fConfirm=true;
				break;

			case 'v':
				printf("Version " VERSION "\n");
				break;

			case 'h':
				IssueCommandlineHelp();
				return(0);
		}
	}

	if(!csBinaryPatchFile.IsEmpty()) {
		wxFile file, filePatch;
		if(!file.Open(csFilepathBinary, wxFile::read)) {
			wxString cs;
			cs=wxString::Format("Unable to open file %s: %s\n", csFilepathBinary.c_str(), strerror(errno));
			printf(cs);
//			getchar();
			return(4);
		}
		DWORD dwLength=file.Length();
		DWORD dwLengthAlloc = dwLength;

		if(!filePatch.Open(csBinaryPatchFile, wxFile::read)) {
			wxString cs;
			cs=wxString::Format("Unable to open file %s: %s\n", csFilepathBinary.c_str(), strerror(errno));
			printf(cs);
//			getchar();
			return(4);
		}
		DWORD dwLengthPatch=filePatch.Length();

		if((dwAddressOffset + dwLengthPatch) > dwLengthAlloc) dwLengthAlloc = dwAddressOffset + dwLengthPatch;

		BYTE *pb = new BYTE [ dwLengthAlloc ]; 
		file.Read(pb, dwLength);
		file.Close();

		filePatch.Read(pb+dwAddressOffset, dwLengthPatch);
		filePatch.Close();

		{
			wxString csFilepathPatched;
			wxFile file;

			csFilepathPatched = csFilepathBinary;
			csFilepathPatched += ".patched";

			if(!file.Create(csFilepathPatched, true)) {
				wxString cs;
				cs=wxString::Format("Unable to open file %s: %s\n", csFilepathPatched.c_str(), strerror(errno));
				printf(cs);
//				getchar();
				return(4);
			}

			file.Write(pb, dwLengthAlloc);
			file.Close();

			printf("patch complete, saved in %s\n", csFilepathPatched.c_str());
			return(1);
		}
	}


	if(fX) {
		wxFile file;
		if(!file.Open(csFilepathBinary, wxFile::read)) {
			wxString cs;
			cs=wxString::Format("Unable to open file %s: %s\n", csFilepathBinary.c_str(), strerror(errno));
			printf(cs);
//			getchar();
			return(4);
		}
		DWORD dwLength=file.Length();


		BYTE *pb = new BYTE [ dwLength ]; 
		file.Read(pb, dwLength);
		file.Close();

		if(!csPatchfile.IsEmpty()) {
			wxTextFile wxtfpatch;
			if(!wxtfpatch.Open(csPatchfile)) {
				printf("Unable to open patch file %s\n", csPatchfile.c_str());
				return 1;
			}

			bool fMore=true, fFirst=true;
			DWORD dwOffset=0;
			while(fMore) {
				wxString cs;
				if(fFirst) {
					cs=wxtfpatch.GetFirstLine();
				} else {
					cs=wxtfpatch.GetNextLine();
				}
				if(wxtfpatch.Eof()) { fMore=false; continue; }
				
				if(strncmp(cs, "//", 2)==0) continue;
				if(fFirst) {
					if(sscanf(cs, "%x", &dwOffset)!=1) {
						printf("unable to get start address from patch file\n");
						return 1;
					}
					printf("Patching from offset %08X\n", dwOffset);
					fFirst=false;
					continue;
				}
				DWORD dwOpcode, dwOp1, dwOp2;

				if(cs.Len()==0) continue;

				if(sscanf(cs, "%x %x %x", &dwOpcode, &dwOp1, &dwOp2)!=3) {
					printf("Malformed line %s\n", (const char *)cs);
					return 1;
				}

				if((dwOffset+8)>dwLength) {
					printf("Patch Overran original file size!!!\n");
					return(1);
				}
				pb[dwOffset++] = (BYTE)dwOpcode;
				pb[dwOffset++] = (BYTE)dwOp1;
				pb[dwOffset++] = (BYTE)(dwOp1>>8);
				pb[dwOffset++] = (BYTE)(dwOp1>>16);
				pb[dwOffset++] = (BYTE)(dwOp1>>24);
				pb[dwOffset++] = (BYTE)dwOp2;
				pb[dwOffset++] = (BYTE)(dwOp2>>8);
				pb[dwOffset++] = (BYTE)(dwOp2>>16);
				pb[dwOffset++] = (BYTE)(dwOp2>>24);

			}

			wxString csFilepathPatched;
			wxFile file;

			csFilepathPatched = csFilepathBinary;
			csFilepathPatched += ".patched";

			if(!file.Create(csFilepathPatched, true)) {
				wxString cs;
				cs=wxString::Format("Unable to open file %s: %s\n", csFilepathPatched.c_str(), strerror(errno));
				printf(cs);
//				getchar();
				return(4);
			}

			file.Write(pb, dwLength);
			file.Close();

			printf("patch complete, saved in %s\n", (const char *)csFilepathPatched);
			return(1);
		}


		DWORD dw=0x92;

		bool fMore=true;

		while(fMore) {
			DWORD dw1, dw2;
			dw1=pb[dw+1]; dw1|=((DWORD)pb[dw+2])<<8; dw1|=((DWORD)pb[dw+3])<<16; dw1|=((DWORD)pb[dw+4])<<24; 
			dw2=pb[dw+5]; dw2|=((DWORD)pb[dw+6])<<8; dw2|=((DWORD)pb[dw+7])<<16; dw2|=((DWORD)pb[dw+8])<<24; 
			printf("%08X: %02X %08X %08X\n", dw, pb[dw], dw1, dw2);
			if(pb[dw]==0xee) fMore=false;
			dw+=9;
		}

		delete [] pb;
		return 0;
	}


	if(milksop.GetAccessRights()) {
		printf("Communicating on printer port at 0x%x\n", milksop.m_wAddress);
	} else {
		printf("Unable to get access to printer port at 0x%x\nThis app needs to run as root to access the hardware.\n", milksop.m_wAddress);
		return 1;
	}


	milksop.FlashInit();

	if(fPower) {
		milksop.Power();
		return 1;
	}

	if(fConfirm) {

		milksop.FlashInit();

		milksop.ResetFlashStateMachine();
		milksop.GetDeviceType();

		wxString cs;
		cs="Device: ";
		cs+=milksop.GetDeviceDestription().c_str();
		cs+="\n";
		puts(cs);
		bool fKnown=false;

		if((milksop.m_bManufacturer == 0x20) && (milksop.m_bDevice ==0xf1 )) {
			fKnown=true; dwKnownDeviceSizeInBytes=1024 * 1024;
		}

	//	if((milksop.m_bManufacturer == 0xf1) && (milksop.m_bDevice ==0x20 )) {
	//		fKnown=true; dwKnownDeviceSizeInBytes=1024 * 1024;
	//	}

		if(!fKnown) {
			printf("Unrecognized device - aborting... are we all plugged in alright?\n");
			Sleep(100);
	//	goto again;
	//		getchar();
			return 1;
		}

		if(fTestFlashCommsOnly) return 0;

	}
	
	if(fErase) {
		printf("Erasing chip.. ");
		if(milksop.EraseChip())  {
			printf("erase done\n");
		} else {
			printf("erase timed out\n");
			return 1;
		}
	}

	if(fProgram) {
		wxFile file;
		if(!file.Open(csFilepathBinary, wxFile::read)) {
			wxString cs;
			cs=wxString::Format("Unable to open file %s: %s\n", (const char *)csFilepathBinary, strerror(errno));
			printf(cs);
//			getchar();
			return(4);
		}
		DWORD dwLength=file.Length();

		printf("PROGRAMMING from %X -> %X with %s\n", dwAddressOffset, dwAddressOffset+dwLength-1, (const char *)csFilepathBinary);

		if((dwLength+dwAddressOffset) > dwKnownDeviceSizeInBytes) {
			printf("File is length %u bytes but device can only hold %u bytes\n",
				dwLength, dwKnownDeviceSizeInBytes
			);
//			getchar();
			return 5;
		}

		if((dwLength+dwAddressOffset) < dwKnownDeviceSizeInBytes) {
			printf("Warning: File is only length %u bytes but device holds %u bytes\n",
				dwLength, dwKnownDeviceSizeInBytes
			);
		}

		DWORD dwTick=GetTickCount();
		BYTE *pb = new BYTE [ dwLength ]; 
		file.Read(pb, dwLength);
		file.Close();

		if(!milksop.ProgramAndVerify(pb, dwLength, dwAddressOffset)) {
			printf("Faled to verify\n");

			delete [] pb;
			return 6;
		}

		printf(" Program/Verify took %umS\n", GetTickCount()-dwTick);
		printf("Programming completed and verified\n");

		delete [] pb;
		return 0;
	}

	if(fReadback) {
		wxFile file;
		if(!file.Create(csFilepathBinary, true)) {
			wxString cs;
			cs=wxString::Format("Unable to open file %s: %s\n", (const char *)csFilepathBinary, strerror(errno));
			printf(cs);
			return(4);
		}

		printf("READING from %X -> %X to %s\n", dwAddressOffset, dwKnownDeviceSizeInBytes-1, (const char *)csFilepathBinary);
		DWORD dwTick=GetTickCount();
		BYTE *pb = new BYTE [ dwKnownDeviceSizeInBytes-dwAddressOffset ]; 

		milksop.ReadBackData(pb, dwKnownDeviceSizeInBytes-dwAddressOffset, dwAddressOffset);

		file.Write(pb, dwKnownDeviceSizeInBytes-dwAddressOffset);
		file.Close();

		printf("Readback completed in %umS\n", GetTickCount()-dwTick);

		delete [] pb;
		return 0;

	}

//	getchar();
	return 0;

}
