/***************************************************************************
                          CJtagRegisterManagement.cpp  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "winconst.h"  /* defines constants, couple of static functions */
#include "svf.h"

static char caHexCharacters[]={
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	0,1,2,3,4,5,6,7,8,9,-1,-1,-1,-1,-1,-1,
	-1, 10,11,12,13,14,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1, 10,11,12,13,14,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
};

// characters are encoded from last hex digit backwards through to the first
//, eg  '12345'  results in 0x45, 0x23, 0x01

bool CJtagRegisterManagement::LoadFromAsciiHex(BYTE *ba, const char *sz, int nLength)
{
	bool fAllZeros=true;
	BYTE *baOld=ba;

	int nBitPlacement=m_nHeaderBits;
	int nBitsActual=m_nBits-(m_nHeaderBits+m_nTrailerBits);
	int nBitsLifetime=0;
	char c=0;

	while(nBitsActual--) {
		if(nBitsLifetime==0) {
			nLength--;
			c=caHexCharacters[(unsigned int)sz[nLength]];
			if(c==-1) { /*ErrorYY("Bad character in hex literal"); */ return(false); }
			if(c!=0) fAllZeros=false;
			nBitsLifetime=4;
		}
		if(c&1) { ba[nBitPlacement>>3] |=1<<(nBitPlacement&7); } else { ba[nBitPlacement>>3] &=~(1<<(nBitPlacement&7)); }
		nBitPlacement++;
		c>>=1;
		nBitsLifetime--;
	}

	if(baOld==m_baTdiMask) m_fAllTdiDontCare=fAllZeros;
	if(baOld==m_baTdoMask) {
		m_fAllTdoDontCare=fAllZeros;
	}

	return(true);
}

bool CBitVector::Set( const char *sz)
{
	int nByte;
	BYTE bMask;
	int nSize=strlen(sz)-1;
	nByte=nSize>>3;
	bMask=1<<(nSize & 7);

	if(nSize<0) return(false);

	m_nLength=0;
	m_cbaBits.Empty();
	m_cbaMask.Empty();

	m_cbaMask.Alloc(nByte+1);
	m_cbaBits.Alloc(nByte+1);

	while(*sz) {
		switch(*sz++) {
			case '0':
				m_cbaMask.Item(nByte) = (m_cbaMask.Item(nByte)|bMask);
				break;
			case '1':
				m_cbaBits.Item(nByte) = ( m_cbaBits.Item(nByte)|bMask);
				m_cbaMask.Item(nByte) = ( m_cbaMask.Item(nByte)|bMask);
				break;
			case 'X':
				break;
			case 'x':
				break;
			default:
				return(false);
				break;
		}
		m_nLength++;
		if(bMask==1) {
			bMask=128;
			nByte--;
		} else {
			bMask>>=1;
		}
	}
	return(true);
}

bool CBitVector::IsEqual( CBitVector * pvector)
{
	if(m_nLength!=pvector->m_nLength) return(false);
	for(DWORD t=0;t<m_cbaMask.GetCount();t++) {
		BYTE bAggregatedMask=m_cbaMask.Item(t) & pvector->m_cbaMask.Item(t);
		if(
			(m_cbaBits.Item(t) & bAggregatedMask) != (pvector->m_cbaBits.Item(t) & bAggregatedMask)
		) return(false);
	}
	return(true);
}

bool CBitVector::CopyShifted( const CBitVector * pbvSmaller, int nPositionStart )
{
	if( (m_nLength)>= (pbvSmaller->m_nLength+nPositionStart) ) {
		int nByte=nPositionStart>>3;
		BYTE bShift=1 << (nPositionStart & 7);
		int nCount=pbvSmaller->m_nLength;
		int nByteNew=0;
		BYTE bShiftNew=1;

		BYTE bData=m_cbaBits.Item(nByte);
		BYTE bMask=m_cbaMask.Item(nByte);
		BYTE bDataNew=pbvSmaller->m_cbaBits.Item(nByteNew);
		BYTE bMaskNew=pbvSmaller->m_cbaMask.Item(nByteNew);

		while(nCount--) {
			if(bDataNew & bShiftNew) {
				bData|=bShift;
			} else {
				bData&=~bShift;
			}
			if(bMaskNew & bShiftNew) {
				bMask|=bShift;
			} else {
				bMask&=~bShift;
			}
			bShift<<=1;
			if(bShift==0) {
				m_cbaBits.Item(nByte) = ( bData);
				m_cbaMask.Item(nByte) = ( bMask);
				bShift=1;
				nByte++;
				bData=m_cbaBits.Item(nByte);
				bMask=m_cbaMask.Item(nByte);
			}
			bShiftNew<<=1;
			if(bShiftNew==0) {
				bShiftNew=1;
				nByteNew++;
				bDataNew=pbvSmaller->m_cbaBits.Item(nByteNew);
				bMaskNew=pbvSmaller->m_cbaMask.Item(nByteNew);
			}

		}

		if(bShift!=1) {
			m_cbaBits.Item(nByte) = ( bData);
			m_cbaMask.Item(nByte) = ( bMask);
		}

		return(true);

	} else { // would overlap size of larger 'this' register
		ASSERT(0);
		return(false);
	}
}

void CBitVector::ToCString( string & rcs) // fill rcs with ascii representation
{
	int nByte=0;
	BYTE bMask=1;
	rcs.resize(0);

	for(int t=0;t<m_nLength;t++) {
		if((m_cbaMask.Item(nByte)&bMask)==0) {
			rcs+='x';
		} else { // care
			if(m_cbaBits.Item(nByte) & bMask) rcs+='1'; else rcs+='0';
		}
		if(bMask==128) {
			bMask=1;
			nByte++;
		} else {
			bMask<<=1;
		}
	}
}

static BYTE baMasks[] = {  0xff, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f };


void CJtagRegisterManagement::FillCStringWithAsciiHex(string &rcs, BYTE * pba)
{
	static char caHex[] = "0123456789ABCDEF";
/*
	int nMax=(m_nBits-1)>>3;
	if((m_nBits-1)&7) nMax++;

	if(!m_nBits) return;

	pba+=nMax-1;

	rcs=caHex[ (((*pba) & baMasks[m_nBits&7])&0xf0)>>4];
	rcs+=caHex[ (((*pba) & baMasks[m_nBits&7])&0xf)];
	pba--;  nMax--;

	while(nMax) {
		rcs+=caHex[ ((*pba) &0xf0)>>4];
		rcs+=caHex[ ((*pba)&0xf)];
		pba--; nMax--;
	}
*/

	int nBitPlacement=0; // m_nHeaderBits;
	int nBitsActual=m_nBits; // -(m_nHeaderBits+m_nTrailerBits);
	int nBitsLifetime=0;
	char c=0, cm=1, sz[512], *pc;
	pc=&sz[511];

	while(nBitsActual--) {
		if(nBitsLifetime==0) {
			*pc-- =caHex[(unsigned int)c];
			c=0; cm=1;
			nBitsLifetime=4;
		}
		if( pba[nBitPlacement>>3] &(1<<(nBitPlacement&7)) ) c|=cm;
		nBitPlacement++;
		cm<<=1;
		nBitsLifetime--;
	}
	sz[511]='\0';

	{ *pc-- =caHex[(unsigned int)c]; }
	rcs=&pc[1];
}

bool CJtagRegisterManagement::CopyBitVectorData(CBitVector *pbv)
{
	ASSERT(pbv->GetLength()==GetSize());
	if(pbv->GetLength()!=GetSize()) return(false);
	int nCount=(GetSize()-1)>>3;
	if(GetSize()&7) nCount++;
	memcpy(m_baTdi, &(pbv->m_cbaBits.Item(0)), nCount);
	memcpy(m_baTdiMask, &(pbv->m_cbaMask.Item(0)), nCount);
	m_fAllTdiDontCare=true;
	BYTE *pb=&(pbv->m_cbaMask.Item(0));
	for(int n=0;n<(nCount-1);n++) { if(*pb++) m_fAllTdiDontCare=false; }
	if(*pb & baMasks[GetSize()&7]) m_fAllTdiDontCare=false;
	return(true);
}

bool CJtagRegisterManagement::CopyBitVectorReadback(CBitVector *pbv)
{
	ASSERT(pbv->GetLength()==GetSize());
	if(pbv->GetLength()!=GetSize()) return(false);
	int nCount=(GetSize()-1)>>3;
	if(GetSize()&7) nCount++;
	memcpy(m_baTdo, &(pbv->m_cbaBits.Item(0)), nCount);
	memcpy(m_baTdoMask, &(pbv->m_cbaMask.Item(0)), nCount);
	m_fAllTdiDontCare=true;
	BYTE *pb=&(pbv->m_cbaMask.Item(0));
	for(int n=0;n<(nCount-1);n++) { if(*pb++) m_fAllTdoDontCare=false; }
	if(*pb & baMasks[GetSize()&7]) m_fAllTdoDontCare=false;
	return(true);
}




