/***************************************************************************
                          CMiloschUserRealtime.h

	Class stops all interrupts, kernel mode interference while instantiated
	Gives all CPU cycles to usermode code.

	''(dirty trick, don't try this at home!)''

                             -------------------
    begin                : Tue Oct 1 2002
    copyright            : 	(C)2002 Milosch Meriac
    email                : dontrythisathome@meriac.de

	2002-10-01  andy@warmcat.com   Migrated into this cpp class
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#ifndef WIN32
#include <unistd.h>
#include <sys/io.h>
#include <sys/mman.h>
#endif


class CMiloschUserRealtime
{
	public:
		bool fSingleProcessMode; // NULL indicates unsuccessful construction, test with IsSuccessfullyInSingleProcessMode()
		__int64 m_i64ClocksPerThousandSeconds;
		unsigned char m_bLastKeyboardCode;

	public:
		CMiloschUserRealtime() {

#ifndef WIN32
				
			CFile file;
			char sz[8192];

			m_i64ClocksPerThousandSeconds=0;
			fSingleProcessMode=false; // initially false

			if(file.Open("/proc/cpuinfo", O_RDONLY)) { // parse /proc/cpuinfo looking for, eg, cpu MHz         : 1599.741
				int nRead=file.Read(sz, sizeof(sz));
				if(nRead>0) {
					sz[nRead]='\0';
					char *szMHz=strstr(sz, "MHz");
					if(szMHz!=NULL) {
						szMHz+=3;
						while((*szMHz==' ') || (*szMHz==':') ||(*szMHz=='\t'))  szMHz++;
						m_i64ClocksPerThousandSeconds=(atoi(szMHz)*(__int64)1000);
						while(isdigit(*szMHz))  szMHz++;
						if(*szMHz=='.') {
							szMHz++;
							m_i64ClocksPerThousandSeconds+=atoi(szMHz);
						}
//						printf("%u\n", (int)m_i64ClocksPerThousandSeconds);
					} else {
						printf("CMiloschUserRealtime failed: unable to find MHz in /proc/cpuinfo\n");
					}
				} else {
					printf("CMiloschUserRealtime failed: unable to read from /proc/cpuinfo\n");
				}
				file.Close();
			} else {
				printf("CMiloschUserRealtime failed: unable to open /proc/cpuinfo\n");
			}

			if(!m_i64ClocksPerThousandSeconds) {
				printf("CMiloschUserRealtime failed: unable to get CPU speed from /proc/cpuinfo\n");
				return;
			}

		    if(iopl(3))	 {
				printf("CMiloschUserRealtime failed: You have to be root");
			} else {
				if(mlockall(MCL_CURRENT|MCL_FUTURE)) {
					printf("CMiloschUserRealtime failed: Can't lock memory");
				} else {
					printf("Starting realtime...\n");
					fflush(NULL);
					sync(); sync(); sync();

				    	__asm("cli");

					m_bLastKeyboardCode = inb(0x60);
					fSingleProcessMode=true;
				}
			}
#endif
		}

		~CMiloschUserRealtime() {
#ifndef WIN32
			if(fSingleProcessMode) { // if anything needs starting back up, do it
				__asm("sti");
				munlockall();
				printf("Stopped realtime...\n");
			}
#endif
		}

		int IsSuccessfullyInSingleProcessMode() { return (int)(fSingleProcessMode!=false); }  // use this to check if constructor worked
		int IsKeyPressed() {  // returns nonzero if a key has been pressed (used to indicate leaving full CPU mode)
#ifndef WIN32
			return inb(0x64)&1; 
#else
			BYTE b;
			_asm {
				mov	dx,0x64
//				add dl, 1
				in	al, dx
				mov byte ptr [b], al
			}
			return b&1; 
#endif
		}

		int GetKeyboardEvent() {
			BYTE b=inb(0x60);
			if(m_bLastKeyboardCode==b) return -1;
			m_bLastKeyboardCode=b;
			return b;
		}

		DWORD GetHiresTimestampLsd() {
			DWORD a3, a2;
#ifndef WIN32
			 __asm__ __volatile__ (" rdtsc" :"=a" (a3), "=d" (a2));
#endif
			return a3;
		}
		__int64 GetHiresTimestamp() {
			__int64 i64; unsigned int a3, a2;
#ifndef WIN32
			 __asm__ __volatile__ (" rdtsc" :"=a" (a3), "=d" (a2));
#endif
			i64=a3; i64|=((__int64)a2)<<32;
			return i64;
		}
		
};

