/***************************************************************************
                          CParallel.cpp  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


 #include "winconst.h"  /* defines constants, couple of static functions */
 #include "CParallel.h"

 		CParallel::CParallel() {
			m_bModeMask=0;
			m_bModeOld=0x04;
			m_wAddress=0x378;
		}

		bool CParallel::GetAccessRights() { // get the rights to access the port (needed for NT/2000/XP)
#ifdef WIN32
			CBL_RequestAccessToPorts();
#else
			
			{
				string cs;
				cs=StringFormat("/var/lock/milk-prn-%x.lock", m_wAddress);
				
				DWORD dw=GetTickCount();
				bool fOk=false;
				while( ((GetTickCount() -dw) < 5000) && (!fOk)) {
					
					if(CFile::FileExists(cs.c_str())) {
						if(!unlink(cs.c_str())) {
							Sleep(250);
							continue;
						}
					}
					if(! m_fileLock.Open(cs, O_CREAT|O_RDWR)) {
						Sleep(250);
						continue;
					}
					
					fOk=true;
				}
				
				if(!fOk) return false;
				
			}
			
		  /* Get access to the ports */
			if (ioperm(m_wAddress, 3, 1)) { perror("ioperm"); return(false);}
#endif
			return true;
		}

		void CParallel::GiveUpAccessRights()
		{
#ifdef WIN32
#else
			m_fileLock.Close();
			string cs;
			cs=StringFormat("/var/lock/milk-prn-%x.lock", m_wAddress);
			unlink(cs.c_str());

			if (ioperm(m_wAddress, 3, 0)) {perror("ioperm"); return;}
#endif
		}
		
		void CParallel::FlashInit() // briefly asserts init, resetting the CPLD ('flash' in the flashing the telephone hook sense)
		{
			Mode(m_bModeOld & (~4));
			Sleep(10);
			Mode(m_bModeOld|4);
		}

		void CParallel::Write(BYTE bValue) { // issue a byte on the printer port data lines and clock it in using STB
			BYTE bModeOld=(m_bModeOld & 0xfe) | 1;
			BYTE bModeNew=(bModeOld & 0xfe) | 0;
#ifdef WIN32
			WORD w=m_wAddress;
			_asm {
				mov	dx,word ptr [w]
				mov	al, byte ptr [bValue]
				out	dx,al
				out	dx,al
				mov	al, [bModeOld]
				add	dl, 2
				out	dx,al
				mov	al, [bModeNew]
				out	dx, al
			}
#else
				outb(bValue, m_wAddress);
				outb(bModeOld, m_wAddress+2);
				outb(bModeNew, m_wAddress+2);
#endif
		}

		void CParallel::WriteNoStrobe(BYTE bValue) { // issue a byte on the printer port data lines but don't operate the STB line
#ifdef WIN32
			WORD w=m_wAddress;
			_asm {
				mov	dx,word ptr [w]
				mov	al, byte ptr [bValue]
				out	dx,al
			}
#else
				outb(bValue, m_wAddress);
#endif
		}

		BYTE CParallel::Read() { // read the mode bits issued by milksop
			BYTE b;

#ifdef WIN32
			WORD w=m_wAddress;
			_asm {
				mov	dx,word ptr [w]
				add dl, 1
				in	al, dx
				mov byte ptr [b], al
			}
#else
			b=inb(m_wAddress+1);
#endif
			return(b);
		}

		void CParallel::Mode(BYTE b) { // set the mode bits output by the printer port
			b&=~1;
			m_bModeOld = b;
#ifdef WIN32
			WORD w=m_wAddress;
			_asm {
				mov	dx,word ptr [w]
				mov	al, [b]
				add	dl, 2
				out	dx,al
				out	dx,al
				out	dx,al
			}
#else
			outb(b, m_wAddress+2);
#endif
		}

		void CParallel::SetPrinterPort(WORD w) { m_wAddress=w; }
		bool CParallel::AwaitMilksopNoLongerBusy(DWORD dw) { while(((Read() & 0x80)) && (dw!=0)) {  dw--; }  if(dw==0) return false; return true; }
		BYTE CParallel::GetReturnedNybble() {
			// nportJ1PrinterAck : out std_logic;  -- return nybble b3  0x40
			// portJ1PrinterPError : out std_logic; -- return nybble b2 0x20
			// portJ1PrinterSelect : out std_logic; -- return nybble b1 0x10
			// nportJ1PrinterFault : out std_logic; -- return nybble b0 0x08
			BYTE b= ((Read() >>3) &0x0f)^0xf;
//			ASSERT( b== (((Read() >>3) &0x0f)^0xf) );
			return b;
		}
		void CParallel::SetMilksopMode(int temode) {
			// strobe action with nportPrinterJ1AutoFd = '1' is setting mode
			Mode(m_bModeOld | 0x02) ; // set Autofd to '1'
			Write( ((BYTE)(int)temode) | m_bModeMask );
			Mode(m_bModeOld & ~0x02) ; // set Autofd to '0'
		}

	void CParallel::FillWithRandom(BYTE * pba, DWORD dwLength) {
		while(dwLength--) {
			*pba++ = (BYTE)rand();
    	}		
	}
