/***************************************************************************
                          CParallel.h  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include <stdlib.h> /* for rand() */

 // CParallel deals with lowest-level access to the printer port hardware
 // derive your device class from this class to have the necessary powers

class CParallel
{
	public:
		WORD m_wAddress;
		BYTE m_bModeOld;
		BYTE m_bModeMask;
		CFile m_fileLock;  // lock file held open for duration of port usage

	public:
		CParallel() ;
		bool GetAccessRights(); // get the rights to access the port (needed for NT/2000/XP)
		void GiveUpAccessRights();
		void FlashInit(); // briefly asserts init, resetting the CPLD ('flash' in the flashing the telephone hook sense)
		void Write(BYTE bValue);  // issue a byte on the printer port data lines and clock it in using STB
		void WriteNoStrobe(BYTE bValue); // issue a byte on the printer port data lines but don't operate the STB line
		BYTE Read(); // read the mode bits issued by milksop
		void Mode(BYTE b) ; // set the mode bits output by the printer port
		void SetPrinterPort(WORD w);
		bool AwaitMilksopNoLongerBusy(DWORD dw=100000) ;
		BYTE GetReturnedNybble() ;
		void SetMilksopMode(int temode) ;
		void FillWithRandom(BYTE * pba, DWORD dwLength);

};

