/***************************************************************************
                          CParallelCheapLPC.cpp  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

   #include "winconst.h"  /* defines constants, couple of static functions */
 #include "CParallel.h"
 #include "CParallelCheapLPC.h"

 		CParallelCheapLPC::CParallelCheapLPC() {
			m_bMaskLeds=LED_READ|LED_WRITE;  // default to both LEDs off
			m_nDelayFactor=0;
		}

		void CParallelCheapLPC::ResetLPC()
		{
				Mode(m_bModeOld);
				WriteNoStrobe(0x40);
				WriteNoStrobe(0xc0);
		}
		
		BYTE CParallelCheapLPC::GetReturnedNybble() {
				return CParallel::GetReturnedNybble() ^ 0x0f;
		}

		int CParallelCheapLPC::IssueLPCMemoryRead(DWORD dwAds)
		{
				Write(0x80); // nLFRAME asserted, data =0
				Write(0xc0 | (0x4 << 1));  // memory read CYCTYPE
				Write(0xc0 | ( ((dwAds>>28) & 0xf)<< 1));  // ads MSB
				Write(0xc0 | ( ((dwAds>>24) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>20) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>16) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>12) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>8) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>4) & 0xf)<< 1));  //
				Write(0xc0 | ( (dwAds & 0xf)<< 1) );  // ads LSB
			
				Write(0xc0 |  ((0xf)<< 1));  // turnaround 1
				Write(0xc0 |  ((0xf)<< 1));  // turnaround 2 - we should float, but instead leave at F
			
				bool fPoll=true;
				DWORD dwTimeout=0x800;
				while(fPoll) {
					
					switch(GetReturnedNybble()) {
						
						case 0: // acknowledged okay
							fPoll=false;
							break;
						
						case 0x5: // wait short
							break;
						
						case 0x6: // wait long
							break;
						
						case 0xA: // explicit error
						default:
							printf("LPC bus error - peripheral returned SYNC=%02X\n", GetReturnedNybble());
							ResetLPC();
							return -1;
					}
					if(!dwTimeout--) {
						printf("LPC bus timeout - peripheral returning SYNC=%02X\n", GetReturnedNybble());
						ResetLPC();
						return -1;						
					}
				}
				Write(0xc0 |  ((0xf)<< 1));  // device driving - acknowledge sync
				
				BYTE b;
				b=GetReturnedNybble();
				Write(0xc0 | ((0xf)<< 1));  // device driving - unable to float, keep weak '1's
				b|=GetReturnedNybble()<<4;
				Write(0xc0 | ((0xf)<< 1));  // device driving - unable to float, keep weak '1's

				Write(0xc0 | ((0xf)<< 1));  // device driving - turnaround 1
				Write(0xc0 | ((0xf)<< 1));  // float - turnaround 2
				
				return b;
		}

		int CParallelCheapLPC::IssueLPCIORead(WORD wAds)
		{
				Write(0x80); // nLFRAME asserted, data =0
				Write(0xc0 | (0x0 << 1));  // IO read CYCTYPE
				Write(0xc0 | ( ((wAds>>12) & 0xf)<< 1));  //
				Write(0xc0 | ( ((wAds>>8) & 0xf)<< 1));  //
				Write(0xc0 | ( ((wAds>>4) & 0xf)<< 1));  //
				Write(0xc0 | ( (wAds & 0xf)<< 1) );  // ads LSB
			
				Write(0xc0 |  ((0xf)<< 1));  // turnaround 1
				Write(0xc0 |  ((0xf)<< 1));  // turnaround 2 - we should float, but instead leave at F
			
				bool fPoll=true;
				DWORD dwTimeout=0x800;
				while(fPoll) {
					
					switch(GetReturnedNybble()) {
						
						case 0: // acknowledged okay
							fPoll=false;
							break;
						
						case 0x5: // wait short
							break;
						
						case 0x6: // wait long
							break;
						
						case 0xA: // explicit error
						default:
							printf("LPC bus error - peripheral returned SYNC=%02X\n", GetReturnedNybble());
							ResetLPC();
							return -1;
					}
					if(!dwTimeout--) {
						printf("LPC bus timeout - peripheral returning SYNC=%02X\n", GetReturnedNybble());
						ResetLPC();
						return -1;						
					}
				}
				Write(0xc0 |  ((0xf)<< 1));  // device driving - acknowledge sync
				
				BYTE b;
				b=GetReturnedNybble();
				Write(0xc0 | ((0xf)<< 1));  // device driving - unable to float, keep weak '1's
				b|=GetReturnedNybble()<<4;
				Write(0xc0 | ((0xf)<< 1));  // device driving - unable to float, keep weak '1's

				Write(0xc0 | ((0xf)<< 1));  // device driving - turnaround 1
				Write(0xc0 | ((0xf)<< 1));  // float - turnaround 2
				
				return b;
		}
		
		int CParallelCheapLPC::IssueLPCMemoryWrite(DWORD dwAds, BYTE b)
		{
				Write(0x80); // nLFRAME asserted, data =0
				Write(0xc0 | (0x6 << 1));  // memory write CYCTYPE
				Write(0xc0 | ( ((dwAds>>28) & 0xf)<< 1));  // ads MSB
				Write(0xc0 | ( ((dwAds>>24) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>20) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>16) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>12) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>8) & 0xf)<< 1));  //
				Write(0xc0 | ( ((dwAds>>4) & 0xf)<< 1));  //
				Write(0xc0 | ( (dwAds & 0xf)<< 1) );  // ads LSB

				Write(0xc0 | ( (b & 0xf)<< 1) );  // data LSB
				Write(0xc0 | ( ((b>>4) & 0xf)<< 1));  //

				Write(0xc0 |  ((0xf)<< 1));  // turnaround 1
				Write(0xc0 |  ((0xf)<< 1));  // turnaround 2 - we should float, but instead leave at F
			
				bool fPoll=true;
				DWORD dwTimeout=0x800;
				while(fPoll) {
					
					switch(GetReturnedNybble()) {
						
						case 0: // acknowledged okay
							fPoll=false;
							break;
						
						case 0x5: // wait short
							break;
						
						case 0x6: // wait long
							break;
						
						case 0xA: // explicit error
						default:
							printf("LPC bus error - peripheral returned SYNC=%02X\n", GetReturnedNybble());
							ResetLPC();
							return -1;
					}
					if(!dwTimeout--) {
						printf("LPC bus timeout - peripheral returning SYNC=%02X\n", GetReturnedNybble());
						ResetLPC();
						return -1;						
					}
				}
				Write(0xc0 |  ((0xf)<< 1));  // device driving - unable to float, keep weak '1's

				Write(0xc0 | ((0xf)<< 1));  // device driving - turnaround 1
				Write(0xc0 | ((0xf)<< 1));  // float - turnaround 2
				
				return b;
		}

		int CParallelCheapLPC::IssueLPCIOWrite(WORD wAds, BYTE b)
		{
				Write(0x80); // nLFRAME asserted, data =0
				Write(0xc0 | (0x2 << 1));  // IO write CYCTYPE
				Write(0xc0 | ( ((wAds>>12) & 0xf)<< 1));  //
				Write(0xc0 | ( ((wAds>>8) & 0xf)<< 1));  //
				Write(0xc0 | ( ((wAds>>4) & 0xf)<< 1));  //
				Write(0xc0 | ( (wAds & 0xf)<< 1) );  // ads LSB

				Write(0xc0 | ( (b & 0xf)<< 1) );  // data LSB
				Write(0xc0 | ( ((b>>4) & 0xf)<< 1));  //

				Write(0xc0 |  ((0xf)<< 1));  // turnaround 1
				Write(0xc0 |  ((0xf)<< 1));  // turnaround 2 - we should float, but instead leave at F
			
				bool fPoll=true;
				DWORD dwTimeout=0x800;
				while(fPoll) {
					
					switch(GetReturnedNybble()) {
						
						case 0: // acknowledged okay
							fPoll=false;
							break;
						
						case 0x5: // wait short
							break;
						
						case 0x6: // wait long
							break;
						
						case 0xA: // explicit error
						default:
							printf("LPC bus error - peripheral returned SYNC=%02X\n", GetReturnedNybble());
							ResetLPC();
							return -1;
					}
					if(!dwTimeout--) {
						printf("LPC bus timeout - peripheral returning SYNC=%02X\n", GetReturnedNybble());
						ResetLPC();
						return -1;						
					}
				}
				Write(0xc0 |  ((0xf)<< 1));  // device driving - unable to float, keep weak '1's

				Write(0xc0 | ((0xf)<< 1));  // device driving - turnaround 1
				Write(0xc0 | ((0xf)<< 1));  // float - turnaround 2
				
				return b;
		}

		bool CParallelCheapLPC::FlashProgram(DWORD dw, BYTE b)
		{
			m_bMaskLeds&=~LED_WRITE;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xaa)<0) { printf("CParallelCheapLPC::FlashProgram - first IssueLPCMemoryWrite for 0x%x data 0x%x returned <0\n", dw, b); return false; }
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x2AAA, 0x55)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xa0)<0) return false;
			if(IssueLPCMemoryWrite(dw, b)<0)  { printf("CParallelCheapLPC::FlashProgram - second IssueLPCMemoryWrite for 0x%x data 0x%x returned <0\n", dw, b); return false; }
			
			DWORD dwTimeout=0x8000;
			while(dwTimeout--) {
				int n=IssueLPCMemoryRead(dw);
				if(n==-1) { printf("CParallelCheapLPC::FlashProgram - IssueLPCMemoryRead returned -1\n"); return false; }
				if(((BYTE)n)==b) return true;
			}
			printf("Timeout while programming address %X with %02X\n", dw, b);
			return false;
		}

		bool CParallelCheapLPC::FlashEraseBlock(DWORD dw)
		{
			m_bMaskLeds&=~LED_WRITE;

			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xaa)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x2AAA, 0x55)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0x80)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xaa)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x2AAA, 0x55)<0) return false;
			if(IssueLPCMemoryWrite(dw, 0x50)<0) return false;
			
			DWORD dwTimeout=0x8000000;
			while(dwTimeout--) {
				int n=IssueLPCMemoryRead(dw);
				if(n==-1) { m_bMaskLeds|=LED_WRITE; return false; }
				if(((BYTE)n & 0x80)==0x80) { m_bMaskLeds|=LED_WRITE; return true; }
			}
			m_bMaskLeds|=LED_WRITE;
			printf("Timeout while erasing block at %X\n", dw);
			return false;
		}

		bool CParallelCheapLPC::FlashEraseWholeDevice(DWORD dw)
		{  // does not work on SST in LPC mode
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xaa)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x2AAA, 0x55)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0x80)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xaa)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x2AAA, 0x55)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0x10)<0) return false;
			
			DWORD dwTimeout=0x8000000;
			while(dwTimeout--) {
				int n=IssueLPCMemoryRead(dw);
				if(n==-1) return false;
				if(((BYTE)n & 0x80)==0x80) return true;
			}
			printf("Timeout while erasing chip \n");
			return false;
		}

		bool CParallelCheapLPC::FlashEraseMultipleBlocks(DWORD dwStart, int nCountBlocks, DWORD dwAddressIncrement)
		{
			while(nCountBlocks--) {
				if(!FlashEraseBlock(dwStart)) return false;
				dwStart+=dwAddressIncrement;
			}
			return true;
		}
		
		bool CParallelCheapLPC::FlashResetStateMachine(DWORD dw)
		{
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xaa)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x2AAA, 0x55)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xf0)<0) return false;
			return true;
		}
		
		bool CParallelCheapLPC::FlashGetDeviceId(DWORD dw, BYTE *pbManufacturer, BYTE *pbDevice)
		{
			bool f=true;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0xaa)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x2AAA, 0x55)<0) return false;
			if(IssueLPCMemoryWrite((dw & 0xffff0000)|0x5555, 0x90)<0) return false;
			int n=IssueLPCMemoryRead(dw+0);
			if(n==-1) f=false;
			*pbManufacturer=(BYTE)n;
			n=IssueLPCMemoryRead(dw+1);
			if(n==-1) f=false;
			*pbDevice=(BYTE)n;
			FlashResetStateMachine(dw);
			return f;
		}

		bool CParallelCheapLPC::ReadBackData(BYTE * pba, DWORD dwLength, DWORD dwStartAddress) {
			DWORD dwa=dwStartAddress;
			while(dwLength--) {

				if((dwa&0xffff) == 0) printf("%06X\n", dwa);
				int n=IssueLPCMemoryRead(dwa);
				if(n==-1) return false;
				dwa++;
				*pba++=(BYTE)n;
			}
			return true;
		}


		bool CParallelCheapLPC::ProgramAndVerify(BYTE * pba, DWORD dwLength, DWORD dwStartAddress, bool fVerify)
		{
			BYTE *pbap=pba;
			DWORD dwLen=dwLength, dwAds=dwStartAddress;
			DWORD dwTick=GetTickCount()+1000;
			m_bMaskLeds&=~LED_WRITE;
			while(dwLen--) {
				if(!FlashProgram(dwAds++, *pbap++)) {
					printf("CParallelCheapLPC::ProgramAndVerify - FlashProgram for 0x%x data 0x%x returned false\n", dwAds-1, pbap[-1]);
					if(!m_fDebugging) {
						m_bMaskLeds|=LED_READ|LED_WRITE;
						WriteNoStrobe(0xff);
						return false;
					}
				}
				if(GetTickCount()>dwTick) { dwTick=GetTickCount()+1000; printf("Programming %X...\n", dwAds); }
			}
			m_bMaskLeds|=LED_WRITE;

			if(fVerify) {
				BYTE *pbap1=pba;
				DWORD dwLen1=dwLength, dwAds1=dwStartAddress;
				m_bMaskLeds&=~LED_READ;
				dwTick=GetTickCount()+1000;
				while(dwLen1--) {
					if(IssueLPCMemoryRead(dwAds1++) !=( *pbap1++)) {
						m_bMaskLeds|=LED_READ|LED_WRITE;
						WriteNoStrobe(0xff);
						return false;
					}
					if(GetTickCount()>dwTick) { dwTick=GetTickCount()+1000; printf("Verifying %X...\n", dwAds1); }
				}
				m_bMaskLeds|=LED_READ;
			}
			WriteNoStrobe(0xff);
			return true;
		}


		bool CParallelCheapLPC::EraseChip(DWORD dwStartAddress)
		{
			switch(m_bManufacturer) {
				case 0xbf: // SST
					return FlashEraseMultipleBlocks(dwStartAddress, m_dwKnownSize/0x4000, 0x4000);
					break;
				case 0x20: // ST
					return FlashEraseWholeDevice(dwStartAddress);
					break;
				default:
					return false;
			}
		}
