/***************************************************************************
                          CParallelCheapLPC.h  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


class CParallelCheapLPC : public CParallel
{
	public:
		BYTE m_bManufacturer;
		BYTE m_bDevice;
		BYTE m_bMaskLeds; // b0 clear = reading led lit, b5 clear = writing led lit
		DWORD m_dwKnownSize;
		bool m_fDebugging;
		int m_nDelayFactor;

		enum {
			LED_READ=1,
			LED_WRITE=0x20
		};
		// b7 = inverted nLRST
		// b6 = inverted nLFRAME
		// b5 = optional writing LED (cathode side)
		// b4..b1 = LPC data out
		// b0 = optional reading LED (cathode side)
		// Strobe = inverted clock
		
	public:
		CParallelCheapLPC() ;
		void ResetLPC();
		void DebugDelay() { volatile int n, n1=0; for(n=0;n<m_nDelayFactor;n++) n1+=CParallel::Read(); }
			// overrides of IO access primitives allow LED control and delay insertion for all accesses
		__inline void Write(BYTE bValue) { CParallel::Write(bValue | m_bMaskLeds); if(m_nDelayFactor) DebugDelay(); }
		void WriteNoStrobe(BYTE bValue) { CParallel::WriteNoStrobe(bValue | m_bMaskLeds); if(m_nDelayFactor) DebugDelay(); }
		BYTE Read() { if(m_nDelayFactor) DebugDelay(); return CParallel::Read(); }

		BYTE GetReturnedNybble() ;
		int IssueLPCMemoryRead(DWORD dwAds);
		int IssueLPCIORead(WORD wAds);		
		int IssueLPCMemoryWrite(DWORD dwAds, BYTE b);
		int IssueLPCIOWrite(WORD wAds, BYTE b);
		bool FlashProgram(DWORD dw, BYTE b);
		bool FlashEraseBlock(DWORD dw);
		bool FlashEraseMultipleBlocks(DWORD dwStart, int nCountBlocks, DWORD dwAddressIncrement=0x10000);		
		bool FlashResetStateMachine(DWORD dw);		
		bool FlashGetDeviceId(DWORD dw, BYTE *pbManufacturer, BYTE *pbDevice);
		bool ReadBackData(BYTE * pba, DWORD dwLength, DWORD dwStartAddress) ;
		bool ProgramAndVerify(BYTE * pba, DWORD dwLength, DWORD dwStartAddress, bool fVerify) ;
		bool FlashEraseWholeDevice(DWORD dwStartAddress);
		bool EraseChip(DWORD dwStartAddress);
};
