/***************************************************************************
                          CParallelFiltror.cpp  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
  #include "winconst.h"  /* defines constants, couple of static functions */
 #include "CParallel.h"
 #include "CParallelFiltror.h"

 		CParallelFiltror::CParallelFiltror() {
			m_bModeMask=0;
			m_bModeOld=0x04;
		}

		void CParallelFiltror::Power() {
			m_bModeMask |=0x08;
			SetMilksopMode(TEM_RESET);
			Sleep(200);
			m_bModeMask &=~0x08;
			SetMilksopMode(TEM_RESET);

			Sleep(200);

			m_bModeMask |=0x08;
			SetMilksopMode(TEM_RESET);
			Sleep(200);
			m_bModeMask &=~0x08;
			SetMilksopMode(TEM_RESET);
	}

		void CParallelFiltror::SetAddress(DWORD dw) {
			SetMilksopMode(TEM_ADDRESS);
			Write((BYTE)(dw>>16));
			Write((BYTE)(dw>>8));
			Write((BYTE)dw);
		}

		bool CParallelFiltror::ProgramAndVerify(const BYTE * pba, DWORD dwLength, DWORD dwStartAddress, bool fVerify) {

			SetAddress(dwStartAddress);
			DWORD dwLen=dwLength;
			const BYTE *pbaProgram=&pba[0];
			int nCountErrors=0;
			SetMilksopMode(TEM_WRITE);
			DWORD dwa=dwStartAddress;
			while(dwLen--) {

//				if((dwa&0x1fff) == 0) { printf("%06X\r", dwa); Sleep(0); }
				dwa++;

				Write(*pbaProgram++);

				if(!AwaitMilksopNoLongerBusy(500000)) {
					printf("\ntimeout at %06X writing %02X\n", dwa, *(pbaProgram-1));
					FlashInit();
					return false;			
				}
				
			}

   			if(fVerify) {
				printf("\nverifying \n");

				SetAddress(dwStartAddress);
				SetMilksopMode(TEM_READ);
				BYTE b;
				dwa=dwStartAddress;
				while(dwLength--) {


					if((dwa&0x1fff) == 0) printf("%06X errs: %u\n", dwa, nCountErrors);
					dwa++;

					Write(0); // dummy write to initiate read sequence
					if(!AwaitMilksopNoLongerBusy()) {  // do not go on with read until we see that we have performed bus cycle at RAM
						printf("\ntimeout at %06X reading\n", dwa);
						FlashInit();
						return false;			
					}
					b=GetReturnedNybble()<<4;
					Write(0);  // no need to wait here as whole byte was captured the first time
					b|=(GetReturnedNybble());
				
					if(b!=*pba++) nCountErrors++;
				}		
   			}

//			printf("\n");
	
			return nCountErrors==0;
		}

		bool CParallelFiltror::ReadBackData(BYTE * pba, DWORD dwLength, DWORD dwStartAddress) {

			SetAddress(dwStartAddress);
		
   			SetMilksopMode(TEM_READ);
			BYTE b;
			DWORD dwa=dwStartAddress;
			while(dwLength--) {

//				if((dwa&0xffff) == 0) printf("%06X\r", dwa);
				dwa++;

				Write(0); // dummy write to initiate read sequence
				if(!AwaitMilksopNoLongerBusy()) {  // do not go on with read until we see that we have performed bus cycle at RAM
					printf("\ntimeout at %06X reading\n", dwa);
					FlashInit();
					return false;			
				}
				b=GetReturnedNybble()<<4;
				Write(0);  // no need to wait here as whole byte was captured the first time
				b|=(GetReturnedNybble());
				
				*pba++=b;
			}
			return true;
		}

		WORD CParallelFiltror::CheckForIncomingComms(WORD * pwChecksum)
		{
			BYTE ba[4];
			if(!ReadBackData(&ba[0], 1, FILT_DEBUG_TOPC_LEN+1)) return 0;
			if(!(ba[0]&0x80)) return 0;
			if(!ReadBackData(&ba[0], 2, FILT_DEBUG_TOPC_LEN)) return 0;
			WORD wLen= (WORD)((((WORD)(ba[1]&0x7f))<<8) | ba[0]);

			if(!ReadBackData(&ba[0], 2, FILT_DEBUG_TOPC_CHECKSUM)) return 0;
			if(pwChecksum!=NULL) *pwChecksum = (WORD)((((WORD)ba[1])<<8) | ba[0]);
			return wLen;
		}

		bool CParallelFiltror::MarkIncomingCommsAsRead()
		{
			BYTE ba[2];
			ba[0]=ba[1]=0;
			return ProgramAndVerify(&ba[0], 2, FILT_DEBUG_TOPC_LEN, false);
		}

		bool CParallelFiltror::CheckForOutgoingStillPending()
		{
			BYTE ba[2];
			if(!ReadBackData(&ba[0], 2, FILT_DEBUG_FROMPC_LEN)) return 0;
			if(!(ba[1]&0x80)) return false;
			return true;
		}

		bool CParallelFiltror::MarkOutgoingAsAvailable(WORD wChecksum, WORD wLength)
		{
			BYTE ba[4];
			ba[0]=(BYTE)wChecksum;
			ba[1]=(BYTE)(wChecksum>>8);
			ba[2]=(BYTE)wLength;
			ba[3]=(BYTE)(wLength>>8)|0x80;
			return ProgramAndVerify(&ba[0], 4, FILT_DEBUG_FROMPC_CHECKSUM, false);
		}

		int CParallelFiltror::SendArrayToTarget(const BYTE * pba, WORD wLength)
		{
			WORD wChecksum=0;
			int n=0;
			if(wLength >= (WORD)FILT_DEBUG_MAX_DATA) return -1;
			if(CheckForOutgoingStillPending()) return -2;

			while(n++<(int)wLength) {
				wChecksum+=pba[n-1];
			}

			if(!ProgramAndVerify(pba, wLength, FILT_DEBUG_FROMPC_START, false)) return -3;
			MarkOutgoingAsAvailable(wChecksum, wLength);
			return 0;
		}

		int CParallelFiltror::GetArrayFromTarget( BYTE * pba, WORD wLengthMax)
		{
			WORD wChecksum=0, wChecksumComputed=0;
			WORD wLength=0;
			int n=0;
			if(wLengthMax < (WORD)FILT_DEBUG_MAX_DATA) return -1;

			wLength=CheckForIncomingComms(&wChecksum);
			if(wLength==0) return 0;

			if(!ReadBackData(&pba[0], wLength, FILT_DEBUG_TOPC_START)) return -2;

			while(n++<(int)wLength) {
				wChecksumComputed+=pba[n-1];
			}

			if(wChecksum != wChecksumComputed) {
				printf("(Bad checksum seen len=%x: %X saw %x: '%s')\n", wLength, wChecksum, wChecksumComputed, (const char *)pba);
				return -3;
			} else {
//				printf("(len=%x: %X)\n", wLength, wChecksum);

			}
			MarkIncomingCommsAsRead();
			return wLength;
		}
