/***************************************************************************
                          CParallelFiltror.h  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 // CParallelFiltror represents the protocol used to operate Filtror over the parallel port
// note that although several signals from the printer port have inverted sense compared to milksop,
// all of the inversion to compensate is done by the CPLD retaining the same physical levels

class CParallelFiltror : public CParallel
{
	public:
		
			//	constant constSelectAddress : std_logic_vector(1 downto 0) := "00";
			//	constant constSelectRead : std_logic_vector(1 downto 0) := "01";  -- return read data directly from ram data bus
			//	constant constSelectWrite : std_logic_vector(1 downto 0) := "10";

		typedef enum {  // Operation modes that filtror offers
			TEM_ADDRESS = 0,
			TEM_READ = 1,
			TEM_WRITE = 2,
			TEM_RESET =3
		} teMode;

		typedef enum {
			FILT_DEBUG_FOOTPRINT = 0x1000,
			FILT_DEBUG_MAX_DATA = (FILT_DEBUG_FOOTPRINT/2)-4,
			FILT_DEBUG_BASE = 0xff0fe000,
			FILT_DEBUG_TOPC_START = (FILT_DEBUG_BASE+0),
			FILT_DEBUG_FROMPC_START  = (FILT_DEBUG_BASE+(FILT_DEBUG_FOOTPRINT/2)),
			FILT_DEBUG_TOPC_LEN =  (FILT_DEBUG_BASE+(FILT_DEBUG_FOOTPRINT/2)-2),
			FILT_DEBUG_FROMPC_LEN =  (FILT_DEBUG_BASE+FILT_DEBUG_FOOTPRINT-2),
			FILT_DEBUG_TOPC_CHECKSUM =  (FILT_DEBUG_BASE+(FILT_DEBUG_FOOTPRINT/2)-4),
			FILT_DEBUG_FROMPC_CHECKSUM=  (FILT_DEBUG_BASE+FILT_DEBUG_FOOTPRINT-4)
		};

			// b3 = cycle power
		
	public:
		CParallelFiltror() ;
      void Power() ;
		void SetAddress(DWORD dw) ;
		bool ProgramAndVerify(const BYTE * pba, DWORD dwLength, DWORD dwStartAddress, bool fVerify) ;
		bool ReadBackData(BYTE * pba, DWORD dwLength, DWORD dwStartAddress) ;
		WORD CheckForIncomingComms(WORD *pwChecksum);
		bool MarkIncomingCommsAsRead();
		bool CheckForOutgoingStillPending();
		bool MarkOutgoingAsAvailable(WORD wChecksum, WORD wLength);
		int SendArrayToTarget(const BYTE * pba, WORD wLength);
		int GetArrayFromTarget( BYTE * pba, WORD wLengthMax);

};
