/***************************************************************************
                          CParallelI2c.cpp  -  description
                             -------------------
    begin                : Wed Oct 2 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "milk.h"
#include "CMiloschUserRealtime.h"

DWORD CParallelI2c::MonitorUntilKeypress(char *szBufferOriginal, DWORD dwBufferMaxSize)
{ // for extent of this block, we own the CPU
	CMiloschUserRealtime mur;
	char * szBuffer=szBufferOriginal;
	const int nConstantCountLoopsBetweekKeyboardCheck=100000;

	if(mur.IsSuccessfullyInSingleProcessMode()) {
		bool fKeypress=false;
		DWORD dwCountKeypressDetectLoops=nConstantCountLoopsBetweekKeyboardCheck;  // don't look every time, it would be slow
		BYTE bPortState=Read(), bPortStateOld=0;
		CI2CEvent *pi2cevent=NULL;

		m_i64ClocksPerThousandSeconds=mur.m_i64ClocksPerThousandSeconds;

		while(!fKeypress) {
			if(!(dwCountKeypressDetectLoops--)) {		// check if we are finished every now and again
				fKeypress=mur.IsKeyPressed()!=0;
				dwCountKeypressDetectLoops=nConstantCountLoopsBetweekKeyboardCheck;
			}

			bPortStateOld=bPortState;
			bPortState=Read();  // single IO read per loop, its so slow to read

					// always on lookout for START and STOP actions, which can be used as an async abort

			if(
				((bPortStateOld & (PPI2C_CLOCK|PPI2C_DATA)) == PPI2C_CLOCK) &&
				((bPortState & (PPI2C_CLOCK|PPI2C_DATA)) == (PPI2C_CLOCK|PPI2C_DATA))
			) {  // detected STOP action, Data went up while clock high
				m_cpi2cs=CPI2CS_BUSIDLE;
				m_nCountMultibit=0;
				continue;
			}

			if(
				((bPortStateOld & (PPI2C_CLOCK|PPI2C_DATA)) == (PPI2C_CLOCK|PPI2C_DATA)) &&
				((bPortState & (PPI2C_CLOCK|PPI2C_DATA)) == (PPI2C_CLOCK))
			) {  // detected START action, Data went down while clock high
				m_cpi2cs=CPI2CS_FETCHING_ADS_AND_RW;  // next clock up is start of address capture
				m_nCountMultibit=0;
				pi2cevent=(CI2CEvent *)szBuffer;  szBuffer+=sizeof(CI2CEvent);
				pi2cevent->Reset();
				pi2cevent->m_i64Timestamp=mur.GetHiresTimestamp();
				if(szBuffer>=(szBufferOriginal+dwBufferMaxSize)) return (DWORD)(szBuffer-szBufferOriginal);
				continue;
			}

				// otherwise, if no STOP or START, await clock upgoing

			if(
				((bPortStateOld & (PPI2C_CLOCK)) == 0) &&
				((bPortState & (PPI2C_CLOCK)) == (PPI2C_CLOCK))
			) {  // upgoing clock seen

				switch(m_cpi2cs) {

					case CPI2CS_FETCHING_ADS_AND_RW:
						pi2cevent->m_bAdsRwLsb <<=1;
						if(bPortState & PPI2C_DATA) pi2cevent->m_bAdsRwLsb|=1;
						if(m_nCountMultibit++==7) {
							m_cpi2cs=CPI2CS_ADS_ACK;
						}
						break;

					case CPI2CS_ADS_ACK:
						m_nCountMultibit=0;
						if(bPortState & PPI2C_DATA) { // NAK!
							pi2cevent->m_fnAcked=true;
							m_cpi2cs=CPI2CS_BUSIDLE;
						} else {
							pi2cevent->m_fAcked=true;
							m_cpi2cs=CPI2CS_FETCHING_DATA;
						}
						break;

					case CPI2CS_FETCHING_DATA:
						*szBuffer <<=1;
						if(bPortState & PPI2C_DATA) *szBuffer|=1;
						if(m_nCountMultibit++==7) {
							m_cpi2cs=CPI2CS_DATA_ACK;
							pi2cevent->m_dwDataFollowing++;
							szBuffer++;
							if(szBuffer>=(szBufferOriginal+dwBufferMaxSize)) return (DWORD)(szBuffer-szBufferOriginal);
						}
						break;

					case CPI2CS_DATA_ACK:
						m_nCountMultibit=0;
						if(bPortState & PPI2C_DATA) { // NAK! indicates final in sequence
							m_cpi2cs=CPI2CS_BUSIDLE;
						} else {  // acked, go back for more
							m_cpi2cs=CPI2CS_FETCHING_DATA;
						}
						break;

					default:  // Bus idle, waiting for start
						break;
				}
			}

		}

	} else {
		printf("Failed to get into Realtime mode\n");
		return (DWORD)-1;
	}
	return (DWORD)(szBuffer-szBufferOriginal);
}

