/***************************************************************************
                          CParallelI2c.h  -  description
                             -------------------
    begin                : Sat Aug 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

class CI2CEvent
{
	public:
		BYTE m_bAdsRwLsb;
		bool m_fAcked;
		bool m_fnAcked;
		DWORD m_dwDataFollowing;
		__int64 m_i64Timestamp;
	public:
		CI2CEvent() { Reset(); }
		void Reset() { m_bAdsRwLsb=0; m_fnAcked=m_fAcked=false; m_dwDataFollowing=0; m_i64Timestamp=0; }
		DWORD Dump(__int64 i64Datum, __int64 i64ClocksPerThousandSeconds) {
			char c='W';
			DWORD dw=0;
			if(m_bAdsRwLsb&1) c='r';

			__int64 i64uS=((m_i64Timestamp-i64Datum)*((__int64)1000))/i64ClocksPerThousandSeconds;

			if(i64uS<(__int64)1000) { // <1mS
				printf("    %3uuS: ", (int)i64uS);
			} else { // <1S
				if(i64uS<(__int64)1000000) {
					printf("%3u.%03umS: ", (int)(i64uS/(__int64)1000), (int)((__int64)i64uS%(__int64)1000));
				} else {
					printf("%3u.%03u S: ", (int)(i64uS/(__int64)1000000), (int)(((__int64)i64uS%1000000)/(__int64)1000));
				}
			}

			printf("%02X %c ", m_bAdsRwLsb>>1, c);
			if(m_fnAcked) { printf(" -nak-"); }
			if((!m_fAcked) && (!m_fnAcked)) { printf(" -interrupted-"); }
			while(dw<m_dwDataFollowing) {
				printf("%02X ", *(((unsigned char *)this)+sizeof(CI2CEvent)+dw));
				dw++;
			}
			dw=1;
			printf("  ");
			while(dw<m_dwDataFollowing) {
				BYTE b=*(((unsigned char *)this)+sizeof(CI2CEvent)+dw);
				char c1='.';
				if((b>31) && (b<128)) c1=(char)b;
				printf("%c ", c1);
				dw++;
			}

			printf("\n");
			return sizeof(CI2CEvent)+m_dwDataFollowing;
		}
};


 // CParallelI2c represents the protocol used to operate the Milksop over the parallel port

class CParallelI2c : public CParallel
{
	public:
		typedef enum {
			CPI2CS_BUSIDLE=0,
			CPI2CS_FETCHING_ADS_AND_RW,
			CPI2CS_ADS_ACK,
			CPI2CS_FETCHING_DATA,
			CPI2CS_DATA_ACK
		} tecpi2cs;

		enum {
			PPI2C_CLOCK=0x10,
			PPI2C_DATA=0x20
		};

		int m_nCountMultibit;  // used to count address and data bits inside states
		tecpi2cs m_cpi2cs; // current I2C State
		__int64 m_i64ClocksPerThousandSeconds; // captured from CMiloschUserRealtime

	public:
		CParallelI2c() {
			m_nCountMultibit=0;
			m_cpi2cs=CPI2CS_BUSIDLE;
		}

		DWORD MonitorUntilKeypress(char *szBuffer, DWORD dwBufferMaxSize);  // returns buffer used
};

