/***************************************************************************
                          CParallelJtag.cpp  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 #include "winconst.h"  /* defines constants, couple of static functions */
 #include "CParallel.h"
 #include "CParallelJtag.h"

bool CParallelJtag::ConfirmPowerAndPresent()
{
	WriteNoStrobe(0x40);
	WriteNoStrobe(0x40);
//	printf("Read1=%02X\n", Read());
	if((Read() & 0xa8)!=0x28) return false;
	WriteNoStrobe(0x00);
//	printf("Read2=%02X\n", Read());
	if((Read() & 0xa8)!=0x88) return false;

	return true;
}

void CJtagSvfInterpreterParallelJtag::PutInTestLogicReset()
{
	MoveToState(TOK_STATE_RESET);
	MoveToState(TOK_STATE_RESET);
	MoveToState(TOK_STATE_RESET);
}

int CJtagSvfInterpreterParallelJtag::LoadBoundaryRegister(CJtagRegisterManagement * pjrm, int nJtagState, int nType) {
	int nPattern=0;
	if(pjrm->m_nBits==0) return 0;
	int nCountRetry=0;

	if(nJtagState) {
//		printf("LoadBoundaryRegister %x (%d bits) %s %d\n", (int)pjrm, (int)pjrm->m_nBits,TranslateStateToText(nJtagState), nType);
		nPattern=GetTMSSequenceForState(nJtagState);
	} else {
//		printf("LoadBoundaryRegister %x (%d bits) %d\n", (int)pjrm, (int)pjrm->m_nBits, nType);
	}

	while(nCountRetry++<32) {
		switch(nType & 7) {

			case LBR_TYPE_HEADER:
			case LBR_TYPE_PAYLOAD:
			case LBR_TYPE_TRAILER:
				{
					for(int n=0; n<pjrm->m_nBits;n++) {
						BYTE b=0;
						if(pjrm->GetTdiBit(n)) b|=1;
//						if(nJtagState) {
							if(n==(pjrm->m_nBits-1)) { // last bit needs TMS set
								b|=4;
							}
//						}
						m_ppj.WriteNoStrobe(0x00|b);	
						m_ppj.WriteNoStrobe(0x02|b);
						if(nType & LBR_ATTRIBUTE_TDO) {
							pjrm->SetCapturedBit(n, (m_ppj.Read()&0x10) !=0);
//							printf("%d",(m_ppj.Read()&0x10 )>>4);
						}
					}
				}
				break;

			case LBR_TYPE_TCKONLY:
				{
					m_nLastRunTestLength=pjrm->m_nBits;
					for(int n=0; n<pjrm->m_nBits; n++) {
						if( (nJtagState) && (n==(pjrm->m_nBits-1))) { // last bit needs TMS set
							m_ppj.WriteNoStrobe(0x04);	
							m_ppj.WriteNoStrobe(0x06);
						} else {
							m_ppj.WriteNoStrobe(0x00);	
							m_ppj.WriteNoStrobe(0x02);
						}
					}
				}
				break;

			default:
				break;
		}
	
		if(nType & LBR_ATTRIBUTE_TDO) {
			if(!pjrm->CaptureMatchesAllowingForMask()) {

					if(pjrm==&m_cjrmInstructionPayload) return -1; // retry only applies to data shifter

					printf("(line %u: retry %d...)\n", (unsigned int)m_nLinesSeen, nCountRetry);

						// do the Jtag retry sequence.. we are already at exit-1DR
					m_ppj.WriteNoStrobe(0x00|0);	
					m_ppj.WriteNoStrobe(0x02|0);
						// pause dr
					m_ppj.WriteNoStrobe(0x00|4);	
					m_ppj.WriteNoStrobe(0x02|4);
						// exit2 dr
					m_ppj.WriteNoStrobe(0x00|0);	
					m_ppj.WriteNoStrobe(0x02|0);
						// shift dr
					m_ppj.WriteNoStrobe(0x00|4);	
					m_ppj.WriteNoStrobe(0x02|4);
						// exit-1 DR (again!)
					m_ppj.WriteNoStrobe(0x00|4);	
					m_ppj.WriteNoStrobe(0x02|4);
						// update
					m_ppj.WriteNoStrobe(0x00|0);	
					m_ppj.WriteNoStrobe(0x02|0);
						// idle

						// repeat the last delay

					for(int n=0; n<m_nLastRunTestLength; n++) {
						if( (nJtagState) && (n==(m_nLastRunTestLength-1))) { // last bit needs TMS set
							m_ppj.WriteNoStrobe(0x04);	
							m_ppj.WriteNoStrobe(0x06);
						} else {
							m_ppj.WriteNoStrobe(0x00);	
							m_ppj.WriteNoStrobe(0x02);
						}
					}

					m_ppj.WriteNoStrobe(0x00);	
					m_ppj.WriteNoStrobe(0x02);
					m_ppj.WriteNoStrobe(0x00);	
					m_ppj.WriteNoStrobe(0x02);

						// shift DR

					continue; // and retry
			}
	//		printf("MATCH!\n");
		}

//	string cs;
//	pjrm->FillCStringWithAsciiHexCaptured(cs);
//	printf(cs.c_str());

		if(nJtagState) {
			bool f=false;
			while(nPattern & 0xff) {
				int nCount = (nPattern>>5);
				if(!f) {
					f=true;
					nCount--;
					nPattern>>=1; // skip the first bit
				}
				while(nCount--) {
					BYTE b=0;
					if(nPattern & 1) b=4;
					m_ppj.WriteNoStrobe(0x00|b);	
					m_ppj.WriteNoStrobe(0x02|b);
					nPattern>>=1;
				}
				nPattern>>=8;
			}
			m_nState = nJtagState;
//			printf("Move to stated %s\n", TranslateStateToText(nJtagState));	
		}
		return 0;
	} // while nCountRetry

	return -1; // mismatch even after retries
}

bool CJtagSvfInterpreterParallelJtag::MoveToState(int nState) {

	if(!nState) return true;
//	printf("Moving from %s to %s\n", TranslateStateToText(m_nState), TranslateStateToText(nState));

	int nPattern=GetTMSSequenceForState(nState);
	while(nPattern & 0xff) {
		int nCount = (nPattern>>5);
		while(nCount--) {
			BYTE b=0;
			if(nPattern & 1) b=4;

//			if(nPattern & 1) printf("1"); else printf("0");

			m_ppj.WriteNoStrobe(0x00|b);	
			m_ppj.WriteNoStrobe(0x02|b);
			nPattern>>=1;
		}
		nPattern>>=8;
	}
	m_nState = nState;
//	printf("Moved to state %s\n", TranslateStateToText(nState));
	return false;
}
