/***************************************************************************
                          CParallelMilksop.cpp  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

  #include "winconst.h"  /* defines constants, couple of static functions */
 #include "CParallel.h"
 #include "CParallelMilksop.h"

 		CParallelMilksop::CParallelMilksop() {
			m_bManufacturer=0;
			m_bDevice=0;
			for(int n=0;n<8;n++) { m_faBlockProtected[n]=true; }
		}

		void CParallelMilksop::Power() {
			m_bModeMask |=0x08;
			SetMilksopMode(TEM_RESET);
			Sleep(500);
			m_bModeMask &=~0x08;
			SetMilksopMode(TEM_RESET);
		}

		void CParallelMilksop::ResetFlashStateMachine() {
			SetMilksopMode(TEM_RESET);
			Write(0); // dummy write to initiate reset sequence
		}

		void CParallelMilksop::SetAddress(DWORD dw) {
			SetMilksopMode(TEM_ADDRESS);
			Write((BYTE)(dw>>16));
			Write((BYTE)(dw>>8));
			Write((BYTE)dw);
		}

		void CParallelMilksop::GetDeviceType()
		{
			SetAddress(0);
			SetMilksopMode(TEM_AUTOSELECT);
			Write(0); // dummy write to initiate autoselect sequence

//			return;
			
				// read from address 0 to get manufacturer (20h for ST)
			
			SetMilksopMode(TEM_READ);
			Write(0x55); // dummy write to initiate read sequence

			m_bManufacturer=GetReturnedNybble();
			Write(0x55);
			m_bManufacturer|=(GetReturnedNybble()<<4);

				// read action autoincrements to address 01, device code
			
			Write(0x55); // dummy write to initiate read sequence
			m_bDevice=GetReturnedNybble();
			Write(0x55);
			m_bDevice|=(GetReturnedNybble()<<4);

			for(int n=0;n<8;n++) {

				BYTE b;

				SetAddress(n<<17);
				SetMilksopMode(TEM_READ);
			
				Write(0); // dummy write to initiate read sequence
				b=GetReturnedNybble();
				Write(0);
				b|=(GetReturnedNybble()<<4);

//y				ASSERT( (b==0) || (b==1) );

				m_faBlockProtected[n]= (b==1);
			}
			ResetFlashStateMachine();
		}

		bool CParallelMilksop::ProgramAndVerify(BYTE * pba, DWORD dwLength, DWORD dwStartAddress, bool fVerify) {
			ResetFlashStateMachine();
			SetAddress(dwStartAddress);
			DWORD dwLen=dwLength;
			BYTE *pbaProgram=pba;
			int nCountErrors=0;
			SetMilksopMode(TEM_PROGRAM);
			DWORD dwa=dwStartAddress;
			while(dwLen--) {

				if((dwa&0x1fff) == 0) { printf("%06X\r", dwa); Sleep(0); }
				dwa++;

				Write(*pbaProgram++);
//				Write(0xc8);
				if(!AwaitMilksopNoLongerBusy(500000)) {
					printf("\ntimeout at %06X writing %02X\n", dwa, *(pbaProgram-1));
					FlashInit();
					ResetFlashStateMachine();
					return false;			
				}
				
			}
			if(fVerify) {
				printf("\nverifying \n");

				ResetFlashStateMachine();
				SetAddress(dwStartAddress);
				SetMilksopMode(TEM_READ);
				BYTE b;
				dwa=dwStartAddress;
				while(dwLength--) {

					if((dwa&0x1fff) == 0) printf("%06X errs: %u\r", dwa, nCountErrors);
					dwa++;

					Write(0); // dummy write to initiate read sequence
					b=GetReturnedNybble();
					Write(0);
					b|=(GetReturnedNybble()<<4);
				
					if(b!=*pba++) nCountErrors++;
				}
	

				printf("\n");
			}		
   			ResetFlashStateMachine();

			return nCountErrors==0;
		}

		void CParallelMilksop::ReadBackData(BYTE * pba, DWORD dwLength, DWORD dwStartAddress) {
			ResetFlashStateMachine();
			SetAddress(dwStartAddress);
			SetMilksopMode(TEM_READ);
			BYTE b;
			DWORD dwa=dwStartAddress;
			while(dwLength--) {

				if((dwa&0xffff) == 0) printf("%06X\r", dwa);
				dwa++;

				Write(0); // dummy write to initiate read sequence
				b=GetReturnedNybble();
				Write(0);
				b|=(GetReturnedNybble()<<4);
				
				*pba++=b;
			}
			ResetFlashStateMachine();
		}

		bool CParallelMilksop::EraseChip() {
			ResetFlashStateMachine();
			SetAddress(0x555);
			SetMilksopMode(TEM_ERASE);
			Write(0x10);
			return AwaitMilksopNoLongerBusy(50000000);				
		}

		void CParallelMilksop::EraseBlockContainingAddress(DWORD dwAddress) {
			SetAddress(dwAddress);
			SetMilksopMode(TEM_ERASE);
			Write(0x30);
			AwaitMilksopNoLongerBusy();
		}

		string CParallelMilksop::GetDeviceDestription() {
			string cs;
			cs=StringFormat("Manufacturer: %02X, Device: %02X, protection: ",
				m_bManufacturer, m_bDevice
			);
			for(int n=0;n<8;n++) if(m_faBlockProtected[n]) cs+='1'; else cs+='0';
			return cs;
		}
