/***************************************************************************
                          CParallelMilksop.h  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 // CParallelMilksop represents the protocol used to operate the Milksop over the parallel port

class CParallelMilksop : public CParallel
{
	public:
		
		BYTE m_bManufacturer;
		BYTE m_bDevice;
		bool m_faBlockProtected[8];

			// constant constSelectAddress : std_logic_vector(2 downto 0) := "000";
			// constant constSelectRead : std_logic_vector(2 downto 0) := "001";
			// constant constSelectAutoselect : std_logic_vector(2 downto 0) := "010";
			// constant constSelectProgram : std_logic_vector(2 downto 0) := "011";
			// constant constSelectErase : std_logic_vector(2 downto 0) := "100";
			// constant constSelectReset : std_logic_vector(2 downto 0) := "111";

		typedef enum {  // Operation modes that milksop offers
			TEM_ADDRESS = 0,
			TEM_READ = 1,
			TEM_AUTOSELECT = 2,
			TEM_PROGRAM = 3,
			TEM_ERASE = 4,
			TEM_RESET = 7
		} teMode;

	public:

		CParallelMilksop() ;
		void Power() ;
		void ResetFlashStateMachine() ;
		void SetAddress(DWORD dw) ;
		void GetDeviceType();
		bool ProgramAndVerify(BYTE * pba, DWORD dwLength, DWORD dwStartAddress, bool fVerify) ;
		void ReadBackData(BYTE * pba, DWORD dwLength, DWORD dwStartAddress) ;
		bool EraseChip() ;
		void EraseBlockContainingAddress(DWORD dwAddress) ;
		string GetDeviceDestription() ;

};
