/***************************************************************************
                          CParallelShaftEncoderEmulator.cpp  -  description
                             -------------------
    begin                : Wed Jun 11 2003
    copyright            : (C) 2003 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "milk.h"
#include "CMiloschUserRealtime.h"

DWORD CParallelShaftEncoderEmulator::EmulateUntilKeypress(int nRevolutionPeriodInMilliseconds, int nPulsesPerRevolution, int nStartingQuadraturePosition, bool fDirectionIsForward)
{ // for extent of this block, we own the CPU
	CMiloschUserRealtime mur;
	const int nConstantCountLoopsBetweenKeyboardCheck=1000;
	BYTE baQuadraturePhases[] = {  0x14, 0x18, 0x28, 0x24 };
	BYTE baDatumPhases[] = { 0x02, 0x01 };
	__int64 i64EncoderQuadraturePeriodInCpuClocks;
	int nPercentageAdjusted, nTemp, nTempFreq, nSkewK2CpuClocks, nIndexIncrement=1, nCountOverruns=0;
	DWORD dwNextActionTime;

	m_nPulsesPerRevolutionTimesFour=nPulsesPerRevolution<<2;
	m_nIndexCurrentQuadratureIndex=nStartingQuadraturePosition;
	m_fDirectionIsForward=fDirectionIsForward;

	if(!fDirectionIsForward) { nIndexIncrement=-1; }

	if((m_nPercentageHighPeriod<35) || (m_nPercentageHighPeriod>65)) {
		printf("Mark-space percentage must be between 35 and 65\n");
		return (DWORD)-1;
	}

	nPercentageAdjusted=(m_nPercentageHighPeriod-25)*2;

	i64EncoderQuadraturePeriodInCpuClocks=  ((((__int64)nRevolutionPeriodInMilliseconds)*(mur.m_i64ClocksPerThousandSeconds)) ) / ((__int64)m_nPulsesPerRevolutionTimesFour)   ;

	nSkewK2CpuClocks=(int)((((__int64)m_nCountSkewK2nS)*2500000ll)/mur.m_i64ClocksPerThousandSeconds);

	if(nSkewK2CpuClocks>i64EncoderQuadraturePeriodInCpuClocks) {
		printf("K2 skew fixup (%d clocks) must be less than quadrature CPU clock count %d!\n", (int) nSkewK2CpuClocks, (int)i64EncoderQuadraturePeriodInCpuClocks);
		return (DWORD)-1;
	}

            // compute individual high and low times using mark-space ratio

	m_dwaEncoderQuadraturePeriodInCpuClocks[0]=((i64EncoderQuadraturePeriodInCpuClocks*2) * nPercentageAdjusted)/100 - nSkewK2CpuClocks;
	m_dwaEncoderQuadraturePeriodInCpuClocks[1]=i64EncoderQuadraturePeriodInCpuClocks + nSkewK2CpuClocks;
	m_dwaEncoderQuadraturePeriodInCpuClocks[2]= ((i64EncoderQuadraturePeriodInCpuClocks*2) - (((i64EncoderQuadraturePeriodInCpuClocks*2) * nPercentageAdjusted)/100)) - nSkewK2CpuClocks;
	m_dwaEncoderQuadraturePeriodInCpuClocks[3]= i64EncoderQuadraturePeriodInCpuClocks + nSkewK2CpuClocks;

	nTemp=(int)((i64EncoderQuadraturePeriodInCpuClocks*(__int64)4*(__int64)1000000)/(mur.m_i64ClocksPerThousandSeconds));
	nTempFreq=(int)((__int64)1000000000ll/(__int64)nTemp);

	if(nTemp<5000) {
		printf("*** WARNING *** may not be able to accurately issue quadrature events of less than 5uS, keep an eye on overrun counter\n");
	}


	printf(
		"  total quadrature diameter=%d, starting angular position=%d, cpu clks=%d/%d/%d/%d, mark-space=%d%%\n"
		"  whole pulse period=%d.%03duS (%d.%03dkHz), Quadrature event period=%d.%03duS, K2 skew=%dnS (%d CPU clocks)\n",
		m_nPulsesPerRevolutionTimesFour, m_nIndexCurrentQuadratureIndex,
		(int)m_dwaEncoderQuadraturePeriodInCpuClocks[0],
		(int)m_dwaEncoderQuadraturePeriodInCpuClocks[1],
		(int)m_dwaEncoderQuadraturePeriodInCpuClocks[2],
		(int)m_dwaEncoderQuadraturePeriodInCpuClocks[3],
		m_nPercentageHighPeriod,
		nTemp/1000,
		nTemp-((nTemp/1000)*1000),
		nTempFreq/1000,
		nTempFreq-((nTempFreq/1000)*1000),
		(nTemp/4)/1000,
		(nTemp/4)-(((nTemp/4)/1000)*1000),
		m_nCountSkewK2nS,
		nSkewK2CpuClocks
	);
	printf("Entering emulation mode, your PC will appear frozen - press any key to end\n");
	Sleep(100);

  
	if(mur.IsSuccessfullyInSingleProcessMode()) {
		BYTE  bOverrun, b;
		DWORD nIndexCurrentQuadratureIndex=m_nIndexCurrentQuadratureIndex, nCountMovesToLive=m_nCountMovesToLive;
		DWORD dwCountKeypressDetectLoops=nConstantCountLoopsBetweenKeyboardCheck;  // don't look every time, it would be slow
		DWORD dwStartPulseGatingAtThisPhase=0xffffffff; // phase 4 never seen
		BYTE bMaskOr=0x00, bMaskOrToUse=0x00; // none
		BYTE bMaskAnd=0xff, bMaskAndToUse=0x00; // none
		BYTE bDone=0;

		dwNextActionTime=mur.GetHiresTimestampLsd()+1000000;  // first action

			// main quadrature transition loop

		while(nCountMovesToLive--) {

			if(!(dwCountKeypressDetectLoops--)) {		// check for abort or use action every now and again

				switch(mur.GetKeyboardEvent()) {
					case -1:  // no new keyboard activity
						break;
					case 0x02: // key '1' -- lose one low action on K1
						dwStartPulseGatingAtThisPhase=((nIndexCurrentQuadratureIndex & (~0x3))+(4+1)*nIndexIncrement)%m_nPulsesPerRevolutionTimesFour;
						bMaskOrToUse=0x84;
						bMaskAndToUse=~0x08;
						break;
					case 0x03: // key '2' -- lose one high action on K1
						dwStartPulseGatingAtThisPhase=((nIndexCurrentQuadratureIndex & (~0x3))+(4+3)*nIndexIncrement)%m_nPulsesPerRevolutionTimesFour;
						bMaskOrToUse=0x88;
						bMaskAndToUse=~0x04;
						break;
					case 0x04: // key '3' -- lose one low action on K2
						dwStartPulseGatingAtThisPhase=((nIndexCurrentQuadratureIndex & (~0x3))+(4+2)*nIndexIncrement)%m_nPulsesPerRevolutionTimesFour;
						bMaskOrToUse=0x90;
						bMaskAndToUse=~0x20;
						break;
					case 0x05: // key '4' -- lose one high action on K2
						dwStartPulseGatingAtThisPhase=((nIndexCurrentQuadratureIndex & (~0x3))+(4+0)*nIndexIncrement)%m_nPulsesPerRevolutionTimesFour;
						bMaskOrToUse=0xa0;
						bMaskAndToUse=~0x10;
						break;
					case 0x06: // key '5' -- lose one high action on K0 (reference)
						dwStartPulseGatingAtThisPhase=0;
						bMaskOrToUse=0x82;
						bMaskAndToUse=~0x01;
						break;
					case 0x07: // key '6' -- reverse direction
						nIndexIncrement=-nIndexIncrement;
						bMaskOrToUse=0x82;
						bMaskAndToUse=~0x01;
						break;
					case 0x08: // key '7' -- skip 2 phases - should always be seen as quad error
						dwStartPulseGatingAtThisPhase=((nIndexCurrentQuadratureIndex & (~0x3))+(1)*nIndexIncrement)%m_nPulsesPerRevolutionTimesFour;
						bMaskOrToUse=0xa0;
						bMaskAndToUse=~0x10;
						break;
					case 0x1c: // enter key down - STOP
						nCountMovesToLive=0;
//						printf("%02X\n", mur.m_bLastKeyboardCode);
						break;
				}
				dwCountKeypressDetectLoops=nConstantCountLoopsBetweenKeyboardCheck;
			}

			nIndexCurrentQuadratureIndex=(nIndexCurrentQuadratureIndex+nIndexIncrement)%m_nPulsesPerRevolutionTimesFour;

			if(nIndexCurrentQuadratureIndex==dwStartPulseGatingAtThisPhase) {
				if(bDone) {
					dwStartPulseGatingAtThisPhase=0xffffffff;
					bMaskOr=0;
					bMaskAnd=0xff;
					bDone=0;
				} else {
					bMaskOr=bMaskOrToUse;
					bMaskAnd=bMaskAndToUse;
					dwStartPulseGatingAtThisPhase=(dwStartPulseGatingAtThisPhase+(2*nIndexIncrement))%m_nPulsesPerRevolutionTimesFour;
					bDone=1;
				}
			}

			b=((baDatumPhases[(nIndexCurrentQuadratureIndex==0)?1:0] | baQuadraturePhases[ nIndexCurrentQuadratureIndex&3 ])|bMaskOr)&bMaskAnd;

				// wait for next action time

			bOverrun=1;
			while((int)((mur.GetHiresTimestampLsd()-dwNextActionTime))<0) bOverrun=0;

			outb(b, m_wAddress);

			if(bOverrun) nCountOverruns++;
			dwNextActionTime+=m_dwaEncoderQuadraturePeriodInCpuClocks[nIndexCurrentQuadratureIndex&3];

		}    // while

		m_nIndexCurrentQuadratureIndex=nIndexCurrentQuadratureIndex;

	} else {
		printf("Failed to get into Realtime mode\n");
		return (DWORD)-1;
	}

    printf("Final angular position: %u, overruns=%d\n", m_nIndexCurrentQuadratureIndex, nCountOverruns);
  
	return (DWORD)1;
}


