
      // CParallelShaftEncoderEmulator represents the emulated shaft encoder interface to the parallel port

      // D0 -- V0+
      // D1 -- V0-
      // D2 -- V1+
      // D3 -- V1-
      // D4 -- V2+
      // D5 -- V2-

class CParallelShaftEncoderEmulator : public CParallel
{
	public:

      BYTE m_bState;  // b0/b2/b4 are the positive logic states, negative ones on b1/b3/b5 
      DWORD m_dwaEncoderQuadraturePeriodInCpuClocks[4]; // pulse period /4 in cpu clocks, for high [0] then low[1]
      __int64 m_i64CpuClockNextActionTime;
      int m_nPulsesPerRevolutionTimesFour;
      int m_nIndexCurrentQuadratureIndex;
      int m_nPercentageHighPeriod;
	int m_nCountSkewK2nS;
      bool m_fDirectionIsForward;

      int m_nCountMovesToLive;
      
	public:
		CParallelShaftEncoderEmulator() {
			m_i64CpuClockNextActionTime=0;
			m_dwaEncoderQuadraturePeriodInCpuClocks[0]=1500*15;
			m_dwaEncoderQuadraturePeriodInCpuClocks[1]=1500*15;
			m_dwaEncoderQuadraturePeriodInCpuClocks[2]=1500*15;
			m_dwaEncoderQuadraturePeriodInCpuClocks[3]=1500*15;
			m_bState=0x15;
			m_nPulsesPerRevolutionTimesFour=10000<<2;
			m_nIndexCurrentQuadratureIndex=5000<<2;
			m_fDirectionIsForward=true;
			m_nCountMovesToLive=-1;
			m_nPercentageHighPeriod=50;
			m_nCountSkewK2nS=0;
		}

		DWORD EmulateUntilKeypress(int nRevolutionPeriodInMilliseconds, int nPulsesPerRevolution, int nStartingQuadraturePosition, bool fDirectionIsForward);
};
