/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Jul  7 10:06:55 BST 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* 
	This is my first nontrivial piece of code for Linux, (although I have written plenty of C++ under MFC) if you have advice or
	complaints I will be happy to hear them
*/

//#ifdef WIN32
//#define wxSIZE_T_IS_UINT
//#include "winsock.h"
//#endif

#include "milk.h"

#include <stdio.h>
#ifndef WIN32
#include <unistd.h>
#include <termios.h>
#include <sys/ioctl.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/mman.h>
#else
#include <conio.h>
#endif

#include <string>

#ifdef WIN32
#define kbhit _kbhit
#else
int kbhit(void);

int errno;

/*
 *  kbhit()  --  a keyboard lookahead monitor
 *
 *  returns the number of characters available to read.
 */

int kbhit(void)
{
  int			cnt = 0;
  int			error;
  static struct termios	Otty, Ntty;

  tcgetattr(0, &Otty);
  Ntty = Otty;

  Ntty.c_iflag 		= 0;	   /* input mode	*/
  Ntty.c_oflag 		 &= ~ICANON;	   /* output mode	*/
  Ntty.c_lflag 	       &= ~ICANON; /* raw mode 		*/
  Ntty.c_cc[VMIN] 	= 0;	   /* minimum chars to wait for */
  Ntty.c_cc[VTIME] 	= 0;   /* minimum wait time	*/

  if (0 == (error = tcsetattr(0, TCSANOW, &Ntty))) {

    error     += ioctl(0, FIONREAD, &cnt);
    error     += tcsetattr(0, TCSANOW, &Otty);

  }

  return (error == 0 ? cnt : -1 );
}

/*
 *  getch()  --  a blocking single character input from stdin
 *
 *  Returns a character, or -1 if an input error occurs.
 *
 *  Conditionals allow compiling with or without echoing of
 *  the input characters, and with or without flushing pre-existing
 *  existing  buffered input before blocking.
 *
 */
int
getch(void)
{
  char			ch;
  int			error;
  static struct termios	Otty, Ntty;

  fflush(stdout);
  tcgetattr(0, &Otty);
  Ntty = Otty;

  Ntty.c_iflag  =  0;		/* input mode		*/
  Ntty.c_oflag  =  0;		/* output mode		*/
  Ntty.c_lflag &= ~ICANON;	/* line settings 	*/

#if 1
  /* disable echoing the char as it is typed */
  Ntty.c_lflag &= ~ECHO;	/* disable echo 	*/
#else
  /* enable echoing the char as it is typed */
  Ntty.c_lflag |=  ECHO;	/* enable echo	 	*/
#endif

  Ntty.c_cc[VMIN]  = CMIN;	/* minimum chars to wait for */
  Ntty.c_cc[VTIME] = CTIME;	/* minimum wait time	*/

#if 1
/*
 * use this to flush the input buffer before blocking for new input
 */
#define FLAG TCSAFLUSH
#else
/*
 * use this to return a char from the current input buffer, or block if
 * no input is waiting.
 */
#define FLAG TCSANOW

#endif

 if (0 == (error = tcsetattr(0, FLAG, &Ntty))) {
    error  = read(0, &ch, 1 );	          /* get char from stdin */
    error += tcsetattr(0, FLAG, &Otty);   /* restore old settings */
  }

  return (error == 1 ? (int) ch : -1 );
}
#endif



void IssueCommandlineHelp()
{
	printf(
		"MILK app: controls Milksop flash programmer\n"
		"\n"
		"milk [mode] [options]\n"
		"Mode switches (you can get the same effect by running the app using different app names or symlinks)\n"
  		" -m, --milksop  (or run as 'milksop') Milksop mode\n"
 		" -c, --cheaplpc  (or run as 'cheaplpc') CheapLPC mode\n"
 		" -f, --filtror   (or run as 'filtror') Filtror mode\n"
 		" -j, --jtag  (or run as 'jektor') Jtag mode\n"
 		" -2, --cheapi2c  (or run as 'cheapi2c') I2C mode\n"
 		" -y, --cygnal  (or run as 'c2blow') Cygnal C2 flasher mode\n"
   		"\n"
		"Options that do not need mode\n"
		"  -h, --help   print this help\n"
		"  -v, --version   show version\n"
		"  -a, --address hhhhh    Perform action starting from this hex address in flash (default 0)\n"
		"  -d, --defaultfile <file>   incoming binary file for use with -H -b\n"
		"  -b, --binarypatch <file>   insert binary into binary file, needs --address hhhhh\n"
		"  -H, --headerfile <file>   create const unsigned char array in .h (header) file from file given in -d\n"
		"\n"
		"Milksop Options:(-m)\n"
		"  -i, --internal   Target internal flash (default is external) used with other options\n"
		"  -z, --justcheck   Just test that the flash can be communicated with, then exit\n"
		"  -r, --readback <file>   Read back flash into the binary file given\n"
		"  -p, --program <file>   Erase/Program flash with the binary file given\n"
		"  -v, --verify   If given with program, reads back and confirms correct after program\n"
		"  -e, --erase   Just perform erase\n"
		"  -o, --ioport hhh   Use parallel port at given hex IO address (default 0x378)\n"
		"  -a, --address hhhhh    Perform action starting from this hex address in flash (default 0)\n"
		"  -q, --cyclepower   quick power cycle\n"
		"\n"
		"CheapLPC Options:(-c)\n"
		"  -r, --readback <file>   Read back flash into the binary file given\n"
		"  -p, --program <file>   Erase/Program flash with the binary file given\n"
		"  -v, --verify   If given with program, reads back and confirms correct after program\n"
		"  -e, --erase   Just perform erase\n"
		"  -o, --ioport hhh   Use parallel port at given hex IO address (default 0x378)\n"
		"  -a, --address hhhhh    Perform action starting from this hex address in flash (default 0)\n"
		"  -D  --debug   Debugging mode\n"
		"  -S  --slow n  Slow down all IO by factor n\n"
		"  -T  --test enter interactive test mode\n"
		"\n"
		"Filtror Options:(-m)\n"

		"  -r, --readback <file>   Read back flash into the binary file given\n"
  		"  -s, --showdata <hexlength>  Display memory at address given with -a\n"
		"  -p, --program <file>   Erase/Program flash with the binary file given\n"
		"  -v, --verify   If given with program, reads back and confirms correct after program\n"
		"  -t, --terminal   Filtror terminal mode\n"
		"  -o, --ioport hhh   Use parallel port at given hex IO address (default 0x378)\n"
		"  -a, --address hhhhh    Perform action starting from this hex address in flash (default 0)\n"
		"  -q, --cyclepower   quick power cycle\n"
		"\n"
		"Jtag Options:(-j)\n"
		"  -p, --program <svffile>   Execute SVF file on jtag\n"
		"  -o, --ioport hhh   Use parallel port at given hex IO address (default 0x378)\n"
		"\n"
		"Quadrature Encoder Emulator Options:(-E)\n"
		"  -P, --periodms <period>   Time in mS for shaft to rotate one revolution\n"
		"  -B, --backwards   Shaft is turning backwards (default is forwards)\n"
		"  -p, --position <decimalpos>   Starting quadrature position\n"
		"  -M, --moves <decimalmoves>   How many quadrature events to issue\n"
		"  -r, --ratio <decimalpercentage>  Mark-Space ratio high percentage, default 50, range 35-65\n"
		"  -C, --cycles <decimal>  Number of quadrature cycles issued per full rotation\n"
		"  -S, --skew <decimalnS>  Advance or retard K2 transitions in nS, default 0, signed\n"
		"\n"
	);
	printf(
		"\n"
		"Examples:\n"
		"  milk -m -i -p myfile.bin\n"
		"  milk -m -p myfile.bin -v -o 278 -a 80000\n"
		"  milk -f -r newfile.bin\n"
		"  milk -d binoriginalfile -t patchfile\n"
		"  milk -d binoriginalfile -a 1000 -b binpatchfile\n"
		"\n"
	);
}
	 int main(int argc, char * argv[])


{

	typedef enum {
   		AM_NOIO,
		AM_MILKSOP,
		AM_CHEAPLPC,
		AM_FILTROR,
		AM_JTAG,
		AM_I2C,
        AM_SHAFT
	} APP_MODE;

	APP_MODE appmode=AM_NOIO; // default mode is nothing
	
	bool 
		fReadback=false, 
		fProgram=false, 
		fErase=false, 
		fX=false, 
		fPower=false, 
		fTestFlashCommsOnly=false,
		fConfirm=false,
		fVerify=false,
		fInternal=false,
  		fShowData=false,
		fTerminal=false,
		fDebug=false,
		fTestMode=false,
		fQueryVideo=false,
		fSetVideo=false,
        fBackwards=false
	;
	DWORD dwAddressOffset=0;
	DWORD dwKnownDeviceSizeInBytes=0;
	DWORD dwRequestedLength=0;
 	DWORD dwShowDataLength=0;
	int nSlow=0, nPeriodms=1000, nInitialAngularPosition=-1, nMoves=-1,nPercentageMarkSpace=50, nCountSkewK2nS=0, nPulsesPerRev=1024;
	WORD wIO=0x378;
	string csFilepathBinary;
	string csPatchfile, csBinaryPatchFile, csHeaderFilepath;

	printf("Milksop GPL Reflasher - " VERSION " - (c)2002 andy@warmcat.com\n\n");

	if(argc==1) {
		IssueCommandlineHelp();




		return 1;
	}

	csFilepathBinary=argv[0];

	if(csFilepathBinary.size() >=7) if(strcmp(csFilepathBinary.c_str()+csFilepathBinary.size()-7, "milksop")==0) appmode=AM_MILKSOP;
	if(csFilepathBinary.size() >=8) if(strcmp(csFilepathBinary.c_str()+csFilepathBinary.size()-8, "cheaplpc")==0)  appmode=AM_CHEAPLPC;
	if(csFilepathBinary.size() >=8) if(strcmp(csFilepathBinary.c_str()+csFilepathBinary.size()-8, "cheapi2c")==0)  appmode=AM_I2C;
	if(csFilepathBinary.size() >=7) if(strcmp(csFilepathBinary.c_str()+csFilepathBinary.size()-7, "filtror")==0)  appmode=AM_FILTROR;
	if(csFilepathBinary.size() >=6) if(strcmp(csFilepathBinary.c_str()+csFilepathBinary.size()-6, "jektor")==0)  appmode=AM_JTAG;

//	printf("Called with: %s\n", csFilepathBinary.c_str());

   static struct option optionaLongOptions[] = {
    {"internal",   0, 0, 'i'},
    {"justcheck",  0, 0, 'z'},
    {"defaultfile",   1, 0, 'd'},
    {"readback",   1, 0, 'r'},
    {"program",    1, 0, 'p'},
    {"position",    1, 0, 'p'},
    {"erase",      0, 0, 'e'},
    {"debug",      0, 0, 'D'},
    {"ioport",     1, 0, 'o'},
    {"address",    1, 0, 'a'},
    {"showdata",    1, 0, 's'},
    {"length",     1, 0, 'l'},
    {"xcode",      1, 0, 'x'},
    {"moves",      1, 0, 'M'},
    {"cyclepower", 0, 0, 'q'},
    {"queryvideo", 0, 0, 'Q'},
    {"setvideo", 0, 0, 'K'},
    {"patch",      1, 0, 'y'},
    {"binarypatch",1, 0, 'b'},
    {"version",    0, 0, 'V'},
    {"verify",    0, 0, 'v'},
    {"terminal",    0, 0, 't'},
    {"test",    0, 0, 'T'},
    {"headerfile",    1, 0, 'H'},
	{ "slow", 1, 0, 'S'},
	{ "skew", 1, 0, 'S'},
    {"periodms",      1, 0, 'P'},
    {"backwards",      0, 0, 'B'},
    {"ratio",      1, 0, 'r'},
    {"cycles",      1, 0, 'C'},

    {"help",       0, 0, 'h'},
    {"jtag",       0, 0, 'j'},
   {"c2blow",       0, 0, 'y'},
    {"cheaplpc",   0, 0, 'c'},
    {"cheapi2c",   0, 0, '2'},
    {"filtror",    0, 0, 'f'},
    {"milksop",       0, 0, 'm'},
    { "encoder", 0, 0, 'E' },
    {0, 0, 0, 0}
    };

	int opt, option_index;

	while((opt = getopt_long(argc, argv, "d:mizr:p:eo:a:x:qtb:Vvhctl:fs:y:jH:D2S:TQ:K:EP:BM:C:", &optionaLongOptions[0], &option_index )) !=-1) {

		int n;

		switch(opt) {
			
			case 'o':
				{ 
					int nArg;
					sscanf(optarg, "%x", (unsigned int *)&nArg);
					wIO=(WORD)nArg;
					break;
				}
				
			case 'a': // address
				sscanf(optarg, "%x", (unsigned int *)&n);
				dwAddressOffset=(DWORD)n;
				break;

			case 'l': // length
				sscanf(optarg, "%x", (unsigned int *)&n);
				dwRequestedLength=(DWORD)n;
				break;
			
   			case 's': // showdata
				sscanf(optarg, "%x", (unsigned int *)&n);

				dwShowDataLength=(DWORD)n;
    			fShowData=true;

				break;
			
			case 'y':
				csPatchfile = optarg;
				fX=true;
				break;

			case 'b':
				csBinaryPatchFile=optarg;
				break;

			case 'H': // headerfile
				csHeaderFilepath=optarg;
				break;
			case 'i':
				fInternal=true;
				break;
			case 'D':
				fDebug=true;
				break;
			case 'S':
				nCountSkewK2nS=nSlow= atoi(optarg);
				break;
			case 'B':
				fBackwards=true;
				break;
			case 'P':
				nPeriodms= atoi(optarg);
				break;

			case 'C':
				nPulsesPerRev= atoi(optarg);
				break;

   			case 'd':
				csFilepathBinary = optarg;
				break;

			case 'r':
				fReadback=true;
				csFilepathBinary = optarg;
				fConfirm=true;
				nPercentageMarkSpace=atoi(optarg);
				break;

			case 'e':
				fErase=true;
				fConfirm=true;
				break;

			case 'm': //milksop
				appmode=AM_MILKSOP;
				break;
			
   			case 'c': //cheaplpc
				appmode=AM_CHEAPLPC;
				break;
						
			case 'f': //filtror
				appmode=AM_FILTROR;
				break;

			case 'j': // jtag
				appmode=AM_JTAG;
				break;

            case 'E': // AM_SHAFT
              appmode=AM_SHAFT;
              break;
              
			case '2': // i2c
				appmode=AM_I2C;
				break;

			case 'x':
				fX=true;
				csFilepathBinary = optarg;
                nMoves=atoi(optarg);
				break;

          case 'M':

                nMoves=atoi(optarg);

				break;

			case 'p':
				fErase=true; fProgram=true;
				csFilepathBinary = optarg;
				fConfirm=true;
                nInitialAngularPosition=atoi(optarg);
				break;

			case 'q':
				 fPower=true;
				break;

			case 't':
				 fTerminal=true;
				break;

			case 'T':
				 fTestMode=true;
				break;

			case 'z':
				fTestFlashCommsOnly = true;
				fConfirm=true;
				break;

			case 'v': // verify
   				fVerify=true;
				break;

			case 'V':
				printf("Version " VERSION "\n");
				break;

			case 'Q':
				fQueryVideo=true;
				csFilepathBinary = optarg;
				break;

      case 'K':
				fSetVideo=true;
				csFilepathBinary = optarg;
				break;

			case 'h':
				IssueCommandlineHelp();
				return(0);
		}
	}

#ifndef WIN32
	{
		static struct termios tty;

		tcgetattr(0, &tty);

//		tty.c_iflag 		= 0;	   /* input mode	*/
		tty.c_oflag 		 &= ~ICANON;	   /* output mode	*/
		tty.c_lflag 	       &= ~ICANON; /* raw mode 		*/
		tty.c_cc[VMIN] 	= 0;	   /* minimum chars to wait for */
		tty.c_cc[VTIME] 	= 0;   /* minimum wait time	*/

		tcsetattr(0, TCSANOW, &tty);
	}
#endif

	if(csBinaryPatchFile.length()!=0) {
		CFile file, filePatch;
		
		string cs1;
		cs1=StringFormat("Patching Binary file %s into %s at %x\n", csBinaryPatchFile.c_str(), csFilepathBinary.c_str(), dwAddressOffset);
		puts(cs1.c_str());
	    if(!file.Open(csFilepathBinary.c_str(), O_RDONLY)) {
			string cs;
			cs=StringFormat("Unable to open file %s: %s\n", csFilepathBinary.c_str(), strerror(errno));
			printf(cs.c_str());
//			getchar();
			return(4);
		}
		DWORD dwLength=file.GetLength();
		DWORD dwLengthAlloc = dwLength;

		if(!filePatch.Open(csBinaryPatchFile, O_RDONLY)) {
			string cs;
			cs=StringFormat("Unable to open file %s: %s\n", csFilepathBinary.c_str(), strerror(errno));
			printf(cs.c_str());
//			getchar();
			return(4);
		}
		DWORD dwLengthPatch=filePatch.GetLength();

		if((dwAddressOffset + dwLengthPatch) > dwLengthAlloc) dwLengthAlloc = dwAddressOffset + dwLengthPatch;

		BYTE *pb = new BYTE [ dwLengthAlloc ]; 
		file.Read(pb, dwLength);
		file.Close();


		filePatch.Read(pb+dwAddressOffset, dwLengthPatch);
		filePatch.Close();


		{

			string csFilepathPatched;
			CFile filePatched;

			csFilepathPatched = csFilepathBinary;
			csFilepathPatched += ".patched";

			if(!filePatched.Open(csFilepathPatched.c_str(), O_CREAT|O_RDWR)) {
				string cs;
				cs=StringFormat("Unable to open file %s: %s\n", csFilepathPatched.c_str(), strerror(errno));
				printf(cs.c_str());
//				getchar();
				return(4);
			}

			filePatched.Write(pb, dwLengthAlloc);
			filePatched.Close();


			printf("patch complete, saved in %s\n", csFilepathPatched.c_str());
			return(0);
		}
	}


	if((csHeaderFilepath.length()!=0) && (!fQueryVideo)) {  // create header file
		CFile file, filePatch;

		string cs1;
		cs1=StringFormat("Creating header file %s from %s \n", csHeaderFilepath.c_str(), csFilepathBinary.c_str());
		puts(cs1.c_str());
	    if(!file.Open(csFilepathBinary.c_str(), O_RDONLY)) {
			string cs;
			cs=StringFormat("Unable to open file %s: %s\n", csFilepathBinary.c_str(), strerror(errno));
			printf(cs.c_str());
//			getchar();


			return(4);
		}
		DWORD dwLength=file.GetLength();

		BYTE *pb = new BYTE [ dwLength ];
		file.Read(pb, dwLength);
		file.Close();

		{
			CFile fileHeader;

			if(!fileHeader.Open(csHeaderFilepath.c_str(), O_CREAT|O_RDWR)) {
				string cs;
				cs=StringFormat("Unable to open file %s: %s\n", csHeaderFilepath.c_str(), strerror(errno));
				printf(cs.c_str());
				return(4);
			}

			char sz[256];
			int nPos=0;
			DWORD dwPos=0;

			fileHeader.Write("{\n", 2);

			while(dwPos<dwLength) {
				nPos+=sprintf(&sz[nPos], "0x%02X", pb[dwPos++]);
				if(dwPos<dwLength) { sz[nPos++]=','; sz[nPos++]=' '; }
				if((dwPos& 0xf)==0) {
					sz[nPos++]='\n';
					fileHeader.Write(sz, nPos);
					nPos=0;
				}
			}
			if(nPos) {
				sz[nPos++]='\n';
				fileHeader.Write(sz, nPos);
			}
			fileHeader.Write("};\n", 3);
			fileHeader.Close();
		}

		delete [] pb;

		printf("Done\n");
		return(0);
	}


	if(fX) {
		printf("Dumping X-Code file %s\n", (const char *)csFilepathBinary.c_str());
		CFile file;
		if(!file.Open(csFilepathBinary.c_str(),O_RDONLY)) {
			string cs;
			cs=StringFormat("Unable to open file %s: %s\n", csFilepathBinary.c_str(), strerror(errno));
			printf(cs.c_str());
//			getchar();
			return(4);
		}
		DWORD dwLength=file.GetLength();


		BYTE *pb = new BYTE [ dwLength ]; 
		if((DWORD)file.Read(pb, dwLength)!=dwLength) {
			printf("unable to read from file properly\n");
			return 1;
		}
		file.Close();

		DWORD dw=0x00; // 0x92;

		bool fMore=true;

		while(fMore) {
			DWORD dw1, dw2;
			char szOpcodeAsHex[20];
			const char *pszOpcode=&szOpcodeAsHex[0];
			sprintf(szOpcodeAsHex, "%02X", pb[dw]);
			switch(pb[dw]) {
				case 0x02: pszOpcode="RDMEM   "; break;
				case 0x03: pszOpcode="WRMEM   "; break;
				case 0x06: pszOpcode="ANDORA  "; break;
				case 0x04: pszOpcode="WRPCICFG"; break;
				case 0x05: pszOpcode="RDPCICFG"; break;
				case 0x08: pszOpcode="JNE     "; break;
				case 0x07: pszOpcode="ACCCMD  "; break;
				case 0x09: pszOpcode="JMP     "; break;

				case 0x10: pszOpcode="ANDOREBP"; break;
				case 0x11: pszOpcode="OUTB    "; break;
				case 0x12: pszOpcode="INA     "; break;
				case 0xee: pszOpcode="END     "; break;
			}
			dw1=pb[dw+1]; dw1|=((DWORD)pb[dw+2])<<8; dw1|=((DWORD)pb[dw+3])<<16; dw1|=((DWORD)pb[dw+4])<<24; 
			dw2=pb[dw+5]; dw2|=((DWORD)pb[dw+6])<<8; dw2|=((DWORD)pb[dw+7])<<16; dw2|=((DWORD)pb[dw+8])<<24; 

			if( (pb[dw]==0x08) || (pb[dw]==0x09)) dw2+=dw+9;

			printf("%08X: %s %08X %08X\n", dw, pszOpcode, dw1, dw2);
			if(pb[dw]==0xee) fMore=false;
			dw+=9;
		}

		delete [] pb;
		return 0;
	}


	if(fQueryVideo) {           // -Q file1 -H file2

		CFile file, file1;
		if(!file.Open(csFilepathBinary.c_str(),O_RDONLY)) {
			string cs;
			cs=StringFormat("Unable to open file %s: %s\n", csFilepathBinary.c_str(), strerror(errno));
			printf(cs.c_str());
//			getchar();
			return(4);
		}
		DWORD dwLength=file.GetLength();
		BYTE *pb = new BYTE [ dwLength ];
		file.Read(pb, dwLength);
		file.Close();

		if(!file1.Open(csHeaderFilepath.c_str(),O_RDONLY)) {
			string cs;
			cs=StringFormat("Unable to open file %s: %s\n", csHeaderFilepath.c_str(), strerror(errno));
			printf(cs.c_str());
//			getchar();
			return(4);
		}
		DWORD dwLength1=file1.GetLength();


		BYTE *pb1 = new BYTE [ dwLength1 ];
		file1.Read(pb1, dwLength1);
		file1.Close();

        DWORD dw=0, dwRun=0;
        char sz[80];
        bool fDiff=false, fAnyDiff=false;
        
        while ((dw<=dwLength) && (dw<=dwLength1)) {
          bool fFinal=(dw==dwLength) || (dw==dwLength1);
          
          if( ((!fFinal) && (pb[dw]!=pb1[dw]) ) ||
           ((fFinal) && (!fDiff))
           ) {  // different
              fAnyDiff=true;
              if(!fDiff) { // wasn't different up until now
                printf("(%X bytes same)\n", dwRun);
                 dwRun=0;
                  { for(unsigned int n=0;n<sizeof(sz);n++) sz[n]=' '; }
                  sz[36+25]='\n';
                 sz[36+25+1]='\0';
                 sprintf(sz, "%08X:", dw&(~7));
                    sz[9]=' ';
              }
               if(!fFinal) {
                 sprintf(&sz[(dw&7)*3+10], "%02X ", pb[dw]);  sz[(dw&7)*3+10+3]=' ';
                 sprintf(&sz[(dw&7)*3+10+26], "%02X ", pb1[dw]); sz[(dw&7)*3+10+26+3]=' ';
                 if((dw&7)==7) {
                    printf("%s", sz);
                    { for(unsigned int n=0;n<sizeof(sz);n++) sz[n]=' '; }
                    sprintf(sz, "%08X:", (dw+1)&(~7));
                    sz[9]=' ';
                  sz[36+25]='\n';
                 sz[36+25+1]='\0';
                 }
              }
           
            fDiff=true;
          } else {  // same
            if(fDiff) {
              printf("%s", sz);
              dwRun=0;
            }
            fDiff=false;
          }
          dwRun++;
          dw++;
        }
        if(dwLength>dwLength1) {
          printf("0x%x extra bytes in %s\n",  dwLength-dwLength1,  csFilepathBinary.c_str());
        }
        if(dwLength>dwLength1) {
          printf("0x%x extra bytes in %s\n",  dwLength1-dwLength,  csHeaderFilepath.c_str());
        }
        if(!fAnyDiff) {
           printf("Files are identical\n");
          }
      return 0;
	}



	switch(appmode) {
	
		case AM_MILKSOP:
			{
				CParallelMilksop milksop;
				milksop.m_wAddress=wIO;
				if(fInternal) milksop.m_bModeMask|=0x10; // b4 of mode selects internal

				if(milksop.GetAccessRights()) {
					printf("MILKSOP on printer port at 0x%x\n", milksop.m_wAddress);
				} else {
					printf("Unable to get access to printer port at 0x%x\nThis app needs to run as root to access the hardware.\n", milksop.m_wAddress);
					return 1;
				}
			
				milksop.FlashInit();
			
				if(fPower) {
					milksop.Power();
					return 1;
				}
			
				if(fConfirm) {
			
					milksop.FlashInit();
			
					milksop.ResetFlashStateMachine();
					milksop.GetDeviceType();

			
					string cs;
					cs="Device: ";
					cs+=milksop.GetDeviceDestription().c_str();
					cs+="\n";
					puts(cs.c_str());
					bool fKnown=false;
			
					if((milksop.m_bManufacturer == 0x20) && (milksop.m_bDevice ==0xf1 )) {
						fKnown=true; dwKnownDeviceSizeInBytes=1024 * 1024;
						printf("  ST 29F080\n");
					}
			
					if((milksop.m_bManufacturer == 0xAD) && (milksop.m_bDevice ==0xD5 )) {
						fKnown=true; dwKnownDeviceSizeInBytes=1024 * 1024;
						printf("  Hynix 29F080\n");
					}
			
					if(!fKnown) {
						printf("Unrecognized device - aborting... are we all plugged in alright?\n");
						Sleep(100);
				//	goto again;
				//		getchar();
						return 1;
					}
			
					if(fTestFlashCommsOnly) return 0;
			
				}
				
				if(fErase) {
					printf("Erasing chip.. ");
					if(milksop.EraseChip())  {
						printf("erase done\n");
					} else {
						printf("erase timed out\n");
						return 1;
					}
				}
			
				if(fProgram) {
					CFile file;

					if(!file.Open(csFilepathBinary, O_RDONLY)) {


						string cs;
						cs=StringFormat("Unable to open file %s: %s\n", (const char *)csFilepathBinary.c_str(), strerror(errno));
						printf(cs.c_str());
			//			getchar();
						return(4);
					}
					DWORD dwLength=file.GetLength();
			
					printf("PROGRAMMING from %X -> %X with %s\n", dwAddressOffset, dwAddressOffset+dwLength-1, (const char *)csFilepathBinary.c_str());
			
					if((dwLength+dwAddressOffset) > dwKnownDeviceSizeInBytes) {

						printf("File is length %u bytes but device can only hold %u bytes\n",
							dwLength, dwKnownDeviceSizeInBytes
						);
			//			getchar();
						return 5;
					}
			
					if((dwLength+dwAddressOffset) < dwKnownDeviceSizeInBytes) {
						printf("Warning: File is only length %u bytes but device holds %u bytes\n",
							dwLength, dwKnownDeviceSizeInBytes
						);
					}
			
					DWORD dwTick=GetTickCount();
					BYTE *pb = new BYTE [ dwLength ]; 
					file.Read(pb, dwLength);
					file.Close();
			
					if(!milksop.ProgramAndVerify(pb, dwLength, dwAddressOffset, fVerify)) {

						printf("Faled to verify\n");
			
						delete [] pb;
						return 6;

					}
			
					if(fVerify) {
	  					printf(" Program/Verify took %umS\n", GetTickCount()-dwTick);
  						printf("Programming completed and verified\n");
					} else {
  						printf(" Unverified Program took %umS\n", GetTickCount()-dwTick);
						printf("Programming completed\n");

					}		
			
					delete [] pb;
					return 0;
				}
			
				if(fReadback) {
					CFile file;

					if(!file.Open(csFilepathBinary, O_CREAT|O_RDWR)) {
						string cs;
						cs=StringFormat("Unable to open file %s: %s\n", (const char *)csFilepathBinary.c_str(), strerror(errno));
						printf(cs.c_str());
						return(4);
					}
			
					printf("READING from %X -> %X to %s\n", dwAddressOffset, dwAddressOffset+dwKnownDeviceSizeInBytes-1, (const char *)csFilepathBinary.c_str());
					DWORD dwTick=GetTickCount();
					BYTE *pb = new BYTE [ dwKnownDeviceSizeInBytes-dwAddressOffset ]; 
			
					milksop.ReadBackData(pb, dwKnownDeviceSizeInBytes-dwAddressOffset, dwAddressOffset);
			
					file.Write(pb, dwKnownDeviceSizeInBytes-dwAddressOffset);
					file.Close();
			
					printf("Readback completed in %umS\n", GetTickCount()-dwTick);
			
					delete [] pb;
					return 0;

			
				}
			} // case
			break;
			
		case AM_FILTROR:
			{
				CParallelFiltror filtror;
				filtror.m_wAddress=wIO;
				dwKnownDeviceSizeInBytes=0x100000;
				
				if(filtror.GetAccessRights()) {
					printf("inFILTRatOR on printer port at 0x%x\n", filtror.m_wAddress);
				} else {
					printf("Unable to get access to printer port at 0x%x\nThis app needs to run as root to access the hardware.\n", filtror.m_wAddress);
					return 1;
				}
				
				if(!fShowData)  filtror.FlashInit();


				if(fProgram) {

					CFile file;
					if(!file.Open(csFilepathBinary, O_RDONLY)) {
						string cs;
						cs=StringFormat("Unable to open file %s: %s\n", (const char *)csFilepathBinary.c_str(), strerror(errno));
						printf(cs.c_str());
			//			getchar();
						return(4);
					}
					DWORD dwLength=file.GetLength();
			
					printf("PROGRAMMING from %X -> %X with %s\n", dwAddressOffset, dwAddressOffset+dwLength-1, (const char *)csFilepathBinary.c_str());
			
					if((dwLength+dwAddressOffset) > dwKnownDeviceSizeInBytes) {
						printf("File is length %u bytes but device can only hold %u bytes\n",
							dwLength, dwKnownDeviceSizeInBytes
						);
			//			getchar();
						return 5;
					}
			
					if((dwLength+dwAddressOffset) < dwKnownDeviceSizeInBytes) {
						printf("Warning: File is only length %u bytes but device holds %u bytes\n",
							dwLength, dwKnownDeviceSizeInBytes
						);
					}
			
					DWORD dwTick=GetTickCount();
					BYTE *pb = new BYTE [ dwLength ]; 
					DWORD dwIssued=file.Read(pb, dwLength);
					printf("  Read %u\n", dwIssued);
					file.Close();
			
//					filtror.FillWithRandom(pb, dwLength);

					if(!filtror.ProgramAndVerify(pb, dwLength, dwAddressOffset, fVerify)) {
						printf("Faled to verify\n");
			
						delete [] pb;
//						return 6;
					} else {
						if(fVerify) {
	  						printf(" Program/Verify took %umS\n", GetTickCount()-dwTick);
  							printf("Programming completed and verified\n");
						} else {
	  						printf(" Unverified Program took %umS\n", GetTickCount()-dwTick);
  							printf("Programming completed\n");
						}		
						delete [] pb;
//						return 0;

     				}
				}
			
				if(fReadback) {
					CFile file;
					if(!file.Open(csFilepathBinary, O_CREAT|O_RDWR)) {
						string cs;
						cs=StringFormat("Unable to open file %s: %s\n", (const char *)csFilepathBinary.c_str(), strerror(errno));
						printf(cs.c_str());
						return(4);
					}
			
					printf("READING from %X -> %X to %s\n", dwAddressOffset, dwAddressOffset+dwKnownDeviceSizeInBytes-1, (const char *)csFilepathBinary.c_str());
					DWORD dwTick=GetTickCount();
					BYTE *pb = new BYTE [ dwKnownDeviceSizeInBytes-dwAddressOffset ]; 
			
					filtror.ReadBackData(pb, dwKnownDeviceSizeInBytes-dwAddressOffset, dwAddressOffset);
			
					file.Write(pb, dwKnownDeviceSizeInBytes-dwAddressOffset);
					file.Close();

			
					printf("Readback completed in %umS\n", GetTickCount()-dwTick);
			
					delete [] pb;
					return 0;
			
				}

				if(fShowData) {
					BYTE *pb = new BYTE [ dwShowDataLength ];

			
					filtror.ReadBackData(pb, dwShowDataLength, dwAddressOffset);
			
					for(DWORD dw=0; dw<dwShowDataLength;dw++) {
      					if((dw&0xf)==0) printf("\n%06X: ", dw);
						printf("%02X ", pb[dw]);
       			}
					printf("\n");
					delete [] pb;
      			}

				if(fPower) {
					filtror.Power();
				}

#define NO_SLEEP_BOOST_MS 500

				if(fTerminal) { // infiltrator terminal mode
					bool fMore=true;
					DWORD dwSleep=0;
					DWORD dwDelayTimes=0;
					DWORD dwNoSleepingUntilAfterThisTick=GetTickCount()+NO_SLEEP_BOOST_MS;
					char szBuffer[2040];

					printf("Entering inFILTRatOR terminal mode, Ctrl-C exits:\n");

					while(fMore) {

						int nKey=kbhit();

						if(nKey<=0) { // look for message from target
							do {
								BYTE ba[2048];
								int nLength=filtror.GetArrayFromTarget(&ba[0], sizeof(ba));
								if(nLength>0) { // new arrival
									dwDelayTimes=0;
									ba[nLength]='\0';
									printf("%s", (const char *)ba);
									dwNoSleepingUntilAfterThisTick=GetTickCount()+NO_SLEEP_BOOST_MS;
								} else {

									if(nLength<0) { printf("inp error %d\n", nLength); }
									if(GetTickCount()>dwNoSleepingUntilAfterThisTick) {

										Sleep(dwSleep);
										if(dwSleep<200) dwSleep+=1;  // slowly increase polling delay after a send or rx event to max 200mS, so we don't use up all CPU	
									}
								}
							} while (GetTickCount()<dwNoSleepingUntilAfterThisTick);
						} else { // keypress
#ifndef WIN32
	{
		static struct termios tty;

		tcgetattr(0, &tty);

//		tty.c_iflag 		= 0;	   /* input mode	*/
		tty.c_oflag 		 &= ~ICANON;	   /* output mode	*/
		tty.c_lflag 	       |= ICANON; /* raw mode 		*/
		tty.c_cc[VMIN] 	= 0;	   /* minimum chars to wait for */
		tty.c_cc[VTIME] 	= 0;   /* minimum wait time	*/


		tcsetattr(0, TCSANOW, &tty);
	}
#endif
						fgets(szBuffer, sizeof(szBuffer)-1, stdin);
#ifndef WIN32
	{
		static struct termios tty;

		tcgetattr(0, &tty);

//		tty.c_iflag 		= 0;	   /* input mode	*/
		tty.c_oflag 		 &= ~ICANON;	   /* output mode	*/
		tty.c_lflag 	       &= ~ICANON; /* raw mode 		*/
		tty.c_cc[VMIN] 	= 0;	   /* minimum chars to wait for */
		tty.c_cc[VTIME] 	= 0;   /* minimum wait time	*/

		tcsetattr(0, TCSANOW, &tty);
	}

#endif
							int nResult=filtror.SendArrayToTarget((const BYTE *)&szBuffer[0], strlen(szBuffer));
							if(nResult<0) {
								printf("Send attempt returned %d\n", nResult);
							}
							dwDelayTimes=0;
							dwSleep=0;
							dwNoSleepingUntilAfterThisTick=GetTickCount()+NO_SLEEP_BOOST_MS;
						}
					}
				}

				return 0;
//               Sleep(500);
//              } // while 1

			}
			break;
		
		case AM_CHEAPLPC:
			{
				CParallelCheapLPC cheaplpc;
				cheaplpc.m_wAddress=wIO;
				cheaplpc.m_nDelayFactor=nSlow;
				bool fKnown=false;

				if(cheaplpc.GetAccessRights()) {
					printf("CHEAPLPC on printer port at 0x%x\n", cheaplpc.m_wAddress);

				} else {
					printf("Unable to get access to printer port at 0x%x\nThis app needs to run as root to access the hardware.\n", cheaplpc.m_wAddress);
					return 1;
				}

				cheaplpc.m_fDebugging=fDebug;

				if(fTestMode) {
					printf("Press Enter to change between read and write modes, Ctrl-C exits\n\n");
					int nTestType=0;
					BYTE bWalk=1;
					while(1) {
						if(kbhit()>0) {
							nTestType^=1;
							getch();
						}
						switch(nTestType) {
							case 0:
								{
									BYTE b;
									cheaplpc.WriteNoStrobe(0xff);
									Sleep(500);
									b=cheaplpc.GetReturnedNybble();
									printf("reading LAD3->  %X%X%X%X  <-LAD0\n", (b>>3)&1, (b>>2)&1, (b>>1)&1, b&1);
								}
								break;

							case 1:
								{
									cheaplpc.WriteNoStrobe(0xe1 | (bWalk<<1));
									printf("WRITING LAD3->  %X%X%X%X  <-LAD0\n", (bWalk>>3)&1, (bWalk>>2)&1, (bWalk>>1)&1, bWalk&1);
									bWalk<<=1;
									if(bWalk==0x10) bWalk=1;
									Sleep(1000);
								}
								break;
						}
					}

				} else {

					cheaplpc.WriteNoStrobe(0xff);
					Sleep(50);
					if(cheaplpc.GetReturnedNybble()!=0x0f) {
						printf("WARNING - failed initial 0xf read check - printer port or ntiosupp problems?\n");
					}

					if	(cheaplpc.FlashGetDeviceId(dwAddressOffset, &cheaplpc.m_bManufacturer, &cheaplpc.m_bDevice)) {
						printf("Flash at address %0lX reports device ID man=%02X dev=%02X\n", (unsigned long)dwAddressOffset, cheaplpc.m_bManufacturer, cheaplpc.m_bDevice);				
						switch(cheaplpc.m_bManufacturer) {
							case 0xbf:
								printf("SST ");
								switch(cheaplpc.m_bDevice) {
									case 0x52:
										printf("49LF020A (2Mbit)\n");
										fKnown=true;
										cheaplpc.m_dwKnownSize=0x40000;
										break;
                    
    /*
added by Jo Vanvoorden in order to support the 49LF040 bios.
Please use the -a fff8000 option to address the correct bytes.
Make sure line 9-12 are disconnected or grounded
questions : jo.vanvoorden@pandora.be
*/                                    case 0x51:
                                        printf("49LF040 (4Mbit)\n");
                                        fKnown=true;
                                        cheaplpc.m_dwKnownSize=0x80000;
                                        break;

                                        
									case 0x61:
										printf("49LF020 (2Mbit)\n");
										fKnown=true;
										cheaplpc.m_dwKnownSize=0x40000;
										break;
									default:
										printf("Unknown device\n");
										break;
								}
								break;
							case 0x20:
								printf("ST ");
								switch(cheaplpc.m_bDevice) {
									case 0xF1:
										printf("M29F080A (8Mbit)\n");
										fKnown=true;
										cheaplpc.m_dwKnownSize=0x100000;
										break;
									default:
										printf("Unknown device\n");
										break;
								}
								break;
							default:
								break;
						}
					} else {
						printf("error getting device ID at address %0lX\n", (unsigned long)dwAddressOffset);
					}



				if(dwAddressOffset==0) {
					printf("You must give the -a xxxxxxxx switch, where the argument is the LPC start address of the device\n");
				}
				
				if(!fKnown) {
					printf("Device not supported\n");
					return(-2);
				}
	
				if(fErase) {
					printf("ERASING Device...\n");
					if(!cheaplpc.EraseChip(dwAddressOffset)) {
						printf("  ERROR ON ERASE\n");
						return -4;
					} else {
						printf("Erase completed\n");
					}
				}

				if(fProgram) {

					CFile file;
					if(!file.Open(csFilepathBinary, O_RDONLY)) {
						string cs;
						cs=StringFormat("Unable to open file %s: %s\n", (const char *)csFilepathBinary.c_str(), strerror(errno));
						printf(cs.c_str());
			//			getchar();
						return(4);
					}
					DWORD dwLength=file.GetLength();
			
					printf("PROGRAMMING from %X -> %X with %s\n", dwAddressOffset, dwAddressOffset+dwLength-1, (const char *)csFilepathBinary.c_str());

			
					if((dwLength) > cheaplpc.m_dwKnownSize) {
						printf("File is length %u bytes but device can only hold %u bytes\n",
							dwLength, cheaplpc.m_dwKnownSize


						);
			//			getchar();
						return 5;
					}
			
					if((dwLength) < cheaplpc.m_dwKnownSize) {
						printf("Warning: File is only length %u bytes but device holds %u bytes\n",
							dwLength, cheaplpc.m_dwKnownSize
						);
					}
			
					DWORD dwTick=GetTickCount();
					BYTE *pb = new BYTE [ dwLength ];
					file.Read(pb, dwLength);
					file.Close();
			
//					filtror.FillWithRandom(pb, dwLength);

					if(!cheaplpc.ProgramAndVerify(pb, dwLength, dwAddressOffset, fVerify)) {
						printf("Faled to verify\n");
			
						delete [] pb;
//						return 6;
					} else {
						if(fVerify) {
	  						printf(" Program/Verify took %umS\n", GetTickCount()-dwTick);
  							printf("Programming completed and verified\n");
						} else {
	  						printf(" Unverified Program took %umS\n", GetTickCount()-dwTick);
  							printf("Programming completed\n");
						}		
						delete [] pb;
//						return 0;
     				}
				}


				if(fReadback) {
					CFile file;
					if(!file.Open(csFilepathBinary, O_CREAT|O_RDWR)) {
						string cs;
						cs=StringFormat("Unable to open file %s: %s\n", (const char *)csFilepathBinary.c_str(), strerror(errno));
						printf(cs.c_str());
						return(4);
					}
					
					if(dwRequestedLength==0) dwRequestedLength=cheaplpc.m_dwKnownSize;
					if(cheaplpc.m_dwKnownSize < dwRequestedLength) cheaplpc.m_dwKnownSize=dwRequestedLength;
			
					printf("READING from %X -> %X to %s\n", dwAddressOffset, dwAddressOffset+cheaplpc.m_dwKnownSize-1, (const char *)csFilepathBinary.c_str());
					DWORD dwTick=GetTickCount();
					BYTE *pb = new BYTE [ cheaplpc.m_dwKnownSize ];
					cheaplpc.m_bMaskLeds&=~CParallelCheapLPC::LED_READ;
					cheaplpc.ResetLPC();
					cheaplpc.ReadBackData(pb, cheaplpc.m_dwKnownSize, dwAddressOffset);
					cheaplpc.m_bMaskLeds|=CParallelCheapLPC::LED_READ;
					cheaplpc.WriteNoStrobe(0xff);

					file.Write(pb, cheaplpc.m_dwKnownSize);
					file.Close();
			
					printf("Readback completed in %umS\n", GetTickCount()-dwTick);
			
					delete [] pb;
	//				return 0;	
				}
			}
			}
			break;

 		case AM_JTAG:
			{
				CJtagSvfInterpreterParallelJtag jtag;
				jtag.m_ppj.m_wAddress=wIO;
				
				if(jtag.m_ppj.GetAccessRights()) {
					printf("JTAG on printer port at 0x%x\n", jtag.m_ppj.m_wAddress);
				} else {
					printf("Unable to get access to printer port at 0x%x\nThis app needs to run as root to access the hardware.\n", jtag.m_ppj.m_wAddress);
					return 1;
				}

				if(!jtag.m_ppj.ConfirmPowerAndPresent()) {
					printf("Unable to confirm Cheaptag/Xilinx parallel cable is present, and/or power has been applied to device - aborting\n");

					return 5;
				}

				jtag.	PutInTestLogicReset();
				
				if(fProgram) {
					printf("JTAG SVF Programming %s\n",  (const char *)csFilepathBinary.c_str());

					if(jtag.ExecuteSvf(csFilepathBinary.c_str())) {
						printf("Completed okay\n");
					} else {
						printf("FAILED\n");
					}
              }
            }
          break;

 		case AM_I2C:
#ifndef WIN32


			{
				CParallelI2c i2C;
				i2C.m_wAddress=wIO;

				if(i2C.GetAccessRights()) {
					printf("CheapI2C on printer port at 0x%x\n", i2C.m_wAddress);
				} else {
					printf("Unable to get access to printer port at 0x%x\nThis app needs to run as root to access the hardware.\n", i2C.m_wAddress);
					return 1;
				}

				i2C.WriteNoStrobe(0xff);  // default to not driving zeros anywhere

				const int nSizeofMaxBuffer=512 * 1024;
				char * szBuffer = new char [nSizeofMaxBuffer];

				printf("Entering capture mode, your PC will appear frozen - press any key to end\n");
				Sleep(100);
				
				DWORD dwLength=i2C.MonitorUntilKeypress(szBuffer, nSizeofMaxBuffer);
				printf("Monitoring completed\n");
				
				if(dwLength!=(DWORD)-1) {

					CI2CEvent * pci2cevent=(CI2CEvent *)szBuffer;
//					BYTE ba[512];
//					DWORD dwAddress=0;
					__int64 i64LastTime=pci2cevent->m_i64Timestamp;

					//memset(&ba[0], 0xff, sizeof(ba));

					while(pci2cevent < (CI2CEvent *)(szBuffer+dwLength) ) {
						int n=pci2cevent->Dump(
							i64LastTime,
							i2C.m_i64ClocksPerThousandSeconds
						);

/*
						if(pci2cevent->m_bAdsRwLsb==(0x45<<1)) {  // candidate for hack encoding
							if(n==(sizeof(CI2CEvent)+2)) { // looks reasonable
								BYTE * pb=((BYTE *)pci2cevent)+sizeof(CI2CEvent);
								if(*pb==0x44) { // header
									if(pb[1]<8) {
										dwAddress=(((DWORD)pb[1])<<6);
									}
								} else {
									if(*pb==0x42) { // content
										ba[dwAddress++]=pb[1];
										if(dwAddress>=sizeof(ba)) dwAddress=0;
									}
								}
							}
						}
*/
						i64LastTime=pci2cevent->m_i64Timestamp;
						pci2cevent=(CI2CEvent *)(((char *) pci2cevent)+n);
					}

/*
					CFile file;

					if(csFilepathBinary.size()) {
						if(!file.Open(csFilepathBinary, O_CREAT|O_RDWR)) {
							string cs;
							cs=StringFormat("Unable to open file %s: %s\n", (const char *)csFilepathBinary.c_str(), strerror(errno));
							printf(cs.c_str());
							return(4);
						} else {

							file.Write(&ba[0], sizeof(ba));
							file.Close();
							printf("   Binary Hack Dump %s written\n", (const char *)csFilepathBinary.c_str());
						}
					}
*/

					printf("Done\n");
				} else {
					printf("Failed\n");
				}
	    
	    }
#else
	printf("Sorry- cheapI2C is Linux only at the moment\n");
#endif
          break;

  		case AM_SHAFT:
#ifndef WIN32

			{
				CParallelShaftEncoderEmulator cpsee;
				cpsee.m_wAddress=wIO;

				if(cpsee.GetAccessRights()) {
					printf("Shaft Encoder Emulator on printer port at 0x%x\n", cpsee.m_wAddress);
				} else {
					printf("Unable to get access to printer port at 0x%x\nThis app needs to run as root to access the hardware.\n", cpsee.m_wAddress);
					return 1;
				}

				cpsee.m_nCountMovesToLive=nMoves;
				if(nInitialAngularPosition!=-1) {
					cpsee.m_nIndexCurrentQuadratureIndex=nInitialAngularPosition;
				} else {
					cpsee.WriteNoStrobe(0xff);  // default to not driving zeros anywhere
				}
				cpsee.m_nPercentageHighPeriod=nPercentageMarkSpace;
				cpsee.m_nCountSkewK2nS=nCountSkewK2nS;
				cpsee.EmulateUntilKeypress(nPeriodms,  nPulsesPerRev, cpsee.m_nIndexCurrentQuadratureIndex,  !fBackwards);
			}

#else
	printf("Sorry- Shaft Encoder is Linux only at the moment\n");
#endif
          break;


    default:
		   	break;
	} // switch
		
//	getchar();
	return 0;

}
