#ifndef lint
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.28 2000/01/17 02:04:06 bde Exp $";
#endif
#include <stdlib.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
static int yygrowstack();
#define YYPREFIX "yy"
#line 5 "svf.y"


#define YYSTYPE T_YYSTYPE
typedef struct {
	char symbol[256];
} T_YYSTYPE;

#include "milk.h"
#include "svf.h"

#define YYMAXDEPTH 20
#define YYREDMAX 50


/* set up table for fast scanning of ASCII */
	/* char valid in label name */	
#define L 1
	/* char is a number */

#define N 2
	/* char is whitespace */
#define W 4
	/* char is passed as literal to yacc */
#define C 8
	/* non-newm_szLine white space */
#define X 16


BYTE ascii[] = {
	0,0,0,0,0,0,0,0,0,W+X,W+C,0,0,W,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	W+X,C,C,C,C,C,C,C,C,C,C,C,C,C,C,C,
	L+N,L+N,L+N,L+N,L+N,L+N,L+N,L+N,L+N,L+N,C,C,C,C,C,C,
	C,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,C,C,C,C,L,	/* underscore */
	C,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,C,C,C,C,C,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
};

typedef struct {
	const char *name;
	WORD token;
	BYTE length;
} OPERATORS;

OPERATORS operators[] = {
 { "absent", TOK_OP_ABSENT, 6 } ,
 { "drselect", TOK_STATE_DRSELECT, 8 } ,
 { "drcapture", TOK_STATE_DRCAPTURE, 9 } ,
 { "drshift", TOK_STATE_DRSHIFT, 7 } ,
 { "drexit1", TOK_STATE_DREXIT1, 7 } ,
 { "drpause", TOK_STATE_DRPAUSE, 7 } ,
 { "drexit2", TOK_STATE_DREXIT2, 7 } ,
 { "drupdate", TOK_STATE_DRUPDATE, 8 } ,
 { "enddr", TOK_CMD_ENDDR, 5 } ,
 { "endir", TOK_CMD_ENDIR, 5 } ,
 { "endstate", TOK_OP_ENDSTATE, 8 } ,
 { "hdr", TOK_CMD_HDR, 3 } ,
 { "hir", TOK_CMD_HIR, 3 } ,
 { "irupdate", TOK_STATE_IRUPDATE, 8 } ,
 { "irselect", TOK_STATE_IRSELECT, 8 } ,
 { "ircapture", TOK_STATE_IRCAPTURE, 9 } ,
 { "idle", TOK_STATE_IDLE, 4 } ,
 { "irshift", TOK_STATE_IRSHIFT, 7 } ,
 { "irexit1", TOK_STATE_IREXIT1, 7 } ,
 { "irpause", TOK_STATE_IRPAUSE, 7 } ,
 { "irexit2", TOK_STATE_IREXIT2, 7 } ,
 { "mask", TOK_OP_MASK, 4 } ,
 { "off", TOK_OP_OFF, 3 } ,
 { "on", TOK_OP_ON, 2 } ,
 { "pio", TOK_CMD_PIO, 3 } ,
 { "piomap", TOK_CMD_PIOMAP, 6 } ,
 { "reset", TOK_STATE_RESET, 5 } ,
 { "runtest", TOK_CMD_RUNTEST, 7 } ,
 { "sck", TOK_OP_SCK, 3 } ,
 { "smask", TOK_OP_SMASK, 5 } ,
 { "sdr", TOK_CMD_SDR, 3 } ,
 { "sir", TOK_CMD_SIR, 3 } ,
 { "state", TOK_CMD_STATE, 5 } ,
 { "tck", TOK_OP_TCK, 3 } ,
 { "tdr", TOK_CMD_TDR, 3 } ,
 { "tir", TOK_CMD_TIR, 3 } ,
 { "trst", TOK_CMD_TRST, 4 } ,
 { "tdi", TOK_OP_TDI, 3 } ,

 { "tdo", TOK_OP_TDO, 3 } ,
 { "z", TOK_OP_Z, 1 } ,
 { NULL, 0, 0 }
};

#define yyerror CJtagSvfInterpreter::ErrorYY


#line 119 "svf.cpp"
#define YYERRCODE 256
#define NUMBER 257
#define LITERAL 258
#define TOK_STATE_DRSELECT 259
#define TOK_STATE_DRCAPTURE 260
#define TOK_STATE_DRSHIFT 261
#define TOK_STATE_DREXIT1 262
#define TOK_STATE_DRPAUSE 263
#define TOK_STATE_DREXIT2 264
#define TOK_STATE_DRUPDATE 265
#define TOK_CMD_ENDDR 266
#define TOK_CMD_ENDIR 267
#define TOK_CMD_HDR 268
#define TOK_CMD_HIR 269
#define TOK_STATE_IRUPDATE 270
#define TOK_STATE_IRSELECT 271
#define TOK_STATE_IRCAPTURE 272
#define TOK_STATE_IDLE 273
#define TOK_STATE_IRSHIFT 274
#define TOK_STATE_IREXIT1 275
#define TOK_STATE_IRPAUSE 276
#define TOK_STATE_IREXIT2 277
#define TOK_OP_MASK 278
#define TOK_CMD_PIO 279
#define TOK_CMD_PIOMAP 280
#define TOK_STATE_RESET 281
#define TOK_CMD_RUNTEST 282
#define TOK_OP_SMASK 283
#define TOK_CMD_SDR 284
#define TOK_CMD_SIR 285
#define TOK_CMD_STATE 286
#define TOK_CMD_TDR 287
#define TOK_CMD_TIR 288
#define TOK_CMD_TRST 289
#define TOK_OP_TDI 290
#define TOK_OP_TDO 291
#define TOK_OP_ABSENT 292
#define TOK_OP_ON 293
#define TOK_OP_OFF 294
#define TOK_OP_Z 295
#define TOK_OP_ENDSTATE 296
#define TOK_OP_TCK 297
#define TOK_OP_SCK 298
const short yylhs[] = {                                        -1,
    0,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    3,    3,    3,
    3,    4,    5,    4,    6,    6,    7,    8,    8,    9,
    9,    9,    9,   10,   10,   11,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
};
const short yylen[] = {                                         2,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    0,    3,    1,    1,    2,    2,    1,    4,
    4,    4,    4,    2,    1,    1,    2,    3,    3,    3,
    3,    3,    3,    4,    6,    5,    5,    3,    4,    3,
    4,    3,    4,    3,    4,    3,    4,    3,    4,    0,
};
const short yydefred[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    1,   18,   19,   20,   21,    0,
    0,   36,    0,    0,    0,    0,    0,    0,    0,    2,
    3,    4,    5,    0,    7,    8,    9,   10,   11,    0,
   13,   14,    0,   16,    0,   23,    0,   37,    0,    0,
    0,    0,    0,    0,   38,   39,    0,    0,    0,    0,
   48,   35,    0,   50,    0,    0,    0,    0,    0,   25,
   26,    0,   56,    0,   58,    0,    0,   22,   52,    0,
   54,    0,   40,   41,   42,   43,    0,    0,    0,    0,
   49,   34,   51,    0,   27,   28,    0,    0,   44,   57,
   59,   24,   53,   55,    0,    0,    0,    0,   47,   46,
    0,   32,   33,   30,   31,   45,
};
const short yydgoto[] = {                                      14,
   15,   46,   47,   48,   77,   72,   68,   69,   62,   63,
   23,
};
const short yysindex[] = {                                   -218,
 -261, -261, -252, -252,  -24,  -21, -250, -252, -252, -179,
 -252, -252, -240,    0,    0,    0,    0,    0,    0,  -41,
  -37,    0,  -58,  -56, -233, -232, -287,  -52,  -42,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  -29,    0,  -38,  -36,
  -26,  -23,  -20,  -19,    0,    0,    2,    4,    5,    6,
    0,    0,  -32,    0,  -22,   -3, -202, -232,   17,    0,
    0,  -59,    0,  -18,    0,  -16, -179,    0,    0,  -12,
    0,   -2,    0,    0,    0,    0, -199, -198, -195, -193,
    0,    0,    0,   13,    0,    0,   14, -261,    0,    0,
    0,    0,    0,    0,   33,   34,   35,   36,    0,    0,
   19,    0,    0,    0,    0,    0,
};
const short yyrindex[] = {                                     79,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   31,    0,    0,    0,    0,    0,   54,
    0,    0,   77,    0,  100,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   46,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
};
const short yygindex[] = {                                      0,
    0,    0,    3,   11,    0,    0,   21,    0,   40,  -15,
   20,
};
#define YYTABLESIZE 381
const short yytable[] = {                                      99,
   61,   16,   64,   20,   21,   22,   73,   27,   65,   70,
   71,   17,   74,   76,   18,   25,   75,   55,   26,   19,
   79,   56,   81,   24,   66,   67,   91,   28,   29,   78,
   49,   50,   83,   80,   82,   84,   93,   94,   85,   86,
  100,   87,  101,   88,   89,   90,  103,    1,    2,    3,
    4,   51,   52,   53,   54,   95,  104,   97,  105,  106,
    5,    6,  107,    7,  108,    8,    9,   10,   11,   12,
   13,  109,  110,  112,  113,  114,  115,  116,   60,   30,
   31,   32,   33,   34,   35,   36,   29,  102,   96,   18,
   37,   38,   39,   40,   41,   42,   43,   44,    0,    0,
  111,   45,   92,    0,   92,    0,    0,    0,    0,    0,
    0,    0,   19,   92,    0,   92,    0,    0,    0,   92,
    0,   92,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   20,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   21,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   57,
    0,   57,    0,    0,   58,   57,   58,    0,    0,    0,
   58,   59,   60,   59,   60,   57,   98,   59,   60,   57,
   58,   57,    0,    0,   58,   57,   58,   59,   60,    0,
   58,   59,   60,   59,   60,   57,    0,   59,   60,   57,
   58,   57,    0,    0,   58,   57,   58,   59,   60,    0,
   58,   59,   60,   59,   60,   57,    0,   59,   60,    0,
   58,    0,    0,    0,    0,    0,    0,   59,   60,    6,
    6,    6,    6,    6,    6,    6,    0,    0,    0,    0,
    6,    6,    6,    6,    6,    6,    6,    6,    0,    0,
    0,    6,   12,   12,   12,   12,   12,   12,   12,    0,
    0,    0,    0,   12,   12,   12,   12,   12,   12,   12,
   12,    0,    0,    0,   12,   15,   15,   15,   15,   15,
   15,   15,    0,    0,    0,    0,   15,   15,   15,   15,
   15,   15,   15,   15,    0,    0,    0,   15,   17,   17,
   17,   17,   17,   17,   17,    0,    0,    0,    0,   17,
   17,   17,   17,   17,   17,   17,   17,    0,    0,    0,
   17,
};
const short yycheck[] = {                                      59,
   59,  263,   59,    1,    2,  258,   59,  258,   24,  297,
  298,  273,   28,   29,  276,   40,   59,   59,   40,  281,
   59,   59,   59,    4,  258,  258,   59,    8,    9,   59,
   11,   12,   59,   49,   50,   59,   59,   41,   59,   59,
   59,   40,   59,   40,   40,   40,   59,  266,  267,  268,
  269,  292,  293,  294,  295,  258,   59,   41,  258,  258,
  279,  280,  258,  282,  258,  284,  285,  286,  287,  288,
  289,   59,   59,   41,   41,   41,   41,   59,    0,  259,
  260,  261,  262,  263,  264,  265,   41,   77,   68,   59,
  270,  271,  272,  273,  274,  275,  276,  277,   -1,   -1,
   98,  281,   63,   -1,   65,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   59,   74,   -1,   76,   -1,   -1,   -1,   80,
   -1,   82,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  278,
   -1,  278,   -1,   -1,  283,  278,  283,   -1,   -1,   -1,
  283,  290,  291,  290,  291,  278,  296,  290,  291,  278,
  283,  278,   -1,   -1,  283,  278,  283,  290,  291,   -1,
  283,  290,  291,  290,  291,  278,   -1,  290,  291,  278,
  283,  278,   -1,   -1,  283,  278,  283,  290,  291,   -1,
  283,  290,  291,  290,  291,  278,   -1,  290,  291,   -1,
  283,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,  259,
  260,  261,  262,  263,  264,  265,   -1,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  275,  276,  277,   -1,   -1,
   -1,  281,  259,  260,  261,  262,  263,  264,  265,   -1,
   -1,   -1,   -1,  270,  271,  272,  273,  274,  275,  276,
  277,   -1,   -1,   -1,  281,  259,  260,  261,  262,  263,
  264,  265,   -1,   -1,   -1,   -1,  270,  271,  272,  273,
  274,  275,  276,  277,   -1,   -1,   -1,  281,  259,  260,
  261,  262,  263,  264,  265,   -1,   -1,   -1,   -1,  270,
  271,  272,  273,  274,  275,  276,  277,   -1,   -1,   -1,
  281,
};
#define YYFINAL 14
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 298
#if YYDEBUG
const char * const yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"';'",0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NUMBER","LITERAL",
"TOK_STATE_DRSELECT","TOK_STATE_DRCAPTURE","TOK_STATE_DRSHIFT",
"TOK_STATE_DREXIT1","TOK_STATE_DRPAUSE","TOK_STATE_DREXIT2",
"TOK_STATE_DRUPDATE","TOK_CMD_ENDDR","TOK_CMD_ENDIR","TOK_CMD_HDR",
"TOK_CMD_HIR","TOK_STATE_IRUPDATE","TOK_STATE_IRSELECT","TOK_STATE_IRCAPTURE",
"TOK_STATE_IDLE","TOK_STATE_IRSHIFT","TOK_STATE_IREXIT1","TOK_STATE_IRPAUSE",
"TOK_STATE_IREXIT2","TOK_OP_MASK","TOK_CMD_PIO","TOK_CMD_PIOMAP",
"TOK_STATE_RESET","TOK_CMD_RUNTEST","TOK_OP_SMASK","TOK_CMD_SDR","TOK_CMD_SIR",
"TOK_CMD_STATE","TOK_CMD_TDR","TOK_CMD_TIR","TOK_CMD_TRST","TOK_OP_TDI",
"TOK_OP_TDO","TOK_OP_ABSENT","TOK_OP_ON","TOK_OP_OFF","TOK_OP_Z",
"TOK_OP_ENDSTATE","TOK_OP_TCK","TOK_OP_SCK",
};
const char * const yyrule[] = {
"$accept : ruleSvfCommand",
"ruleSvfCommand : ruleSvfStatement",
"ruleSvfAnyState : TOK_STATE_DRSELECT",
"ruleSvfAnyState : TOK_STATE_DRCAPTURE",
"ruleSvfAnyState : TOK_STATE_DRSHIFT",
"ruleSvfAnyState : TOK_STATE_DREXIT1",
"ruleSvfAnyState : TOK_STATE_DRPAUSE",
"ruleSvfAnyState : TOK_STATE_DREXIT2",
"ruleSvfAnyState : TOK_STATE_DRUPDATE",
"ruleSvfAnyState : TOK_STATE_IRUPDATE",
"ruleSvfAnyState : TOK_STATE_IRSELECT",
"ruleSvfAnyState : TOK_STATE_IRCAPTURE",
"ruleSvfAnyState : TOK_STATE_IDLE",
"ruleSvfAnyState : TOK_STATE_IRSHIFT",
"ruleSvfAnyState : TOK_STATE_IREXIT1",
"ruleSvfAnyState : TOK_STATE_IRPAUSE",
"ruleSvfAnyState : TOK_STATE_IREXIT2",
"ruleSvfAnyState : TOK_STATE_RESET",
"ruleSvfStableState : TOK_STATE_DRPAUSE",
"ruleSvfStableState : TOK_STATE_IDLE",
"ruleSvfStableState : TOK_STATE_IRPAUSE",
"ruleSvfStableState : TOK_STATE_RESET",
"ruleSvfAnyStateListEndingStable : ruleSvfStableState ';'",
"$$1 :",
"ruleSvfAnyStateListEndingStable : ruleSvfAnyState $$1 ruleSvfAnyStateListEndingStable",
"ruleClockSource : TOK_OP_TCK",
"ruleClockSource : TOK_OP_SCK",
"rulePioName : LITERAL LITERAL",
"rulePioNameList : rulePioName rulePioName",
"rulePioNameList : rulePioName",
"ruleScanQualifier : TOK_OP_TDI '(' LITERAL ')'",
"ruleScanQualifier : TOK_OP_TDO '(' LITERAL ')'",
"ruleScanQualifier : TOK_OP_MASK '(' LITERAL ')'",
"ruleScanQualifier : TOK_OP_SMASK '(' LITERAL ')'",
"ruleScanQualifierList : ruleScanQualifierList ruleScanQualifier",
"ruleScanQualifierList : ruleScanQualifier",
"ruleGetBitCount : LITERAL",
"ruleSvfStatement : TOK_CMD_STATE ruleSvfAnyStateListEndingStable",
"ruleSvfStatement : TOK_CMD_ENDDR ruleSvfStableState ';'",
"ruleSvfStatement : TOK_CMD_ENDIR ruleSvfStableState ';'",
"ruleSvfStatement : TOK_CMD_TRST TOK_OP_ABSENT ';'",
"ruleSvfStatement : TOK_CMD_TRST TOK_OP_ON ';'",
"ruleSvfStatement : TOK_CMD_TRST TOK_OP_OFF ';'",
"ruleSvfStatement : TOK_CMD_TRST TOK_OP_Z ';'",
"ruleSvfStatement : TOK_CMD_RUNTEST LITERAL ruleClockSource ';'",
"ruleSvfStatement : TOK_CMD_RUNTEST LITERAL ruleClockSource TOK_OP_ENDSTATE ruleSvfStableState ';'",
"ruleSvfStatement : TOK_CMD_PIOMAP '(' rulePioNameList ')' ';'",
"ruleSvfStatement : TOK_CMD_PIO '(' LITERAL ')' ';'",
"ruleSvfStatement : TOK_CMD_HDR ruleGetBitCount ';'",
"ruleSvfStatement : TOK_CMD_HDR ruleGetBitCount ruleScanQualifierList ';'",
"ruleSvfStatement : TOK_CMD_HIR ruleGetBitCount ';'",
"ruleSvfStatement : TOK_CMD_HIR ruleGetBitCount ruleScanQualifierList ';'",
"ruleSvfStatement : TOK_CMD_TDR ruleGetBitCount ';'",
"ruleSvfStatement : TOK_CMD_TDR ruleGetBitCount ruleScanQualifierList ';'",
"ruleSvfStatement : TOK_CMD_TIR ruleGetBitCount ';'",
"ruleSvfStatement : TOK_CMD_TIR ruleGetBitCount ruleScanQualifierList ';'",
"ruleSvfStatement : TOK_CMD_SDR ruleGetBitCount ';'",
"ruleSvfStatement : TOK_CMD_SDR ruleGetBitCount ruleScanQualifierList ';'",
"ruleSvfStatement : TOK_CMD_SIR ruleGetBitCount ';'",
"ruleSvfStatement : TOK_CMD_SIR ruleGetBitCount ruleScanQualifierList ';'",
"ruleSvfStatement :",
};
#endif
#ifndef YYSTYPE
typedef int YYSTYPE;
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
#line 419 "svf.y"


/**+ stuff */


bool CJtagRegisterManagement::CaptureMatchesAllowingForMask()
{
	for(int n=0;n<m_nBits;n++) {
		if(GetTdoMaskBit(n)) {
			if(GetCapturedBit(n)!=GetTdoBit(n)) return false;
		}
	}
	return true;
}

// returns necessary sequence for TMS cycles to get to new state from this one
  // if(b7..b0) is nonzero, store in CB tap controller TMS register
  // shift right 8 bits and repeat


  int  CJtagSvfInterpreter::GetTMSSequenceForState(int nState)
  {
  	switch(m_nState) { // existing stable state
  		case TOK_STATE_RESET:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0xbf); // 11111
  					break;
  				case TOK_STATE_IDLE:
  					return(0x20);	// 0
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0xaa);	// 01010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x6266);	// 011 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0x82);	// 0100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0xa6);	// 01100
  					break;
  			}
  			break;
  		case TOK_STATE_IDLE:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0x67); // 111
  					break;
  				case TOK_STATE_IDLE:
  					return(0);
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x85);	// 1010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0xab);	// 11010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0x61);	// 100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x83);	// 1100
  					break;
  			}
  			break;
  		case TOK_STATE_DRPAUSE:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0x6367);  // 111 110
  					break;
  				case TOK_STATE_IDLE:
  					return(0x63);	// 110
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x6267);	// 111 010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x628f);	// 1111 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0xa7);	//11100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x408f);	// 1111 00
  					break;
  			}
  			break;
  		case TOK_STATE_IRPAUSE:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0xbf); // 11111
  					break;
  				case TOK_STATE_IDLE:
  					return(0x63);	// 110
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x6267);	// 111 010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x628f);	// 1111 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0xa7);	// 11100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x408f);	// 1111 00
  					break;
  			}
  			break;
  		case TOK_STATE_IRSHIFT:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0xbf);  // 11111
  					break;
  				case TOK_STATE_IDLE:
  					return(0x63);	// 110
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x6267);	// 111010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x628f);	// 1111 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0xa7);	//11100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x408f);	// 1111 00
  					break;
  			}
  			break;
  		case TOK_STATE_DRSHIFT:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0xbf);  // 11111
  					break;
  				case TOK_STATE_IDLE:
  					return(0x63);	// 110
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x41);	// 10
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x628f);	// 1111 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0xa7);	//11100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x408f);	// 1111 00
  					break;
  			}
  			break;


  	}
  	return(0);
  }
bool CJtagSvfInterpreter::ExecuteSvf(const char * szName)
{


	WORD r;
	bool fMore=true;
	bool fRetcode=true;
	int nLines=0;
	DWORD dwTime=GetTickCount();

	m_nLinesSeen=1;
	m_fSeenError=false;
	strcpy(m_szErrorText, "No Error");

	m_csFilepath=szName;

	m_file=fopen(szName, "rt");
	if(m_file==NULL) {
		ReportMessage(szName, "Unable to open file", 0);
		return(false);
	}

	printf("   Processing SVF file: %s\n", szName);

	while(fMore) {
		if(fgets(m_szBuffer, sizeof(m_szBuffer), m_file)==NULL) {
			fMore=false; continue;
		}
		m_cNextChar=*m_szBuffer;
		m_szLine=(char *)m_szBuffer+1;
//		puts(m_szBuffer);
		r=ParseYY();

		if((r!=99)||(m_fSeenError)) {

//		printf("ParseYY returns %d\n", r);
			fRetcode=false;
			fMore=false;
		}
		nLines++;
		m_nLinesSeen++;
		if(nLines==5) {
			DWORD dwTimeNow=GetTickCount();
			nLines=0;
			if(dwTimeNow-dwTime > 500) {
				printf("  lines done: %d    \r", m_nLinesSeen);
				dwTime=dwTimeNow;
			}
		}
	}

	if(fRetcode==false) {
		ReportMessage(m_szErrorText, "SVF error", 0);
	}

	if(fRetcode==true) printf("   Completed OK         \n"); else printf("   Completed With ERRORS      \n");

	return(fRetcode);
}



int CJtagSvfInterpreter::ErrorYY(const char *s)
{
	puts(s);
	if(!m_fSeenError) {
		char sz[2048];
		sprintf(sz, "%s(%d): %s", m_csFilepath.c_str(), m_nLinesSeen, s);
		strncpy(m_szErrorText, sz, sizeof(m_szErrorText)-1);
		m_fSeenError=1;
	}
	return(false);
}



		const char *  CJtagSvfInterpreter::TranslateStateToText(int nState)
		{
			switch(nState) {
				case TOK_STATE_DRSELECT:  return("DRSELECT");
				case TOK_STATE_DRCAPTURE:  return("DRCAPTURE");
				case TOK_STATE_DRSHIFT:  return("DRSHIFT");
				case TOK_STATE_DREXIT1:  return("DREXIT1");
				case TOK_STATE_DRPAUSE:  return("DRPAUSE");
				case TOK_STATE_DREXIT2:  return("DREXIT2");
				case TOK_STATE_DRUPDATE:  return("DRUPDATE");
				case TOK_STATE_IRUPDATE:  return("IRUPDATE");
				case TOK_STATE_IRSELECT:  return("IRSELECT");
				case TOK_STATE_IRCAPTURE:  return("IRCAPTURE");
				case TOK_STATE_IDLE:  return("IDLE");
				case TOK_STATE_IRSHIFT:  return("IRSHIFT");
				case TOK_STATE_IREXIT1:  return("IREXIT1");
				case TOK_STATE_IRPAUSE:  return("IRPAUSE");
				case TOK_STATE_IREXIT2:  return("IREXIT2");
				case TOK_STATE_RESET:	return("RESET");
			}
			printf("%d\n", nState);
			return("!! Illegal State Index !!");
		}


 #define yylex CJtagSvfInterpreter::LexYY

/**+ yylex */

int yylex()
{
	WORD a,b;

		// error/terminator
restart:

	if(m_cNextChar=='\0') {
		if(fgets(m_szBuffer, sizeof(m_szBuffer), m_file)==NULL) {
			return -1;
		}
		m_nLinesSeen++;
		m_cNextChar=*m_szBuffer;
		m_szLine=(char *)m_szBuffer+1;

	}

	if(m_fSeenError) return -1;

		// whitespace

	while(ascii[(unsigned int)m_cNextChar]&X) {m_cNextChar=*m_szLine++; }

	if((m_cNextChar=='!') || (m_cNextChar=='/' && *m_szLine=='/')) { // comment until end of m_szLine
		printf(m_szBuffer);
		while( m_cNextChar ) m_cNextChar=*m_szLine++;
		goto restart;
	}

		// literal

	if(ascii[(unsigned int)m_cNextChar]&C) {
		a=m_cNextChar; m_cNextChar=*m_szLine++;
#ifdef DEBUG_LEX
		printf("Char: '%c'\n", a);
#endif
		return(a);
	}
/*
	if(ascii[m_cNextChar]&N) { // number
		a=0;
		while(ascii[m_cNextChar]&L) {
			yylval.symbol[a++]=m_cNextChar;
			m_cNextChar=*m_szLine++;
		}
		yylval.symbol[a]='\0';
#ifdef DEBUG_LEX
		printf("Number '%s'\n", yylval.symbol);
#endif
		return(NUMBER);
	}
*/
	m_nLengthLastLiteral=0;
	while(ascii[(unsigned int)m_cNextChar]&L) {
		yylval.symbol[m_nLengthLastLiteral++]=m_cNextChar;
		m_cNextChar=*m_szLine++;
	}
	yylval.symbol[m_nLengthLastLiteral]='\0';

	if(!m_nLengthLastLiteral) {
		yyerror((const char *)"Funny Character");
		return('\n');
	}

#ifdef DEBUG_LEX
				printf("Checking symbol '%s'\n", yylval.symbol);
#endif
	b=0; while(operators[b].length) {
		if(operators[b].length==m_nLengthLastLiteral) {
			if(strcasecmp(operators[b].name,yylval.symbol)==0) {
#ifdef DEBUG_LEX
				printf("Token '%s'\n", yylval.symbol);

#endif
				m_nLastToken=operators[b].token;
				yylval.symbol[0]=m_nLastToken;
				yylval.symbol[1]=m_nLastToken >> 8;

				switch(m_nLastToken) {
					case TOK_CMD_HDR:
						m_pSelectedRegister=&m_cjrmDataHeader;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_HIR:
						m_pSelectedRegister=&m_cjrmInstructionHeader;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_TDR:
						m_pSelectedRegister=&m_cjrmDataTrailer;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_TIR:
						m_pSelectedRegister=&m_cjrmInstructionTrailer;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_SDR:
						m_pSelectedRegister=&m_cjrmDataPayload;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_SIR:
						m_pSelectedRegister=&m_cjrmInstructionPayload;
						m_fTdoPresent=false;
						break;
				}

				return(m_nLastToken);
			}
		}
		b++;
	}

#ifdef DEBUG_LEX
	printf("Literal '%s'\n", yylval.symbol);
#endif
	return(LITERAL);

}



#define yyparse CJtagSvfInterpreter::ParseYY


#line 820 "svf.cpp"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack()
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 173 "svf.y"
{	/* int t;
*/
/*					*ret=$1;
*/
					return(99);
				}
break;
case 22:
#line 206 "svf.y"
{
/*		printf("State: %s", $1.symbol);
*/
 		MoveToState(*((WORD *)(yyvsp[-1].symbol)));
   }
break;
case 23:
#line 210 "svf.y"
{
/*		printf("State: %s", $1.symbol);
*/
 		MoveToState(*((WORD *)(yyvsp[0].symbol)));
   }
break;
case 25:
#line 217 "svf.y"
{ m_fClockWasTCK=true; }
break;
case 26:
#line 218 "svf.y"
{ m_fClockWasTCK=false; }
break;
case 30:
#line 231 "svf.y"
{
 		m_pSelectedRegister->LoadTdiFromAsciiHex(yyvsp[-1].symbol, m_nLengthLastLiteral);
   }
break;
case 31:
#line 234 "svf.y"
{
 		m_fTdoPresent=true; m_pSelectedRegister->LoadTdoFromAsciiHex(yyvsp[-1].symbol, m_nLengthLastLiteral);
   }
break;
case 32:
#line 237 "svf.y"
{
 		m_pSelectedRegister->LoadTdoMaskFromAsciiHex(yyvsp[-1].symbol, m_nLengthLastLiteral);
   }
break;
case 33:
#line 240 "svf.y"
{
 		m_pSelectedRegister->LoadTdiMaskFromAsciiHex(yyvsp[-1].symbol, m_nLengthLastLiteral);
  }
break;
case 36:
#line 251 "svf.y"
{
 		 int n=atoi(yyvsp[0].symbol);
    	if((n<0)||(n>MAX_BITS)) yyerror("Bad Bit Count");
    	else {
			int nBit;
			m_pSelectedRegister->SetBitCount(n);

			if(m_pSelectedRegister == &m_cjrmInstructionPayload) {
				m_pSelectedRegister->m_nHeaderBits=m_cjrmInstructionHeader.GetSize();
				m_pSelectedRegister->m_nTrailerBits=m_cjrmInstructionTrailer.GetSize();
				m_pSelectedRegister->SetBitCount(n+m_pSelectedRegister->m_nHeaderBits+ m_pSelectedRegister->m_nTrailerBits);
/*				printf("instruction selected, hdr=%d, trail=%d, eff=%d\n",
*/
/*					m_pSelectedRegister->m_nHeaderBits,
*/
/*					m_pSelectedRegister->m_nTrailerBits,
*/
/*					m_pSelectedRegister->m_nBits
*/
/*				);
*/
				for( nBit=0;nBit<m_pSelectedRegister->m_nHeaderBits;nBit++) {
					m_pSelectedRegister->SetTdiBit(nBit, m_cjrmInstructionHeader.GetTdiBit(nBit));
					m_pSelectedRegister->SetTdoBit(nBit, m_cjrmInstructionHeader.GetTdoBit(nBit));
					m_pSelectedRegister->SetTdoMaskBit(nBit, m_cjrmInstructionHeader.GetTdoMaskBit(nBit));
				}
				for(nBit=0;nBit<m_pSelectedRegister->m_nTrailerBits;nBit++) {
					m_pSelectedRegister->SetTdiBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmInstructionTrailer.GetTdiBit(nBit));
					m_pSelectedRegister->SetTdoBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmInstructionTrailer.GetTdoBit(nBit));
					m_pSelectedRegister->SetTdoMaskBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmInstructionTrailer.GetTdoMaskBit(nBit));
				}
			}
			if(m_pSelectedRegister == &m_cjrmDataPayload) {

				m_pSelectedRegister->m_nHeaderBits=m_cjrmDataHeader.GetSize();
				m_pSelectedRegister->m_nTrailerBits=m_cjrmDataTrailer.GetSize();
				m_pSelectedRegister->SetBitCount(n+m_pSelectedRegister->m_nHeaderBits+ m_pSelectedRegister->m_nTrailerBits);
/*				printf("data selected, hdr=%d, trail=%d, eff=%d\n",
*/
/*					m_pSelectedRegister->m_nHeaderBits,
*/
/*					m_pSelectedRegister->m_nTrailerBits,
*/
/*					m_pSelectedRegister->m_nBits
*/
/*				);
*/
				for(nBit=0;nBit<m_pSelectedRegister->m_nHeaderBits;nBit++) {
					m_pSelectedRegister->SetTdiBit(nBit, m_cjrmDataHeader.GetTdiBit(nBit));
					m_pSelectedRegister->SetTdoBit(nBit, m_cjrmDataHeader.GetTdoBit(nBit));
					m_pSelectedRegister->SetTdoMaskBit(nBit, m_cjrmDataHeader.GetTdoMaskBit(nBit));
				}
				for(nBit=0;nBit<m_pSelectedRegister->m_nTrailerBits;nBit++) {
					m_pSelectedRegister->SetTdiBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmDataTrailer.GetTdiBit(nBit));
					m_pSelectedRegister->SetTdoBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmDataTrailer.GetTdoBit(nBit));
					m_pSelectedRegister->SetTdoMaskBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmDataTrailer.GetTdoMaskBit(nBit));
				}
			}


 		     m_pSelectedRegister->m_fAllTdiDontCare=m_pSelectedRegister->m_fAllTdoDontCare=true;
			}
     }
break;
case 38:
#line 310 "svf.y"
{ m_nStateEndDr=m_nLastToken; }
break;
case 39:
#line 312 "svf.y"
{ m_nStateEndIr=m_nLastToken; }
break;
case 40:
#line 314 "svf.y"
{ m_fTrstAbsent=true; }
break;
case 41:
#line 315 "svf.y"
{
 		if(m_fTrstAbsent) yyerror("TRST cannot be changed after TRST ABSENT"); else SetTRSTState(0);
   }
break;
case 42:
#line 318 "svf.y"
{
 		if(m_fTrstAbsent) yyerror("TRST cannot be changed after TRST ABSENT"); else SetTRSTState(1);
   }
break;
case 43:
#line 321 "svf.y"
{
 		if(m_fTrstAbsent) yyerror("TRST cannot be changed after TRST ABSENT"); else SetTRSTState(1);
   }
break;
case 44:
#line 326 "svf.y"
{

		if(m_fClockWasTCK) {
			string cs;
			cs=yyvsp[-2].symbol;
			long l=atol(cs.c_str());
			 m_cjrmJustForTCK.SetBitCount(l); 
			 m_cjrmJustForTCK.m_fAllTdiDontCare=true;
			 LoadBoundaryRegister(&m_cjrmJustForTCK, 0, LBR_TYPE_TCKONLY);
		} else {
			PerformSleep(atol(yyvsp[-2].symbol)/1000+1); 
		}

 }
break;
case 45:
#line 340 "svf.y"
{
   if(m_fClockWasTCK) {
			m_cjrmJustForTCK.SetBitCount(atol(yyvsp[-4].symbol)); 
			LoadBoundaryRegister(&m_cjrmJustForTCK, 0, LBR_TYPE_TCKONLY);
/*			MoveToState(m_nLastToken);
*/
			printf("State: %s\n", yyvsp[-1].symbol);
			MoveToState(atol(yyvsp[-1].symbol));
		} else {
			PerformSleep(atol(yyvsp[-4].symbol)/1000+1); 
		}
 }
break;
case 57:
#line 369 "svf.y"
{

  int nMask=0;
		if(m_fTdoPresent) nMask|=LBR_ATTRIBUTE_TDO;
		MoveToState(TOK_STATE_DRSHIFT);
		if(LoadBoundaryRegister(
			&m_cjrmDataPayload, 
			m_nStateEndDr,
			LBR_TYPE_PAYLOAD|nMask
		)<0) {
			string cs, csCap, csTdo, csMask;
			m_cjrmDataPayload.FillCStringWithAsciiHexCaptured(csCap);
			m_cjrmDataPayload.FillCStringWithAsciiHexTDO(csTdo);
			m_cjrmDataPayload.FillCStringWithAsciiHexTDOMASK(csMask);
			cs=StringFormat("TDO did not match required value: TDO=%s, Req=%s, Mask=%s",
				csCap.c_str(), csTdo.c_str(), csMask.c_str()
			);
			yyerror(cs.c_str());
		}

  }
break;
case 59:
#line 392 "svf.y"
{
	
  int nMask=0;
		if(m_fTdoPresent) nMask|=LBR_ATTRIBUTE_TDO;
		MoveToState(TOK_STATE_IRSHIFT);

		if(LoadBoundaryRegister(
			&m_cjrmInstructionPayload,
			m_nStateEndIr,
			LBR_TYPE_PAYLOAD|nMask
		)<0) {
			string cs, csCap, csTdo, csMask;
			m_cjrmInstructionPayload.FillCStringWithAsciiHexCaptured(csCap);
			m_cjrmInstructionPayload.FillCStringWithAsciiHexTDO(csTdo);
			m_cjrmInstructionPayload.FillCStringWithAsciiHexTDOMASK(csMask);
			cs=StringFormat("TDO did not match required value: (eff len=%d) TDO=%s, Req=%s, Mask=%s",
				m_cjrmInstructionPayload.m_nBits, csCap.c_str(), csTdo.c_str(), csMask.c_str()
			);
			yyerror(cs.c_str());
		}

  }
break;
#line 1234 "svf.cpp"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
