/***************************************************************************
                          svf.h  -  description
                             -------------------
    begin                : Tue Jul 9 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __SVH_H__
#define __SVH_H__

#define NUMBER 257
#define LITERAL 258
#define TOK_STATE_DRSELECT 259
#define TOK_STATE_DRCAPTURE 260
#define TOK_STATE_DRSHIFT 261
#define TOK_STATE_DREXIT1 262
#define TOK_STATE_DRPAUSE 263
#define TOK_STATE_DREXIT2 264
#define TOK_STATE_DRUPDATE 265
#define TOK_CMD_ENDDR 266
#define TOK_CMD_ENDIR 267
#define TOK_CMD_HDR 268
#define TOK_CMD_HIR 269
#define TOK_STATE_IRUPDATE 270
#define TOK_STATE_IRSELECT 271
#define TOK_STATE_IRCAPTURE 272
#define TOK_STATE_IDLE 273
#define TOK_STATE_IRSHIFT 274
#define TOK_STATE_IREXIT1 275
#define TOK_STATE_IRPAUSE 276
#define TOK_STATE_IREXIT2 277
#define TOK_OP_MASK 278
#define TOK_CMD_PIO 279
#define TOK_CMD_PIOMAP 280
#define TOK_STATE_RESET 281
#define TOK_CMD_RUNTEST 282
#define TOK_OP_SMASK 283
#define TOK_CMD_SDR 284
#define TOK_CMD_SIR 285
#define TOK_CMD_STATE 286
#define TOK_CMD_TDR 287
#define TOK_CMD_TIR 288
#define TOK_CMD_TRST 289
#define TOK_OP_TDI 290
#define TOK_OP_TDO 291
#define TOK_OP_ABSENT 292
#define TOK_OP_ON 293
#define TOK_OP_OFF 294
#define TOK_OP_Z 295
#define TOK_OP_ENDSTATE 296
#define TOK_OP_TCK 297
#define TOK_OP_SCK 298

#define MAX_BITS 512

class CBitVector	// variable-length bit vector class
{
	public:
		CByteArray m_cbaBits;
		CByteArray m_cbaMask;
		int m_nLength;

	public:
		bool   Set( const char * sz);  // FALSE return means error in string (0, 1, X or x allowed)
		bool   IsEqual( CBitVector * pvector);
		int GetLength() const { return(m_nLength); }
		void   ToCString( string & rcs); // fill rcs with ascii representation
		int GetBit(int n) { ASSERT(n>=0); ASSERT(n<m_nLength);   // returns 0, 1, or 2 for DC
			if( m_cbaMask.Item(n>>3)& (1<<(n&7)) ) {
				return( (m_cbaBits.Item(n>>3)& (1<<(n&7)))>>(n&7)  );
			} else {
				return(2);
			}
		}
		void SetBit(int n, int nValue) {
			if(nValue&0xfffffffe) {
				m_cbaMask.Item(n>>3) = m_cbaMask.Item(n>>3)| (1<<(n&7)) ;
			} else {
				m_cbaMask.Item(n>>3) = m_cbaMask.Item(n>>3)& (~(1<<(n&7))) ;
				if(nValue & 1) {
					m_cbaBits.Item(n>>3) = m_cbaBits.Item(n>>3)| (1<<(n&7)) ;
				} else {
					m_cbaBits.Item(n>>3) = m_cbaBits.Item(n>>3)& (~(1<<(n&7))) ;
				}
			}
		}
		bool   CopyShifted( const CBitVector * pbvSmaller, int nPositionStart );
		const BYTE * GetStartOfBitsArray() { return((const BYTE *)(&(m_cbaBits.Item(0)))); }
		const BYTE * GetStartOfMaskingArray() { return((const BYTE *)(&(m_cbaMask.Item(0)))); }
		void SetSize(int nBits) { m_cbaBits.Alloc((nBits>>3)+1);  m_cbaMask.Alloc((nBits>>3)+1); m_nLength=nBits; }
};

class CJtagRegisterManagement
{
	public:
		long m_nBits;
		bool m_fAllTdiDontCare;
		bool m_fAllTdoDontCare;
		BYTE m_baTdi[MAX_BITS/8+1];
		BYTE m_baTdo[MAX_BITS/8+1];
		BYTE m_baTdiMask[MAX_BITS/8+1];
		BYTE m_baTdoMask[MAX_BITS/8+1];
		BYTE m_baTdoCaptured[MAX_BITS/8+1];
		int m_nHeaderBits, m_nTrailerBits;

	private:
		bool   LoadFromAsciiHex(BYTE *, const char *, int nLength);
		void   FillCStringWithAsciiHex(string &rcs, BYTE * pba);

	public:
		CJtagRegisterManagement() { m_nBits=0; m_fAllTdiDontCare=m_fAllTdoDontCare=true; m_nHeaderBits=0; m_nTrailerBits=0; }
		bool ContainsAnything() { return( m_nBits!=0 ); }
		void SetBitCount(long nCountBits) { m_nBits=nCountBits; m_fAllTdiDontCare=false;  }
		void SetAllBitsHigh() { m_fAllTdiDontCare=false; if(m_nBits<MAX_BITS) { for(int t=0;t<(m_nBits>>3)+1;t++) m_baTdiMask[t]=m_baTdi[t]=0xff; } }
		void SetAllBitsLow() { m_fAllTdiDontCare=false; if(m_nBits<MAX_BITS) { for(int t=0;t<(m_nBits>>3)+1;t++) {m_baTdiMask[t]=0xff; m_baTdi[t]=0x00;} } }
		bool LoadTdiFromAsciiHex(const char * szAsciiHex, int nLength) { return(LoadFromAsciiHex(m_baTdi, szAsciiHex, nLength)); }
		bool LoadTdiMaskFromAsciiHex(const char * szAsciiHex, int nLength) { return(LoadFromAsciiHex(m_baTdiMask, szAsciiHex, nLength)); }
		bool LoadTdoFromAsciiHex(const char * szAsciiHex, int nLength) { return(LoadFromAsciiHex(m_baTdo, szAsciiHex, nLength)); }
		bool LoadTdoMaskFromAsciiHex(const char * szAsciiHex, int nLength) { return(LoadFromAsciiHex(m_baTdoMask, szAsciiHex, nLength)); }
		bool   CopyShifted(const CBitVector * pbvSmaller, int nPositionStart, const CBitVector * pbvReadback=NULL);
		bool   CopyBitVectorData(CBitVector *pbv);
		bool   CopyBitVectorReadback(CBitVector *pbv);
		long GetSize() { return(m_nBits); }
		void FillCStringWithAsciiHexTDI(string & rcs) { FillCStringWithAsciiHex(rcs, m_baTdi); }
		void FillCStringWithAsciiHexTDO(string & rcs) { FillCStringWithAsciiHex(rcs, m_baTdo); }
		void FillCStringWithAsciiHexCaptured(string & rcs) { FillCStringWithAsciiHex(rcs, m_baTdoCaptured); }
		void FillCStringWithAsciiHexTDIMASK(string & rcs) { FillCStringWithAsciiHex(rcs, m_baTdiMask); }
		void FillCStringWithAsciiHexTDOMASK(string & rcs) { FillCStringWithAsciiHex(rcs, m_baTdoMask); }
		DWORD   GetDwordFromCaptured();
		void SetTdiToDword(DWORD dw) { *((DWORD *)&m_baTdi[0])=dw; }
		bool SetBit(int nBit, bool fValue) { ASSERT(nBit<m_nBits); if(nBit>=m_nBits) return false; if(fValue) m_baTdi[nBit>>3]|=(1<<(nBit&7)); else m_baTdi[nBit>>3]&=~(1<<(nBit&7)); return true; }
		bool IsAnyTDOCare() { return(!m_fAllTdoDontCare); }
		bool GetCapturedBit(int nBit) { return( (m_baTdoCaptured[nBit>>3]>>(nBit&7))&1 )!=0; }
		bool GetTdoBit(int nBit) { return( (m_baTdo[nBit>>3]>>(nBit&7))&1 )!=0; }
		bool GetTdoMaskBit(int nBit) { return( (m_baTdoMask[nBit>>3]>>(nBit&7))&1 )!=0; }
		bool GetTdiBit(int nBit) { return( (m_baTdi[nBit>>3]>>(nBit&7))&1 )!=0; }
		void SetCapturedBit(int nBit, bool f) { if(f) m_baTdoCaptured[nBit>>3] |=1<<(nBit&7); else m_baTdoCaptured[nBit>>3] &= ~(1<<(nBit&7)); }
		void SetTdiBit(int nBit, bool f) { if(f) m_baTdi[nBit>>3] |=1<<(nBit&7); else m_baTdi[nBit>>3] &= ~(1<<(nBit&7)); }
		void SetTdoBit(int nBit, bool f) { if(f) m_baTdo[nBit>>3] |=1<<(nBit&7); else m_baTdo[nBit>>3] &= ~(1<<(nBit&7)); }
		void SetTdoMaskBit(int nBit, bool f) { if(f) m_baTdoMask[nBit>>3] |=1<<(nBit&7); else m_baTdoMask[nBit>>3] &= ~(1<<(nBit&7)); }
		bool CaptureMatchesAllowingForMask();
};


class CJtagSvfInterpreter
{
	public:
		int m_nState; // current state of Jtag interface
		CJtagRegisterManagement m_cjrmInstructionHeader;
		CJtagRegisterManagement m_cjrmInstructionPayload;
		CJtagRegisterManagement m_cjrmInstructionTrailer;
		CJtagRegisterManagement m_cjrmDataHeader;
		CJtagRegisterManagement m_cjrmDataPayload;
		CJtagRegisterManagement m_cjrmDataTrailer;
		CJtagRegisterManagement m_cjrmJustForTCK;
		char m_szaPioNames[32][32];
		int m_nStateEndDr;
		int m_nStateEndIr;
		bool m_fTrstAbsent;
		bool m_fTdoPresent; // FALSE means perform no readback comparisan
		string m_csFilepath;
		FILE * m_file;
		char m_szBuffer[256];
		int m_nLastRunTestLength;

		enum typeLoadBoundaryRegisterAction {
			LBR_TYPE_HEADER=0,
			LBR_TYPE_PAYLOAD=1,
			LBR_TYPE_TRAILER=2,
			LBR_TYPE_TCKONLY=3,
			LBR_TYPE_DYNCFG=4,
			LBR_ATTRIBUTE_TDO=128
		};
	protected:
		bool m_fClockWasTCK;
		CJtagRegisterManagement * m_pSelectedRegister;
		int m_nLengthLastLiteral;
		int m_nLastToken;
		int m_nLinesSeen;
		bool m_fSeenError;
		char m_szErrorText[256];
		char m_cNextChar;
		char *m_szLine;

	private:
		int ParseYY();
		int LexYY();
		int ErrorYY(const char *s);
		int ReportMessage(const char *s, const char * sz2, int n) { printf("%s '%s': %d\n", s, sz2, n); return 0; }
    	void PerformSleep(unsigned long ul) {  Sleep(ul); }

	public:
		CJtagSvfInterpreter() {
    		m_nStateEndDr=m_nStateEndIr=TOK_STATE_IDLE;
			m_fTrstAbsent=false;
			m_cjrmJustForTCK.m_fAllTdiDontCare=m_cjrmJustForTCK.m_fAllTdoDontCare=true;
			m_nState =TOK_STATE_RESET;
			m_nLastRunTestLength=0;
  		}
		virtual ~CJtagSvfInterpreter() { ; }
		bool ExecuteSvf(const char * szName);

  // returns necessary sequence for TMS cycles to get to new state from this one
  // if(b7..b0) is nonzero, store in CB tap controller TMS register
  // shift right 8 bits and repeat

  	int  GetTMSSequenceForState(int nState);
	const char *  TranslateStateToText(int nState);

    protected:  // override these guys in a derivation in order to perform the Jtag actions

      virtual void SetTRSTState(int n) =0;
      virtual int LoadBoundaryRegister(CJtagRegisterManagement * pjrm, int nJtagState, int nType) =0;
      virtual bool MoveToState(int nState) =0;
};

#endif
