/* YACC parser definition for SVF */

/**+ start */

%{

#define YYSTYPE T_YYSTYPE
typedef struct {
	char symbol[256];
} T_YYSTYPE;

#include "milk.h"
#include "svf.h"

#define YYMAXDEPTH 20
#define YYREDMAX 50


/* set up table for fast scanning of ASCII */
	/* char valid in label name */	
#define L 1
	/* char is a number */

#define N 2
	/* char is whitespace */
#define W 4
	/* char is passed as literal to yacc */
#define C 8
	/* non-newm_szLine white space */
#define X 16


BYTE ascii[] = {
	0,0,0,0,0,0,0,0,0,W+X,W+C,0,0,W,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	W+X,C,C,C,C,C,C,C,C,C,C,C,C,C,C,C,
	L+N,L+N,L+N,L+N,L+N,L+N,L+N,L+N,L+N,L+N,C,C,C,C,C,C,
	C,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,C,C,C,C,L,	/* underscore */
	C,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,C,C,C,C,C,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
	L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,
};

typedef struct {
	const char *name;
	WORD token;
	BYTE length;
} OPERATORS;

OPERATORS operators[] = {
 { "absent", TOK_OP_ABSENT, 6 } ,
 { "drselect", TOK_STATE_DRSELECT, 8 } ,
 { "drcapture", TOK_STATE_DRCAPTURE, 9 } ,
 { "drshift", TOK_STATE_DRSHIFT, 7 } ,
 { "drexit1", TOK_STATE_DREXIT1, 7 } ,
 { "drpause", TOK_STATE_DRPAUSE, 7 } ,
 { "drexit2", TOK_STATE_DREXIT2, 7 } ,
 { "drupdate", TOK_STATE_DRUPDATE, 8 } ,
 { "enddr", TOK_CMD_ENDDR, 5 } ,
 { "endir", TOK_CMD_ENDIR, 5 } ,
 { "endstate", TOK_OP_ENDSTATE, 8 } ,
 { "hdr", TOK_CMD_HDR, 3 } ,
 { "hir", TOK_CMD_HIR, 3 } ,
 { "irupdate", TOK_STATE_IRUPDATE, 8 } ,
 { "irselect", TOK_STATE_IRSELECT, 8 } ,
 { "ircapture", TOK_STATE_IRCAPTURE, 9 } ,
 { "idle", TOK_STATE_IDLE, 4 } ,
 { "irshift", TOK_STATE_IRSHIFT, 7 } ,
 { "irexit1", TOK_STATE_IREXIT1, 7 } ,
 { "irpause", TOK_STATE_IRPAUSE, 7 } ,
 { "irexit2", TOK_STATE_IREXIT2, 7 } ,
 { "mask", TOK_OP_MASK, 4 } ,
 { "off", TOK_OP_OFF, 3 } ,
 { "on", TOK_OP_ON, 2 } ,
 { "pio", TOK_CMD_PIO, 3 } ,
 { "piomap", TOK_CMD_PIOMAP, 6 } ,
 { "reset", TOK_STATE_RESET, 5 } ,
 { "runtest", TOK_CMD_RUNTEST, 7 } ,
 { "sck", TOK_OP_SCK, 3 } ,
 { "smask", TOK_OP_SMASK, 5 } ,
 { "sdr", TOK_CMD_SDR, 3 } ,
 { "sir", TOK_CMD_SIR, 3 } ,
 { "state", TOK_CMD_STATE, 5 } ,
 { "tck", TOK_OP_TCK, 3 } ,
 { "tdr", TOK_CMD_TDR, 3 } ,
 { "tir", TOK_CMD_TIR, 3 } ,
 { "trst", TOK_CMD_TRST, 4 } ,
 { "tdi", TOK_OP_TDI, 3 } ,

 { "tdo", TOK_OP_TDO, 3 } ,
 { "z", TOK_OP_Z, 1 } ,
 { NULL, 0, 0 }
};

#define yyerror CJtagSvfInterpreter::ErrorYY


%}

/**- token defs */

%token NUMBER
%token LITERAL

/* operators */

%token TOK_STATE_DRSELECT
%token TOK_STATE_DRCAPTURE
%token TOK_STATE_DRSHIFT
%token TOK_STATE_DREXIT1
%token TOK_STATE_DRPAUSE
%token TOK_STATE_DREXIT2
%token TOK_STATE_DRUPDATE
%token TOK_CMD_ENDDR
%token TOK_CMD_ENDIR
%token TOK_CMD_HDR
%token TOK_CMD_HIR
%token TOK_STATE_IRUPDATE
%token TOK_STATE_IRSELECT

%token TOK_STATE_IRCAPTURE
%token TOK_STATE_IDLE
%token TOK_STATE_IRSHIFT
%token TOK_STATE_IREXIT1
%token TOK_STATE_IRPAUSE
%token TOK_STATE_IREXIT2
%token TOK_OP_MASK
%token TOK_CMD_PIO
%token TOK_CMD_PIOMAP
%token TOK_STATE_RESET
%token TOK_CMD_RUNTEST
%token TOK_OP_SMASK
%token TOK_CMD_SDR
%token TOK_CMD_SIR
%token TOK_CMD_STATE
%token TOK_CMD_TDR
%token TOK_CMD_TIR
%token TOK_CMD_TRST
%token TOK_OP_TDI
%token TOK_OP_TDO
%token TOK_OP_ABSENT
%token TOK_OP_ON
%token TOK_OP_OFF
%token TOK_OP_Z
%token TOK_OP_ENDSTATE
%token TOK_OP_TCK
%token TOK_OP_SCK


/**- token precedence and typing */
/*
%type <symbol> NUMBER
%type <symbol> LITERAL

 %type <symbol> ruleSvfCommand
 %type <symbol> ruleSvfStatement
*/
/**- start of rules */

%%


/**+ exp/expr */

ruleSvfCommand:	ruleSvfStatement {	// int t;
//					*ret=$1;
					return(99);
				} 
;

ruleSvfAnyState:
 TOK_STATE_DRSELECT |
 TOK_STATE_DRCAPTURE  |
 TOK_STATE_DRSHIFT |
 TOK_STATE_DREXIT1 |
 TOK_STATE_DRPAUSE |
 TOK_STATE_DREXIT2 |
 TOK_STATE_DRUPDATE |
 TOK_STATE_IRUPDATE |
 TOK_STATE_IRSELECT |
 TOK_STATE_IRCAPTURE |
 TOK_STATE_IDLE |
 TOK_STATE_IRSHIFT |
 TOK_STATE_IREXIT1 |
 TOK_STATE_IRPAUSE |
 TOK_STATE_IREXIT2 |
 TOK_STATE_RESET 
;	

ruleSvfStableState:
 TOK_STATE_DRPAUSE |
 TOK_STATE_IDLE |
 TOK_STATE_IRPAUSE |
 TOK_STATE_RESET 
;	

ruleSvfAnyStateListEndingStable:
	ruleSvfStableState ';' {
//		printf("State: %s", $1.symbol);
 		MoveToState(*((WORD *)($1.symbol)));
   }|
	ruleSvfAnyState {
//		printf("State: %s", $1.symbol);
 		MoveToState(*((WORD *)($1.symbol)));
   } ruleSvfAnyStateListEndingStable
;

ruleClockSource:
	TOK_OP_TCK { m_fClockWasTCK=true; } |
	TOK_OP_SCK { m_fClockWasTCK=false; }
;

rulePioName:
	LITERAL LITERAL
;

rulePioNameList:
	rulePioName rulePioName |
	rulePioName 
;

ruleScanQualifier:
	TOK_OP_TDI '(' LITERAL ')' {
 		m_pSelectedRegister->LoadTdiFromAsciiHex($3.symbol, m_nLengthLastLiteral);
   }|
	TOK_OP_TDO '(' LITERAL ')' {
 		m_fTdoPresent=true; m_pSelectedRegister->LoadTdoFromAsciiHex($3.symbol, m_nLengthLastLiteral);
   }|
	TOK_OP_MASK '(' LITERAL ')' {
 		m_pSelectedRegister->LoadTdoMaskFromAsciiHex($3.symbol, m_nLengthLastLiteral);
   }|
	TOK_OP_SMASK '(' LITERAL ')'{
 		m_pSelectedRegister->LoadTdiMaskFromAsciiHex($3.symbol, m_nLengthLastLiteral);
  }
;

ruleScanQualifierList:
	ruleScanQualifierList ruleScanQualifier |
	ruleScanQualifier
;

ruleGetBitCount:
	LITERAL {
 		 int n=atoi($1.symbol);
    	if((n<0)||(n>MAX_BITS)) yyerror("Bad Bit Count");
    	else {
			int nBit;
			m_pSelectedRegister->SetBitCount(n);

			if(m_pSelectedRegister == &m_cjrmInstructionPayload) {
				m_pSelectedRegister->m_nHeaderBits=m_cjrmInstructionHeader.GetSize();
				m_pSelectedRegister->m_nTrailerBits=m_cjrmInstructionTrailer.GetSize();
				m_pSelectedRegister->SetBitCount(n+m_pSelectedRegister->m_nHeaderBits+ m_pSelectedRegister->m_nTrailerBits);
//				printf("instruction selected, hdr=%d, trail=%d, eff=%d\n",
//					m_pSelectedRegister->m_nHeaderBits,
//					m_pSelectedRegister->m_nTrailerBits,
//					m_pSelectedRegister->m_nBits
//				);
				for( nBit=0;nBit<m_pSelectedRegister->m_nHeaderBits;nBit++) {
					m_pSelectedRegister->SetTdiBit(nBit, m_cjrmInstructionHeader.GetTdiBit(nBit));
					m_pSelectedRegister->SetTdoBit(nBit, m_cjrmInstructionHeader.GetTdoBit(nBit));
					m_pSelectedRegister->SetTdoMaskBit(nBit, m_cjrmInstructionHeader.GetTdoMaskBit(nBit));
				}
				for(nBit=0;nBit<m_pSelectedRegister->m_nTrailerBits;nBit++) {
					m_pSelectedRegister->SetTdiBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmInstructionTrailer.GetTdiBit(nBit));
					m_pSelectedRegister->SetTdoBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmInstructionTrailer.GetTdoBit(nBit));
					m_pSelectedRegister->SetTdoMaskBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmInstructionTrailer.GetTdoMaskBit(nBit));
				}
			}
			if(m_pSelectedRegister == &m_cjrmDataPayload) {

				m_pSelectedRegister->m_nHeaderBits=m_cjrmDataHeader.GetSize();
				m_pSelectedRegister->m_nTrailerBits=m_cjrmDataTrailer.GetSize();
				m_pSelectedRegister->SetBitCount(n+m_pSelectedRegister->m_nHeaderBits+ m_pSelectedRegister->m_nTrailerBits);
//				printf("data selected, hdr=%d, trail=%d, eff=%d\n",
//					m_pSelectedRegister->m_nHeaderBits,
//					m_pSelectedRegister->m_nTrailerBits,
//					m_pSelectedRegister->m_nBits
//				);
				for(nBit=0;nBit<m_pSelectedRegister->m_nHeaderBits;nBit++) {
					m_pSelectedRegister->SetTdiBit(nBit, m_cjrmDataHeader.GetTdiBit(nBit));
					m_pSelectedRegister->SetTdoBit(nBit, m_cjrmDataHeader.GetTdoBit(nBit));
					m_pSelectedRegister->SetTdoMaskBit(nBit, m_cjrmDataHeader.GetTdoMaskBit(nBit));
				}
				for(nBit=0;nBit<m_pSelectedRegister->m_nTrailerBits;nBit++) {
					m_pSelectedRegister->SetTdiBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmDataTrailer.GetTdiBit(nBit));
					m_pSelectedRegister->SetTdoBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmDataTrailer.GetTdoBit(nBit));
					m_pSelectedRegister->SetTdoMaskBit(nBit+n+m_pSelectedRegister->m_nHeaderBits, m_cjrmDataTrailer.GetTdoMaskBit(nBit));
				}
			}


 		     m_pSelectedRegister->m_fAllTdiDontCare=m_pSelectedRegister->m_fAllTdoDontCare=true;
			}
     }
;

ruleSvfStatement:

	TOK_CMD_STATE ruleSvfAnyStateListEndingStable | /* commands taken care of in reference */

	TOK_CMD_ENDDR ruleSvfStableState ';' { m_nStateEndDr=m_nLastToken; }|

	TOK_CMD_ENDIR ruleSvfStableState ';' { m_nStateEndIr=m_nLastToken; }|

	TOK_CMD_TRST TOK_OP_ABSENT ';' { m_fTrstAbsent=true; }|
	TOK_CMD_TRST TOK_OP_ON ';' {
 		if(m_fTrstAbsent) yyerror("TRST cannot be changed after TRST ABSENT"); else SetTRSTState(0);
   } |
	TOK_CMD_TRST TOK_OP_OFF ';' {
 		if(m_fTrstAbsent) yyerror("TRST cannot be changed after TRST ABSENT"); else SetTRSTState(1);
   }|
	TOK_CMD_TRST TOK_OP_Z ';' {
 		if(m_fTrstAbsent) yyerror("TRST cannot be changed after TRST ABSENT"); else SetTRSTState(1);
   }|
	

	TOK_CMD_RUNTEST LITERAL ruleClockSource ';' {

		if(m_fClockWasTCK) {
			string cs;
			cs=$2.symbol;
			long l=atol(cs.c_str());
			 m_cjrmJustForTCK.SetBitCount(l); 
			 m_cjrmJustForTCK.m_fAllTdiDontCare=true;
			 LoadBoundaryRegister(&m_cjrmJustForTCK, 0, LBR_TYPE_TCKONLY);
		} else {
			PerformSleep(atol($2.symbol)/1000+1); 
		}

 } |
	TOK_CMD_RUNTEST LITERAL ruleClockSource TOK_OP_ENDSTATE ruleSvfStableState ';' {
   if(m_fClockWasTCK) {
			m_cjrmJustForTCK.SetBitCount(atol($2.symbol)); 
			LoadBoundaryRegister(&m_cjrmJustForTCK, 0, LBR_TYPE_TCKONLY);
//			MoveToState(m_nLastToken);
			printf("State: %s\n", $5.symbol);
			MoveToState(atol($5.symbol));
		} else {
			PerformSleep(atol($2.symbol)/1000+1); 
		}
 }|

	TOK_CMD_PIOMAP '(' rulePioNameList ')' ';' |

	TOK_CMD_PIO '(' LITERAL ')' ';' |

	TOK_CMD_HDR ruleGetBitCount ';' |
	TOK_CMD_HDR ruleGetBitCount  ruleScanQualifierList ';' |

	TOK_CMD_HIR ruleGetBitCount ';' |
	TOK_CMD_HIR ruleGetBitCount ruleScanQualifierList ';'  |

	TOK_CMD_TDR ruleGetBitCount ';' |
	TOK_CMD_TDR ruleGetBitCount  ruleScanQualifierList ';' |

	TOK_CMD_TIR ruleGetBitCount ';' |
	TOK_CMD_TIR ruleGetBitCount  ruleScanQualifierList ';' |

	TOK_CMD_SDR ruleGetBitCount ';' |
	TOK_CMD_SDR ruleGetBitCount  ruleScanQualifierList ';'  {

  int nMask=0;
		if(m_fTdoPresent) nMask|=LBR_ATTRIBUTE_TDO;
		MoveToState(TOK_STATE_DRSHIFT);
		if(LoadBoundaryRegister(
			&m_cjrmDataPayload, 
			m_nStateEndDr,
			LBR_TYPE_PAYLOAD|nMask
		)<0) {
			string cs, csCap, csTdo, csMask;
			m_cjrmDataPayload.FillCStringWithAsciiHexCaptured(csCap);
			m_cjrmDataPayload.FillCStringWithAsciiHexTDO(csTdo);
			m_cjrmDataPayload.FillCStringWithAsciiHexTDOMASK(csMask);
			cs=StringFormat("TDO did not match required value: TDO=%s, Req=%s, Mask=%s",
				csCap.c_str(), csTdo.c_str(), csMask.c_str()
			);
			yyerror(cs.c_str());
		}

  }|

	TOK_CMD_SIR ruleGetBitCount ';' |
	TOK_CMD_SIR ruleGetBitCount  ruleScanQualifierList ';' {
	
  int nMask=0;
		if(m_fTdoPresent) nMask|=LBR_ATTRIBUTE_TDO;
		MoveToState(TOK_STATE_IRSHIFT);

		if(LoadBoundaryRegister(
			&m_cjrmInstructionPayload,
			m_nStateEndIr,
			LBR_TYPE_PAYLOAD|nMask
		)<0) {
			string cs, csCap, csTdo, csMask;
			m_cjrmInstructionPayload.FillCStringWithAsciiHexCaptured(csCap);
			m_cjrmInstructionPayload.FillCStringWithAsciiHexTDO(csTdo);
			m_cjrmInstructionPayload.FillCStringWithAsciiHexTDOMASK(csMask);
			cs=StringFormat("TDO did not match required value: (eff len=%d) TDO=%s, Req=%s, Mask=%s",
				m_cjrmInstructionPayload.m_nBits, csCap.c_str(), csTdo.c_str(), csMask.c_str()
			);
			yyerror(cs.c_str());
		}

  }|
;




%%

/**+ stuff */


bool CJtagRegisterManagement::CaptureMatchesAllowingForMask()
{
	for(int n=0;n<m_nBits;n++) {
		if(GetTdoMaskBit(n)) {
			if(GetCapturedBit(n)!=GetTdoBit(n)) return false;
		}
	}
	return true;
}

// returns necessary sequence for TMS cycles to get to new state from this one
  // if(b7..b0) is nonzero, store in CB tap controller TMS register
  // shift right 8 bits and repeat


  int  CJtagSvfInterpreter::GetTMSSequenceForState(int nState)
  {
  	switch(m_nState) { // existing stable state
  		case TOK_STATE_RESET:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0xbf); // 11111
  					break;
  				case TOK_STATE_IDLE:
  					return(0x20);	// 0
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0xaa);	// 01010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x6266);	// 011 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0x82);	// 0100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0xa6);	// 01100
  					break;
  			}
  			break;
  		case TOK_STATE_IDLE:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0x67); // 111
  					break;
  				case TOK_STATE_IDLE:
  					return(0);
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x85);	// 1010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0xab);	// 11010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0x61);	// 100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x83);	// 1100
  					break;
  			}
  			break;
  		case TOK_STATE_DRPAUSE:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0x6367);  // 111 110
  					break;
  				case TOK_STATE_IDLE:
  					return(0x63);	// 110
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x6267);	// 111 010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x628f);	// 1111 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0xa7);	//11100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x408f);	// 1111 00
  					break;
  			}
  			break;
  		case TOK_STATE_IRPAUSE:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0xbf); // 11111
  					break;
  				case TOK_STATE_IDLE:
  					return(0x63);	// 110
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x6267);	// 111 010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x628f);	// 1111 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0xa7);	// 11100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x408f);	// 1111 00
  					break;
  			}
  			break;
  		case TOK_STATE_IRSHIFT:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0xbf);  // 11111
  					break;
  				case TOK_STATE_IDLE:
  					return(0x63);	// 110
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x6267);	// 111010
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x628f);	// 1111 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0xa7);	//11100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x408f);	// 1111 00
  					break;
  			}
  			break;
  		case TOK_STATE_DRSHIFT:
  			switch(nState) { // existing stable state
  				case TOK_STATE_RESET:
  					return(0xbf);  // 11111
  					break;
  				case TOK_STATE_IDLE:
  					return(0x63);	// 110
  					break;
  				case TOK_STATE_DRPAUSE:
  					return(0x41);	// 10
  					break;
  				case TOK_STATE_IRPAUSE:
  					return(0x628f);	// 1111 010
  					break;
  				case TOK_STATE_DRSHIFT:
  					return(0xa7);	//11100
  					break;
  				case TOK_STATE_IRSHIFT:
  					return(0x408f);	// 1111 00
  					break;
  			}
  			break;


  	}
  	return(0);
  }
bool CJtagSvfInterpreter::ExecuteSvf(const char * szName)
{


	WORD r;
	bool fMore=true;
	bool fRetcode=true;
	int nLines=0;
	DWORD dwTime=GetTickCount();

	m_nLinesSeen=1;
	m_fSeenError=false;
	strcpy(m_szErrorText, "No Error");

	m_csFilepath=szName;

	m_file=fopen(szName, "rt");
	if(m_file==NULL) {
		ReportMessage(szName, "Unable to open file", 0);
		return(false);
	}

	printf("   Processing SVF file: %s\n", szName);

	while(fMore) {
		if(fgets(m_szBuffer, sizeof(m_szBuffer), m_file)==NULL) {
			fMore=false; continue;
		}
		m_cNextChar=*m_szBuffer;
		m_szLine=(char *)m_szBuffer+1;
//		puts(m_szBuffer);
		r=ParseYY();

		if((r!=99)||(m_fSeenError)) {

//		printf("ParseYY returns %d\n", r);
			fRetcode=false;
			fMore=false;
		}
		nLines++;
		m_nLinesSeen++;
		if(nLines==5) {
			DWORD dwTimeNow=GetTickCount();
			nLines=0;
			if(dwTimeNow-dwTime > 500) {
				printf("  lines done: %d    \r", m_nLinesSeen);
				dwTime=dwTimeNow;
			}
		}
	}

	if(fRetcode==false) {
		ReportMessage(m_szErrorText, "SVF error", 0);
	}

	if(fRetcode==true) printf("   Completed OK         \n"); else printf("   Completed With ERRORS      \n");

	return(fRetcode);
}



int CJtagSvfInterpreter::ErrorYY(const char *s)
{
	puts(s);
	if(!m_fSeenError) {
		char sz[2048];
		sprintf(sz, "%s(%d): %s", m_csFilepath.c_str(), m_nLinesSeen, s);
		strncpy(m_szErrorText, sz, sizeof(m_szErrorText)-1);
		m_fSeenError=1;
	}
	return(false);
}



		const char *  CJtagSvfInterpreter::TranslateStateToText(int nState)
		{
			switch(nState) {
				case TOK_STATE_DRSELECT:  return("DRSELECT");
				case TOK_STATE_DRCAPTURE:  return("DRCAPTURE");
				case TOK_STATE_DRSHIFT:  return("DRSHIFT");
				case TOK_STATE_DREXIT1:  return("DREXIT1");
				case TOK_STATE_DRPAUSE:  return("DRPAUSE");
				case TOK_STATE_DREXIT2:  return("DREXIT2");
				case TOK_STATE_DRUPDATE:  return("DRUPDATE");
				case TOK_STATE_IRUPDATE:  return("IRUPDATE");
				case TOK_STATE_IRSELECT:  return("IRSELECT");
				case TOK_STATE_IRCAPTURE:  return("IRCAPTURE");
				case TOK_STATE_IDLE:  return("IDLE");
				case TOK_STATE_IRSHIFT:  return("IRSHIFT");
				case TOK_STATE_IREXIT1:  return("IREXIT1");
				case TOK_STATE_IRPAUSE:  return("IRPAUSE");
				case TOK_STATE_IREXIT2:  return("IREXIT2");
				case TOK_STATE_RESET:	return("RESET");
			}
			printf("%d\n", nState);
			return("!! Illegal State Index !!");
		}


 #define yylex CJtagSvfInterpreter::LexYY

/**+ yylex */

int yylex()
{
	WORD a,b;

		// error/terminator
restart:

	if(m_cNextChar=='\0') {
		if(fgets(m_szBuffer, sizeof(m_szBuffer), m_file)==NULL) {
			return -1;
		}
		m_nLinesSeen++;
		m_cNextChar=*m_szBuffer;
		m_szLine=(char *)m_szBuffer+1;

	}

	if(m_fSeenError) return -1;

		// whitespace

	while(ascii[(unsigned int)m_cNextChar]&X) {m_cNextChar=*m_szLine++; }

	if((m_cNextChar=='!') || (m_cNextChar=='/' && *m_szLine=='/')) { // comment until end of m_szLine
		printf(m_szBuffer);
		while( m_cNextChar ) m_cNextChar=*m_szLine++;
		goto restart;
	}

		// literal

	if(ascii[(unsigned int)m_cNextChar]&C) {
		a=m_cNextChar; m_cNextChar=*m_szLine++;
#ifdef DEBUG_LEX
		printf("Char: '%c'\n", a);
#endif
		return(a);
	}
/*
	if(ascii[m_cNextChar]&N) { // number
		a=0;
		while(ascii[m_cNextChar]&L) {
			yylval.symbol[a++]=m_cNextChar;
			m_cNextChar=*m_szLine++;
		}
		yylval.symbol[a]='\0';
#ifdef DEBUG_LEX
		printf("Number '%s'\n", yylval.symbol);
#endif
		return(NUMBER);
	}
*/
	m_nLengthLastLiteral=0;
	while(ascii[(unsigned int)m_cNextChar]&L) {
		yylval.symbol[m_nLengthLastLiteral++]=m_cNextChar;
		m_cNextChar=*m_szLine++;
	}
	yylval.symbol[m_nLengthLastLiteral]='\0';

	if(!m_nLengthLastLiteral) {
		yyerror((const char *)"Funny Character");
		return('\n');
	}

#ifdef DEBUG_LEX
				printf("Checking symbol '%s'\n", yylval.symbol);
#endif
	b=0; while(operators[b].length) {
		if(operators[b].length==m_nLengthLastLiteral) {
			if(strcasecmp(operators[b].name,yylval.symbol)==0) {
#ifdef DEBUG_LEX
				printf("Token '%s'\n", yylval.symbol);

#endif
				m_nLastToken=operators[b].token;
				yylval.symbol[0]=m_nLastToken;
				yylval.symbol[1]=m_nLastToken >> 8;

				switch(m_nLastToken) {
					case TOK_CMD_HDR:
						m_pSelectedRegister=&m_cjrmDataHeader;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_HIR:
						m_pSelectedRegister=&m_cjrmInstructionHeader;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_TDR:
						m_pSelectedRegister=&m_cjrmDataTrailer;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_TIR:
						m_pSelectedRegister=&m_cjrmInstructionTrailer;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_SDR:
						m_pSelectedRegister=&m_cjrmDataPayload;
						m_fTdoPresent=false;
						break;
					case TOK_CMD_SIR:
						m_pSelectedRegister=&m_cjrmInstructionPayload;
						m_fTdoPresent=false;
						break;
				}

				return(m_nLastToken);
			}
		}
		b++;
	}

#ifdef DEBUG_LEX
	printf("Literal '%s'\n", yylval.symbol);
#endif
	return(LITERAL);

}



#define yyparse CJtagSvfInterpreter::ParseYY


