/***************************************************************************
                          winconst.cpp  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "winconst.h"
#include <stdarg.h>

 #ifndef WIN32
 void Sleep(int nMs)  { usleep(nMs * 1000); }

    DWORD GetTickCount(void)
    {
     struct timeval _tstart;
     struct timezone tz;

     gettimeofday(&_tstart, &tz);
	  return (_tstart.tv_sec*1000) +(_tstart.tv_usec /1000);
    }

#else


	const char * optarg;
	int nArg=1;
	int getopt_long(int argc, char ** argv, const char * szcSwitchMap, option * poptionaLongOptions, int * pn)
	{
		if(nArg<argc) {
			char cSwitchChar=-1;

			if(argv[nArg][0]=='-') { // some kind of switch, look for long
				if(argv[nArg][1]=='-') { // double switch
					if(poptionaLongOptions!=NULL) {
						int n=0; while(poptionaLongOptions[n].szcName!=NULL) {
							if(stricmp(&argv[nArg][2], poptionaLongOptions[n].szcName)==0) {
							cSwitchChar=poptionaLongOptions[n].cShortForm;
							}
							n++;
						}
					}
				}

				if(strlen(argv[nArg])==2) { // -x
					int n=0;
					while(szcSwitchMap[n]!='\0') {
						if(szcSwitchMap[n]==argv[nArg][1]) {
							cSwitchChar=argv[nArg][1];
							if(szcSwitchMap[n+1]==':') {
								if((nArg+1)>=argc) {
									printf("-%c switch must have a following argument\n", cSwitchChar);
									exit(0);
								} else {
									optarg=argv[nArg+1];
									nArg++;
								}
								while(szcSwitchMap[n]) n++;
								n--;
							}
						}
						n++;
					}
				}
			}

			nArg++;

			return cSwitchChar;
		}
		return -1;
	}

#endif

string StringFormat(const char *szFormat, ...) {
	char szBuffer[2048];
	string cs;
	WORD wLength;
	va_list argList;
	va_start(argList, szFormat);
	wLength=(WORD) vsprintf(szBuffer, szFormat, argList);
	va_end(argList);
	cs=&szBuffer[0];
	return cs;
}

bool CFile::Open(const char *szFilename, int nModes, int nFileMode)
{
#ifdef WIN32
	nModes|=_O_BINARY;
#endif
	if(nModes & O_CREAT) {
		unlink(szFilename);
	}
	m_nHandleFile=open(szFilename, nModes, nFileMode);
	return (m_nHandleFile!=-1);
}

int CFile::Read(void * pvoid, unsigned int uiLength)
{
	return read(m_nHandleFile, pvoid, uiLength);
}

int CFile::Write(const void *pvoid, unsigned int uiLength)
{
	return write(m_nHandleFile, pvoid, uiLength);
}

void CArray::AllocateIfNecessary(unsigned int ui)
{
	if(ui>=m_uiStorageExtent) {
		BYTE * pb = new BYTE [ui + m_nAdditionalAlloc ];
		if(m_uiStorageExtent) { // existing stg to copy over
			for(unsigned int n=0; n<m_uiStorageExtent; n++) pb[n] = ((BYTE *)m_pvoidStorage)[n];
		}
		RemoveAll();
		m_uiStorageExtent =ui + m_nAdditionalAlloc;
		m_pvoidStorage = pb;
	}
}


