/***************************************************************************
                          winconst.h  -  description
                             -------------------
    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by Andy Green
    email                : andy@warmcat.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __WINCONST_INCLUDED__
#define __WINCONST_INCLUDED__

#include <stdio.h>
#include <string>
#include <fstream>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <assert.h>

using namespace std;

  typedef unsigned int DWORD;
  typedef unsigned short WORD;
  typedef unsigned char BYTE;
#define ASSERT assert


#ifdef WIN32 // windows

#include <io.h>
#include <assert.h>
// #include <winbase.h>
extern "C" void __declspec(dllimport) __stdcall Sleep(
    DWORD dwMilliseconds

    );

extern "C" DWORD __declspec(dllimport) __stdcall GetTickCount(
    void
    );

//  #include "resource.h"
#define BOOL int
#define strcasecmp stricmp
  #include "ntiosupport.h"
extern 	const char * optarg;


#define DEFAULT_PERMS _S_IREAD | _S_IWRITE

	struct option {
		const char * szcName;
		int nTakesArg;
		void * pvoid;
		char cShortForm;
	};
	int getopt_long(int argc, char ** argv, const char * szcSwitchMap, option * poptionaLongOptions, int * pn);


#else  // linux

	typedef long long __int64;

#define _open open
#define _close close


  #include <sys/io.h>
  #include <unistd.h>
  #include <getopt.h>
  #include <sys/time.h>
  extern int errno;

	#define DEFAULT_PERMS S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH

		// defined in winconst.cpp

  void Sleep(int nMs); //  { usleep(nMs * 1000); }
  DWORD GetTickCount(void);

#endif

string StringFormat(const char *szFormat, ...) ;

class CFile
{
	public:
		int m_nHandleFile;

	public:
		CFile() { m_nHandleFile=-1; }
		~CFile() { Close(); }
		void Close() { if(m_nHandleFile!=-1) { _close(m_nHandleFile); } m_nHandleFile=-1; }
		bool Open(const char *szFilename, int nModes, int nFileModes=DEFAULT_PERMS);
		bool Open(const string & rstring, int nModes, int nFileModes=DEFAULT_PERMS) { 
			return Open(rstring.c_str(), nModes, nFileModes); 
		}
		int Read(void * pvoid, unsigned int dwLength);
		int Write(const void *pvoid, unsigned int dwLength);
		static bool FileExists(const char * szc) { int n=_open(szc, O_RDONLY); if(n!=-1) { close(n); return true; } return false; }
		unsigned int GetLength() { struct stat thisstat; if(! fstat(m_nHandleFile, &thisstat))  return thisstat.st_size; return 0; }
		static unsigned int GetLength(const char * szcFilpath)  { struct stat thisstat; if(! stat(szcFilpath, &thisstat))  return thisstat.st_size; return 0; }
		bool IsOpen() { return m_nHandleFile!=-1; }
};

class CArray
{
	public:
		void * m_pvoidStorage;
		unsigned int m_uiStorageExtent;
		unsigned int m_uiUsedExtent;
		enum {
			m_nAdditionalAlloc=50  // bytes to alloc ahead
		};

	public:
		CArray() { m_pvoidStorage=NULL; m_uiStorageExtent=m_uiUsedExtent=0; }
		~CArray() { RemoveAll(); }
		void RemoveAll() { if(m_pvoidStorage!=NULL) { delete [] (BYTE *)m_pvoidStorage; } m_pvoidStorage=NULL; m_uiStorageExtent=m_uiUsedExtent=0; }
		void AllocateIfNecessary(unsigned int ui);
		void * GetStartOfArray() { return m_pvoidStorage; }
		void Empty() { m_uiUsedExtent=0; }
};

class CByteArray : public CArray
{
	public:
		BYTE GetAt(unsigned int ui) { ASSERT(ui<m_uiUsedExtent); return *(((BYTE *)GetStartOfArray())+ui); }
		BYTE & Item(unsigned int ui) { ASSERT(ui<m_uiUsedExtent); return *(((BYTE *)GetStartOfArray())+ui); }
		BYTE & Item( int ui) { return(Item((unsigned int)ui)); }
		const BYTE & Item( int ui) const { return (const BYTE &)(Item((unsigned int)ui)); }
		void SetAt(unsigned int ui, BYTE b) { ASSERT(ui<m_uiUsedExtent); *(((BYTE *)GetStartOfArray())+ui)=b; }
		void SetAtGrow(unsigned int ui, BYTE b) { AllocateIfNecessary(ui);  if(ui>=m_uiUsedExtent) m_uiUsedExtent=ui+1; *(((BYTE *)GetStartOfArray())+ui)=b; }
		void Add(BYTE b) { AllocateIfNecessary(m_uiUsedExtent+1);  m_uiUsedExtent++; *(((BYTE *)GetStartOfArray())+m_uiUsedExtent)=b; }
		void Alloc(unsigned int uiCount) { AllocateIfNecessary(uiCount * sizeof(BYTE)); }
		unsigned int GetCount() { return m_uiUsedExtent/sizeof(BYTE); }
};

#endif
