/*

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef AFX_MILK_H__7ADD5432_2C2B_42C8_9119_EE6E18F490FA__INCLUDED_
#define AFX_MILK_H__7ADD5432_2C2B_42C8_9119_EE6E18F490FA__INCLUDED_

//void Sleep(DWORD);
//DWORD GetTickCount(void);

#ifndef __WXGTK__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"
#include <ntiosupport.h>
#else

typedef unsigned int DWORD;
typedef unsigned short WORD;
typedef unsigned char BYTE;

#include <sys/io.h>
#include <unistd.h>

void Sleep(int nMs) { usleep(nMs * 1000); }

#endif

// CParallel deals with lowest-level access to the printer port hardware

class CParallel
{
	public:
		WORD m_wAddress;
		BYTE m_bModeOld;
		BYTE m_bModeMask;

	public:
		CParallel() {
			m_bModeMask=0;
			m_bModeOld=0x04;
			m_wAddress=0x378;
		}

		bool GetAccessRights() { // get the rights to access the port (needed for NT/2000/XP)
#ifndef __WXGTK__
			CBL_RequestAccessToPorts();
#else
		  /* Get access to the ports */
			if (ioperm(m_wAddress, 3, 1)) { perror("ioperm"); return(false);}
#endif
			return true;
		}  

		void FlashInit()
		{
			Mode(m_bModeOld & (~4));
			Sleep(10);
			Mode(m_bModeOld|4);
		}

		void Write(BYTE bValue) { // issue a byte on the printer port data lines and clock it in using STB
			BYTE bModeOld=(m_bModeOld & 0xfe) | 1;
			BYTE bModeNew=(bModeOld & 0xfe) | 0;
#ifndef __WXGTK__
			WORD w=m_wAddress;
			_asm {
				mov	dx,word ptr [w]
				mov	al, byte ptr [bValue]
				out	dx,al
				mov	al, [bModeOld]
				add	dl, 2
				out	dx,al
				mov	al, [bModeNew]
				out	dx, al
			}
#else
				outb(bValue, m_wAddress);
				outb(bModeOld, m_wAddress+2);
				outb(bModeNew, m_wAddress+2);
#endif
		}

		BYTE Read() { // read the mode bits issued by milksop
			BYTE b;

#ifndef __WXGTK__
			WORD w=m_wAddress;
			_asm {
				mov	dx,word ptr [w]
				add dl, 1
				in	al, dx
				mov byte ptr [b], al
			}
#else
			b=inb(m_wAddress+1);
#endif
			return(b);
		}

		void Mode(BYTE b) { // set the mode bits output by the printer port
			b&=~1;
			m_bModeOld = b;
#ifndef __WXGTK__
			WORD w=m_wAddress;
			_asm {
				mov	dx,word ptr [w]
				mov	al, [b]
				add	dl, 2
				out	dx,al
				out	dx,al
				out	dx,al
			}
#else
			outb(b, m_wAddress+2);
#endif
		}

};


// CParallelMilksop represents the protocol used to operate the Milksop over the parallel port

class CParallelMilksop : public CParallel
{
	public:
		
		BYTE m_bManufacturer;
		BYTE m_bDevice;
		bool m_faBlockProtected[8];

			// constant constSelectAddress : std_logic_vector(2 downto 0) := "000";
			// constant constSelectRead : std_logic_vector(2 downto 0) := "001";
			// constant constSelectAutoselect : std_logic_vector(2 downto 0) := "010";
			// constant constSelectProgram : std_logic_vector(2 downto 0) := "011";
			// constant constSelectErase : std_logic_vector(2 downto 0) := "100";
			// constant constSelectReset : std_logic_vector(2 downto 0) := "111";

		typedef enum {  // Operation modes that milksop offers
			TEM_ADDRESS = 0,
			TEM_READ = 1,
			TEM_AUTOSELECT = 2,
			TEM_PROGRAM = 3,
			TEM_ERASE = 4,
			TEM_RESET = 7
		} teMode;

	public:
		CParallelMilksop() {
			m_bManufacturer=0;
			m_bDevice=0;
			for(int n=0;n<8;n++) { m_faBlockProtected[n]=true; }
		}

		void SetPrinterPort(WORD w) { m_wAddress=w; }
		bool AwaitMilksopNoLongerBusy(DWORD dw=100000) { while(((Read() & 0x80)) && (dw!=0)) { Read(); dw--; }  if(dw==0) return false; return true; }
		BYTE GetReturnedNybble() {
			// nportJ1PrinterAck : out std_logic;  -- return nybble b3  0x40
			// portJ1PrinterPError : out std_logic; -- return nybble b2 0x20
			// portJ1PrinterSelect : out std_logic; -- return nybble b1 0x10
			// nportJ1PrinterFault : out std_logic; -- return nybble b0 0x08
			BYTE b= ((Read() >>3) &0x0f)^0xf;
//			ASSERT( b== (((Read() >>3) &0x0f)^0xf) );
			return b;
		}
		void SetMilksopMode(teMode temode) {
			// strobe action with nportPrinterJ1AutoFd = '1' is setting mode
			Mode(m_bModeOld | 0x02) ; // set Autofd to '1'
			Write( ((BYTE)(int)temode) | m_bModeMask );
			Mode(m_bModeOld & ~0x02) ; // set Autofd to '0'
		}

		void Power() {
			m_bModeMask |=0x08;
			SetMilksopMode(TEM_RESET);
			Sleep(500);
			m_bModeMask &=~0x08;
			SetMilksopMode(TEM_RESET);
		}

		void ResetFlashStateMachine() {
			SetMilksopMode(TEM_RESET);
			Write(0); // dummy write to initiate reset sequence
		}

		void SetAddress(DWORD dw) {
			SetMilksopMode(TEM_ADDRESS);
			Write((BYTE)(dw>>16));
			Write((BYTE)(dw>>8));
			Write((BYTE)dw);
		}

		void GetDeviceType()
		{
			SetAddress(0);
			SetMilksopMode(TEM_AUTOSELECT);
			Write(0); // dummy write to initiate autoselect sequence

//			return;
			
				// read from address 0 to get manufacturer (20h for ST)
			
			SetMilksopMode(TEM_READ);
			Write(0x55); // dummy write to initiate read sequence

			m_bManufacturer=GetReturnedNybble();
			Write(0x55);
			m_bManufacturer|=(GetReturnedNybble()<<4);

				// read action autoincrements to address 01, device code 
			
			Write(0x55); // dummy write to initiate read sequence
			m_bDevice=GetReturnedNybble();
			Write(0x55);
			m_bDevice|=(GetReturnedNybble()<<4);

			for(int n=0;n<8;n++) {

				BYTE b;

				SetAddress(n<<17);
				SetMilksopMode(TEM_READ);
			
				Write(0); // dummy write to initiate read sequence
				b=GetReturnedNybble();
				Write(0);
				b|=(GetReturnedNybble()<<4);

//y				ASSERT( (b==0) || (b==1) );

				m_faBlockProtected[n]= (b==1);
			}
			ResetFlashStateMachine();
		}

		bool ProgramAndVerify(BYTE * pba, DWORD dwLength, DWORD dwStartAddress) {
			ResetFlashStateMachine();
			SetAddress(dwStartAddress);
			DWORD dwLen=dwLength;
			BYTE *pbaProgram=pba;
			int nCountErrors=0;
			SetMilksopMode(TEM_PROGRAM);
			DWORD dwa=dwStartAddress;
			while(dwLen--) {

				if((dwa&0x1fff) == 0) { printf("%06X\r", dwa); Sleep(0); }
				dwa++;

				Write(*pbaProgram++);
//				Write(0xc8);
				if(!AwaitMilksopNoLongerBusy(500000)) {
					printf("\ntimeout at %06X writing %02X\n", dwa, *(pbaProgram-1));
					FlashInit();
					ResetFlashStateMachine();
					return false;			
				}
				
			}

			printf("\nverifying \n");

			ResetFlashStateMachine();
			SetAddress(dwStartAddress);
			SetMilksopMode(TEM_READ);
			BYTE b;
			dwa=dwStartAddress;
			while(dwLength--) {

				if((dwa&0x1fff) == 0) printf("%06X errs: %u\r", dwa, nCountErrors);
				dwa++;

				Write(0); // dummy write to initiate read sequence
				b=GetReturnedNybble();
				Write(0);
				b|=(GetReturnedNybble()<<4);
				
				if(b!=*pba++) nCountErrors++;
			}

			printf("\n");
			ResetFlashStateMachine();

			return nCountErrors==0;
		}

		void ReadBackData(BYTE * pba, DWORD dwLength, DWORD dwStartAddress) {
			ResetFlashStateMachine();
			SetAddress(dwStartAddress);
			SetMilksopMode(TEM_READ);
			BYTE b;
			DWORD dwa=dwStartAddress;
			while(dwLength--) {

				if((dwa&0xffff) == 0) printf("%06X\r", dwa);
				dwa++;

				Write(0); // dummy write to initiate read sequence
				b=GetReturnedNybble();
				Write(0);
				b|=(GetReturnedNybble()<<4);
				
				*pba++=b;
			}
			ResetFlashStateMachine();
		}

		bool EraseChip() {
			ResetFlashStateMachine();
			SetAddress(0x555);
			SetMilksopMode(TEM_ERASE);
			Write(0x10);
			return AwaitMilksopNoLongerBusy(5000000);				
		}

		void EraseBlockContainingAddress(DWORD dwAddress) {
			SetAddress(dwAddress);
			SetMilksopMode(TEM_ERASE);
			Write(0x30);
			AwaitMilksopNoLongerBusy();
		}

		wxString GetDeviceDestription() {
			wxString cs;
			cs=wxString::Format("Manufacturer: %02X, Device: %02X, protection: ",
				m_bManufacturer, m_bDevice
			);
			for(int n=0;n<8;n++) if(m_faBlockProtected[n]) cs+='1'; else cs+='0';
			return cs;
		}

};



#endif // !defined(AFX_MILK_H__7ADD5432_2C2B_42C8_9119_EE6E18F490FA__INCLUDED_)
