/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.ssh;

import com.isnetworks.ssh.FileBrowser;
import com.isnetworks.ssh.FileDisplayControl;
import com.isnetworks.ssh.FileListAWT;
import com.isnetworks.ssh.FileListItem;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.sshcommon.SSHFileTransferDialogControl;
import com.mindbright.util.ArraySort;
import com.mindbright.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class FileDisplayAWT
extends Panel
implements ActionListener,
ItemListener,
FileDisplayControl {
    private FileBrowser mBrowser;
    private Button mChgDirButton;
    private Button mDeleteButton;
    private Panel mFileButtonsInnerPanel;
    private Panel mFileButtonsPanel;
    private Panel mFileHeaderPanel;
    private FileListAWT mFileList;
    private Label mMachineDescriptionLabel;
    private String mMachineDescriptionText;
    private Label mFileSystemLocationLabel;
    private Button mMkDirButton;
    private Button mRefreshButton;
    private Button mRenameButton;
    private Frame mOwnerFrame;
    private SSHFileTransferDialogControl mFileXferDialog;

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            FileListItem fileListItem;
            String string = actionEvent.getActionCommand();
            if ("chdir".equals(string)) {
                String string2 = SSHMiscDialogs.textInput("Change directory", "Directory", this.mOwnerFrame, this.getFileSystemLocationLabelText());
                if (string2 != null) {
                    this.mBrowser.changeDirectory(string2);
                }
            } else if ("mkdir".equals(string)) {
                String string3 = SSHMiscDialogs.textInput("Make directory relative to current path", "Directory name", this.mOwnerFrame);
                if (string3 != null) {
                    this.mBrowser.makeDirectory(string3);
                }
            } else if ("rename".equals(string)) {
                FileListItem fileListItem2 = this.getSelectedFile();
                String string4 = SSHMiscDialogs.textInput("Rename file", "New file name", this.mOwnerFrame, fileListItem2.getName());
                if (string4 != null) {
                    this.mBrowser.rename(fileListItem2, string4);
                }
            } else if ("delete".equals(string)) {
                this.mBrowser.delete(this.getSelectedFiles());
            } else if (!"refresh".equals(string) && (fileListItem = this.mFileList.getFileListItem(string)) != null) {
                this.mBrowser.fileDoubleClicked(fileListItem);
            }
            this.mBrowser.refresh();
        }
        catch (Exception exception) {
            this.mFileXferDialog.logError(exception);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableButtons();
    }

    public FileDisplayAWT(Frame frame, String string, SSHFileTransferDialogControl sSHFileTransferDialogControl) {
        super(new BorderLayout(2, 10));
        this.mOwnerFrame = frame;
        this.mFileXferDialog = sSHFileTransferDialogControl;
        this.mMachineDescriptionLabel = new Label(string);
        this.mMachineDescriptionText = string;
        this.add((Component)this.getFileHeaderPanel(), "North");
        this.add((Component)this.getFileList(), "Center");
        this.add((Component)this.getFileButtonsPanel(), "South");
    }

    private Panel getFileHeaderPanel() {
        if (this.mFileHeaderPanel == null) {
            this.mFileHeaderPanel = new Panel(new GridLayout(2, 1));
            this.mFileHeaderPanel.add(this.getMachineDescriptionLabel());
            this.mFileHeaderPanel.add(this.getFileSystemLocationLabel());
        }
        return this.mFileHeaderPanel;
    }

    private Label getMachineDescriptionLabel() {
        return this.mMachineDescriptionLabel;
    }

    private Label getFileSystemLocationLabel() {
        if (this.mFileSystemLocationLabel == null) {
            this.mFileSystemLocationLabel = new Label("");
        }
        return this.mFileSystemLocationLabel;
    }

    private Panel getFileButtonsPanel() {
        if (this.mFileButtonsPanel == null) {
            this.mFileButtonsPanel = new Panel(new BorderLayout());
            this.mFileButtonsPanel.add((Component)this.getFileButtonsInnerPanel(), "North");
        }
        return this.mFileButtonsPanel;
    }

    private Panel getFileButtonsInnerPanel() {
        if (this.mFileButtonsInnerPanel == null) {
            this.mFileButtonsInnerPanel = new Panel(new GridLayout(1, 5));
            this.mFileButtonsInnerPanel.add(this.getChgDirButton());
            this.mFileButtonsInnerPanel.add(this.getMkDirButton());
            this.mFileButtonsInnerPanel.add(this.getRenameButton());
            this.mFileButtonsInnerPanel.add(this.getDeleteButton());
            this.mFileButtonsInnerPanel.add(this.getRefreshButton());
        }
        return this.mFileButtonsInnerPanel;
    }

    private Button getChgDirButton() {
        if (this.mChgDirButton == null) {
            this.mChgDirButton = new Button("ChgDir");
            this.mChgDirButton.setActionCommand("chdir");
            this.mChgDirButton.addActionListener(this);
        }
        return this.mChgDirButton;
    }

    private Button getMkDirButton() {
        if (this.mMkDirButton == null) {
            this.mMkDirButton = new Button("MkDir");
            this.mMkDirButton.setActionCommand("mkdir");
            this.mMkDirButton.addActionListener(this);
        }
        return this.mMkDirButton;
    }

    private Button getRenameButton() {
        if (this.mRenameButton == null) {
            this.mRenameButton = new Button("Rename");
            this.mRenameButton.setActionCommand("rename");
            this.mRenameButton.addActionListener(this);
        }
        return this.mRenameButton;
    }

    private Button getDeleteButton() {
        if (this.mDeleteButton == null) {
            this.mDeleteButton = new Button("Delete");
            this.mDeleteButton.setActionCommand("delete");
            this.mDeleteButton.addActionListener(this);
        }
        return this.mDeleteButton;
    }

    private Button getRefreshButton() {
        if (this.mRefreshButton == null) {
            this.mRefreshButton = new Button("Refresh");
            this.mRefreshButton.setActionCommand("refresh");
            this.mRefreshButton.addActionListener(this);
        }
        return this.mRefreshButton;
    }

    private FileListAWT getFileList() {
        if (this.mFileList == null) {
            this.mFileList = new FileListAWT();
            this.mFileList.setMultipleMode(true);
            this.mFileList.addActionListener(this);
            this.mFileList.addItemListener(this);
        }
        return this.mFileList;
    }

    private void enableButtons() {
        this.mRenameButton.setEnabled(this.mFileList.getSelectionCount() == 1);
        this.mDeleteButton.setEnabled(this.mFileList.getSelectionCount() > 0);
    }

    public String getFileSystemLocationLabelText() {
        return this.getFileSystemLocationLabel().getText();
    }

    public void setFileSystemLocationLabelText(String string) {
        this.getFileSystemLocationLabel().setText(string);
    }

    public void setFileList(Vector vector, Vector vector2, String string, String string2) {
        Object object;
        int n;
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        this.setFileSystemLocationLabelText(string);
        int n2 = vector.size();
        int n3 = vector2.size();
        long l = 0L;
        ArraySort.Comparable[] comparableArray = new FileListItem[n2 + n3];
        for (n = 0; n < n2; ++n) {
            comparableArray[n] = (FileListItem)vector.elementAt(n);
        }
        for (n = 0; n < n3; ++n) {
            comparableArray[n + n2] = object = (FileListItem)vector2.elementAt(n);
            l += ((FileListItem)object).getSize();
        }
        object = "";
        if (l > 0L) {
            object = " (" + StringUtil.nBytesToString(l, 4) + ")";
        }
        this.getMachineDescriptionLabel().setText(this.mMachineDescriptionText + " : " + n3 + " file" + (n3 > 1 ? "s" : "") + (String)object);
        ArraySort.sort(comparableArray, 0, n2);
        ArraySort.sort(comparableArray, n2, n2 + n3);
        vector.setSize(0);
        vector2.setSize(0);
        this.mFileList.setListItems((FileListItem[])comparableArray);
        this.mFileList.invalidate();
        this.enableButtons();
        this.mFileButtonsInnerPanel.invalidate();
    }

    public void setFileBrowser(FileBrowser fileBrowser) {
        this.mBrowser = fileBrowser;
    }

    public FileListItem getSelectedFile() {
        return this.mFileList.getSelectedFileListItem();
    }

    public FileListItem[] getSelectedFiles() {
        return this.mFileList.getSelectedFileListItems();
    }
}

