/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.ssh;

import com.isnetworks.ssh.FileBrowser;
import com.isnetworks.ssh.FileDisplayControl;
import com.isnetworks.ssh.FileListItem;
import com.isnetworks.ssh.FileListSwing;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.sshcommon.SSHFileTransferDialogControl;
import com.mindbright.util.ArraySort;
import com.mindbright.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileDisplaySwing
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener,
FileDisplayControl {
    private FileBrowser mBrowser;
    private JButton mChgDirButton;
    private JButton mDeleteButton;
    private JPanel mFileHeaderPanel;
    private FileListSwing mFileList;
    private JLabel mMachineDescriptionLabel;
    private String mMachineDescriptionText;
    private JLabel mFileSystemLocationLabel;
    private JButton mMkDirButton;
    private JButton mRefreshButton;
    private JButton mRenameButton;
    private Frame mOwnerFrame;
    private SSHFileTransferDialogControl mFileXferDialog;

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if ("chdir".equals(string)) {
                String string2 = SSHMiscDialogs.textInput("Change directory", "Directory", this.mOwnerFrame, this.getFileSystemLocationLabelText());
                if (string2 != null) {
                    this.mBrowser.changeDirectory(string2);
                }
            } else if ("mkdir".equals(string)) {
                String string3 = SSHMiscDialogs.textInput("Make directory relative to current path", "Directory name", this.mOwnerFrame);
                if (string3 != null) {
                    this.mBrowser.makeDirectory(string3);
                }
            } else if ("rename".equals(string)) {
                FileListItem fileListItem = this.getSelectedFile();
                String string4 = SSHMiscDialogs.textInput("Rename file", "New file name", this.mOwnerFrame, fileListItem.getName());
                if (string4 != null) {
                    this.mBrowser.rename(fileListItem, string4);
                }
            } else if ("delete".equals(string)) {
                this.mBrowser.delete(this.getSelectedFiles());
            } else if ("refresh".equals(string)) {
                // empty if block
            }
            this.mBrowser.refresh();
        }
        catch (Exception exception) {
            this.mFileXferDialog.logError(exception);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
        this.mFileList.ensureIndexIsVisible(this.mFileList.getLeadSelectionIndex());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            int n = this.mFileList.locationToIndex(mouseEvent.getPoint());
            this.mFileList.ensureIndexIsVisible(n);
            FileListItem fileListItem = this.mFileList.getFileListItem((String)this.mFileList.getModel().getElementAt(n));
            if (fileListItem != null) {
                try {
                    this.mBrowser.fileDoubleClicked(fileListItem);
                    this.mBrowser.refresh();
                }
                catch (Exception exception) {
                    this.mFileXferDialog.logError(exception);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public FileDisplaySwing(Frame frame, String string, SSHFileTransferDialogControl sSHFileTransferDialogControl) {
        super(new BorderLayout());
        this.mOwnerFrame = frame;
        this.mFileXferDialog = sSHFileTransferDialogControl;
        this.mMachineDescriptionLabel = new JLabel(string);
        this.mMachineDescriptionText = string;
        this.add("North", this.getFileHeaderPanel());
        FileListSwing fileListSwing = this.getFileList();
        JScrollPane jScrollPane = new JScrollPane(fileListSwing, 20, 30);
        this.add("Center", jScrollPane);
        this.add("South", this.getFileButtonsPanel());
    }

    private JPanel getFileHeaderPanel() {
        if (this.mFileHeaderPanel == null) {
            this.mFileHeaderPanel = new JPanel(new GridLayout(2, 1));
            this.mFileHeaderPanel.add(this.getMachineDescriptionLabel());
            this.mFileHeaderPanel.add(this.getFileSystemLocationLabel());
        }
        return this.mFileHeaderPanel;
    }

    private JLabel getMachineDescriptionLabel() {
        return this.mMachineDescriptionLabel;
    }

    private JLabel getFileSystemLocationLabel() {
        if (this.mFileSystemLocationLabel == null) {
            this.mFileSystemLocationLabel = new JLabel("");
        }
        return this.mFileSystemLocationLabel;
    }

    private JPanel getFileButtonsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 3, 5, 5));
        jPanel.add(this.getChgDirButton());
        jPanel.add(this.getMkDirButton());
        jPanel.add(this.getRenameButton());
        jPanel.add(this.getDeleteButton());
        jPanel.add(this.getRefreshButton());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(" "), "North");
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)new JLabel(""), "Center");
        return jPanel2;
    }

    private JButton makeButton(String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        return jButton;
    }

    private JButton getChgDirButton() {
        if (this.mChgDirButton == null) {
            this.mChgDirButton = this.makeButton("ChDir", "chdir");
        }
        return this.mChgDirButton;
    }

    private JButton getMkDirButton() {
        if (this.mMkDirButton == null) {
            this.mMkDirButton = this.makeButton("MkDir", "mkdir");
        }
        return this.mMkDirButton;
    }

    private JButton getRenameButton() {
        if (this.mRenameButton == null) {
            this.mRenameButton = this.makeButton("Rename", "rename");
        }
        return this.mRenameButton;
    }

    private JButton getDeleteButton() {
        if (this.mDeleteButton == null) {
            this.mDeleteButton = this.makeButton("Delete", "delete");
        }
        return this.mDeleteButton;
    }

    private JButton getRefreshButton() {
        if (this.mRefreshButton == null) {
            this.mRefreshButton = this.makeButton("Refresh", "refresh");
        }
        return this.mRefreshButton;
    }

    private FileListSwing getFileList() {
        if (this.mFileList == null) {
            this.mFileList = new FileListSwing();
            this.mFileList.addListSelectionListener(this);
            this.mFileList.addMouseListener(this);
        }
        return this.mFileList;
    }

    private void enableButtons() {
        this.mRenameButton.setEnabled(this.mFileList.getSelectionCount() == 1);
        this.mDeleteButton.setEnabled(this.mFileList.getSelectionCount() > 0);
    }

    public String getFileSystemLocationLabelText() {
        return this.getFileSystemLocationLabel().getText();
    }

    public void setFileSystemLocationLabelText(String string) {
        this.getFileSystemLocationLabel().setText(string);
    }

    public void setFileList(Vector vector, Vector vector2, String string, String string2) {
        Object object;
        int n;
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        this.setFileSystemLocationLabelText(string);
        int n2 = vector.size();
        int n3 = vector2.size();
        long l = 0L;
        ArraySort.Comparable[] comparableArray = new FileListItem[n2 + n3];
        for (n = 0; n < n2; ++n) {
            comparableArray[n] = (FileListItem)vector.elementAt(n);
        }
        for (n = 0; n < n3; ++n) {
            comparableArray[n + n2] = object = (FileListItem)vector2.elementAt(n);
            l += ((FileListItem)object).getSize();
        }
        object = "";
        if (l > 0L) {
            object = " (" + StringUtil.nBytesToString(l, 4) + ")";
        }
        this.getMachineDescriptionLabel().setText(this.mMachineDescriptionText + " : " + n3 + " file" + (n3 > 1 ? "s" : "") + (String)object);
        ArraySort.sort(comparableArray, 0, n2);
        ArraySort.sort(comparableArray, n2, n2 + n3);
        vector.setSize(0);
        vector2.setSize(0);
        this.mFileList.setListItems((FileListItem[])comparableArray);
        this.enableButtons();
    }

    public void setFileBrowser(FileBrowser fileBrowser) {
        this.mBrowser = fileBrowser;
    }

    public FileListItem getSelectedFile() {
        return this.mFileList.getSelectedFileListItem();
    }

    public FileListItem[] getSelectedFiles() {
        return this.mFileList.getSelectedFileListItems();
    }
}

