/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.net;

import com.mindbright.net.HttpHeader;
import com.mindbright.net.ProxyAuthenticator;
import com.mindbright.net.SocketFactory;
import com.mindbright.net.WebProxyException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class WebProxyTunnelSocket {
    private String proxyHost;
    private int proxyPort;
    private String targetHost;
    private int targetPort;
    private Socket socket;
    HttpHeader responseHeader;
    String serverDesc;

    public HttpHeader getResponseHeader() {
        return this.responseHeader;
    }

    public String getServerDesc() {
        return this.serverDesc;
    }

    private WebProxyTunnelSocket(String string, int n, String string2, int n2, long l) throws IOException, UnknownHostException {
        this.socket = SocketFactory.newSocket(string2, n2, l);
        this.proxyHost = string2;
        this.proxyPort = n2;
        this.targetHost = this.targetHost;
        this.targetPort = this.targetPort;
    }

    public static Socket getProxy(String string, int n, String string2, int n2, ProxyAuthenticator proxyAuthenticator, String string3) throws IOException, UnknownHostException {
        return WebProxyTunnelSocket.getProxy(string, n, string2, n2, 0L, null, proxyAuthenticator, string3);
    }

    public static Socket getProxy(String string, int n, String string2, int n2, long l, ProxyAuthenticator proxyAuthenticator, String string3) throws IOException, UnknownHostException {
        return WebProxyTunnelSocket.getProxy(string, n, string2, n2, l, null, proxyAuthenticator, string3);
    }

    public static Socket getProxy(String string, int n, String string2, int n2, String string3, ProxyAuthenticator proxyAuthenticator, String string4) throws IOException, UnknownHostException {
        return WebProxyTunnelSocket.getProxy(string, n, string2, n2, 0L, string3, proxyAuthenticator, string4);
    }

    public static Socket getProxy(String string, int n, String string2, int n2, long l, String string3, ProxyAuthenticator proxyAuthenticator, String string4) throws IOException, UnknownHostException {
        String string5;
        WebProxyTunnelSocket webProxyTunnelSocket = new WebProxyTunnelSocket(string, n, string2, n2, l);
        int n3 = -1;
        try {
            InputStream inputStream = webProxyTunnelSocket.socket.getInputStream();
            OutputStream outputStream = webProxyTunnelSocket.socket.getOutputStream();
            HttpHeader httpHeader = new HttpHeader();
            if (string3 == null) {
                string3 = "";
            }
            httpHeader.setStartLine("CONNECT " + string3 + string + ":" + n + " HTTP/1.0");
            httpHeader.setHeaderField("User-Agent", string4);
            httpHeader.setHeaderField("Pragma", "No-Cache");
            httpHeader.setHeaderField("Proxy-Connection", "Keep-Alive");
            httpHeader.writeTo(outputStream);
            webProxyTunnelSocket.responseHeader = new HttpHeader(inputStream);
            string5 = webProxyTunnelSocket.responseHeader.getHeaderField("server");
            if (webProxyTunnelSocket.responseHeader.getStatus() == 407 && proxyAuthenticator != null) {
                String string6 = webProxyTunnelSocket.responseHeader.getProxyAuthMethod();
                if (!"basic".equalsIgnoreCase(string6)) {
                    if ("digest".equalsIgnoreCase(string6)) {
                        throw new IOException("We don't support 'Digest' HTTP Authentication");
                    }
                    throw new IOException("Unknown HTTP Authentication method '" + string6 + "'");
                }
                String string7 = webProxyTunnelSocket.responseHeader.getProxyAuthRealm();
                if (string7 == null) {
                    string7 = "";
                }
                webProxyTunnelSocket.socket.close();
                webProxyTunnelSocket = new WebProxyTunnelSocket(string, n, string2, n2, l);
                inputStream = webProxyTunnelSocket.socket.getInputStream();
                outputStream = webProxyTunnelSocket.socket.getOutputStream();
                String string8 = proxyAuthenticator.getProxyUsername("HTTP Proxy", string7);
                String string9 = proxyAuthenticator.getProxyPassword("HTTP Proxy", string7);
                httpHeader.setBasicProxyAuth(string8, string9);
                httpHeader.writeTo(outputStream);
                webProxyTunnelSocket.responseHeader = new HttpHeader(inputStream);
            }
            n3 = webProxyTunnelSocket.responseHeader.getStatus();
        }
        catch (SocketException socketException) {
            throw new SocketException("Error communicating with proxy server " + string2 + ":" + n2 + " (" + socketException.getMessage() + ")");
        }
        if (n3 < 200 || n3 > 299) {
            throw new WebProxyException("Proxy tunnel setup failed: " + webProxyTunnelSocket.responseHeader.getStartLine());
        }
        webProxyTunnelSocket.serverDesc = string5;
        return webProxyTunnelSocket.socket;
    }

    public String toString() {
        return "WebProxyTunnelSocket[addr=" + this.socket.getInetAddress() + ",port=" + this.socket.getPort() + ",localport=" + this.socket.getLocalPort() + "]";
    }
}

