/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.digest;

import com.mindbright.jca.security.DigestException;
import com.mindbright.security.digest.MD512BitBlock;

public final class SHA256
extends MD512BitBlock {
    public static final int DIGEST_LENGTH = 32;
    private static final int H0 = 1779033703;
    private static final int H1 = -1150833019;
    private static final int H2 = 1013904242;
    private static final int H3 = -1521486534;
    private static final int H4 = 1359893119;
    private static final int H5 = -1694144372;
    private static final int H6 = 528734635;
    private static final int H7 = 1541459225;
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int[] hash = new int[8];
    private int[] W = new int[64];

    private static final int RR(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    protected void transform(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.hash[0];
        int n6 = this.hash[1];
        int n7 = this.hash[2];
        int n8 = this.hash[3];
        int n9 = this.hash[4];
        int n10 = this.hash[5];
        int n11 = this.hash[6];
        int n12 = this.hash[7];
        for (n4 = 0; n4 < 16; ++n4) {
            this.W[n4] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        }
        for (n4 = 16; n4 < 64; ++n4) {
            n3 = SHA256.RR(this.W[n4 - 15], 7) ^ SHA256.RR(this.W[n4 - 15], 18) ^ this.W[n4 - 15] >>> 3;
            n2 = SHA256.RR(this.W[n4 - 2], 17) ^ SHA256.RR(this.W[n4 - 2], 19) ^ this.W[n4 - 2] >>> 10;
            this.W[n4] = this.W[n4 - 16] + n3 + this.W[n4 - 7] + n2;
        }
        for (n4 = 0; n4 < 64; ++n4) {
            n3 = SHA256.RR(n5, 2) ^ SHA256.RR(n5, 13) ^ SHA256.RR(n5, 22);
            n2 = n5 & n6 ^ n5 & n7 ^ n6 & n7;
            int n13 = SHA256.RR(n9, 6) ^ SHA256.RR(n9, 11) ^ SHA256.RR(n9, 25);
            int n14 = n9 & n10 ^ ~n9 & n11;
            int n15 = n12 + n13 + n14 + K[n4] + this.W[n4];
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8 + n15;
            n8 = n7;
            n7 = n6;
            n6 = n5;
            n5 = n15 + n3 + n2;
        }
        this.hash[0] = this.hash[0] + n5;
        this.hash[1] = this.hash[1] + n6;
        this.hash[2] = this.hash[2] + n7;
        this.hash[3] = this.hash[3] + n8;
        this.hash[4] = this.hash[4] + n9;
        this.hash[5] = this.hash[5] + n10;
        this.hash[6] = this.hash[6] + n11;
        this.hash[7] = this.hash[7] + n12;
    }

    public SHA256() {
        super("SHA256", 32);
    }

    protected MD512BitBlock cloneInternal() {
        SHA256 sHA256 = new SHA256();
        for (int i = 0; i < this.hash.length; ++i) {
            sHA256.hash[i] = this.hash[i];
        }
        return sHA256;
    }

    protected void engineReset() {
        this.hash[0] = 1779033703;
        this.hash[1] = -1150833019;
        this.hash[2] = 1013904242;
        this.hash[3] = -1521486534;
        this.hash[4] = 1359893119;
        this.hash[5] = -1694144372;
        this.hash[6] = 528734635;
        this.hash[7] = 1541459225;
        this.count = 0L;
        this.rest = 0;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        int n3;
        int n4 = n3 = this.rest < 56 ? 56 - this.rest : 120 - this.rest;
        if (n2 < 32) {
            throw new DigestException("SHA256, output buffer too short");
        }
        this.count *= 8L;
        byte[] byArray2 = new byte[]{(byte)(this.count >>> 56), (byte)(this.count >>> 58), (byte)(this.count >>> 40), (byte)(this.count >>> 32), (byte)(this.count >>> 24), (byte)(this.count >>> 16), (byte)(this.count >>> 8), (byte)this.count};
        this.engineUpdate(MD512BitBlock.md4_padding, 0, n3);
        this.engineUpdate(byArray2, 0, 8);
        for (int i = 0; i < this.hash.length; ++i) {
            int n5 = this.hash[i];
            byArray[n++] = (byte)(n5 >>> 24 & 0xFF);
            byArray[n++] = (byte)(n5 >>> 16 & 0xFF);
            byArray[n++] = (byte)(n5 >>> 8 & 0xFF);
            byArray[n++] = (byte)(n5 & 0xFF);
        }
        this.engineReset();
        return 32;
    }
}

