/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.x509;

import com.mindbright.asn1.ASN1DER;
import com.mindbright.asn1.ASN1OIDRegistry;
import com.mindbright.asn1.ASN1Object;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.jca.security.cert.CertificateEncodingException;
import com.mindbright.jca.security.cert.CertificateException;
import com.mindbright.jca.security.spec.DSAPublicKeySpec;
import com.mindbright.jca.security.spec.RSAPublicKeySpec;
import com.mindbright.security.pkcs1.DSAParams;
import com.mindbright.security.pkcs1.DSAPublicKey;
import com.mindbright.security.pkcs1.RSAPublicKey;
import com.mindbright.security.x509.BasicConstraints;
import com.mindbright.security.x509.Certificate;
import com.mindbright.security.x509.Extension;
import com.mindbright.security.x509.Extensions;
import com.mindbright.security.x509.KeyUsage;
import com.mindbright.security.x509.SubjectKeyIdentifier;
import com.mindbright.security.x509.SubjectPublicKeyInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class X509Certificate
extends com.mindbright.jca.security.cert.Certificate {
    private byte[] encoded;
    private Certificate certificate;
    static /* synthetic */ Class class$com$mindbright$security$x509$SubjectKeyIdentifier;
    static /* synthetic */ Class class$com$mindbright$security$x509$KeyUsage;
    static /* synthetic */ Class class$com$mindbright$security$x509$BasicConstraints;

    public X509Certificate(byte[] byArray) {
        super("X.509");
        this.encoded = byArray;
        this.certificate = new Certificate();
        ASN1OIDRegistry.addModule("com.mindbright.security.x509");
        ASN1OIDRegistry.addModule("com.mindbright.security.pkcs1");
        try {
            ASN1DER aSN1DER = new ASN1DER();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            aSN1DER.decode(byteArrayInputStream, this.certificate);
        }
        catch (IOException iOException) {
            throw new Error("Internal error decoding DER encoded X.509 cert: " + iOException.getMessage());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.encoded;
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    public String toString() {
        return "X509 Certificate: \n  subject: " + this.getSubjectDN() + "\n" + "  issuer: " + this.getIssuerDN() + "\n" + "  version: " + (this.getVersion() + 1) + "\n" + "  pubalg: " + this.getPubAlgName() + "\n" + "  serialNo: " + this.getSerialNumber() + "\n\n" + " Extensions:\n\n" + this.getExtensions();
    }

    public String getIssuerDN() {
        return this.certificate.tbsCertificate.issuer.getRFC2253Value();
    }

    public String getSubjectDN() {
        return this.certificate.tbsCertificate.subject.getRFC2253Value();
    }

    public BigInteger getSerialNumber() {
        return this.certificate.tbsCertificate.serialNumber.getValue();
    }

    public String getPubAlgName() {
        return this.certificate.tbsCertificate.subjectPublicKeyInfo.algorithm.algorithmName();
    }

    private ASN1Object getExtensionWithOID(String string, Class clazz) {
        try {
            Extensions extensions = this.certificate.tbsCertificate.extensions;
            for (int i = 0; i < extensions.getCount(); ++i) {
                Extension extension = (Extension)extensions.getComponent(i);
                if (!extension.extnID.getString().equals(string)) continue;
                ASN1DER aSN1DER = new ASN1DER();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extension.extnValue.getRaw());
                ASN1Object aSN1Object = (ASN1Object)clazz.newInstance();
                aSN1DER.decode(byteArrayInputStream, aSN1Object);
                return aSN1Object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        return (SubjectKeyIdentifier)this.getExtensionWithOID("2.5.29.14", class$com$mindbright$security$x509$SubjectKeyIdentifier == null ? (class$com$mindbright$security$x509$SubjectKeyIdentifier = X509Certificate.class$("com.mindbright.security.x509.SubjectKeyIdentifier")) : class$com$mindbright$security$x509$SubjectKeyIdentifier);
    }

    public KeyUsage getKeyUsage() {
        return (KeyUsage)this.getExtensionWithOID("2.5.29.15", class$com$mindbright$security$x509$KeyUsage == null ? (class$com$mindbright$security$x509$KeyUsage = X509Certificate.class$("com.mindbright.security.x509.KeyUsage")) : class$com$mindbright$security$x509$KeyUsage);
    }

    public BasicConstraints getBasicConstraints() {
        return (BasicConstraints)this.getExtensionWithOID("2.5.29.19", class$com$mindbright$security$x509$BasicConstraints == null ? (class$com$mindbright$security$x509$BasicConstraints = X509Certificate.class$("com.mindbright.security.x509.BasicConstraints")) : class$com$mindbright$security$x509$BasicConstraints);
    }

    public String getExtensions() {
        String string = "";
        try {
            Extensions extensions = this.certificate.tbsCertificate.extensions;
            for (int i = 0; i < extensions.getCount(); ++i) {
                String string2;
                Extension extension = (Extension)extensions.getComponent(i);
                String string3 = extension.extnID.getString();
                String string4 = string2 = extension.critical.getValue() ? "yes" : "no ";
                String string5 = string3.equals("2.5.29.14") ? this.getKeyUsage().toString() : (string3.equals("2.5.29.15") ? this.getSubjectKeyIdentifier().toString() : (string3.equals("2.5.29.19") ? this.getBasicConstraints().toString() : string3));
                string = string + "  critical: " + string2 + " " + string5 + "\n";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public int getVersion() {
        int n = 0;
        try {
            n = this.certificate.tbsCertificate.version.getValue().intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public PublicKey getPublicKey() {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.certificate.tbsCertificate.subjectPublicKeyInfo;
        String string = subjectPublicKeyInfo.algorithm.algorithmName().toUpperCase();
        ASN1DER aSN1DER = new ASN1DER();
        if (string.startsWith("RSA")) {
            RSAPublicKey rSAPublicKey = new RSAPublicKey();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(subjectPublicKeyInfo.subjectPublicKey.getBitArray());
            try {
                aSN1DER.decode(byteArrayInputStream, rSAPublicKey);
            }
            catch (Exception exception) {
                throw new Error("Internal error decoding SubjectPublicKeyInfo.subjectPublicKey: " + exception.getMessage());
            }
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.modulus.getValue(), rSAPublicKey.publicExponent.getValue());
                return keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new Error("Error creating RSA key: " + exception.getMessage());
            }
        }
        if (string.startsWith("DSA")) {
            DSAPublicKey dSAPublicKey = new DSAPublicKey();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(subjectPublicKeyInfo.subjectPublicKey.getBitArray());
            try {
                aSN1DER.decode(byteArrayInputStream, dSAPublicKey);
            }
            catch (Exception exception) {
                throw new Error("Internal error decoding SubjectPublicKeyInfo.subjectPublicKey: " + exception.getMessage());
            }
            BigInteger bigInteger = dSAPublicKey.getValue();
            DSAParams dSAParams = (DSAParams)subjectPublicKeyInfo.algorithm.parameters.getValue();
            BigInteger bigInteger2 = dSAParams.p.getValue();
            BigInteger bigInteger3 = dSAParams.q.getValue();
            BigInteger bigInteger4 = dSAParams.g.getValue();
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4);
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new Error("Error creating DSA key: " + exception.getMessage());
            }
        }
        throw new Error("Internal error decoding publicKey: unknown algorithm");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

