/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSHChannelController;
import com.mindbright.ssh.SSHListenChannel;
import com.mindbright.ssh.SSHPdu;
import com.mindbright.ssh.SSHTunnel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class SSHFtpTunnel
extends SSHTunnel {
    public static final String TUNNEL_NAME = "#FTP";
    public static final int MAX_REMOTE_LISTEN = 10;
    boolean havePORT;
    boolean waitingPASVResponse;
    String localAddrPASVStr;
    InetAddress localAddr;
    byte[][] newPortMsg;
    static int timeWaitKludgeToggler;
    static Object timeWaitKludgeCrit;

    public SSHFtpTunnel(Socket socket, int n, int n2, SSHChannelController sSHChannelController) throws IOException {
        super(socket, n, n2, sSHChannelController);
        int n3;
        int n4;
        int n5;
        int n6;
        this.havePORT = sSHChannelController.sshAsClient().havePORTFtp;
        if (this.havePORT) {
            int n7 = sSHChannelController.sshAsClient().firstFTPPort;
            byte[] byArray = sSHChannelController.sshAsClient().getServerRealAddr().getAddress();
            n6 = byArray[0] & 0xFF;
            n5 = byArray[1] & 0xFF;
            n4 = byArray[2] & 0xFF;
            n3 = byArray[3] & 0xFF;
            this.newPortMsg = new byte[10][1];
            for (int i = 0; i < 10; ++i) {
                int n8 = n7 + i >>> 8 & 0xFF;
                int n9 = n7 + i & 0xFF;
                String string = "PORT " + n6 + "," + n5 + "," + n4 + "," + n3 + "," + n8 + "," + n9 + "\n";
                this.newPortMsg[i] = string.getBytes();
            }
        }
        this.localAddr = sSHChannelController.sshAsClient().getLocalAddr();
        byte[] byArray = sSHChannelController.sshAsClient().getLocalAddr().getAddress();
        if (byArray[0] == 0) {
            byArray = InetAddress.getLocalHost().getAddress();
        }
        n6 = byArray[0] & 0xFF;
        n5 = byArray[1] & 0xFF;
        n4 = byArray[2] & 0xFF;
        n3 = byArray[3] & 0xFF;
        this.localAddrPASVStr = n6 + "," + n5 + "," + n4 + "," + n3;
    }

    boolean parseHostAndPort(String string, int[] nArray) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        try {
            for (int i = 0; i < 6; ++i) {
                if (i == 5) {
                    n2 = string.indexOf(41, n);
                    if (n2 == -1) {
                        n2 = string.indexOf(13, n);
                    } else if (n2 == -1) {
                        n2 = string.indexOf(10, n);
                    }
                } else {
                    n2 = string.indexOf(44, n);
                }
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                nArray[i] = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(SSHPdu sSHPdu) {
        String string = new String(sSHPdu.rawData(), sSHPdu.rawOffset(), sSHPdu.rawSize());
        if (string.startsWith("PASV") || string.startsWith("pasv")) {
            this.waitingPASVResponse = true;
        } else if (string.startsWith("PORT ") || string.startsWith("port ")) {
            int[] nArray;
            if (!this.havePORT) {
                this.controller.alert("Ftp-client is using PORT commands, either \nenable 'passive mode' in the ftp-client or \nenable 'ftp PORT' in 'SSH Settings' and reconnect.");
            } else if (this.parseHostAndPort(string = string.substring(5), nArray = new int[6])) {
                String string2;
                byte[] byArray;
                byte[] byArray2 = sSHPdu.rawData();
                Object object = timeWaitKludgeCrit;
                synchronized (object) {
                    byArray = this.newPortMsg[timeWaitKludgeToggler];
                    string2 = TUNNEL_NAME + timeWaitKludgeToggler;
                    timeWaitKludgeToggler = (timeWaitKludgeToggler + 1) % 10;
                }
                int n = byArray.length;
                int n2 = sSHPdu.rawOffset() - 4;
                byArray2[n2++] = (byte)(n >>> 24 & 0xFF);
                byArray2[n2++] = (byte)(n >>> 16 & 0xFF);
                byArray2[n2++] = (byte)(n >>> 8 & 0xFF);
                byArray2[n2++] = (byte)(n & 0xFF);
                System.arraycopy(byArray, 0, byArray2, n2, n);
                sSHPdu.rawAdjustSize(n2 + n);
                String string3 = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                int n3 = nArray[4] << 8 | nArray[5];
                this.controller.addHostMapTemporary(string2, string3, n3);
            } else {
                this.controller.alert("Bug in SSHFtpTunnel (PORT), please report: " + string);
            }
        }
        super.receive(sSHPdu);
    }

    public void transmit(SSHPdu sSHPdu) {
        SSHListenChannel sSHListenChannel = null;
        String string = new String(sSHPdu.rawData(), sSHPdu.rawOffset(), sSHPdu.rawSize());
        if (this.waitingPASVResponse && string.startsWith("227 ")) {
            int[] nArray;
            this.waitingPASVResponse = false;
            if (this.parseHostAndPort(string = string.substring(27), nArray = new int[6])) {
                String string2 = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                int n = nArray[4] << 8 | nArray[5];
                try {
                    sSHListenChannel = this.controller.newListenChannel(this.localAddr.getHostAddress(), 0, string2, n, "general");
                }
                catch (IOException iOException) {
                    this.controller.alert("Error in FtpTunnel: " + iOException.toString());
                    sSHListenChannel = null;
                }
                if (sSHListenChannel != null) {
                    sSHListenChannel.setTemporaryListener(true);
                    int n2 = sSHListenChannel.getListenPort();
                    int n3 = n2 >>> 8 & 0xFF;
                    int n4 = n2 & 0xFF;
                    string = "227 Entering Passive Mode (" + this.localAddrPASVStr + "," + n3 + "," + n4 + ")\n";
                    byte[] byArray = string.getBytes();
                    sSHPdu.rawSetData(byArray);
                }
            } else {
                this.controller.alert("Bug in SSHFtpTunnel (PASV), please report: " + string);
            }
        }
        super.transmit(sSHPdu);
    }

    public String getDescription() {
        if (this.ioSocket != null) {
            return this.ioSocket.getInetAddress().getHostAddress() + ":" + this.ioSocket.getPort() + " <-ftp-> " + this.getLocalHost() + ":" + this.ioSocket.getLocalPort() + " <-ssh-> " + this.remoteDesc;
        }
        return "< N/A >";
    }

    static {
        timeWaitKludgeCrit = new Object();
    }
}

