/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.application.MindTermApp;
import com.mindbright.application.ModuleTerminalImpl;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.Logo;
import com.mindbright.net.WebProxyException;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHConsoleClient;
import com.mindbright.ssh.SSHInteractor;
import com.mindbright.ssh.SSHMenuHandler;
import com.mindbright.ssh.SSHMenuHandlerFull;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh.SSHPropertyHandler;
import com.mindbright.ssh.SSHStdIO;
import com.mindbright.ssh.SSHVersionSpySocket;
import com.mindbright.ssh.Version;
import com.mindbright.ssh2.SSH2AccessDeniedException;
import com.mindbright.ssh2.SSH2AuthHostBased;
import com.mindbright.ssh2.SSH2AuthKbdInteract;
import com.mindbright.ssh2.SSH2AuthPassword;
import com.mindbright.ssh2.SSH2AuthPublicKey;
import com.mindbright.ssh2.SSH2AuthSSHComSecurID;
import com.mindbright.ssh2.SSH2Authenticator;
import com.mindbright.ssh2.SSH2Channel;
import com.mindbright.ssh2.SSH2Compressor;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2ConnectionEventAdapter;
import com.mindbright.ssh2.SSH2ConsoleRemote;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FTPProxyFilter;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2HostKeyVerifier;
import com.mindbright.ssh2.SSH2Interactor;
import com.mindbright.ssh2.SSH2KeyFingerprint;
import com.mindbright.ssh2.SSH2KeyPairFile;
import com.mindbright.ssh2.SSH2ListUtil;
import com.mindbright.ssh2.SSH2Listener;
import com.mindbright.ssh2.SSH2PKISigner;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.ssh2.SSH2SessionChannel;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.ssh2.SSH2SignatureException;
import com.mindbright.ssh2.SSH2StreamFilter;
import com.mindbright.ssh2.SSH2StreamFilterFactory;
import com.mindbright.ssh2.SSH2StreamSniffer;
import com.mindbright.ssh2.SSH2TCPChannel;
import com.mindbright.ssh2.SSH2TerminalAdapter;
import com.mindbright.ssh2.SSH2TerminalAdapterImpl;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2TransportEventAdapter;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.ssh2.SSH2UserCancelException;
import com.mindbright.sshcommon.SSHConsoleRemote;
import com.mindbright.terminal.TerminalInputListener;
import com.mindbright.terminal.TerminalWin;
import com.mindbright.terminal.TerminalWindow;
import com.mindbright.util.RandomSeed;
import java.applet.AppletContext;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class SSHInteractiveClient
extends SSHClient
implements Runnable,
SSHInteractor,
SSH2Interactor,
MindTermApp,
TerminalInputListener {
    public boolean isSSH2 = false;
    public SSH2Transport transport;
    SSH2Connection connection;
    SSH2TerminalAdapter termAdapter;
    public boolean wantHelpInfo = true;
    public String customStartMessage = null;
    SSHMenuHandler menus;
    SSHStdIO sshStdIO;
    SSHPropertyHandler propsHandler;
    public boolean quiet;
    public boolean exitOnLogout;
    boolean initQuiet;
    boolean isFirstPasswdAuth;
    private Vector tunnels = new Vector();

    public SSHInteractiveClient(boolean bl, boolean bl2, SSHPropertyHandler sSHPropertyHandler) {
        super(sSHPropertyHandler, sSHPropertyHandler);
        this.propsHandler = sSHPropertyHandler;
        this.interactor = this;
        sSHPropertyHandler.setInteractor(this);
        sSHPropertyHandler.setClient(this);
        this.quiet = bl;
        this.exitOnLogout = bl2;
        this.initQuiet = bl;
        this.setConsole(new SSHStdIO());
        this.sshStdIO = (SSHStdIO)this.console;
        this.sshStdIO.setClient(this);
    }

    public SSHInteractiveClient(SSHInteractiveClient sSHInteractiveClient) {
        this(true, true, new SSHPropertyHandler(sSHInteractiveClient.propsHandler));
        this.activateTunnels = false;
        this.wantHelpInfo = sSHInteractiveClient.wantHelpInfo;
        this.customStartMessage = sSHInteractiveClient.customStartMessage;
    }

    public void setMenus(SSHMenuHandler sSHMenuHandler) {
        this.menus = sSHMenuHandler;
    }

    public SSHPropertyHandler getPropertyHandler() {
        return this.propsHandler;
    }

    public void updateMenus() {
        if (this.menus != null) {
            this.menus.update();
        }
    }

    public void splashScreen() {
        TerminalWin terminalWin = this.getTerminalWin();
        if (terminalWin != null) {
            terminalWin.clearScreen();
            terminalWin.setCursorPos(0, 0);
        }
        this.console.println("MindTerm version " + Version.version);
        this.console.println(Version.copyright);
        this.console.println(Version.licenseMessage);
        this.showLogo();
        if (this.menus != null && this.menus.havePopupMenu) {
            if (terminalWin != null) {
                terminalWin.setCursorPos(terminalWin.rows() - 3, 0);
                terminalWin.clearLine();
            }
            this.console.println("\rpress <ctrl> + <mouse-" + this.menus.getPopupButton() + "> for Menu");
        }
        if (this.propsHandler.getSSHHomeDir() != null) {
            if (terminalWin != null) {
                terminalWin.setCursorPos(terminalWin.rows() - 2, 0);
                terminalWin.clearLine();
            }
            this.console.println("\rMindTerm home: " + this.propsHandler.getSSHHomeDir());
        }
        if (terminalWin != null) {
            terminalWin.setCursorPos(terminalWin.rows() - 1, 0);
            terminalWin.clearLine();
        }
    }

    public boolean installLogo() {
        ByteArrayOutputStream byteArrayOutputStream;
        boolean bl = false;
        TerminalWin terminalWin = this.getTerminalWin();
        if (terminalWin != null && (byteArrayOutputStream = this.readResource("/defaults/logo.gif")) != null) {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            int n = -1;
            int n2 = -1;
            boolean bl2 = false;
            while (!bl2) {
                n = image.getWidth(null);
                n2 = image.getHeight(null);
                if (n != -1 && n2 != -1) {
                    bl2 = true;
                }
                Thread.yield();
            }
            terminalWin.setLogo(image, -1, -1, n, n2);
            bl = true;
        }
        return bl;
    }

    public ByteArrayOutputStream readResource(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (inputStream != null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n;
                while ((n = inputStream.read()) >= 0) {
                    byteArrayOutputStream.write(n);
                }
            }
            catch (IOException iOException) {
                System.err.println("ERROR reading resource " + string + " : " + iOException);
            }
        }
        return byteArrayOutputStream;
    }

    void initRandomSeed() {
        if (!this.haveSecureRandom()) {
            this.console.print("Initializing random generator, please wait...");
            this.initSeedGenerator();
            this.console.print("done");
        }
    }

    public void doSingleCommand(String string) throws Exception {
        this.commandLine = string;
        this.installLogo();
        this.splashScreen();
        this.initRandomSeed();
        this.startSSHClient(false);
    }

    public void run() {
        this.installLogo();
        boolean bl = true;
        while (bl) {
            String string;
            boolean bl2 = false;
            try {
                this.splashScreen();
                this.initRandomSeed();
                this.startSSHClient(true);
                if (this.sshStdIO.isConnected()) {
                    this.sshStdIO.serverDisconnect("\n\r\n\rServer died or connection lost");
                    this.disconnect(false);
                    this.propsHandler.clearServerSetting();
                }
                Thread.sleep(1000L);
                try {
                    this.propsHandler.checkSave();
                }
                catch (IOException iOException) {
                    this.alert("Error saving settings!");
                }
            }
            catch (SSHClient.AuthFailException authFailException) {
                this.alert("Authentication failed, " + authFailException.getMessage());
                this.propsHandler.clearPasswords();
            }
            catch (WebProxyException webProxyException) {
                this.alert(webProxyException.getMessage());
                this.propsHandler.clearPasswords();
            }
            catch (SSHStdIO.SSHExternalMessage sSHExternalMessage) {
                bl2 = true;
                string = sSHExternalMessage.getMessage();
                if (string != null && string.trim().length() > 0) {
                    this.alert(sSHExternalMessage.getMessage());
                }
            }
            catch (UnknownHostException unknownHostException) {
                string = unknownHostException.getMessage();
                if (this.propsHandler.getProperty("proxytype").equals("none")) {
                    this.alert("Unknown host: " + string);
                } else {
                    this.alert("Unknown proxy host: " + string);
                }
                this.propsHandler.clearServerSetting();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.alert("File not found: " + fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                string = exception.getMessage();
                if (string == null || string.trim().length() == 0) {
                    string = exception.toString();
                }
                string = "Error connecting to " + this.propsHandler.getProperty("server") + ", reason:\n" + "-> " + string;
                this.alert(string);
                if (SSH.DEBUGMORE) {
                    exception.printStackTrace();
                }
            }
            catch (ThreadDeath threadDeath) {
                if (this.controller != null) {
                    this.controller.killAll();
                }
                this.controller = null;
                throw threadDeath;
            }
            this.propsHandler.passivateProperties();
            this.activateTunnels = true;
            if (!bl2) {
                if (!this.propsHandler.savePasswords || this.usedOTP) {
                    this.propsHandler.clearPasswords();
                }
                this.propsHandler.currentPropsFile = null;
                if (!this.propsHandler.autoLoadProps) {
                    this.propsHandler.clearPasswords();
                    this.initQuiet = false;
                }
                this.quiet = false;
            }
            this.controller = null;
            TerminalWin terminalWin = this.getTerminalWin();
            if (terminalWin != null) {
                terminalWin.setTitle(null);
            }
            bl = !this.exitOnLogout;
        }
    }

    public long getConnectTimeout() {
        return this.propsHandler.getPropertyI("connect-timeout") * 1000;
    }

    public long getHelloTimeout() {
        return this.propsHandler.getPropertyI("hello-timeout") * 1000;
    }

    private void startSSHClient(boolean bl) throws Exception {
        this.isFirstPasswdAuth = true;
        this.bootSSH(bl, true);
        int n = 2;
        String string = this.propsHandler.getProperty("protocol");
        long l = this.getHelloTimeout();
        if ("auto".equals(string)) {
            int n2 = this.sshSocket.getSoTimeout();
            if (l >= 0L) {
                this.sshSocket.setSoTimeout((int)l);
            }
            this.sshSocket = new SSHVersionSpySocket(this.sshSocket);
            n = ((SSHVersionSpySocket)this.sshSocket).getMajorVersion();
            if (l >= 0L) {
                this.sshSocket.setSoTimeout(n2);
            }
        } else if ("ssh1".equals(string)) {
            n = 1;
        }
        if (n == 1) {
            this.console.println("Warning connecting using ssh1, consider upgrading server!");
            this.console.println("");
            this.boot(bl, this.sshSocket);
            this.controller.waitForExit();
        } else {
            this.runSSH2Client();
        }
    }

    public boolean isDumb() {
        return this.console.getTerminal() == null;
    }

    public TerminalWin getTerminalWin() {
        TerminalWindow terminalWindow = this.console.getTerminal();
        if (terminalWindow != null && terminalWindow instanceof TerminalWin) {
            return (TerminalWin)terminalWindow;
        }
        return null;
    }

    public void showLogo() {
        TerminalWin terminalWin = this.getTerminalWin();
        if (terminalWin != null) {
            terminalWin.showLogo();
        }
    }

    public void hideLogo() {
        TerminalWin terminalWin = this.getTerminalWin();
        if (terminalWin != null) {
            terminalWin.hideLogo();
        }
    }

    public Logo getLogo() {
        Logo logo = null;
        TerminalWin terminalWin = this.getTerminalWin();
        if (terminalWin != null) {
            Image image = terminalWin.getLogo();
            logo = new Logo(image);
        }
        return logo;
    }

    public void updateTitle() {
        this.sshStdIO.updateTitle();
    }

    public String promptLine(String string, boolean bl) throws SSH2UserCancelException {
        try {
            String string2 = null;
            while (string2 == null) {
                if (bl) {
                    string2 = this.promptLine(string, "");
                    continue;
                }
                string2 = this.promptPassword(string);
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new SSH2UserCancelException(iOException.getMessage());
        }
    }

    public String[] promptMulti(String[] stringArray, boolean[] blArray) throws SSH2UserCancelException {
        return this.promptMultiFull(null, null, stringArray, blArray);
    }

    public String[] promptMultiFull(String string, String string2, String[] stringArray, boolean[] blArray) throws SSH2UserCancelException {
        try {
            if (string != null && string.length() > 0) {
                this.console.println(string);
            }
            if (string2 != null && string2.length() > 0) {
                this.console.println(string2);
            }
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = null;
                while (string3 == null) {
                    if (blArray[i]) {
                        string3 = this.promptLine(stringArray[i], "");
                        continue;
                    }
                    string3 = this.promptPassword(stringArray[i]);
                }
                stringArray2[i] = string3;
            }
            return stringArray2;
        }
        catch (IOException iOException) {
            throw new SSH2UserCancelException(iOException.getMessage());
        }
    }

    public int promptList(String string, String string2, String[] stringArray) throws SSH2UserCancelException {
        try {
            this.console.println(string);
            this.console.println(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                this.console.println(i + ") " + stringArray[i]);
            }
            String string3 = null;
            while (string3 == null) {
                string3 = this.promptLine("Choice", "0");
            }
            return Integer.parseInt(string3);
        }
        catch (Exception exception) {
            throw new SSH2UserCancelException(exception.getMessage());
        }
    }

    public void propsStateChanged(SSHPropertyHandler sSHPropertyHandler) {
        this.updateMenus();
    }

    public void startNewSession(SSHClient sSHClient) {
    }

    public void sessionStarted(SSHClient sSHClient) {
        this.quiet = this.initQuiet;
    }

    public boolean quietPrompts() {
        return this.commandLine != null || this.quiet;
    }

    public boolean isVerbose() {
        return this.wantHelpInfo;
    }

    public String promptLine(String string, String string2) throws IOException {
        return this.sshStdIO.promptLine(string, string2, false);
    }

    public String promptPassword(String string) throws IOException {
        return this.sshStdIO.promptLine(string, "", true);
    }

    public boolean askConfirmation(String string, boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = this.askConfirmation(string, true, bl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl2;
    }

    public boolean askConfirmation(String string, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = false;
        if (this.menus != null && bl) {
            bl3 = this.menus.confirmDialog(string, bl2);
        } else {
            String string2 = null;
            while (string2 == null) {
                string2 = this.promptLine(string + (bl2 ? " ([yes]/no) " : "(yes/[no]) "), "");
            }
            if (string2.equalsIgnoreCase("yes") || string2.equals("y")) {
                bl3 = true;
            } else if (string2.equals("")) {
                bl3 = bl2;
            }
        }
        return bl3;
    }

    public boolean licenseDialog(String string) {
        if (string != null && this.menus instanceof SSHMenuHandlerFull) {
            Frame frame = ((SSHMenuHandlerFull)this.menus).parent;
            int n = AWTConvenience.isSwingJFrame(frame) ? 55 : 75;
            return SSHMiscDialogs.confirm("MindTerm - License agreeement", string, 24, n, "Accept", "Decline", false, frame, true);
        }
        return false;
    }

    public void connected(SSHClient sSHClient) {
        this.updateMenus();
        this.console.println("Connected to server running " + this.srvVersionStr);
    }

    public void open(SSHClient sSHClient) {
        this.updateMenus();
        this.updateTitle();
    }

    public void disconnected(SSHClient sSHClient, boolean bl) {
        this.sshStdIO.breakPromptLine("Login aborted by user");
        this.updateMenus();
        this.updateTitle();
    }

    public void report(String string) {
        if (string != null && string.length() > 0) {
            this.console.println(string);
        }
        this.console.println("");
    }

    public SSH2Interactor getInteractor() {
        return this;
    }

    public void alert(String string) {
        if (string == null) {
            string = "Unknown error (null)";
        }
        if (this.menus != null) {
            if (string.length() < 50) {
                this.menus.alertDialog(string);
            } else {
                this.menus.textDialog("MindTerm - Alert", string, 4, 38, true);
            }
        } else {
            this.report(string);
        }
    }

    public void forcedDisconnect() {
        if (this.isSSH2) {
            this.transport.normalDisconnect("Closed by user");
        } else {
            super.forcedDisconnect();
        }
    }

    public void requestLocalPortForward(String string, int n, String string2, int n2, String string3) throws IOException {
        if (this.isSSH2) {
            SSH2StreamFilter sSH2StreamFilter = null;
            if ("ftp".equals(string3)) {
                String string4 = this.propsHandler.getProperty("real-server");
                if (string4 == null) {
                    string4 = this.propsHandler.getProperty("server");
                }
                sSH2StreamFilter = new SSH2FTPProxyFilter(string, string4);
            } else if ("sniff".equals(string3)) {
                sSH2StreamFilter = SSH2StreamSniffer.getFilterFactory();
            }
            this.connection.newLocalForward(string, n, string2, n2, (SSH2StreamFilterFactory)((Object)sSH2StreamFilter));
        } else {
            super.requestLocalPortForward(string, n, string2, n2, string3);
        }
    }

    public void addRemotePortForward(String string, int n, String string2, int n2, String string3) {
        super.addRemotePortForward(string, n, string2, n2, string3);
        if (this.isSSH2) {
            this.connection.newRemoteForward(string, n, string2, n2);
        }
    }

    public void delLocalPortForward(String string, int n) {
        boolean bl = this.isOpened;
        if (this.isSSH2) {
            this.connection.deleteLocalForward(string, n);
            this.isOpened = false;
        }
        super.delLocalPortForward(string, n);
        this.isOpened = bl;
    }

    public void delRemotePortForward(String string, int n) {
        super.delRemotePortForward(string, n);
        if (this.isSSH2) {
            this.connection.deleteRemoteForward(string, n);
        }
    }

    void setAliveInterval(int n) {
        if (this.isSSH2) {
            this.transport.enableKeepAlive(n);
        } else {
            super.setAliveInterval(n);
        }
    }

    void runSSH2Client() throws IOException {
        try {
            try {
                SSH2SessionChannel sSH2SessionChannel;
                this.isSSH2 = true;
                SSH2Preferences sSH2Preferences = new SSH2Preferences(this.propsHandler.getProperties());
                if (SSH.DEBUGMORE) {
                    sSH2Preferences.setPreference("log-level", "7");
                }
                this.transport = new SSH2Transport(this.sshSocket, sSH2Preferences, null, this.secureRandom());
                this.transport.setEventHandler(new SSH2TransportEventAdapter(){

                    public boolean kexAuthenticateHost(SSH2Transport sSH2Transport, SSH2Signature sSH2Signature) {
                        try {
                            SSHInteractiveClient.this.propsHandler.showFingerprint(sSH2Signature.getPublicKeyBlob(), sSH2Signature.getAlgorithmName());
                            if (SSHInteractiveClient.this.fingerprintMatch(sSH2Signature)) {
                                return true;
                            }
                            return SSHInteractiveClient.this.propsHandler.verifyKnownSSH2Hosts(SSHInteractiveClient.this, sSH2Signature);
                        }
                        catch (SSH2Exception sSH2Exception) {
                            SSHInteractiveClient.this.transport.getLog().error("SSHInteractiveClient", "verifyKnownSSH2Hosts", "Error " + sSH2Exception.getMessage());
                        }
                        catch (IOException iOException) {
                            SSHInteractiveClient.this.transport.getLog().error("SSHInteractiveClient", "verifyKnownSSH2Hosts", "Error " + iOException.getMessage());
                        }
                        return false;
                    }

                    public void gotConnectInfoText(SSH2Transport sSH2Transport, String string) {
                        SSHInteractiveClient.this.alert(string);
                    }
                });
                this.transport.boot();
                this.srvVersionStr = this.transport.getServerVersion();
                this.connected(null);
                if (!this.transport.waitForKEXComplete()) {
                    throw new IOException("Key exchange failed: " + this.transport.getDisconnectMessage());
                }
                this.isConnected = true;
                SSH2Authenticator sSH2Authenticator = new SSH2Authenticator(){

                    public void peerMethods(String string) {
                        SSHInteractiveClient.this.addAuthModules(this, string);
                    }

                    public void displayBanner(String string) {
                        SSHInteractiveClient.this.alert(string);
                    }
                };
                sSH2Authenticator.setUsername(this.propsHandler.getUsername(null));
                SSH2UserAuth sSH2UserAuth = new SSH2UserAuth(this.transport, sSH2Authenticator);
                if (!sSH2UserAuth.authenticateUser("ssh-connection")) {
                    throw new SSHClient.AuthFailException("permission denied");
                }
                this.connection = new SSH2Connection(sSH2UserAuth, this.transport, null);
                this.connection.setEventHandler(new SSH2ConnectionEventAdapter(){

                    public void localSessionConnect(SSH2Connection sSH2Connection, SSH2Channel sSH2Channel) {
                    }

                    public void localDirectConnect(SSH2Connection sSH2Connection, SSH2Listener sSH2Listener, SSH2Channel sSH2Channel) {
                        SSHInteractiveClient.this.tunnels.addElement(sSH2Channel);
                    }

                    public void remoteForwardConnect(SSH2Connection sSH2Connection, String string, int n, SSH2Channel sSH2Channel) {
                        SSHInteractiveClient.this.tunnels.addElement(sSH2Channel);
                    }

                    public void channelClosed(SSH2Connection sSH2Connection, SSH2Channel sSH2Channel) {
                        SSHInteractiveClient.this.tunnels.removeElement(sSH2Channel);
                    }
                });
                this.transport.setConnection(this.connection);
                sSH2Authenticator.clearSensitiveData();
                if (this.console != null) {
                    this.console.serverConnect(null, null);
                }
                this.isOpened = true;
                this.open(null);
                if (this.menus != null) {
                    ((SSHMenuHandlerFull)this.menus).modulesConnect();
                }
                this.propsHandler.passivateProperties();
                this.propsHandler.activateProperties();
                TerminalWin terminalWin = this.getTerminalWin();
                if (terminalWin != null) {
                    terminalWin.addInputListener(this);
                    this.termAdapter = new SSH2TerminalAdapterImpl(terminalWin);
                    sSH2SessionChannel = this.connection.newTerminal(this.termAdapter);
                    if (this.propsHandler.hasKeyTimingNoise()) {
                        this.termAdapter.startChaff();
                    }
                    if (sSH2SessionChannel.openStatus() != 1) {
                        throw new IOException("Failed to open ssh2 session channel");
                    }
                    if (this.user.wantX11Forward()) {
                        sSH2SessionChannel.requestX11Forward(false, 0);
                    }
                    if (this.user.wantPTY()) {
                        sSH2SessionChannel.requestPTY(terminalWin.terminalType(), terminalWin.rows(), terminalWin.cols(), null);
                    }
                    if (this.commandLine != null) {
                        sSH2SessionChannel.doSingleCommand(this.commandLine);
                    } else {
                        sSH2SessionChannel.doShell();
                    }
                } else {
                    sSH2SessionChannel = this.connection.newSession();
                }
                int n = sSH2SessionChannel.waitForExit(0L);
                if (terminalWin != null) {
                    terminalWin.removeInputListener(this);
                }
                this.termAdapter.detach();
                this.transport.normalDisconnect("Disconnect by user");
                this.console.serverDisconnect(this.getServerAddr().getHostName() + " disconnected: " + n);
                this.disconnect(true);
                if (this.propsHandler.getCompressionLevel() != 0) {
                    for (int i = 0; i < 2; ++i) {
                        SSH2Compressor sSH2Compressor;
                        SSH2Compressor sSH2Compressor2 = sSH2Compressor = i == 0 ? this.transport.getTxCompressor() : this.transport.getRxCompressor();
                        if (sSH2Compressor == null) continue;
                        long l = sSH2Compressor.numOfCompressedBytes();
                        long l2 = sSH2Compressor.numOfUncompressedBytes() > 0L ? sSH2Compressor.numOfUncompressedBytes() : 1L;
                        String string = " raw data (bytes) = " + l2 + ", compressed = " + l + " (" + l * 100L / l2 + "%)";
                        this.console.println((i == 0 ? "outgoing" : "incoming") + string);
                    }
                }
                this.sshStdIO.setTerminal(terminalWin);
            }
            catch (IOException iOException) {
                this.disconnect(false);
                throw iOException;
            }
            catch (Exception exception) {
                System.err.println("** Error in ssh2: ");
                exception.printStackTrace();
                this.disconnect(false);
                throw new IOException("Error in ssh2: " + exception.getMessage() + "{" + exception + "}");
            }
            Object var15_14 = null;
            ((SSHMenuHandlerFull)this.menus).modulesDisconnect();
            this.connection = null;
            this.transport = null;
            this.isSSH2 = false;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            ((SSHMenuHandlerFull)this.menus).modulesDisconnect();
            this.connection = null;
            this.transport = null;
            this.isSSH2 = false;
            throw throwable;
        }
    }

    public boolean fingerprintMatch(SSH2Signature sSH2Signature) {
        String string = this.propsHandler.getProperty("fingerprint");
        if (string == null) {
            string = this.propsHandler.getProperty("fingerprint." + this.propsHandler.getProperty("server") + "." + this.propsHandler.getProperty("port"));
        }
        if (string != null) {
            if (SSH2HostKeyVerifier.compareFingerprints(string, sSH2Signature)) {
                return true;
            }
            if (this.propsHandler.askChangeKeyConfirmation()) {
                byte[] byArray = null;
                try {
                    byArray = sSH2Signature.getPublicKeyBlob();
                }
                catch (SSH2SignatureException sSH2SignatureException) {
                    return false;
                }
                String string2 = SSH2KeyFingerprint.md5Hex(byArray);
                this.propsHandler.setProperty("fingerprint", string2);
            }
        }
        return false;
    }

    public void typedChar(char c) {
    }

    public void typedChar(byte[] byArray) {
    }

    public void sendBytes(byte[] byArray) {
    }

    public void sendBreak() {
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        this.updateTitle();
    }

    public void signalTermTypeChanged(String string) {
    }

    public void addAuthModules(SSH2Authenticator sSH2Authenticator, String string) {
        try {
            int n;
            int[] nArray = this.propsHandler.getAuthTypes(null);
            boolean bl = true;
            block14: for (n = 0; n < nArray.length; ++n) {
                int n2 = nArray[n];
                if (!SSH2ListUtil.isInList(string, SSH.getAuthName(n2)) && !SSH2ListUtil.isInList(string, SSH.getAltAuthName(n2)) && (n2 != 8 || !SSH2ListUtil.isInList(string, "securid-1@ssh.com"))) continue;
                bl = false;
                switch (n2) {
                    case 2: {
                        String string2;
                        Object object;
                        Object object2;
                        String string3 = this.propsHandler.getProperty("idfile");
                        if (string3.indexOf(File.separator) == -1) {
                            string3 = this.propsHandler.getSSHHomeDir() + string3;
                        }
                        Object object3 = new SSH2KeyPairFile();
                        try {
                            ((SSH2KeyPairFile)object3).load(string3, "");
                        }
                        catch (SSH2FatalException sSH2FatalException) {
                            throw new IOException(sSH2FatalException.getMessage());
                        }
                        catch (SSH2AccessDeniedException sSH2AccessDeniedException) {
                            object2 = ((SSH2KeyPairFile)object3).getComment();
                            if (object2 == null || ((String)object2).trim().length() == 0) {
                                object2 = string3;
                            }
                            object = "Key '" + (String)object2 + "' password: ";
                            string2 = this.propsHandler.getIdentityPassword((String)object);
                            ((SSH2KeyPairFile)object3).load(string3, string2);
                        }
                        Object object4 = ((SSH2KeyPairFile)object3).getAlgorithmName();
                        object2 = SSH2Signature.getInstance((String)object4);
                        ((SSH2Signature)object2).initSign(((SSH2KeyPairFile)object3).getKeyPair().getPrivate());
                        ((SSH2Signature)object2).setPublicKey(((SSH2KeyPairFile)object3).getKeyPair().getPublic());
                        sSH2Authenticator.addModule(new SSH2AuthPublicKey((SSH2PKISigner)object2));
                        continue block14;
                    }
                    case 3: {
                        if (this.isFirstPasswdAuth) {
                            this.isFirstPasswdAuth = false;
                        } else {
                            this.propsHandler.eraseProperty("password");
                        }
                        String string3 = this.getProperty("username") + "@" + this.getProperty("server") + "'s password: ";
                        sSH2Authenticator.addModule(new SSH2AuthPassword(this, string3));
                        continue block14;
                    }
                    case 11: {
                        String string2;
                        Object object;
                        Object object3 = this.propsHandler.getProperty("private-host-key");
                        if (((String)object3).indexOf(File.separator) == -1) {
                            object3 = this.propsHandler.getSSHHomeDir() + (String)object3;
                        }
                        Object object4 = new SSH2KeyPairFile();
                        try {
                            ((SSH2KeyPairFile)object4).load((String)object3, "");
                        }
                        catch (SSH2FatalException sSH2FatalException) {
                            throw new IOException(sSH2FatalException.getMessage());
                        }
                        catch (SSH2AccessDeniedException sSH2AccessDeniedException) {
                            object = ((SSH2KeyPairFile)object4).getComment();
                            if (object == null || ((String)object).trim().length() == 0) {
                                object = object3;
                            }
                            string2 = "Key '" + (String)object + "' password: ";
                            String string4 = this.propsHandler.getIdentityPassword(string2);
                            ((SSH2KeyPairFile)object4).load((String)object3, string4);
                        }
                        Object object2 = ((SSH2KeyPairFile)object4).getAlgorithmName();
                        object = SSH2Signature.getInstance((String)object2);
                        ((SSH2Signature)object).initSign(((SSH2KeyPairFile)object4).getKeyPair().getPrivate());
                        ((SSH2Signature)object).setPublicKey(((SSH2KeyPairFile)object4).getKeyPair().getPublic());
                        sSH2Authenticator.addModule(new SSH2AuthHostBased((SSH2PKISigner)object));
                        continue block14;
                    }
                    case 5: 
                    case 8: 
                    case 9: 
                    case 10: {
                        sSH2Authenticator.addModule(new SSH2AuthKbdInteract(this));
                        sSH2Authenticator.addModule(new SSH2AuthSSHComSecurID(this, "Enter Passcode: ", "Wait for token to change and enter Passcode: ", "New PIN:", "Confirm new PIN: ", "Do you want to create your own new PIN (yes/no)? ", "Accept the server assigned PIN: "));
                        continue block14;
                    }
                    default: {
                        throw new IOException("Authentication type " + SSH.authTypeDesc[nArray[n]] + " is not supported in SSH2");
                    }
                }
            }
            if (bl) {
                for (n = 0; n < nArray.length; ++n) {
                    this.report("Authentication method '" + SSH.getAuthName(nArray[n]) + "' not supported by server.");
                }
            }
        }
        catch (Exception exception) {
            if (SSH.DEBUGMORE) {
                System.out.println("Error when setting up authentication: ");
                int[] nArray = this.propsHandler.getAuthTypes(null);
                for (int i = 0; i < nArray.length; ++i) {
                    System.out.print(nArray[i] + ", ");
                }
                System.out.println("");
                exception.printStackTrace();
            }
            this.alert("Error when setting up authentication: " + exception.getMessage());
        }
    }

    public void newShell() {
        ModuleTerminalImpl moduleTerminalImpl = new ModuleTerminalImpl();
        moduleTerminalImpl.init(this);
        moduleTerminalImpl.run();
    }

    public String getVersionId(boolean bl) {
        String string = "SSH-1.5-";
        string = string + this.propsHandler.getProperty("package-version");
        return string;
    }

    public void closeTunnelFromList(int n) {
        if (this.isSSH2) {
            SSH2Channel sSH2Channel = (SSH2Channel)this.tunnels.elementAt(n);
            sSH2Channel.close();
        } else {
            this.controller.closeTunnelFromList(n);
        }
    }

    public String[] listTunnels() {
        if (this.isSSH2) {
            String[] stringArray = new String[this.tunnels.size()];
            Enumeration enumeration = this.tunnels.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                SSH2TCPChannel sSH2TCPChannel = (SSH2TCPChannel)enumeration.nextElement();
                stringArray[n++] = sSH2TCPChannel.toString();
            }
            return stringArray;
        }
        return this.controller.listTunnels();
    }

    public String getHost() {
        return this.getServerAddr().getHostName();
    }

    public int getPort() {
        return this.propsHandler.getSrvPort();
    }

    public Properties getProperties() {
        Properties properties;
        Properties properties2 = new Properties(this.propsHandler.getProperties());
        TerminalWin terminalWin = this.getTerminalWin();
        Properties properties3 = properties = terminalWin != null ? terminalWin.getProperties() : null;
        if (properties != null) {
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                ((Hashtable)properties2).put(string, string2);
            }
        }
        return properties2;
    }

    public String getProperty(String string) {
        TerminalWin terminalWin;
        String string2 = this.propsHandler.getProperty(string);
        if (string2 == null && (terminalWin = this.getTerminalWin()) != null) {
            string2 = terminalWin.getProperty(string);
        }
        return string2;
    }

    public void setProperty(String string, String string2) {
        this.propsHandler.setProperty(string, string2);
    }

    public String getUserName() {
        return this.propsHandler.getProperty("username");
    }

    public Frame getParentFrame() {
        return ((SSHMenuHandlerFull)this.menus).parent;
    }

    public String getAppName() {
        return "MindTerm";
    }

    public RandomSeed getRandomSeed() {
        return this.randomSeed();
    }

    public boolean isApplet() {
        return ((SSHMenuHandlerFull)this.menus).mindterm.weAreAnApplet;
    }

    public AppletContext getAppletContext() {
        return ((SSHMenuHandlerFull)this.menus).mindterm.getAppletContext();
    }

    public SSH2Transport getTransport() {
        return this.transport;
    }

    public SSH2Connection getConnection() {
        return this.connection;
    }

    public SSHConsoleRemote getConsoleRemote() {
        SSHConsoleRemote sSHConsoleRemote = null;
        if (this.isSSH2) {
            sSHConsoleRemote = new SSH2ConsoleRemote(this.getConnection());
        } else {
            this.quiet = true;
            try {
                sSHConsoleRemote = new SSHConsoleClient(this.propsHandler.getSrvHost(), this.propsHandler.getSrvPort(), this.propsHandler, null);
                ((SSHConsoleClient)sSHConsoleRemote).setClientUser(this.propsHandler);
            }
            catch (IOException iOException) {
                this.alert("Error creating remote console: " + iOException.getMessage());
            }
        }
        return sSHConsoleRemote;
    }
}

