/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.gui.GUI;
import com.mindbright.gui.SwingConvenience;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHKeyGenerationDialog;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh2.SSH2AccessDeniedException;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2KeyPairFile;
import com.mindbright.ssh2.SSH2PublicKeyFile;
import com.mindbright.util.Progress;
import com.mindbright.util.RandomSeed;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public final class SSHKeyGenerationDialogSwing
extends SSHKeyGenerationDialog {
    private static JComboBox comboBits;
    private static JComboBox comboType;
    private static JTextField fileText;
    private static JPasswordField pwdText;
    private static JPasswordField pwdText2;
    private static JTextField commText;
    private static JTextArea descText;
    private static ProgressBar progBar;
    private static JButton okBut;
    private static JCheckBox cbOpenSSH;
    private static JPanel cardPanel;
    private static CardLayout cardLayout;
    private static boolean generatedAndSaved;
    private static JTextField fileTextEd;
    private static JPasswordField pwdTextEd;
    private static JPasswordField pwdText2Ed;
    private static JTextField subjTextEd;
    private static JTextField commTextEd;
    private static JLabel typeLbl;
    private static JLabel bitLbl;
    private static JCheckBox cbOpenSSHEd;
    private static JCheckBox cbSSHComEd;
    private static JButton okButEd;
    private static JButton cancButEd;
    private static SSH2KeyPairFile kpf;
    private static SSH2PublicKeyFile pkf;

    public static void show(String string, Frame frame, SSHInteractiveClient sSHInteractiveClient) {
        SSHKeyGenerationDialog.client = sSHInteractiveClient;
        SSHKeyGenerationDialog.parent = frame;
        final JDialog jDialog = SwingConvenience.newBorderJDialog(SSHKeyGenerationDialog.parent, string, true);
        SSHKeyGenerationDialogSwing.createCardPanel();
        jDialog.getContentPane().add((Component)cardPanel, "Center");
        okBut = new JButton("Generate");
        okBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (generatedAndSaved) {
                    SSHKeyGenerationDialogSwing.resetValues();
                    descText.setCaretPosition(0);
                } else if (SSHKeyGenerationDialog.checkValues(new String(pwdText.getPassword()), new String(pwdText2.getPassword()), fileText.getText())) {
                    cardLayout.show(cardPanel, "second");
                    okBut.setEnabled(false);
                }
            }
        });
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                SSHKeyGenerationDialogSwing.resetValues();
            }
        });
        jDialog.getContentPane().add((Component)SwingConvenience.newButtonPanel(new JButton[]{okBut, jButton}), "South");
        SSHKeyGenerationDialogSwing.resetValues();
        descText.setCaretPosition(0);
        jDialog.setResizable(false);
        jDialog.pack();
        RandomSeed randomSeed = SSHKeyGenerationDialog.client.randomSeed();
        randomSeed.addEntropyGenerator(descText);
        AWTConvenience.placeDialog(jDialog);
        comboBits.requestFocus();
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        ((Component)jDialog).setVisible(true);
    }

    private static void createCardPanel() {
        cardPanel = new JPanel();
        cardLayout = new CardLayout();
        cardPanel.setLayout(cardLayout);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        descText = new JTextArea("The key is generated using a random number generator, which is seeded by mouse movement in the field containing this text. Please move the mouse around in here until the progress bar below registers 100%.\n\nThis will create a publickey identity which can be used with the publickey authentication method. Your identity will consist of two parts: public and private keys. Your private key will be saved in the location which you specify; the corresponding public key is saved in a file with an identical name but with an extension of '.pub' added to it.\n\nYour private key is protected by encryption, if you entered a password. If you left the password field blank, the key will not be encrypted. This should only be used in protected environments where unattended logins are desired. The contents of the 'comment' field are stored with your key, and displayed each time you are prompted for the key's password.", 12, 34);
        descText.setEditable(false);
        descText.setLineWrap(true);
        descText.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(descText, 20, 31);
        jPanel.add((Component)jScrollPane, "Center");
        descText.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (progBar.getValue() >= progBar.getMaximum()) {
                    try {
                        SSHKeyGenerationDialog.client.randomSeed().removeProgress();
                        progBar.setValue(0);
                        int n = Integer.valueOf((String)comboBits.getSelectedItem());
                        String string = ((String)comboType.getSelectedItem()).substring(0, 3);
                        descText.setText("Generating keypair, please wait...");
                        descText.setCaretPosition(0);
                        Thread thread = new Thread(new Runnable(this, string, n){
                            private final /* synthetic */ String val$alg;
                            private final /* synthetic */ int val$bits;
                            private final /* synthetic */ 3 this$0;
                            {
                                this.this$0 = var1_1;
                                this.val$alg = string;
                                this.val$bits = n;
                            }

                            public void run() {
                                try {
                                    KeyPair keyPair = SSHKeyGenerationDialog.generateKeyPair(this.val$alg, this.val$bits);
                                    SSHKeyGenerationDialogSwing.access$1200(keyPair);
                                    SSHKeyGenerationDialogSwing.access$800().setEnabled(true);
                                    SSHKeyGenerationDialogSwing.access$800().setLabel("Back");
                                    SSHKeyGenerationDialogSwing.access$200().setText("Key Generation Complete\n\nTo use the key, you must transfer the '.pub' public key file to an SSH server and add it to the set of authorized keys. See your server documentation for details on this.\n\nFor convenience, your public key has been copied to the clipboard.\n\nExamples:\nIn ssh2 the '.pub' file should be pointed out in the file 'authorization' in the config directory (e.g. ~/.ssh2)\n\nIn OpenSSH's ssh2 the contents of the '.pub' file should be added to the file 'authorized_keys2' in your config directory (e.g. ~/.ssh) on the server.\n\nIn ssh1 the contents of the '.pub' file should be added to the file 'authorized_keys' in your ssh directory (e.g. ~/.ssh).\n\nPress 'Back' to generate a new keypair.");
                                    SSHKeyGenerationDialogSwing.access$200().setCaretPosition(0);
                                    SSHKeyGenerationDialogSwing.access$002(true);
                                }
                                catch (Throwable throwable) {
                                    SSHKeyGenerationDialog.alert("Error while generating/saving key pair: " + throwable.getMessage());
                                    SSHKeyGenerationDialogSwing.access$700().show(SSHKeyGenerationDialogSwing.access$600(), "first");
                                }
                            }
                        });
                        thread.start();
                    }
                    catch (Throwable throwable) {
                        SSHKeyGenerationDialog.alert("Error while generating/saving key pair: " + throwable.getMessage());
                        cardLayout.show(cardPanel, "first");
                    }
                }
            }
        });
        progBar = new ProgressBar(512, 150, 20);
        progBar.setStringPainted(true);
        jPanel.add((Component)progBar, "South");
        cardPanel.add((Component)jPanel, "second");
        jPanel = new JPanel();
        AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(jPanel);
        GridBagConstraints gridBagConstraints = aWTGridBagContainer.getConstraints();
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Key type/format", 4), 0, 2);
        comboType = new JComboBox<String>(SSHKeyGenerationDialog.KEY_TYPES);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(comboType, 0, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Key length (bits)", 4), 1, 2);
        comboBits = new JComboBox<String>(SSHKeyGenerationDialog.KEY_LENGTHS);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(comboBits, 1, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Identity file", 4), 2, 2);
        fileText = new JTextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(fileText, 2, 2);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = SSHKeyGenerationDialog.getSaveFile();
                if (file != null) {
                    fileText.setText(file.getAbsolutePath());
                }
            }
        });
        gridBagConstraints.fill = 0;
        aWTGridBagContainer.add(jButton, 2, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Password", 4), 3, 2);
        pwdText = new JPasswordField("", 18);
        pwdText.setEchoChar('*');
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(pwdText, 3, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Password again", 4), 4, 2);
        pwdText2 = new JPasswordField("", 18);
        pwdText2.setEchoChar('*');
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(pwdText2, 4, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Comment", 4), 5, 2);
        commText = new JTextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(commText, 5, 2);
        cbOpenSSH = new JCheckBox("OpenSSH .pub format");
        aWTGridBagContainer.add(cbOpenSSH, 6, 4);
        cardPanel.add((Component)jPanel, "first");
    }

    private static void saveKeyPair(KeyPair keyPair) throws IOException, SSH2Exception, NoSuchAlgorithmException {
        SSHKeyGenerationDialog.saveKeyPair(keyPair, new String(pwdText.getPassword()), fileText.getText(), commText.getText(), (String)comboType.getSelectedItem(), cbOpenSSH.isSelected());
        okBut.setEnabled(true);
        ((JTextComponent)pwdText).setText("");
        ((JTextComponent)pwdText2).setText("");
        progBar.setValue(0);
        fileText.setText(SSHKeyGenerationDialog.getDefaultFileName());
    }

    private static void resetValues() {
        okBut.setEnabled(true);
        comboType.setSelectedIndex(0);
        comboBits.setSelectedItem("1024");
        fileText.setText(SSHKeyGenerationDialog.getDefaultFileName());
        generatedAndSaved = false;
        ((JTextComponent)pwdText).setText("");
        ((JTextComponent)pwdText2).setText("");
        descText.setText("The key is generated using a random number generator, which is seeded by mouse movement in the field containing this text. Please move the mouse around in here until the progress bar below registers 100%.\n\nThis will create a publickey identity which can be used with the publickey authentication method. Your identity will consist of two parts: public and private keys. Your private key will be saved in the location which you specify; the corresponding public key is saved in a file with an identical name but with an extension of '.pub' added to it.\n\nYour private key is protected by encryption, if you entered a password. If you left the password field blank, the key will not be encrypted. This should only be used in protected environments where unattended logins are desired. The contents of the 'comment' field are stored with your key, and displayed each time you are prompted for the key's password.");
        okBut.setLabel("Generate");
        cardLayout.show(cardPanel, "first");
        RandomSeed randomSeed = SSHKeyGenerationDialog.client.randomSeed();
        randomSeed.resetEntropyCount();
        progBar.setValue(0);
        randomSeed.addProgress(progBar);
    }

    public static void editKeyDialog(String string, Frame frame, SSHInteractiveClient sSHInteractiveClient) {
        SSHKeyGenerationDialog.parent = frame;
        SSHKeyGenerationDialog.client = sSHInteractiveClient;
        File file = GUI.selectFile(SSHKeyGenerationDialog.parent, "MindTerm - Select key file to edit", SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir(), null, false);
        String string2 = null;
        String string3 = null;
        kpf = new SSH2KeyPairFile();
        if (file != null) {
            string3 = file.getAbsolutePath();
            try {
                pkf = new SSH2PublicKeyFile();
                pkf.load(string3 + ".pub");
            }
            catch (Exception exception) {
                pkf = null;
            }
            boolean bl = false;
            do {
                try {
                    kpf.load(string3, string2);
                    break;
                }
                catch (SSH2AccessDeniedException sSH2AccessDeniedException) {
                    bl = true;
                }
                catch (Exception exception) {
                    SSHKeyGenerationDialog.alert("Error loading key file: " + exception.getMessage());
                }
            } while ((string2 = SSHMiscDialogs.password("MindTerm - File Password", "Please give password for " + string3, SSHKeyGenerationDialog.parent)) != null);
            if (bl && string2 == null) {
                return;
            }
        } else {
            return;
        }
        if (pkf == null) {
            pkf = new SSH2PublicKeyFile(kpf.getKeyPair().getPublic(), kpf.getSubject(), kpf.getComment());
        }
        final JDialog jDialog = new JDialog(SSHKeyGenerationDialog.parent, string, true);
        AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(jDialog.getContentPane());
        GridBagConstraints gridBagConstraints = aWTGridBagContainer.getConstraints();
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Key type/format", 4), 0, 2);
        typeLbl = new JLabel("DSA");
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(typeLbl, 0, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Key length (bits)", 4), 1, 2);
        bitLbl = new JLabel("1024");
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(bitLbl, 1, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Identity file", 4), 2, 2);
        fileTextEd = new JTextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(fileTextEd, 2, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Password", 4), 3, 2);
        pwdTextEd = new JPasswordField("", 18);
        pwdTextEd.setEchoChar('*');
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(pwdTextEd, 3, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Password again", 4), 4, 2);
        pwdText2Ed = new JPasswordField("", 18);
        pwdText2Ed.setEchoChar('*');
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(pwdText2Ed, 4, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Subject", 4), 5, 2);
        subjTextEd = new JTextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(subjTextEd, 5, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new JLabel("Comment", 4), 6, 2);
        commTextEd = new JTextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(commTextEd, 6, 2);
        cbSSHComEd = new JCheckBox("SSH Comm. private file format");
        aWTGridBagContainer.add(cbSSHComEd, 7, 4);
        cbOpenSSHEd = new JCheckBox("OpenSSH .pub format");
        aWTGridBagContainer.add(cbOpenSSHEd, 8, 4);
        okButEd = new JButton("Save");
        okButEd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = fileTextEd.getText();
                String string2 = new String(pwdTextEd.getPassword());
                if (SSHKeyGenerationDialog.checkValues(string2, new String(pwdText2Ed.getPassword()), string)) {
                    string = SSHKeyGenerationDialog.expandFileName(string);
                    try {
                        String string3 = subjTextEd.getText();
                        String string4 = commTextEd.getText();
                        pkf.setSubject(string3);
                        pkf.setComment(string4);
                        pkf.store(string + ".pub", !cbOpenSSHEd.isSelected());
                        if (!(cbSSHComEd.isSelected() || string2 != null && string2.length() != 0)) {
                            string3 = null;
                            string4 = null;
                        }
                        kpf.setSubject(string3);
                        kpf.setComment(string4);
                        kpf.store(string, (SecureRandom)SSHKeyGenerationDialog.client.secureRandom(), string2, cbSSHComEd.isSelected());
                        jDialog.dispose();
                    }
                    catch (Exception exception) {
                        SSHKeyGenerationDialog.alert("Error saving files: " + exception.getMessage());
                    }
                }
            }
        });
        cancButEd = new JButton("Cancel");
        cancButEd.addActionListener(new AWTConvenience.CloseAction(jDialog));
        JPanel jPanel = SwingConvenience.newButtonPanel(new JButton[]{okButEd, cancButEd});
        aWTGridBagContainer.add(jPanel, 9, 0);
        jDialog.pack();
        fileTextEd.setText(string3);
        ((JTextComponent)pwdTextEd).setText(string2);
        ((JTextComponent)pwdText2Ed).setText(string2);
        typeLbl.setText(kpf.getAlgorithmName());
        bitLbl.setText(String.valueOf(kpf.getBitLength()));
        subjTextEd.setText(kpf.getSubject());
        commTextEd.setText(kpf.getComment());
        cbSSHComEd.setSelected(kpf.isSSHComFormat());
        cbOpenSSHEd.setSelected(!pkf.isSSHComFormat());
        AWTConvenience.placeDialog(jDialog);
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        ((Component)jDialog).setVisible(true);
    }

    static /* synthetic */ void access$1200(KeyPair keyPair) throws IOException, SSH2Exception, NoSuchAlgorithmException {
        SSHKeyGenerationDialogSwing.saveKeyPair(keyPair);
    }

    static /* synthetic */ boolean access$002(boolean bl) {
        generatedAndSaved = bl;
        return generatedAndSaved;
    }

    private static class ProgressBar
    extends JProgressBar
    implements Progress {
        ProgressBar(int n, int n2, int n3) {
            super(0, n);
        }

        public void progress(long l) {
            this.setValue((int)l);
        }
    }
}

