/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.application.MindTerm;
import com.mindbright.application.MindTermModule;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.GUI;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHMenuHandler;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh.SSHPropertyHandler;
import com.mindbright.ssh.Version;
import com.mindbright.ssh2.SSH2ListUtil;
import com.mindbright.terminal.TerminalMenuHandlerFull;
import com.mindbright.terminal.TerminalMenuListener;
import com.mindbright.terminal.TerminalWin;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

public abstract class SSHMenuHandlerFull
extends SSHMenuHandler
implements ActionListener,
ItemListener,
TerminalMenuListener {
    private static final String aboutText = SSH.VER_MINDTERM + "\n" + Version.licenseMessage + "\n" + "\n" + Version.copyright + "\n" + "\thttp://www.appgate.com/mindterm/\n" + "\n" + "This product includes cryptographic software written by,\n" + "Eric Young (eay@cryptsoft.com)\n" + "\n" + "JVM vendor:\t" + MindTerm.javaVendor + "\n" + "JVM version:\t" + MindTerm.javaVersion + "\n" + "OS name:\t" + MindTerm.osName + "\n" + "OS arch.:\t" + MindTerm.osArch + "\n" + "OS version:\t" + MindTerm.osVersion + "\n";
    protected static final int ACT_MOD_BASE = 0;
    protected SSHInteractiveClient client;
    protected Frame parent;
    protected TerminalWin term;
    protected MindTerm mindterm;
    protected MindTermModule[] modules;
    protected int modCnt;
    protected SSHPropertyHandler ph;
    protected static final int MENU_FILE = 0;
    protected static final int MENU_SETTINGS = 1;
    protected static final int MENU_TUNNELS = 2;
    protected static final int MENU_HELP = 3;
    private static final int M_FILE_NEW = 1;
    private static final int M_FILE_CLONE = 2;
    private static final int M_FILE_CONN = 3;
    private static final int M_FILE_DISC = 4;
    private static final int M_FILE_LOAD = 6;
    private static final int M_FILE_SAVE = 7;
    private static final int M_FILE_SAVEAS = 8;
    private static final int M_FILE_CREATID = 10;
    private static final int M_FILE_EDITPKI = 11;
    private static final int M_FILE_PRINT_SCREEN = 13;
    private static final int M_FILE_PRINT_BUFFER = 14;
    private static final int M_FILE_CAPTURE = 16;
    private static final int M_FILE_SEND = 17;
    private static final int M_FILE_CLOSE = 19;
    private static final int M_FILE_EXIT = 20;
    private static final int M_SET_SSH_NEW = 1;
    private static final int M_SET_SSH_PREF = 2;
    private static final int M_SET_TERM = 3;
    private static final int M_SET_RESET = 4;
    private static final int M_SET_AUTOSAVE = 6;
    private static final int M_SET_AUTOLOAD = 7;
    private static final int M_SET_SAVEPWD = 8;
    private static final int M_TUNL_SETUP = 1;
    private static final int M_TUNL_CURRENT = 3;
    private static final int M_HELP_ABOUT = 1;
    protected static final String MENU_HEADER_POPUP = "MindTerm Menu";
    protected static final String MENU_HEADER_PLUGINS = "Plugins";
    protected static final String[][] menuTexts = new String[][]{{"File", "New Terminal", "Clone Terminal", "Connect...", "Disconnect", null, "Load Settings...", "Save Settings", "Save Settings As...", null, "Create Keypair...", "Edit/Convert Keypair...", null, "Print screen...", "Print buffer...", null, "_Capture To File...", "Send ASCII File...", null, "Close", "Exit"}, {"Settings", "New Server...", "Connection...", "Terminal...", "Reset To Defaults", null, "_Auto Save Settings", "_Auto Load Settings", "_Save Passwords"}, {"Tunnels", "Setup...", null, "Current Connections..."}, {"Help", "About MindTerm"}};
    protected static final int NO_SHORTCUT = -1;
    private static final int[][] menuShortCuts = new int[][]{{-1, 78, 79, 67, -1, -1, -1, 83, -1, -1, -1, -1, -1, -1, -1, -1, 69, 88}, {-1, 72, -1, 84}};
    protected static String LBL_SAVE_AS_ALIAS = "Save as alias";
    protected static String LBL_CUSTOM_LIST = "custom list...";
    protected static String LBL_SECURID = "Have SecurID token ready";
    protected static String LBL_CRYPTOCARD = "Have CryptoCard token";
    protected static String LBL_TIS = "TIS challenge/response will occur when connecting";
    protected static String LBL_KBDINT = "Generic keyboard interactive authentication";
    protected static String LBL_TRANS_PREFS = "Transport prefs.";
    protected static String LBL_ANY_STANDARD = "any standard";
    protected static String LBL_X11_FORWARD = "X11 forward";
    protected static String LBL_SEND_KEEP = "Send keep-alive";
    protected static String LBL_BIND_ADDR = "Bind address";
    protected static String LBL_STRICT = "Strict host verify";
    protected static String LBL_ALLOC_PTY = "Allocate PTY";
    protected static String LBL_KEY_NOISE = "Key timing noise";
    protected static String LBL_AVAIL_HOSTS = "Available hosts/aliases";
    protected static String LBL_SERVER = "Server";
    protected static String LBL_PORT = "Port";
    protected static String LBL_USERNAME = "Username";
    protected static String LBL_AUTH = "Authentication";
    protected static String LBL_AUTH_REQ = "Authentication required";
    protected static String LBL_PASSWORD = "Password";
    protected static String LBL_MODIFY_LIST = "Modify list";
    protected static String LBL_IDENTITY = "Identity";
    protected static String LBL_HOST_KEY = "Host key";
    protected static String LBL_PROTOCOL = "Protocol";
    protected static String LBL_PROTO_SSH1 = "SSHv1";
    protected static String LBL_PROTO_SSH2 = "SSHv2";
    protected static String LBL_HKEY_TYPE = "Host key type";
    protected static String LBL_HKEY_DSS = "ssh-dss";
    protected static String LBL_HKEY_RSA = "ssh-rsa";
    protected static String LBL_C2S = "Client to Server";
    protected static String LBL_S2C = "Server to Client";
    protected static String LBL_CIPHER = "Cipher";
    protected static String LBL_MAC = "Mac";
    protected static String LBL_COMP = "Compression";
    protected static String LBL_LOCAL_DISP = "Local display";
    protected static String LBL_INTERVAL = "Interval";
    protected static String LBL_SECONDS = "(s)";
    protected static String LBL_CURR_TUNNELS = "Currently open tunnels";
    protected static String LBL_PROXY_TYPE = "Proxy type";
    protected static String LBL_BTN_OK = "OK";
    protected static String LBL_BTN_DISMISS = "Dismiss";
    protected static String LBL_BTN_CANCEL = "Cancel";
    protected static String LBL_BTN_NEW = "New...";
    protected static String LBL_BTN_CONNECT = "Connect";
    protected static String LBL_BTN_PROXY = "Proxy...";
    protected static String LBL_BTN_PREFS = "Preferences...";
    protected static String LBL_BTN_BROWSE = "Browse...";
    protected static String LBL_BTN_CLOSE_TUNNEL = "Disconnect";
    protected static String LBL_BTN_REFRESH = "Refresh";
    protected static String LBL_BTN_ADD = "Add";
    protected static String LBL_BTN_DELETE = "Delete";
    protected static String LBL_TAB_GENERAL = "General";
    protected static String LBL_TAB_PROXY = "Proxy";
    protected static String LBL_TAB_SECURITY = "Security";
    protected static String LBL_TAB_FEATURES = "Features";
    protected static int IDX_TAB_GENERAL = 0;
    protected static int IDX_TAB_PROXY = 1;
    protected static int IDX_TAB_SECURITY = 2;
    protected static int IDX_TAB_FEATURES = 3;
    protected static String ERR_NO_PROTOCOL = "No protocol version selected";
    protected static String ERR_NO_KEYTYPE = "No host key type selected";
    private int popButtonNum = 3;
    protected static String[] hktypes;
    protected static String[] ciphers;
    protected static String[] macs;
    protected static final String[] compc2s;
    protected static final String[] comps2c;
    protected static final String[] lvl2comp;
    protected static final String[] protos;
    protected static final int[] comp2lvl;
    protected static final String[] AUTH_METHODS;

    protected static int getMenuShortCut(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (menuShortCuts.length <= n) {
            return -1;
        }
        if (menuShortCuts[n].length <= n2) {
            return -1;
        }
        return menuShortCuts[n][n2];
    }

    public static SSHMenuHandler getInstance(Frame frame) {
        try {
            Class<?> clazz = Class.forName(AWTConvenience.isSwingJFrame(frame) ? "com.mindbright.ssh.SSHMenuHandlerFullSwing" : "com.mindbright.ssh.SSHMenuHandlerFullAWT");
            return (SSHMenuHandler)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void init(MindTerm mindTerm, SSHInteractiveClient sSHInteractiveClient, Frame frame, TerminalWin terminalWin) {
        String string;
        this.mindterm = mindTerm;
        this.client = sSHInteractiveClient;
        this.parent = frame;
        this.term = terminalWin;
        this.modCnt = 0;
        this.ph = sSHInteractiveClient.propsHandler;
        int n = 0;
        while (true) {
            if ((string = sSHInteractiveClient.propsHandler.getProperty("module" + n)) == null) break;
            ++n;
        }
        this.modCnt = n + 1;
        this.modules = new MindTermModule[this.modCnt];
        for (n = 0; n < this.modCnt && (string = sSHInteractiveClient.propsHandler.getProperty("module" + n)) != null; ++n) {
            try {
                this.modules[n] = (MindTermModule)Class.forName(string).newInstance();
                this.modules[n].init(sSHInteractiveClient);
                continue;
            }
            catch (Exception exception) {
                this.alertDialog("Module class '" + string + "' not found");
            }
        }
    }

    private void initCiphers() {
        if (ciphers == null) {
            ciphers = SSH2ListUtil.arrayFromList(SSHPropertyHandler.ciphAlgsSort);
            macs = SSH2ListUtil.arrayFromList(SSHPropertyHandler.macAlgs);
            hktypes = SSH2ListUtil.arrayFromList(SSHPropertyHandler.hostKeyAlgs);
        }
    }

    public void setPopupButton(int n) {
        this.term.setPopupButton(n);
        this.popButtonNum = n;
    }

    public int getPopupButton() {
        return this.popButtonNum;
    }

    protected String getModuleLabel(int n) {
        return this.client.propsHandler.getProperty("module" + n + ".label");
    }

    protected void modulesConnect() {
        if (this.modules == null) {
            return;
        }
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            this.modules[i].connected(this.client);
        }
    }

    protected void modulesDisconnect() {
        if (this.modules == null) {
            return;
        }
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            this.modules[i].disconnected(this.client);
        }
    }

    private int[] mapAction(String string) {
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 0;
        block0: for (n = 0; n < menuTexts.length; ++n) {
            for (n2 = 1; n2 < menuTexts[n].length; ++n2) {
                String string2 = menuTexts[n][n2];
                if (string2 == null || !string.equals(string2) && !("_" + string).equals(string2)) continue;
                nArray[0] = n;
                nArray[1] = n2;
                n = menuTexts.length;
                continue block0;
            }
        }
        return nArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleMenuAction(this.mapAction(this.getMenuLabel(actionEvent.getSource())));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.handleMenuAction(this.mapAction((String)itemEvent.getItem()));
    }

    private void handleMenuAction(int[] nArray) {
        switch (nArray[0]) {
            case 0: {
                switch (nArray[1]) {
                    case 1: {
                        this.mindterm.newWindow();
                        break;
                    }
                    case 2: {
                        this.mindterm.cloneWindow();
                        break;
                    }
                    case 3: {
                        this.initCiphers();
                        this.connectDialog("MindTerm - Connect");
                        break;
                    }
                    case 4: {
                        if (!this.mindterm.confirmClose()) break;
                        this.client.forcedDisconnect();
                        this.client.quiet = this.client.initQuiet;
                        break;
                    }
                    case 6: {
                        this.loadFileDialog();
                        break;
                    }
                    case 7: {
                        try {
                            if (this.client.propsHandler.savePasswords && this.client.propsHandler.emptyPropertyPassword()) {
                                String string = this.setPasswordDialog("Please set password for alias " + this.client.propsHandler.currentAlias, "MindTerm - Set File Password");
                                if (string == null) {
                                    return;
                                }
                                this.client.propsHandler.setPropertyPassword(string);
                            }
                            this.client.propsHandler.saveCurrentFile();
                        }
                        catch (Throwable throwable) {
                            this.alertDialog("Error saving settings: " + throwable.getMessage());
                        }
                        break;
                    }
                    case 8: {
                        this.saveAsFileDialog();
                        break;
                    }
                    case 10: {
                        this.keyGenerationDialogCreate();
                        break;
                    }
                    case 11: {
                        this.keyGenerationDialogEdit();
                        break;
                    }
                    case 16: {
                        if (this.getState(0, 16)) {
                            if (((TerminalMenuHandlerFull)this.term.getMenus()).captureToFileDialog()) break;
                            this.setState(0, 16, false);
                            break;
                        }
                        ((TerminalMenuHandlerFull)this.term.getMenus()).endCapture();
                        break;
                    }
                    case 17: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).sendFileDialog();
                        break;
                    }
                    case 13: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).printScreen();
                        break;
                    }
                    case 14: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).printBuffer();
                        break;
                    }
                    case 19: {
                        this.mindterm.close();
                        break;
                    }
                    case 20: {
                        this.mindterm.exit();
                    }
                }
                break;
            }
            case 1: {
                switch (nArray[1]) {
                    case 1: {
                        this.sshNewServerDialog();
                        break;
                    }
                    case 2: {
                        this.sshPreferencesDialog();
                        break;
                    }
                    case 3: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).termSettingsDialog();
                        break;
                    }
                    case 4: {
                        this.client.propsHandler.resetToDefaults();
                        break;
                    }
                    case 6: {
                        this.client.propsHandler.setAutoSaveProps(this.getState(1, 6));
                        this.update();
                        break;
                    }
                    case 7: {
                        this.client.propsHandler.setAutoLoadProps(this.getState(1, 7));
                        this.update();
                        break;
                    }
                    case 8: {
                        this.client.propsHandler.setSavePasswords(this.getState(1, 8));
                        if (!this.client.propsHandler.savePasswords || !this.client.propsHandler.emptyPropertyPassword() || this.client.propsHandler.getAlias() == null) break;
                        String string = this.setPasswordDialog("Please set password for alias " + this.client.propsHandler.currentAlias, "MindTerm - Set File Password");
                        if (string == null) {
                            this.client.propsHandler.setSavePasswords(false);
                            this.update();
                            return;
                        }
                        this.client.propsHandler.setPropertyPassword(string);
                    }
                }
                break;
            }
            case 2: {
                switch (nArray[1]) {
                    case 1: {
                        this.setupTunnelsDialog();
                        break;
                    }
                    case 3: {
                        this.currentTunnelsDialog();
                    }
                }
                break;
            }
            case 3: {
                switch (nArray[1]) {
                    case 1: {
                        this.aboutDialog(this.parent, this.client, "About " + SSH.VER_MINDTERM, aboutText);
                    }
                }
            }
        }
    }

    protected abstract void setEnabled(int var1, int var2, boolean var3);

    protected abstract void setState(int var1, int var2, boolean var3);

    protected abstract boolean getState(int var1, int var2);

    protected abstract void updatePluginMenu();

    public abstract void setupMenuBar(boolean var1);

    protected abstract String getMenuLabel(Object var1);

    public void update() {
        boolean bl = this.client.isOpened();
        boolean bl2 = this.client.isConnected();
        boolean bl3 = this.client.propsHandler.getSSHHomeDir() != null;
        boolean bl4 = this.client.propsHandler.getPropertyB("allow-new-server");
        this.setEnabled(0, 1, bl4);
        this.setEnabled(0, 2, bl);
        this.setEnabled(0, 17, bl);
        this.setEnabled(0, 8, bl && bl3);
        this.setEnabled(0, 3, !bl2 && bl4);
        this.setEnabled(0, 4, bl2);
        this.setEnabled(0, 6, !bl2 && bl4);
        this.setEnabled(0, 7, this.client.propsHandler.wantSave() && this.client.propsHandler.currentAlias != null);
        this.setEnabled(1, 1, !bl && bl4);
        this.setEnabled(1, 2, bl);
        this.setEnabled(1, 4, !bl);
        this.setEnabled(1, 6, bl3);
        this.setEnabled(1, 7, bl3);
        this.setEnabled(1, 8, bl3);
        this.setState(1, 6, this.client.propsHandler.autoSaveProps);
        this.setState(1, 7, this.client.propsHandler.autoLoadProps);
        this.setState(1, 8, this.client.propsHandler.savePasswords);
        this.setEnabled(2, 3, bl);
        this.setEnabled(2, 1, bl);
        this.updatePluginMenu();
    }

    public void close() {
    }

    protected abstract void sshPreferencesDialog(String var1);

    protected void sshPreferencesDialog() {
        this.initCiphers();
        this.sshPreferencesDialog("MindTerm - SSH Preferences");
    }

    protected abstract void sshNewServerDialog(String var1);

    protected final void sshNewServerDialog() {
        this.initCiphers();
        this.sshNewServerDialog("MindTerm - New Server");
    }

    protected abstract void currentTunnelsDialog(String var1);

    protected final void currentTunnelsDialog() {
        this.currentTunnelsDialog("MindTerm - Currently Open Tunnels");
    }

    protected abstract void setupTunnelsDialog(String var1);

    protected final void setupTunnelsDialog() {
        this.setupTunnelsDialog("MindTerm - Tunnel Setup");
    }

    protected abstract void connectDialog(String var1);

    public final void loadFileDialog() {
        File file = GUI.selectFile(this.parent, "MindTerm - Select file to load settings from", this.client.propsHandler.getSSHHomeDir(), false);
        if (file == null) {
            return;
        }
        try {
            String string = "";
            while (true) {
                try {
                    this.client.propsHandler.setPropertyPassword(string);
                    this.client.propsHandler.loadAbsoluteFile(file.getAbsolutePath(), false);
                    this.client.quiet = true;
                    this.client.sshStdIO.breakPromptLine("Loaded new settings: " + file.getName());
                }
                catch (SSHClient.AuthFailException authFailException) {
                    if ((string = this.passwordDialog("Please give password for " + file.getName(), "MindTerm - File Password")) != null) continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.alertDialog("Error loading settings: " + throwable.getMessage());
        }
    }

    protected abstract void keyGenerationDialogCreate(String var1);

    protected final void keyGenerationDialogCreate() {
        this.keyGenerationDialogCreate("MindTerm - Publickey Keypair Generation");
    }

    protected abstract void keyGenerationDialogEdit(String var1);

    protected final void keyGenerationDialogEdit() {
        this.keyGenerationDialogEdit("MindTerm - Publickey Keypair Edit");
    }

    public final void saveAsFileDialog() {
        String string = this.client.propsHandler.currentAlias;
        if (string == null) {
            string = this.client.propsHandler.getProperty("server");
        }
        string = string + ".mtp";
        File file = GUI.selectFile(this.parent, "MindTerm - Select file to save settings to", this.client.propsHandler.getSSHHomeDir(), string, true);
        if (file == null) {
            return;
        }
        try {
            if (this.client.propsHandler.savePasswords) {
                String string2 = this.setPasswordDialog("Please set password for " + file.getName(), "MindTerm - Set File Password");
                if (string2 == null) {
                    return;
                }
                this.client.propsHandler.setPropertyPassword(string2);
            }
            this.client.propsHandler.saveAsCurrentFile(file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            this.alertDialog("Error saving settings: " + throwable.getMessage());
        }
    }

    public final void alertDialog(String string) {
        GUI.showAlert("MindTerm - Alert", string, this.parent);
    }

    public final String passwordDialog(String string, String string2) {
        return SSHMiscDialogs.password(string2, string, this.parent);
    }

    public final String setPasswordDialog(String string, String string2) {
        return SSHMiscDialogs.setPassword(string2, string, this.parent);
    }

    public final boolean confirmDialog(String string, boolean bl) {
        return GUI.showConfirm("MindTerm - Confirmation", string, bl, this.parent);
    }

    public final void textDialog(String string, String string2, int n, int n2, boolean bl) {
        GUI.showNotice(this.parent, string, string2, n, n2, bl);
    }

    protected abstract void aboutDialog(Frame var1, SSHInteractiveClient var2, String var3, String var4);

    static {
        compc2s = new String[]{"none", "low", "medium", "high"};
        comps2c = new String[]{"none", "medium"};
        lvl2comp = new String[]{"none", "low", "low", "low", "medium", "medium", "medium", "high", "high", "high"};
        protos = new String[]{"auto", "ssh2", "ssh1"};
        comp2lvl = new int[]{0, 2, 6, 9};
        AUTH_METHODS = new String[]{"password", "publickey", "securid", "cryptocard", "tis", "kbd-interact", "hostbased", "custom list..."};
    }

    protected class Actions
    implements ActionListener {
        private int action;

        public Actions(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.action >= 0) {
                SSHMenuHandlerFull.this.modules[this.action - 0].activate(SSHMenuHandlerFull.this.client);
            }
        }
    }
}

