/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.BorderDialog;
import com.mindbright.gui.GUI;
import com.mindbright.gui.Logo;
import com.mindbright.gui.TabPanel;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHKeyGenerationDialogAWT;
import com.mindbright.ssh.SSHMenuHandlerFull;
import com.mindbright.ssh.SSHTunnelDialogAWT;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.terminal.TerminalMenuHandlerFull;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

public class SSHMenuHandlerFullAWT
extends SSHMenuHandlerFull {
    private Object[][] menuItems;
    private MenuItem[] modMenuItems;
    private Choice comboAuthTyp;
    private Checkbox cbSaveAlias;
    private TextField textSrv;
    private TextField textPort;
    private TextField textUser;
    private TextField textAlias;
    private TextField textPrivateKey;
    private TextField textPrivateHostKey;
    private TextField textPwd;
    private Button customBtn;
    private CardLayout authLabelCL;
    private CardLayout authCL;
    private Panel authLabelCP;
    private Panel authCP;
    private String customAuth;
    private Choice comboPrxType;
    private Checkbox cbNeedAuth;
    private TextField textPrxHost;
    private TextField textPrxPort;
    private TextField textPrxUser;
    private TextField textPrxPasswd;
    private Checkbox cbProto1;
    private Checkbox cbProto2;
    private Checkbox cbKeyTypeDSS;
    private Checkbox cbKeyTypeRSA;
    private Choice comboCipherC2S;
    private Choice comboCipherS2C;
    private Choice comboMacC2S;
    private Choice comboMacS2C;
    private Choice comboCompC2S;
    private Choice comboCompS2C;
    private Checkbox cbX11;
    private Checkbox cbIdHost;
    private Checkbox cbKeyNoise;
    private Checkbox cbAlive;
    private Checkbox cbForcPty;
    private TextField textDisp;
    private TextField textMtu;
    private TextField textAlive;
    private Checkbox[] authMethod;
    private List currList;

    public void setupMenuBar(boolean bl) {
        if (bl) {
            PopupMenu popupMenu = new PopupMenu("MindTerm Menu");
            this.preparePopupMenu(popupMenu);
        } else {
            MenuBar menuBar = new MenuBar();
            this.prepareMenuBar(menuBar);
            this.parent.setMenuBar(menuBar);
        }
    }

    private void prepareMenuBar(MenuBar menuBar) {
        menuBar.add(this.getMenu(0));
        menuBar.add((Menu)((TerminalMenuHandlerFull)this.term.getMenus()).getMenu(1));
        menuBar.add(this.getMenu(1));
        Menu menu = this.getPluginMenu();
        if (menu != null) {
            menuBar.add(menu);
        }
        menuBar.add(this.getMenu(2));
        menuBar.setHelpMenu(this.getMenu(3));
        this.term.updateMenus();
    }

    private void preparePopupMenu(PopupMenu popupMenu) {
        this.havePopupMenu = true;
        popupMenu.add(this.getMenu(0));
        popupMenu.add((Menu)((TerminalMenuHandlerFull)this.term.getMenus()).getMenu(1));
        popupMenu.add(this.getMenu(1));
        Menu menu = this.getPluginMenu();
        if (menu != null) {
            popupMenu.add(menu);
        }
        popupMenu.add(this.getMenu(2));
        popupMenu.addSeparator();
        popupMenu.add(this.getMenu(3));
        this.term.getMenus().setPopupMenu(popupMenu);
        this.update();
    }

    private Menu getMenu(int n) {
        Menu menu = new Menu(SSHMenuHandlerFull.menuTexts[n][0]);
        int n2 = SSHMenuHandlerFull.menuTexts[n].length;
        if (this.menuItems == null) {
            this.menuItems = new Object[SSHMenuHandlerFull.menuTexts.length][];
        }
        if (this.menuItems[n] == null) {
            this.menuItems[n] = new Object[SSHMenuHandlerFull.menuTexts[n].length];
        }
        for (int i = 1; i < n2; ++i) {
            MenuItem menuItem;
            String string = SSHMenuHandlerFull.menuTexts[n][i];
            if (string == null) {
                menu.addSeparator();
                continue;
            }
            if (string.charAt(0) == '_') {
                string = string.substring(1);
                menuItem = new CheckboxMenuItem(string);
                ((CheckboxMenuItem)menuItem).addItemListener(this);
            } else {
                menuItem = new MenuItem(string);
                menuItem.addActionListener(this);
            }
            int n3 = SSHMenuHandlerFull.getMenuShortCut(n, i);
            if (n3 != -1) {
                menuItem.setShortcut(new MenuShortcut(n3, true));
            }
            this.menuItems[n][i] = menuItem;
            menu.add(menuItem);
        }
        return menu;
    }

    private Menu getPluginMenu() {
        this.modMenuItems = null;
        Menu menu = null;
        if (this.modCnt > 0) {
            int n;
            this.modMenuItems = new MenuItem[this.modCnt];
            menu = new Menu("Plugins");
            for (n = 0; n < this.modCnt; ++n) {
                MenuItem menuItem;
                String string = this.getModuleLabel(n);
                if (string == null) continue;
                this.modMenuItems[n] = menuItem = new MenuItem(string);
                menuItem.addActionListener(new SSHMenuHandlerFull.Actions(0 + n));
                menu.add(menuItem);
            }
            if (n == 0) {
                menu = null;
            }
        }
        return menu;
    }

    protected void setEnabled(int n, int n2, boolean bl) {
        ((MenuItem)this.menuItems[n][n2]).setEnabled(bl);
    }

    protected void setState(int n, int n2, boolean bl) {
        ((CheckboxMenuItem)this.menuItems[n][n2]).setState(bl);
    }

    protected boolean getState(int n, int n2) {
        return ((CheckboxMenuItem)this.menuItems[n][n2]).getState();
    }

    protected void updatePluginMenu() {
        for (int i = 0; i < this.modCnt; ++i) {
            if (this.getModuleLabel(i) == null) continue;
            this.modMenuItems[i].setEnabled(this.modules[i].isAvailable(this.client));
        }
    }

    protected String getMenuLabel(Object object) {
        return ((MenuItem)object).getLabel();
    }

    public void connectDialog(String string) {
        final Dialog dialog = new Dialog(this.parent, string, true);
        final List list = new List(8);
        dialog.setLayout(new BorderLayout());
        Panel panel = new Panel(new GridLayout(0, 1));
        panel.add(new Label(SSHMenuHandlerFull.LBL_AVAIL_HOSTS));
        panel.add(new Label(" (dir: " + this.ph.getSSHHomeDir() + ")"));
        dialog.add((Component)panel, "North");
        dialog.add((Component)list, "Center");
        final Button button = new Button(SSHMenuHandlerFull.LBL_BTN_NEW);
        ActionListener actionListener = new ActionListener(){

            private void actionConnect() {
                String string = list.getSelectedItem();
                try {
                    String string2 = "";
                    while (true) {
                        try {
                            SSHMenuHandlerFullAWT.this.ph.setPropertyPassword(string2);
                            SSHMenuHandlerFullAWT.this.ph.loadAliasFile(string, false);
                            SSHMenuHandlerFullAWT.this.client.quiet = true;
                            SSHMenuHandlerFullAWT.this.client.sshStdIO.breakPromptLine();
                            dialog.dispose();
                        }
                        catch (SSHClient.AuthFailException authFailException) {
                            if ((string2 = SSHMenuHandlerFullAWT.this.passwordDialog("Please give file password for " + string, "MindTerm - File Password")) != null) continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    SSHMenuHandlerFullAWT.this.alertDialog("Error loading settings: " + throwable.getMessage());
                }
            }

            private void actionNew() {
                try {
                    SSHMenuHandlerFullAWT.this.ph.checkSave();
                }
                catch (Throwable throwable) {
                    SSHMenuHandlerFullAWT.this.alertDialog("Error saving settings: " + throwable.getMessage());
                }
                SSHMenuHandlerFullAWT.this.ph.clearServerSetting();
                button.setEnabled(false);
                dialog.dispose();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == button) {
                    this.actionNew();
                } else {
                    this.actionConnect();
                }
            }
        };
        panel = new Panel(new FlowLayout(1));
        Button button2 = new Button(SSHMenuHandlerFull.LBL_BTN_CONNECT);
        panel.add(button2);
        button2.addActionListener(actionListener);
        panel.add(button);
        button.addActionListener(actionListener);
        button2 = new Button(SSHMenuHandlerFull.LBL_BTN_CANCEL);
        panel.add(button2);
        button2.addActionListener(new AWTConvenience.CloseAction(dialog));
        dialog.add((Component)panel, "South");
        dialog.addWindowListener(new AWTConvenience.CloseAdapter(button2));
        AWTConvenience.setBackgroundOfChildren(dialog);
        dialog.setResizable(true);
        dialog.pack();
        list.removeAll();
        String[] stringArray = this.ph.availableAliases();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                list.add(stringArray[i]);
            }
        }
        list.select(0);
        dialog.pack();
        AWTConvenience.placeDialog(dialog);
        list.requestFocus();
        ((Component)dialog).setVisible(true);
        if (!button.isEnabled()) {
            this.sshNewServerDialog();
        }
    }

    public void keyGenerationDialogCreate(String string) {
        SSHKeyGenerationDialogAWT.show(string, this.parent, this.client);
    }

    public void keyGenerationDialogEdit(String string) {
        SSHKeyGenerationDialogAWT.editKeyDialog(string, this.parent, this.client);
    }

    protected void sshNewServerDialog(String string) {
        this.sshConfigDialog(string, SSHMenuHandlerFull.LBL_TAB_GENERAL);
    }

    public void sshPreferencesDialog(String string) {
        this.sshConfigDialog(string, SSHMenuHandlerFull.LBL_TAB_SECURITY);
    }

    protected void sshConfigDialog(String string, String string2) {
        final Dialog dialog = new Dialog(this.parent, string, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        TabPanel tabPanel = new TabPanel();
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSHMenuHandlerFullAWT.this.updateChoicesGeneral();
            }
        };
        ItemListener itemListener2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSHMenuHandlerFullAWT.this.updateChoicesProxy(itemEvent);
            }
        };
        ItemListener itemListener3 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSHMenuHandlerFullAWT.this.updateChoicesSecurity(itemEvent);
            }
        };
        ItemListener itemListener4 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSHMenuHandlerFullAWT.this.updateChoicesFeatures();
            }
        };
        Panel panel = new Panel(gridBagLayout);
        Label label = new Label(SSHMenuHandlerFull.LBL_SERVER, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        this.textSrv = new TextField("", 20);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.textSrv, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        label = new Label(SSHMenuHandlerFull.LBL_USERNAME, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        this.textUser = new TextField("", 12);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)this.textUser, gridBagConstraints);
        label = new Label(SSHMenuHandlerFull.LBL_AUTH, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        this.comboAuthTyp = AWTConvenience.newChoice(SSHMenuHandlerFull.AUTH_METHODS);
        this.comboAuthTyp.addItemListener(itemListener);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        panel.add((Component)this.comboAuthTyp, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)this.getAuthLabel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)this.getAuth(), gridBagConstraints);
        this.cbSaveAlias = new Checkbox(SSHMenuHandlerFull.LBL_SAVE_AS_ALIAS);
        this.cbSaveAlias.addItemListener(itemListener);
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)this.cbSaveAlias, gridBagConstraints);
        this.textAlias = new TextField("", 12);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)this.textAlias, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)new Label(""), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        tabPanel.add(SSHMenuHandlerFull.LBL_TAB_GENERAL, panel);
        panel = new Panel(gridBagLayout);
        label = new Label(SSHMenuHandlerFull.LBL_PROXY_TYPE, 2);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        this.comboPrxType = AWTConvenience.newChoice(SSH.getProxyTypes());
        this.comboPrxType.addItemListener(itemListener2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        panel.add((Component)this.comboPrxType, gridBagConstraints);
        gridBagConstraints.fill = 2;
        label = new Label(SSHMenuHandlerFull.LBL_SERVER, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        this.textPrxHost = new TextField("", 12);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.textPrxHost, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        label = new Label(SSHMenuHandlerFull.LBL_PORT, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        this.textPrxPort = new TextField("", 12);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)this.textPrxPort, gridBagConstraints);
        Panel panel2 = new Panel(new GridBagLayout());
        this.cbNeedAuth = new Checkbox(SSHMenuHandlerFull.LBL_AUTH);
        this.cbNeedAuth.addItemListener(itemListener2);
        gridBagConstraints.gridwidth = 1;
        panel2.add((Component)this.cbNeedAuth, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel2.add((Component)new Panel(), gridBagConstraints);
        label = new Label(SSHMenuHandlerFull.LBL_USERNAME, 2);
        gridBagConstraints.gridwidth = 1;
        panel2.add((Component)label, gridBagConstraints);
        this.textPrxUser = new TextField("", 12);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        panel2.add((Component)this.textPrxUser, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        label = new Label(SSHMenuHandlerFull.LBL_PASSWORD, 2);
        gridBagConstraints.gridwidth = 1;
        panel2.add((Component)label, gridBagConstraints);
        this.textPrxPasswd = new TextField("", 12);
        gridBagConstraints.gridwidth = 0;
        panel2.add((Component)this.textPrxPasswd, gridBagConstraints);
        panel.add((Component)panel2, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)new Label(""), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        tabPanel.add(SSHMenuHandlerFull.LBL_TAB_PROXY, panel);
        panel = new Panel(gridBagLayout);
        label = new Label(SSHMenuHandlerFull.LBL_PROTOCOL, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        this.cbProto2 = new Checkbox(SSHMenuHandlerFull.LBL_PROTO_SSH2);
        this.cbProto2.addItemListener(itemListener3);
        panel.add((Component)this.cbProto2, gridBagConstraints);
        this.cbProto1 = new Checkbox(SSHMenuHandlerFull.LBL_PROTO_SSH1);
        panel.add((Component)this.cbProto1, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)new Panel(), gridBagConstraints);
        label = new Label(SSHMenuHandlerFull.LBL_HKEY_TYPE, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        this.cbKeyTypeDSS = new Checkbox(SSHMenuHandlerFull.LBL_HKEY_DSS);
        panel.add((Component)this.cbKeyTypeDSS, gridBagConstraints);
        this.cbKeyTypeRSA = new Checkbox(SSHMenuHandlerFull.LBL_HKEY_RSA);
        panel.add((Component)this.cbKeyTypeRSA, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)new Panel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)new Panel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        panel.add((Component)new Label(SSHMenuHandlerFull.LBL_C2S), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)new Label(SSHMenuHandlerFull.LBL_S2C), gridBagConstraints);
        this.comboCipherC2S = AWTConvenience.newChoice(SSHMenuHandlerFull.ciphers);
        this.comboCipherS2C = AWTConvenience.newChoice(SSHMenuHandlerFull.ciphers);
        this.comboMacC2S = AWTConvenience.newChoice(SSHMenuHandlerFull.macs);
        this.comboMacS2C = AWTConvenience.newChoice(SSHMenuHandlerFull.macs);
        this.comboCompC2S = AWTConvenience.newChoice(SSHMenuHandlerFull.compc2s);
        this.comboCompS2C = AWTConvenience.newChoice(SSHMenuHandlerFull.comps2c);
        this.comboCipherC2S.insert(SSHMenuHandlerFull.LBL_ANY_STANDARD, 0);
        this.comboCipherS2C.insert(SSHMenuHandlerFull.LBL_ANY_STANDARD, 0);
        this.comboMacC2S.insert(SSHMenuHandlerFull.LBL_ANY_STANDARD, 0);
        this.comboMacS2C.insert(SSHMenuHandlerFull.LBL_ANY_STANDARD, 0);
        this.comboCipherC2S.addItemListener(itemListener3);
        this.comboMacC2S.addItemListener(itemListener3);
        this.comboCompC2S.addItemListener(itemListener3);
        label = new Label(SSHMenuHandlerFull.LBL_CIPHER, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        panel.add((Component)this.comboCipherC2S, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)this.comboCipherS2C, gridBagConstraints);
        label = new Label(SSHMenuHandlerFull.LBL_MAC, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        panel.add((Component)this.comboMacC2S, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)this.comboMacS2C, gridBagConstraints);
        label = new Label(SSHMenuHandlerFull.LBL_COMP, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        panel.add((Component)this.comboCompC2S, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)this.comboCompS2C, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)new Label(""), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        tabPanel.add(SSHMenuHandlerFull.LBL_TAB_SECURITY, panel);
        panel = new Panel(gridBagLayout);
        label = new Label(SSHMenuHandlerFull.LBL_X11_FORWARD, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        Panel panel3 = new Panel(new FlowLayout(0, 0, 0));
        this.cbX11 = new Checkbox();
        this.cbX11.addItemListener(itemListener4);
        this.textDisp = new TextField("", 12);
        panel3.add(this.cbX11);
        panel3.add(new Label(SSHMenuHandlerFull.LBL_LOCAL_DISP));
        panel3.add(this.textDisp);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)panel3, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        label = new Label(SSHMenuHandlerFull.LBL_SEND_KEEP, 2);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)label, gridBagConstraints);
        panel3 = new Panel(new FlowLayout(0, 0, 0));
        this.cbAlive = new Checkbox();
        this.cbAlive.addItemListener(itemListener4);
        this.textAlive = new TextField("", 12);
        panel3.add(this.cbAlive);
        panel3.add(new Label(SSHMenuHandlerFull.LBL_INTERVAL));
        panel3.add(this.textAlive);
        panel3.add(new Label(SSHMenuHandlerFull.LBL_SECONDS));
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)panel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)new Panel(), gridBagConstraints);
        this.cbIdHost = new Checkbox(SSHMenuHandlerFull.LBL_STRICT);
        panel.add((Component)this.cbIdHost, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)new Panel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)new Panel(), gridBagConstraints);
        this.cbKeyNoise = new Checkbox(SSHMenuHandlerFull.LBL_KEY_NOISE);
        panel.add((Component)this.cbKeyNoise, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)new Panel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        panel.add((Component)new Panel(), gridBagConstraints);
        this.cbForcPty = new Checkbox(SSHMenuHandlerFull.LBL_ALLOC_PTY);
        panel.add((Component)this.cbForcPty, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)new Panel(), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)new Label(""), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        tabPanel.add(SSHMenuHandlerFull.LBL_TAB_FEATURES, panel);
        dialog.add((Component)tabPanel, "Center");
        tabPanel.show(string2);
        Button button = new Button();
        if (this.client.isConnected()) {
            button.setLabel(SSHMenuHandlerFull.LBL_BTN_OK);
        } else {
            button.setLabel(SSHMenuHandlerFull.LBL_BTN_CONNECT);
        }
        Button button2 = new Button(SSHMenuHandlerFull.LBL_BTN_CANCEL);
        Panel panel4 = AWTConvenience.newButtonPanel(new Button[]{button, button2});
        dialog.add((Component)panel4, "South");
        dialog.setResizable(true);
        dialog.pack();
        AWTConvenience.placeDialog(dialog);
        dialog.addWindowListener(new AWTConvenience.CloseAdapter(button2));
        this.populate();
        this.updateChoicesGeneral();
        this.updateChoicesProxy(null);
        this.updateChoicesSecurity(null);
        this.updateChoicesFeatures();
        if (this.textSrv.isEnabled()) {
            this.textSrv.requestFocus();
        } else {
            this.textUser.requestFocus();
        }
        button2.addActionListener(new AWTConvenience.CloseAction(dialog));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SSHMenuHandlerFullAWT.this.okPressed(dialog);
                }
                catch (Exception exception) {
                    SSHMenuHandlerFullAWT.this.alertDialog("Error: " + exception.getMessage());
                }
            }
        });
        ((Component)dialog).setVisible(true);
    }

    private void okPressed(Dialog dialog) throws Exception {
        if (!this.client.isConnected()) {
            if (!this.extractDataFromGeneral()) {
                return;
            }
            this.extractDataFromProxy();
        }
        this.extractDataFromSecurity();
        this.extractDataFromFeatures();
        dialog.dispose();
    }

    private boolean extractDataFromGeneral() {
        String string;
        String string2;
        String string3 = null;
        int n = 22;
        string3 = this.textSrv.getText();
        if (string3.length() == 0) {
            this.alertDialog("Please specify a server to connect to");
            return false;
        }
        int n2 = string3.indexOf(58);
        if (n2 > 0) {
            n = Integer.parseInt(string3.substring(n2 + 1));
            string3 = string3.substring(0, n2);
        }
        this.ph.setProperty("server", string3);
        this.ph.setProperty("port", n);
        this.ph.setProperty("usrname", this.textUser.getText());
        if (this.cbSaveAlias.getState()) {
            string2 = this.textAlias.getText();
            if (string2 == null || string2.trim().length() == 0) {
                this.alertDialog("Please specify an alias name for these settings");
                return false;
            }
            if (this.ph.savePasswords) {
                string = this.setPasswordDialog("Please set password for alias " + string3, "MindTerm - Set File Password");
                if (string == null) {
                    return false;
                }
                this.ph.setPropertyPassword(string);
            }
            this.ph.setAlias(string2);
        }
        this.client.quiet = true;
        string2 = this.ph.getProperty("prxpassword");
        this.ph.clearPasswords();
        if (string2 != null) {
            this.ph.setProperty("prxpassword", string2);
        }
        this.ph.clearAllForwards();
        string = this.comboAuthTyp.getSelectedItem();
        if (string.equals(SSHMenuHandlerFull.LBL_CUSTOM_LIST)) {
            this.ph.setProperty("authtyp", this.customAuth);
        } else {
            this.ph.setProperty("authtyp", string);
        }
        String string4 = this.textPwd.getText();
        if (string4.length() == 0) {
            string4 = null;
        }
        this.ph.setProperty("password", string4);
        this.ph.setProperty("private-key", this.textPrivateKey.getText());
        this.ph.setProperty("private-host-key", this.textPrivateHostKey.getText());
        this.client.sshStdIO.breakPromptLine();
        return true;
    }

    private void extractDataFromProxy() {
        String string = this.comboPrxType.getSelectedItem();
        this.ph.setProperty("proxytype", string);
        if (!"none".equalsIgnoreCase(string)) {
            this.ph.setProperty("proxyhost", this.textPrxHost.getText());
            this.ph.setProperty("proxyport", this.textPrxPort.getText());
        }
        if (this.cbNeedAuth.getState()) {
            this.ph.setProperty("proxyuser", this.textPrxUser.getText());
            String string2 = this.textPwd.getText();
            if (string2.length() == 0) {
                string2 = null;
            }
            this.ph.setProperty("prxpassword", string2);
        } else if ("socks4".equals(string)) {
            this.ph.setProperty("proxyuser", this.textPrxUser.getText());
        }
    }

    private void extractDataFromSecurity() throws Exception {
        boolean bl;
        String string = this.comboCipherC2S.getSelectedItem();
        String string2 = this.comboCipherS2C.getSelectedItem();
        boolean bl2 = bl = this.client.isConnected() && this.client.isSSH2 && !this.client.transport.incompatibleCantReKey;
        if (bl) {
            this.checkSupportedByPeer();
        }
        if (this.cbProto1.getState() && this.cbProto2.getState()) {
            this.ph.setProperty("protocol", "auto");
        } else if (this.cbProto1.getState()) {
            this.ph.setProperty("protocol", "ssh1");
        } else if (this.cbProto2.getState()) {
            this.ph.setProperty("protocol", "ssh2");
        } else {
            throw new Exception(SSHMenuHandlerFull.ERR_NO_PROTOCOL);
        }
        if (this.cbKeyTypeDSS.getState() && this.cbKeyTypeRSA.getState()) {
            this.ph.setProperty("server-host-key-algorithms", "ssh-rsa,ssh-dss");
        } else if (this.cbKeyTypeDSS.getState()) {
            this.ph.setProperty("server-host-key-algorithms", "ssh-dss");
        } else if (this.cbKeyTypeRSA.getState()) {
            this.ph.setProperty("server-host-key-algorithms", "ssh-rsa");
        } else {
            throw new Exception(SSHMenuHandlerFull.ERR_NO_KEYTYPE);
        }
        if (this.comboCipherC2S.getSelectedIndex() > 0) {
            this.ph.setProperty("enc-algorithms-cli2srv", string);
            this.ph.setProperty("cipher", string);
        } else {
            this.ph.resetProperty("enc-algorithms-cli2srv");
            this.ph.resetProperty("cipher");
        }
        if (this.comboCipherS2C.getSelectedIndex() > 0) {
            this.ph.setProperty("enc-algorithms-srv2cli", string2);
        } else {
            this.ph.resetProperty("enc-algorithms-srv2cli");
        }
        if (this.comboMacC2S.getSelectedIndex() > 0) {
            this.ph.setProperty("mac-algorithms-cli2srv", this.comboMacC2S.getSelectedItem());
        } else {
            this.ph.resetProperty("mac-algorithms-cli2srv");
        }
        if (this.comboMacS2C.getSelectedIndex() > 0) {
            this.ph.setProperty("mac-algorithms-srv2cli", this.comboMacS2C.getSelectedItem());
        } else {
            this.ph.resetProperty("mac-algorithms-srv2cli");
        }
        int n = SSHMenuHandlerFull.comp2lvl[this.comboCompC2S.getSelectedIndex()];
        if (n > 0) {
            this.ph.setProperty("comp-algorithms-cli2srv", "zlib,zlib@openssh.com");
        } else {
            this.ph.setProperty("comp-algorithms-cli2srv", "none");
        }
        this.ph.setProperty("compression", n);
        n = this.comboCompS2C.getSelectedIndex();
        if (n > 0) {
            this.ph.setProperty("comp-algorithms-srv2cli", "zlib,zlib@openssh.com");
        } else {
            this.ph.setProperty("comp-algorithms-srv2cli", "none");
        }
        if (bl) {
            SSH2Preferences sSH2Preferences = new SSH2Preferences(this.ph.getProperties());
            this.client.transport.startKeyExchange(sSH2Preferences);
        }
    }

    private void extractDataFromFeatures() {
        if (this.cbX11.getState()) {
            this.ph.setProperty("display", this.textDisp.getText());
        } else {
            this.ph.setProperty("display", "");
        }
        this.ph.setProperty("x11fwd", this.cbX11.getState());
        this.ph.setProperty("stricthostid", this.cbIdHost.getState());
        this.ph.setProperty("key-timing-noise", this.cbKeyNoise.getState());
        this.ph.setProperty("forcpty", this.cbForcPty.getState());
        if (this.cbAlive.getState()) {
            this.ph.setProperty("alive", this.textAlive.getText());
        } else {
            this.ph.setProperty("alive", "0");
        }
    }

    private Panel getAuthLabel() {
        this.authLabelCP = new Panel();
        this.authLabelCL = new CardLayout();
        this.authLabelCP.setLayout(this.authLabelCL);
        int n = 2;
        this.authLabelCP.add((Component)new Label(SSHMenuHandlerFull.LBL_PASSWORD, n), "password");
        this.authLabelCP.add((Component)new Panel(), SSHMenuHandlerFull.LBL_CUSTOM_LIST);
        this.authLabelCP.add((Component)new Label(SSHMenuHandlerFull.LBL_IDENTITY, n), "publickey");
        this.authLabelCP.add((Component)new Panel(), "securid");
        this.authLabelCP.add((Component)new Panel(), "tis");
        this.authLabelCP.add((Component)new Panel(), "kbd-interact");
        this.authLabelCP.add((Component)new Label(SSHMenuHandlerFull.LBL_HOST_KEY, n), "hostbased");
        return this.authLabelCP;
    }

    private Component makeCenter(Component component) {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panel.add(component, gridBagConstraints);
        return panel;
    }

    private Panel getAuth() {
        this.authCP = new Panel();
        this.authCL = new CardLayout();
        this.authCP.setLayout(this.authCL);
        this.textPwd = new TextField("", 12);
        this.textPwd.setEchoChar('*');
        this.customBtn = new Button(SSHMenuHandlerFull.LBL_MODIFY_LIST);
        this.customBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SSHMenuHandlerFullAWT.this.customAuthDialog();
            }
        });
        this.textPrivateKey = new TextField("", 12);
        Button button = new Button(SSHMenuHandlerFull.LBL_BTN_BROWSE);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = GUI.selectFile(SSHMenuHandlerFullAWT.this.parent, "MindTerm - Select file with identity (private)", SSHMenuHandlerFullAWT.this.ph.getSSHHomeDir(), false);
                if (file != null) {
                    SSHMenuHandlerFullAWT.this.textPrivateKey.setText(file.getAbsolutePath());
                }
            }
        });
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.textPrivateKey, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        panel.add((Component)button, gridBagConstraints);
        this.authCP.add(this.makeCenter(this.textPwd), "password");
        this.authCP.add(this.makeCenter(this.customBtn), SSHMenuHandlerFull.LBL_CUSTOM_LIST);
        this.authCP.add((Component)panel, "publickey");
        this.authCP.add((Component)new Label(), "tis");
        this.authCP.add((Component)new Label(), "kbd-interact");
        this.authCP.add((Component)new Panel(), "securid");
        this.authCP.add((Component)new Panel(), "tis");
        this.authCP.add((Component)new Panel(), "kbd-interact");
        this.textPrivateHostKey = new TextField("", 12);
        button = new Button(SSHMenuHandlerFull.LBL_BTN_BROWSE);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = GUI.selectFile(SSHMenuHandlerFullAWT.this.parent, "MindTerm - Select file with private host key", SSHMenuHandlerFullAWT.this.ph.getSSHHomeDir(), false);
                if (file != null) {
                    SSHMenuHandlerFullAWT.this.textPrivateHostKey.setText(file.getAbsolutePath());
                }
            }
        });
        panel = new Panel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.textPrivateHostKey, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        panel.add((Component)button, gridBagConstraints);
        this.authCP.add((Component)panel, "hostbased");
        return this.authCP;
    }

    private void updateChoicesGeneral() {
        this.textSrv.setEnabled(!this.client.isOpened());
        this.textUser.setEnabled(!this.client.isOpened());
        this.cbSaveAlias.setEnabled(!this.client.isOpened());
        this.textAlias.setEnabled(!this.client.isOpened());
        this.comboAuthTyp.setEnabled(!this.client.isOpened());
        this.textPwd.setEnabled(!this.client.isOpened());
        this.customBtn.setEnabled(!this.client.isOpened());
        this.textPrivateKey.setEnabled(!this.client.isOpened());
        this.textPrivateHostKey.setEnabled(!this.client.isOpened());
        String string = this.comboAuthTyp.getSelectedItem();
        this.authLabelCL.show(this.authLabelCP, string);
        this.authCL.show(this.authCP, string);
        if (this.cbSaveAlias.getState()) {
            this.textAlias.setEnabled(true);
            String string2 = this.textAlias.getText();
            if (!(this.textAlias.isEnabled() || string2 != null && string2.trim().length() != 0)) {
                this.textAlias.setText(this.textSrv.getText());
                this.textAlias.requestFocus();
            }
        } else {
            this.textAlias.setText("");
            this.textAlias.setEnabled(false);
        }
    }

    private void updateChoicesProxy(ItemEvent itemEvent) {
        boolean bl;
        if (itemEvent == null || itemEvent.getSource() == this.comboPrxType) {
            int bl2 = SSH.getProxyType(this.comboPrxType.getSelectedItem());
            this.textPrxPort.setText(String.valueOf(SSH.defaultProxyPorts[bl2]));
        }
        boolean bl3 = true;
        boolean bl4 = true;
        String string = this.comboPrxType.getSelectedItem();
        int n = 0;
        try {
            n = SSH.getProxyType(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            boolean bl5 = false;
        }
        if (n == 0 || n == 2) {
            bl4 = false;
        }
        if (this.client.isConnected()) {
            bl = false;
            this.comboPrxType.setEnabled(false);
        } else {
            this.comboPrxType.setEnabled(true);
        }
        this.textPrxHost.setEnabled(bl);
        this.textPrxPort.setEnabled(bl);
        this.cbNeedAuth.setEnabled(bl4);
        if (!bl4) {
            this.cbNeedAuth.setState(false);
        }
        this.textPrxUser.setEnabled(this.cbNeedAuth.getState());
        this.textPrxPasswd.setEnabled(this.cbNeedAuth.getState());
    }

    private void updateChoicesSecurity(ItemEvent itemEvent) {
        boolean bl = this.client.isOpened();
        boolean bl2 = bl ? this.client.isSSH2 : this.cbProto2.getState();
        this.cbProto1.setEnabled(!bl);
        this.cbProto2.setEnabled(!bl);
        this.cbKeyTypeDSS.setEnabled(!bl);
        this.cbKeyTypeRSA.setEnabled(!bl);
        boolean bl3 = false;
        if (this.client.transport != null) {
            bl3 = this.client.transport.incompatibleCantReKey;
        }
        boolean bl4 = !bl || bl2 && bl && !bl3;
        this.comboCipherS2C.setEnabled(bl4 && bl2);
        this.comboMacS2C.setEnabled(bl4 && bl2);
        this.comboCompS2C.setEnabled(bl4 && bl2);
        this.comboCipherC2S.setEnabled(bl4);
        this.comboMacC2S.setEnabled(bl4 && bl2);
        this.comboCompC2S.setEnabled(bl4);
        if (itemEvent != null && itemEvent.getSource() == this.comboCipherC2S) {
            this.comboCipherS2C.select((String)itemEvent.getItem());
        } else if (itemEvent != null && itemEvent.getSource() == this.comboMacS2C) {
            this.comboMacS2C.select((String)itemEvent.getItem());
        } else if (itemEvent != null && itemEvent.getSource() == this.comboCompS2C) {
            if ("none".equals(itemEvent.getItem())) {
                this.comboCompS2C.select("none");
            } else {
                this.comboCompS2C.select("medium");
            }
        }
    }

    private void updateChoicesFeatures() {
        boolean bl = this.client.isOpened();
        this.cbX11.setEnabled(!bl);
        this.cbIdHost.setEnabled(!bl);
        this.cbForcPty.setEnabled(!bl);
        this.textAlive.setEnabled(this.cbAlive.getState());
        this.textDisp.setEnabled(this.cbX11.getState());
    }

    private void populate() {
        String string = this.ph.getProperty("port");
        if (string.length() > 0 && !string.equals("22")) {
            this.textSrv.setText(this.ph.getProperty("server") + ":" + string);
        } else {
            this.textSrv.setText(this.ph.getProperty("server"));
        }
        this.textUser.setText(this.ph.getProperty("username"));
        this.textPrivateKey.setText(this.ph.getProperty("private-key"));
        this.textPrivateHostKey.setText(this.ph.getProperty("private-host-key"));
        this.customAuth = this.ph.getProperty("auth-method");
        if (-1 == this.customAuth.indexOf(44)) {
            this.comboAuthTyp.select(this.customAuth);
        } else {
            this.comboAuthTyp.select(SSHMenuHandlerFull.LBL_CUSTOM_LIST);
        }
        this.textPrxHost.setText(this.ph.getProperty("proxyhost"));
        this.textPrxPort.setText(this.ph.getProperty("proxyport"));
        this.textPrxUser.setText(this.ph.getProperty("proxyuser"));
        this.cbKeyTypeDSS.setState(true);
        this.cbKeyTypeRSA.setState(true);
        this.comboCipherC2S.select(0);
        this.comboCipherS2C.select(0);
        this.comboMacC2S.select(0);
        this.comboMacS2C.select(0);
        this.cbProto1.setState(!this.ph.getProperty("protocol").equals("ssh2"));
        this.cbProto2.setState(!this.ph.getProperty("protocol").equals("ssh1"));
        this.cbKeyTypeDSS.setState(-1 != this.ph.getProperty("server-host-key-algorithms").indexOf("ssh-dss"));
        this.cbKeyTypeRSA.setState(-1 != this.ph.getProperty("server-host-key-algorithms").indexOf("ssh-rsa"));
        this.comboCipherC2S.select(this.ph.getProperty("enc-algorithms-cli2srv"));
        this.comboCipherS2C.select(this.ph.getProperty("enc-algorithms-srv2cli"));
        this.comboMacC2S.select(this.ph.getProperty("mac-algorithms-cli2srv"));
        this.comboMacS2C.select(this.ph.getProperty("mac-algorithms-srv2cli"));
        int n = this.ph.getCompressionLevel();
        this.comboCompC2S.select(SSHMenuHandlerFull.lvl2comp[n]);
        String string2 = this.ph.getProperty("comp-algorithms-srv2cli");
        if ("none".equals(string2)) {
            this.comboCompS2C.select("none");
        } else {
            this.comboCompS2C.select("medium");
        }
        this.textDisp.setText(this.ph.getProperty("display"));
        this.textAlive.setText(this.ph.getProperty("alive"));
        this.cbX11.setState(this.ph.getPropertyB("x11fwd"));
        this.cbAlive.setState(!this.ph.getProperty("alive").equals("0"));
        this.cbIdHost.setState(this.ph.getPropertyB("stricthostid"));
        this.cbKeyNoise.setState(this.ph.getPropertyB("key-timing-noise"));
        this.cbForcPty.setState(this.ph.getPropertyB("forcpty"));
    }

    private void checkSupportedByPeer() throws Exception {
        this.checkSupportedByPeer("enc-algorithms-cli2srv", this.comboCipherC2S);
        this.checkSupportedByPeer("enc-algorithms-srv2cli", this.comboCipherS2C);
        this.checkSupportedByPeer("mac-algorithms-cli2srv", this.comboMacC2S);
        this.checkSupportedByPeer("mac-algorithms-srv2cli", this.comboMacS2C);
        if (!this.comboCompC2S.getSelectedItem().equals("none") && !this.client.transport.getPeerPreferences().isSupported("comp-algorithms-cli2srv", "zlib") || !this.comboCompS2C.getSelectedItem().equals("none") && !this.client.transport.getPeerPreferences().isSupported("comp-algorithms-srv2cli", "zlib")) {
            throw new Exception("Peer doesn't support 'zlib'");
        }
    }

    private void checkSupportedByPeer(String string, Choice choice) throws Exception {
        if (choice.getSelectedIndex() == 0) {
            return;
        }
        String string2 = choice.getSelectedItem();
        if (!this.client.transport.getPeerPreferences().isSupported(string, string2)) {
            throw new Exception("Peer doesn't support: " + string2);
        }
    }

    private void customAuthDialog() {
        final BorderDialog borderDialog = new BorderDialog(this.parent, SSHMenuHandlerFull.LBL_CUSTOM_LIST, true);
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.authMethod = new Checkbox[SSHMenuHandlerFull.AUTH_METHODS.length];
        for (int i = 0; i < this.authMethod.length - 1; ++i) {
            this.authMethod[i] = new Checkbox(SSHMenuHandlerFull.AUTH_METHODS[i]);
            this.authMethod[i].setState(-1 != this.customAuth.indexOf(SSHMenuHandlerFull.AUTH_METHODS[i]));
            panel.add((Component)this.authMethod[i], gridBagConstraints);
        }
        borderDialog.add((Component)panel, "Center");
        Button button = new Button(SSHMenuHandlerFull.LBL_BTN_OK);
        Button button2 = new Button(SSHMenuHandlerFull.LBL_BTN_CANCEL);
        Panel panel2 = AWTConvenience.newButtonPanel(new Button[]{button, button2});
        borderDialog.add((Component)panel2, "South");
        borderDialog.setResizable(true);
        borderDialog.pack();
        AWTConvenience.placeDialog(borderDialog);
        borderDialog.addWindowListener(new AWTConvenience.CloseAdapter(button2));
        button2.addActionListener(new AWTConvenience.CloseAction(borderDialog));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < SSHMenuHandlerFullAWT.this.authMethod.length - 1; ++i) {
                    if (!SSHMenuHandlerFullAWT.this.authMethod[i].getState()) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(SSHMenuHandlerFull.AUTH_METHODS[i]);
                }
                SSHMenuHandlerFullAWT.this.customAuth = stringBuffer.toString();
                System.err.println(SSHMenuHandlerFullAWT.this.customAuth);
                borderDialog.dispose();
            }
        });
        ((Component)borderDialog).setVisible(true);
    }

    public final void currentTunnelsDialog(String string) {
        final BorderDialog borderDialog = new BorderDialog(this.parent, string, false);
        borderDialog.add((Component)new Label(SSHMenuHandlerFull.LBL_CURR_TUNNELS), "North");
        this.currList = new List(8);
        borderDialog.add((Component)this.currList, "Center");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("close".equals(string)) {
                    int n = SSHMenuHandlerFullAWT.this.currList.getSelectedIndex();
                    if (n == -1) {
                        SSHMenuHandlerFullAWT.this.term.ringBell();
                        return;
                    }
                    SSHMenuHandlerFullAWT.this.client.closeTunnelFromList(n);
                    Thread.yield();
                } else if ("refresh".equals(string)) {
                    // empty if block
                }
                SSHMenuHandlerFullAWT.this.refreshCurrList();
                borderDialog.invalidate();
            }
        };
        final Button button = new Button(SSHMenuHandlerFull.LBL_BTN_CLOSE_TUNNEL);
        Button button2 = new Button(SSHMenuHandlerFull.LBL_BTN_REFRESH);
        Button button3 = new Button(SSHMenuHandlerFull.LBL_BTN_DISMISS);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = SSHMenuHandlerFullAWT.this.currList.getSelectedIndex();
                button.setEnabled(n >= 0);
            }
        };
        this.currList.addItemListener(itemListener);
        button.setActionCommand("close");
        button.addActionListener(actionListener);
        button.setEnabled(false);
        button2.setActionCommand("refresh");
        button2.addActionListener(actionListener);
        button3.addActionListener(new AWTConvenience.CloseAction(borderDialog));
        Panel panel = AWTConvenience.newButtonPanel(new Button[]{button, button2, button3});
        borderDialog.add((Component)panel, "South");
        borderDialog.addWindowListener(new AWTConvenience.CloseAdapter(button3));
        AWTConvenience.setBackgroundOfChildren(borderDialog);
        borderDialog.setResizable(true);
        borderDialog.pack();
        this.refreshCurrList();
        AWTConvenience.placeDialog(borderDialog);
        this.currList.requestFocus();
        ((Component)borderDialog).setVisible(true);
    }

    private void refreshCurrList() {
        this.currList.removeAll();
        String[] stringArray = this.client.listTunnels();
        for (int i = 0; i < stringArray.length; ++i) {
            this.currList.add(stringArray[i]);
        }
    }

    protected void setupTunnelsDialog(String string) {
        SSHTunnelDialogAWT.show(string, this.client, this.ph, this.parent);
    }

    protected void aboutDialog(Frame frame, SSHInteractiveClient sSHInteractiveClient, String string, String string2) {
        Component component;
        BorderDialog borderDialog = new BorderDialog(frame, string, true);
        Logo logo = sSHInteractiveClient.getLogo();
        if (logo != null) {
            component = new Panel();
            ((Container)component).add(logo);
            borderDialog.add(component, "North");
        }
        component = new TextArea(string2, 12, 40, 1);
        ((TextComponent)component).setEditable(false);
        borderDialog.add(component, "Center");
        Button button = new Button(SSHMenuHandlerFull.LBL_BTN_OK);
        button.addActionListener(new AWTConvenience.CloseAction(borderDialog));
        Panel panel = new Panel(new FlowLayout(2));
        panel.add(button);
        borderDialog.add((Component)panel, "South");
        borderDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
        AWTConvenience.setBackgroundOfChildren(borderDialog);
        borderDialog.setResizable(true);
        borderDialog.pack();
        AWTConvenience.placeDialog(borderDialog);
        button.requestFocus();
        ((Component)borderDialog).setVisible(true);
    }
}

