/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class SSHVersionSpySocket
extends Socket {
    PushbackInputStream pbIn;
    Socket origSocket;

    public SSHVersionSpySocket(Socket socket) throws IOException {
        this.origSocket = socket;
        this.pbIn = new PushbackInputStream(socket.getInputStream(), 256);
    }

    public int getMajorVersion() throws IOException {
        byte[] byArray = new byte[256];
        int n = 0;
        int n2 = 0;
        String string = null;
        int n3 = 0;
        String string2 = "SSH-";
        while (n3 < 2) {
            n2 = this.pbIn.read();
            if (n2 == -1) {
                throw new IOException("Server closed connection before sending identification");
            }
            if (n2 == 45) {
                ++n3;
            }
            byArray[n++] = (byte)n2;
            if (n >= 5 || n2 == string2.charAt(n - 1)) continue;
            this.pbIn.unread(byArray, 0, n);
            return 2;
        }
        string = new String(byArray, 0, n);
        int n4 = SSHVersionSpySocket.getMajor(string);
        int n5 = SSHVersionSpySocket.getMinor(string);
        if (n5 == 99) {
            n4 = 2;
        }
        this.pbIn.unread(byArray, 0, n);
        return n4;
    }

    private static int getMajor(String string) throws IOException {
        try {
            int n = string.indexOf(46, 4);
            return Integer.parseInt(string.substring(4, n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("corrupt version string: " + string);
        }
    }

    private static int getMinor(String string) throws IOException {
        try {
            int n = string.indexOf(46, 4) + 1;
            int n2 = string.indexOf(45, n);
            return Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("corrupt version string: " + string);
        }
    }

    public InetAddress getInetAddress() {
        return this.origSocket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.origSocket.getLocalAddress();
    }

    public int getPort() {
        return this.origSocket.getPort();
    }

    public int getLocalPort() {
        return this.origSocket.getLocalPort();
    }

    public InputStream getInputStream() throws IOException {
        return this.pbIn;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.origSocket.getOutputStream();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.origSocket.setTcpNoDelay(bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.origSocket.getTcpNoDelay();
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.origSocket.setSoLinger(bl, n);
    }

    public int getSoLinger() throws SocketException {
        return this.origSocket.getSoLinger();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.origSocket.setSoTimeout(n);
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.origSocket.getSoTimeout();
    }

    public synchronized void close() throws IOException {
        this.origSocket.close();
    }

    public String toString() {
        return this.origSocket.toString();
    }
}

