/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2AuthModule;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2PKISigner;
import com.mindbright.ssh2.SSH2SignatureException;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2UserAuth;

public class SSH2AuthHostBased
implements SSH2AuthModule {
    private SSH2PKISigner signer;
    public static final String STANDARD_NAME = "hostbased";

    public SSH2AuthHostBased(SSH2PKISigner sSH2PKISigner) {
        this.signer = sSH2PKISigner;
    }

    protected SSH2PKISigner getSigner() {
        return this.signer;
    }

    public String getStandardName() {
        return STANDARD_NAME;
    }

    public SSH2TransportPDU processMethodMessage(SSH2UserAuth sSH2UserAuth, SSH2TransportPDU sSH2TransportPDU) throws SSH2Exception {
        sSH2UserAuth.getTransport().getLog().warning("SSH2AuthHostBased", "received unexpected packet of type: " + sSH2TransportPDU.getType());
        sSH2TransportPDU = null;
        throw new SSH2FatalException("SSH2AuthHostBased: got unexpected packet of type: " + sSH2TransportPDU.getType());
    }

    public SSH2TransportPDU startAuthentication(SSH2UserAuth sSH2UserAuth) throws SSH2SignatureException {
        SSH2TransportPDU sSH2TransportPDU = sSH2UserAuth.createUserAuthRequest(STANDARD_NAME);
        SSH2PKISigner sSH2PKISigner = this.getSigner();
        byte[] byArray = sSH2PKISigner.getPublicKeyBlob();
        sSH2TransportPDU.writeString(sSH2PKISigner.getAlgorithmName());
        sSH2TransportPDU.writeString(byArray);
        sSH2TransportPDU.writeString(sSH2UserAuth.getTransport().getLocalHostName());
        sSH2TransportPDU.writeString(System.getProperty("user.name", ""));
        this.signPDU(sSH2UserAuth, sSH2TransportPDU, sSH2PKISigner, byArray);
        return sSH2TransportPDU;
    }

    private void signPDU(SSH2UserAuth sSH2UserAuth, SSH2TransportPDU sSH2TransportPDU, SSH2PKISigner sSH2PKISigner, byte[] byArray) throws SSH2SignatureException {
        SSH2TransportPDU sSH2TransportPDU2 = sSH2TransportPDU;
        byte[] byArray2 = sSH2UserAuth.getTransport().getSessionId();
        int n = sSH2TransportPDU2.wPos - sSH2TransportPDU2.getPayloadOffset();
        byte[] byArray3 = new byte[n + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(sSH2TransportPDU2.data, sSH2TransportPDU2.getPayloadOffset(), byArray3, byArray2.length, n);
        byte[] byArray4 = sSH2PKISigner.sign(byArray3);
        sSH2TransportPDU.writeString(byArray4);
    }

    public void clearSensitiveData() {
        this.signer.clearSensitiveData();
    }

    public boolean retryPointless() {
        return true;
    }
}

