/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2Listener;
import com.mindbright.ssh2.SSH2StreamChannel;
import com.mindbright.ssh2.SSH2StreamFilter;
import com.mindbright.ssh2.SSH2StreamFilterFactory;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

public class SSH2FTPProxyFilter
implements SSH2StreamFilter,
SSH2StreamFilterFactory {
    private String localAddrPASVStr;
    private String localAddrPORTStr;
    private InetAddress serverLocalAddr;
    private InetAddress localHost;
    protected SSH2Connection connection;
    protected SSH2StreamChannel channel;
    protected FTPInput ftpIn;
    protected FTPOutput ftpOut;
    protected volatile boolean waitingPASVResponse;

    private static boolean parseHostAndPort(String string, int[] nArray) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        try {
            for (int i = 0; i < 6; ++i) {
                if (i == 5) {
                    n2 = string.indexOf(41, n);
                    if (n2 == -1) {
                        n2 = string.indexOf(13, n);
                    } else if (n2 == -1) {
                        n2 = string.indexOf(10, n);
                    }
                } else {
                    n2 = string.indexOf(44, n);
                }
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                nArray[i] = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public SSH2FTPProxyFilter(String string, String string2) throws UnknownHostException {
        this(InetAddress.getByName(string), InetAddress.getByName(string2));
    }

    public SSH2FTPProxyFilter(InetAddress inetAddress, InetAddress inetAddress2) {
        int n;
        this.localHost = inetAddress;
        this.serverLocalAddr = inetAddress2;
        byte[] byArray = inetAddress.getAddress();
        if ((byArray[0] & 0xFF) == 0) {
            try {
                byArray = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new Error("Error in SSH2FTPProxyFilter: " + unknownHostException);
            }
        }
        this.localAddrPASVStr = "";
        for (n = 0; n < 4; ++n) {
            this.localAddrPASVStr = this.localAddrPASVStr + (byArray[n] & 0xFF) + (n < 3 ? "," : "");
        }
        byArray = inetAddress2.getAddress();
        this.localAddrPORTStr = "";
        for (n = 0; n < 4; ++n) {
            this.localAddrPORTStr = this.localAddrPORTStr + (byArray[n] & 0xFF) + (n < 3 ? "," : "");
        }
    }

    protected SSH2FTPProxyFilter(SSH2Connection sSH2Connection, SSH2StreamChannel sSH2StreamChannel, SSH2FTPProxyFilter sSH2FTPProxyFilter) {
        this.connection = sSH2Connection;
        this.channel = sSH2StreamChannel;
        this.localAddrPASVStr = sSH2FTPProxyFilter.localAddrPASVStr;
        this.localAddrPORTStr = sSH2FTPProxyFilter.localAddrPORTStr;
        this.serverLocalAddr = sSH2FTPProxyFilter.serverLocalAddr;
        this.localHost = sSH2FTPProxyFilter.localHost;
        this.waitingPASVResponse = false;
    }

    public SSH2StreamFilter createFilter(SSH2Connection sSH2Connection, SSH2StreamChannel sSH2StreamChannel) {
        return new SSH2FTPProxyFilter(sSH2Connection, sSH2StreamChannel, this);
    }

    public InputStream getInputFilter(InputStream inputStream) {
        this.ftpIn = new FTPInput(inputStream);
        return this.ftpIn;
    }

    public OutputStream getOutputFilter(OutputStream outputStream) {
        this.ftpOut = new FTPOutput(outputStream);
        return this.ftpOut;
    }

    class FTPOutput
    extends FilterOutputStream {
        public FTPOutput(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            SSH2Listener sSH2Listener = null;
            String string = new String(byArray, n, n2);
            if (SSH2FTPProxyFilter.this.waitingPASVResponse && string.startsWith("227 ")) {
                int[] nArray;
                SSH2FTPProxyFilter.this.waitingPASVResponse = false;
                if (SSH2FTPProxyFilter.parseHostAndPort(string = string.substring(27), nArray = new int[6])) {
                    String string2 = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                    int n3 = nArray[4] << 8 | nArray[5];
                    try {
                        sSH2Listener = SSH2FTPProxyFilter.this.connection.newLocalForward(SSH2FTPProxyFilter.this.localHost.getHostAddress(), 0, string2, n3);
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        SSH2FTPProxyFilter.this.connection.getLog().warning("SSH2FTPProxyFilter", "interrupted in FTP proxy filter: " + interruptedException.toString());
                        sSH2Listener = null;
                    }
                    catch (IOException iOException) {
                        SSH2FTPProxyFilter.this.connection.getLog().warning("SSH2FTPProxyFilter", "error in FTP proxy filter: " + iOException.toString());
                        sSH2Listener = null;
                    }
                    if (sSH2Listener != null) {
                        sSH2Listener.setAcceptMax(1);
                        int n4 = sSH2Listener.getListenPort();
                        int n5 = n4 >>> 8 & 0xFF;
                        int n6 = n4 & 0xFF;
                        string = "227 Entering Passive Mode (" + SSH2FTPProxyFilter.this.localAddrPASVStr + "," + n5 + "," + n6 + ")\n";
                        byte[] byArray2 = string.getBytes();
                        this.out.write(byArray2, 0, byArray2.length);
                    }
                } else {
                    SSH2FTPProxyFilter.this.connection.getLog().warning("SSH2FTPProxyFilter", "error in FTP proxy filter (pasv) for: " + string);
                }
            } else {
                this.out.write(byArray, n, n2);
            }
        }
    }

    class FTPInput
    extends FilterInputStream {
        Random portRandomizer = new Random();
        int lastBoundPort = -1;

        public FTPInput(InputStream inputStream) {
            super(inputStream);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((n2 = this.in.read(byArray, n, n2)) < 0) {
                return n2;
            }
            String string = new String(byArray, n, n2);
            if ((string = string.toLowerCase()).startsWith("pasv")) {
                SSH2FTPProxyFilter.this.waitingPASVResponse = true;
            } else if (string.startsWith("port ")) {
                int[] nArray;
                if (SSH2FTPProxyFilter.parseHostAndPort(string = string.substring(5), nArray = new int[6])) {
                    String string2 = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                    int n3 = nArray[4] << 8 | nArray[5];
                    if (this.lastBoundPort > 0) {
                        SSH2FTPProxyFilter.this.connection.deleteRemoteForward(SSH2FTPProxyFilter.this.serverLocalAddr.getHostAddress(), this.lastBoundPort);
                    }
                    int n4 = 0;
                    boolean bl = false;
                    while (!bl) {
                        n4 = Math.abs(this.portRandomizer.nextInt());
                        n4 %= 64512;
                        bl = SSH2FTPProxyFilter.this.connection.newRemoteForwardBlocking(SSH2FTPProxyFilter.this.serverLocalAddr.getHostAddress(), n4 += 1024, string2, n3, null);
                    }
                    this.lastBoundPort = n4;
                    int n5 = n4 >>> 8 & 0xFF;
                    int n6 = n4 & 0xFF;
                    string = "PORT " + SSH2FTPProxyFilter.this.localAddrPORTStr + "," + n5 + "," + n6 + "\n";
                    byte[] byArray2 = string.getBytes();
                    n2 = byArray2.length;
                    System.arraycopy(byArray2, 0, byArray, n, n2);
                } else {
                    SSH2FTPProxyFilter.this.connection.getLog().warning("SSH2FTPProxyFilter", "error in FTP proxy filter (port) for: " + string);
                }
            }
            return n2;
        }
    }
}

